/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.job;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnetAws.BBacnetAwsNetwork;
import com.tridium.bacnetAws.datatypes.BBackupConfig;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.config.BBacnetFile;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReinitializedDeviceState;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BBackupJob
extends BDeviceManagerJob {
    public static final Type TYPE;
    static Lexicon lex;
    private BBacnetAwsNetwork bacnetAws;
    private BBackupConfig params;
    static /* synthetic */ Class class$com$tridium$bacnetAws$job$BBackupJob;

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(Context context) throws Exception {
        if (this.bacnet == null) {
            throw new IllegalStateException("Must submit thru BacnetNetwork.submitDeviceManagerJob()");
        }
        if (this.params == null) {
            return;
        }
        this.progress(0);
        if (log.isTraceOn()) {
            log.trace("Backing up device at " + this.params.getDeviceAddress() + "...");
        }
        String string = null;
        String string2 = this.params.getPassword().getString();
        if (string2.length() > 0) {
            string = string2;
        }
        try {
            try {
                boolean bl;
                long l = 0L;
                long l2 = 0L;
                try {
                    l = AsnUtil.fromAsnUnsignedInteger((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 139));
                }
                catch (Exception exception) {
                    this.log().message("Protocol Revision cannot be determined: " + exception);
                }
                this.progress(2);
                try {
                    l2 = AsnUtil.fromAsnUnsignedInteger((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 120));
                }
                catch (Exception exception) {
                    this.log().message("Vendor ID cannot be determined: " + exception);
                }
                this.progress(4);
                int n = 5;
                boolean bl2 = false;
                if (l < 10L && l2 == 36L) {
                    bl2 = true;
                }
                n = this.readBRProp(338, bl2, -1, 9);
                boolean bl3 = false;
                if (n >= 0) {
                    bl3 = bl = true;
                }
                if (n > 0 && n < 5) {
                    throw new IllegalStateException("Cannot backup device; BackupAndRestoreState " + BBacnetBackupState.tag((int)n) + " is not IDLE!");
                }
                this.progress(6);
                int n2 = 90;
                try {
                    this.client().writeProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 153, AsnUtil.toAsnUnsigned((long)n2));
                }
                catch (BacnetException bacnetException) {
                    this.log().message("Could not write Backup_Failure_Timeout property:" + (Object)((Object)bacnetException));
                    n2 = this.readBRProp(153, false, 15, 2);
                }
                this.progress(8);
                long l3 = 60L;
                if (bl) {
                    l3 = this.readBRProp(339, bl2, 60, 2);
                }
                l3 *= 1000L;
                this.progress(10);
                this.log().message("Sending START_BACKUP command...");
                this.client().reinitializeDevice(this.params.getDeviceAddress(), BBacnetReinitializedDeviceState.startBackup, string, this.params.getCharacterSet());
                this.progress(12);
                if (bl) {
                    this.log().message("Monitoring Backup_And_Restore_State...");
                    n = this.readBRProp(338, bl2, -1, 9);
                    long l4 = Clock.ticks();
                    long l5 = 0L;
                    while (l5 < l3 && n != 3) {
                        this.log().message("Waiting for device backup preparation to complete (" + l5 / 1000L + " sec)...");
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        this.checkCancel(lex.getText("backup.canceled"));
                        l5 = Clock.ticks() - l4;
                        n = this.readBRProp(338, bl2, -1, 9);
                        if (n == -1) throw new RuntimeException("BACKUP_FAILURE received from device: unable to enter backup mode!");
                        if (n != 5) continue;
                        throw new RuntimeException("BACKUP_FAILURE received from device: unable to enter backup mode!");
                    }
                }
                this.progress(15);
                this.log().message("Reading Configuration_Files...");
                int n3 = AsnUtil.fromAsnUnsignedInt((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 154, 0));
                this.checkCancel(lex.getText("backup.canceled"));
                BBacnetObjectIdentifier[] bBacnetObjectIdentifierArray = new BBacnetObjectIdentifier[n3];
                byte[] byArray = this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 154);
                BValue[] bValueArray = AsnUtil.fromAsn((byte[])byArray);
                if (bValueArray.length != bBacnetObjectIdentifierArray.length) {
                    throw new BajaRuntimeException("ids.length=" + bValueArray.length + ", configFileIds.length=" + bBacnetObjectIdentifierArray.length);
                }
                this.progress(20);
                BFileSystem bFileSystem = BFileSystem.INSTANCE;
                int n4 = 0;
                while (true) {
                    block31: {
                        Object var27_28;
                        block32: {
                            if (n4 < bBacnetObjectIdentifierArray.length) break block32;
                            this.log().success("Finished Backup Procedure!");
                            break;
                        }
                        this.checkCancel(lex.getText("backup.canceled"));
                        bBacnetObjectIdentifierArray[n4] = (BBacnetObjectIdentifier)bValueArray[n4];
                        String string3 = AsnUtil.fromAsnCharacterString((byte[])this.client().readProperty(this.params.getDeviceAddress(), bBacnetObjectIdentifierArray[n4], 77));
                        BBacnetDevice bBacnetDevice = this.bacnetAws.lookupDeviceById(this.params.getDeviceId());
                        byte[] byArray2 = BBacnetFile.readFile((BBacnetDevice)bBacnetDevice, (BBacnetObjectIdentifier)bBacnetObjectIdentifierArray[n4]);
                        OutputStream outputStream = null;
                        try {
                            FilePath filePath = BBackupJob.toFilePath(this.params.getBaseDirectory().normalize());
                            log.trace("fileId:" + bBacnetObjectIdentifierArray[n4] + " fileName=" + string3 + " dir=" + filePath);
                            filePath = filePath.merge(this.params.getDeviceDirectoryName());
                            log.trace("  dir->" + filePath);
                            FilePath filePath2 = filePath.merge(string3 + '_' + bBacnetObjectIdentifierArray[n4].getInstanceNumber() + '_' + n4);
                            log.trace("fp=" + filePath2);
                            BIFile bIFile = bFileSystem.makeFile(filePath2, null);
                            outputStream = bIFile.getOutputStream();
                            outputStream.write(byArray2);
                        }
                        catch (Throwable throwable) {
                            var27_28 = null;
                            if (outputStream == null) throw throwable;
                            try {
                                outputStream.close();
                                throw throwable;
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                        {
                            var27_28 = null;
                            if (outputStream == null) break block31;
                        }
                        try {}
                        catch (Exception exception) {}
                        outputStream.close();
                    }
                    this.progress(n4, bBacnetObjectIdentifierArray.length, 20, 100);
                    ++n4;
                }
            }
            catch (Exception exception) {
                log.message("Exception backing up device: " + exception, (Throwable)exception);
                String string4 = MessageFormat.format(lex.getText("backup.fail"), exception);
                this.add("failureCause", (BValue)BString.make((String)exception.toString()));
                this.log().failed(string4);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var5_35 = null;
            this.log().message("Sending END_BACKUP command...");
            this.client().reinitializeDevice(this.params.getDeviceAddress(), BBacnetReinitializedDeviceState.endBackup, string, this.params.getCharacterSet());
            throw throwable;
        }
        {
            Object var5_36 = null;
        }
        this.log().message("Sending END_BACKUP command...");
        this.client().reinitializeDevice(this.params.getDeviceAddress(), BBacnetReinitializedDeviceState.endBackup, string, this.params.getCharacterSet());
    }

    public static FilePath toFilePath(BOrd bOrd) {
        OrdQuery[] ordQueryArray = bOrd.parse();
        int n = 0;
        while (n < ordQueryArray.length) {
            if (ordQueryArray[n] instanceof FilePath) {
                return (FilePath)ordQueryArray[n];
            }
            ++n;
        }
        throw new IllegalStateException();
    }

    private final int readBRProp(int n, boolean bl, int n2, int n3) {
        String string = BBacnetPropertyIdentifier.tag((int)n);
        if (bl) {
            string = string + " (Niagara)";
        }
        int n4 = n2;
        try {
            switch (n3) {
                case 2: {
                    n4 = (int)AsnUtil.fromAsnUnsignedInteger((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), this.propId(n, bl)));
                    break;
                }
                case 9: {
                    n4 = AsnUtil.fromAsnEnumerated((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), this.propId(n, bl)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid asnType supplied to readBRProp:" + n3);
                }
            }
        }
        catch (Exception exception) {
            this.log().message("Error reading " + string + ':' + exception);
        }
        return n4;
    }

    private final int propId(int n, boolean bl) {
        return bl ? n + 1000 : n;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BBackupJob() {
    }

    public BBackupJob(BBacnetAwsNetwork bBacnetAwsNetwork, BBackupConfig bBackupConfig) {
        super((BBacnetNetwork)bBacnetAwsNetwork);
        this.bacnetAws = bBacnetAwsNetwork;
        this.params = bBackupConfig;
    }

    static {
        Class clazz = class$com$tridium$bacnetAws$job$BBackupJob;
        if (clazz == null) {
            clazz = class$com$tridium$bacnetAws$job$BBackupJob = BBackupJob.class("[Lcom.tridium.bacnetAws.job.BBackupJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lex = Lexicon.make((String)"bacnetAws");
    }
}

