/*
 * Decompiled with CFR 0.152.
 */
package obix.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.util.zip.ZipInputStream;

public class XInputStreamReader
extends Reader {
    static final int UTF_8 = 0;
    static final int UTF_16_BE = 1;
    static final int UTF_16_LE = 2;
    static final String[] ENCODINGS = new String[]{"UTF-8", "UTF-16BE", "UTF-16LE"};
    private InputStream in;
    private boolean autoDetected;
    private boolean zipped;
    private int encoding = -1;

    public XInputStreamReader(InputStream inputStream) throws IOException {
        this.in = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
    }

    public String getEncoding() throws IOException {
        if (!this.autoDetected) {
            this.autoDetect();
        }
        return ENCODINGS[this.encoding];
    }

    public boolean isZipped() throws IOException {
        if (!this.autoDetected) {
            this.autoDetect();
        }
        return this.zipped;
    }

    public int read() throws IOException {
        if (!this.autoDetected) {
            this.autoDetect();
        }
        switch (this.encoding) {
            case 0: {
                int n = this.in.read();
                if (n < 0) {
                    return -1;
                }
                if ((n & 0x80) == 0) {
                    return n;
                }
                return this.readUtf8(n);
            }
            case 1: {
                return this.readUtf16be();
            }
            case 2: {
                return this.readUtf16le();
            }
        }
        throw new IllegalStateException();
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (!this.autoDetected) {
            this.autoDetect();
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = this.read();
            if (n3 < 0) {
                return i == 0 ? -1 : i;
            }
            cArray[n + i] = (char)n3;
        }
        return n2;
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public void close() throws IOException {
        this.in.close();
    }

    private void autoDetect() throws IOException {
        int n;
        int[] nArray = new int[4];
        this.in.mark(4);
        nArray[0] = this.in.read();
        nArray[1] = this.in.read();
        nArray[2] = this.in.read();
        nArray[3] = this.in.read();
        this.in.reset();
        if (this.match(nArray, 80, 75, 3, 4)) {
            ZipInputStream zipInputStream = new ZipInputStream(this.in);
            zipInputStream.getNextEntry();
            this.zipped = true;
            this.in = new BufferedInputStream(zipInputStream);
            this.autoDetect();
            return;
        }
        if (this.match(nArray, 254, 255)) {
            this.in.read();
            this.in.read();
            n = 1;
        } else if (this.match(nArray, 255, 254)) {
            this.in.read();
            this.in.read();
            n = 2;
        } else if (this.match(nArray, 239, 187, 191)) {
            this.in.read();
            this.in.read();
            this.in.read();
            n = 0;
        } else {
            n = 0;
        }
        this.encoding = n;
        this.autoDetected = true;
    }

    private boolean match(int[] nArray, int n, int n2, int n3, int n4) {
        return nArray[0] == n && nArray[1] == n2 && nArray[2] == n3 && nArray[3] == n4;
    }

    private boolean match(int[] nArray, int n, int n2, int n3) {
        return nArray[0] == n && nArray[1] == n2 && nArray[2] == n3;
    }

    private boolean match(int[] nArray, int n, int n2) {
        return nArray[0] == n && nArray[1] == n2;
    }

    private int readUtf8(int n) throws IOException {
        switch (n >> 4) {
            case 12: 
            case 13: {
                int n2 = this.in.read();
                if ((n2 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                return (n & 0x1F) << 6 | (n2 & 0x3F) << 0;
            }
            case 14: {
                int n3 = this.in.read();
                int n4 = this.in.read();
                if ((n3 & 0xC0) != 128 || (n4 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                return (n & 0xF) << 12 | (n3 & 0x3F) << 6 | (n4 & 0x3F) << 0;
            }
            case 15: {
                throw new UTFDataFormatException();
            }
        }
        throw new UTFDataFormatException();
    }

    private int readUtf16be() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n < 0) {
            return -1;
        }
        return (n & 0xFF) << 8 | (n2 & 0xFF) << 0;
    }

    private int readUtf16le() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n < 0) {
            return -1;
        }
        return (n2 & 0xFF) << 8 | (n & 0xFF) << 0;
    }
}

