/*
 * Decompiled with CFR 0.152.
 */
package obix.ui.views;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import obix.Obj;
import obix.Uri;
import obix.net.SessionWatch;
import obix.ui.Command;
import obix.ui.Form;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.Utils;
import obix.ui.View;

public class WatchView
extends View {
    SessionWatch watch;
    JTable table;
    Model model;

    public WatchView(Shell shell, UiSession.Response response, SessionWatch sessionWatch) {
        super(shell, sessionWatch.getName(), response);
        this.watch = sessionWatch;
        this.model = new Model();
        this.table = new JTable(this.model);
        this.table.addMouseListener(new Controller());
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(new JButton(new Command(shell, "Add"){

            public void doInvoke() throws Exception {
                WatchView.this.doAdd();
            }
        }));
        jPanel.add(new JButton(new Command(shell, "Remove"){

            public void doInvoke() throws Exception {
                WatchView.this.doRemove();
            }
        }));
        jPanel.add(new JButton(new Command(shell, "Poll Changes"){

            public void doInvoke() throws Exception {
                WatchView.this.doPollChanges();
            }
        }));
        jPanel.add(new JButton(new Command(shell, "Poll Refresh"){

            public void doInvoke() throws Exception {
                WatchView.this.doPollRefresh();
            }
        }));
        jPanel.add(new JButton(new Command(shell, "Dispose"){

            public void doInvoke() throws Exception {
                WatchView.this.doDispose();
            }
        }));
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)jPanel, "South");
    }

    public void animate() {
        this.table.repaint();
    }

    public void doAdd() throws Exception {
        AddPrompt addPrompt = new AddPrompt();
        addPrompt.href = "";
        if ((addPrompt = (AddPrompt)Form.prompt(this, "Add Href to Watch", addPrompt)) == null) {
            return;
        }
        Uri uri = new Uri(addPrompt.href);
        this.watch.add(new Uri[]{uri});
        this.model.fireTableDataChanged();
    }

    public void doRemove() throws Exception {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        this.watch.remove(nArray);
        this.model.fireTableDataChanged();
    }

    public void doPollChanges() throws Exception {
        this.watch.pollChanges();
        this.animate();
    }

    public void doPollRefresh() throws Exception {
        this.watch.pollRefresh();
        this.animate();
    }

    public void doDispose() {
        this.watch.delete();
        this.shell.refresh();
    }

    public static class AddPrompt {
        public String href;
    }

    class Model
    extends AbstractTableModel {
        Model() {
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return WatchView.this.watch.size();
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Href";
                }
                case 1: {
                    return "Contract";
                }
                case 2: {
                    return "Display";
                }
                case 3: {
                    return "Last Update";
                }
            }
            return "?";
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return WatchView.this.watch.get(n).getHref();
                }
                case 1: {
                    return this.doContractsStr(WatchView.this.watch.get(n));
                }
                case 2: {
                    return WatchView.this.watch.get(n).toDisplayString();
                }
                case 3: {
                    return Utils.millisAgo(WatchView.this.watch.getLastUpdate(n));
                }
            }
            return "?";
        }

        private String doContractsStr(Obj obj) {
            String string = "obix:" + obj.getElement();
            if (obj.getIs() != null) {
                string = string + " " + obj.getIs();
            }
            return string;
        }
    }

    class Controller
    extends MouseAdapter {
        Controller() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getClickCount() != 2 || (n = WatchView.this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
                // empty if block
            }
        }
    }
}

