/*
 * Decompiled with CFR 0.152.
 */
package obix.ui.views;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.View;

public class SessionsView
extends View {
    JTable table;
    Row[] rows;

    public SessionsView(Shell shell) {
        super(shell, "Sessions", null);
        UiSession[] uiSessionArray = UiSession.list();
        this.rows = new Row[uiSessionArray.length];
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i] = new Row(uiSessionArray[i]);
        }
        this.table = new JTable(new Model());
        this.table.addMouseListener(new Controller());
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    static class Row {
        UiSession session;

        Row(UiSession uiSession) {
            this.session = uiSession;
        }

        public Object get(int n) {
            switch (n) {
                case 0: {
                    return this.session.getAuthority();
                }
                case 1: {
                    return this.session.getLobbyUri();
                }
                case 2: {
                    return this.session.getUsername();
                }
            }
            return "?";
        }
    }

    class Controller
    extends MouseAdapter {
        Controller() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getClickCount() == 2 && (n = SessionsView.this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
                SessionsView.this.shell.hyperlink("" + SessionsView.this.rows[n].session.getLobbyUri());
            }
        }
    }

    class Model
    extends AbstractTableModel {
        Model() {
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Authority";
                }
                case 1: {
                    return "Lobby";
                }
                case 2: {
                    return "Username";
                }
            }
            return "?";
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return SessionsView.this.rows.length;
        }

        public Object getValueAt(int n, int n2) {
            return SessionsView.this.rows[n].get(n2);
        }
    }
}

