/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.util.ArrayList;
import obix.Uri;
import obix.net.SessionWatch;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.View;
import obix.ui.views.AlarmConsoleView;
import obix.ui.views.ObjSheetView;
import obix.ui.views.SessionsView;
import obix.ui.views.SourceView;
import obix.ui.views.SplashView;
import obix.ui.views.WatchServiceView;
import obix.ui.views.WatchView;
import obix.ui.views.XmlView;

public class ViewRegistry {
    public static View[] toBuiltin(Shell shell, String string) {
        if (!string.startsWith("spy:")) {
            return null;
        }
        if (string.equals("spy:sessions")) {
            return new View[]{new SessionsView(shell)};
        }
        return new View[]{new SplashView(shell)};
    }

    public static View[] viewsFor(Shell shell, UiSession.Response response) throws Exception {
        ArrayList<View> arrayList = new ArrayList<View>();
        arrayList.add(0, new SourceView(shell, response));
        arrayList.add(0, new XmlView(shell, response));
        if (response.obj != null) {
            arrayList.add(0, new ObjSheetView(shell, response));
        }
        if (response.obj != null && response.obj.getIs() != null) {
            Uri[] uriArray = response.obj.getIs().list();
            for (int i = uriArray.length - 1; i >= 0; --i) {
                View[] viewArray = ViewRegistry.viewsForContract(shell, response, uriArray[i]);
                for (int j = 0; viewArray != null && j < viewArray.length; ++j) {
                    arrayList.add(0, viewArray[j]);
                }
            }
        }
        return arrayList.toArray(new View[arrayList.size()]);
    }

    public static View[] viewsForContract(Shell shell, UiSession.Response response, Uri uri) throws Exception {
        String string = uri.toString();
        if (string.equals("obix:WatchService")) {
            return ViewRegistry.viewsForWatchService(shell, response);
        }
        if (string.equals("obix:AlarmSubject")) {
            return ViewRegistry.viewsForAlarmSubject(shell, response);
        }
        return null;
    }

    static View[] viewsForWatchService(Shell shell, UiSession.Response response) throws Exception {
        ArrayList<View> arrayList = new ArrayList<View>();
        arrayList.add(new WatchServiceView(shell, response));
        SessionWatch[] sessionWatchArray = response.session.getWatches();
        for (int i = 0; i < sessionWatchArray.length; ++i) {
            arrayList.add(new WatchView(shell, response, sessionWatchArray[i]));
        }
        return arrayList.toArray(new View[arrayList.size()]);
    }

    static View[] viewsForAlarmSubject(Shell shell, UiSession.Response response) throws Exception {
        return new View[]{new AlarmConsoleView(shell, response)};
    }
}

