/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import obix.List;
import obix.Obj;
import obix.Ref;
import obix.Uri;
import obix.ui.Command;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.Utils;

public class Tree
extends JTree {
    Shell shell;
    Node root;
    DefaultTreeModel model;

    public Tree(Shell shell) {
        this.shell = shell;
        this.root = Tree.makeRoot();
        this.model = new DefaultTreeModel(this.root);
        this.setModel(this.model);
        this.setCellRenderer(new Renderer());
        this.enableEvents(64L);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        TreePath treePath;
        if (mouseEvent.isPopupTrigger()) {
            Node node;
            TreePath treePath2 = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath2 != null && (node = (Node)treePath2.getLastPathComponent()) != null) {
                mouseEvent.consume();
                this.popup(mouseEvent, node);
                return;
            }
        } else if (mouseEvent.getID() == 501 && (treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
            Node node = (Node)treePath.getLastPathComponent();
            if (node != null) {
                this.setSelectionPath(treePath);
                mouseEvent.consume();
                if (mouseEvent.getClickCount() == 1) {
                    this.singleClick(node);
                } else if (mouseEvent.getClickCount() == 2) {
                    this.doubleClick(node);
                }
            }
            return;
        }
        super.processMouseEvent(mouseEvent);
    }

    void sessionCreated(UiSession uiSession) {
        this.root.kids.add(new Node(this.root, uiSession));
        this.model.reload();
    }

    public void singleClick(Node node) {
    }

    public void doubleClick(Node node) {
        if (node.href == null) {
            return;
        }
        this.shell.hyperlink(node.href);
    }

    public void popup(MouseEvent mouseEvent, Node node) {
        if (node.obj == null) {
            return;
        }
        JPopupMenu jPopupMenu = this.shell.commands.makePopup(node.obj);
        if (jPopupMenu == null) {
            jPopupMenu = new JPopupMenu();
        }
        jPopupMenu.add(new Refresh(node));
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    static Node makeRoot() {
        Node node = new Node();
        node.kids = new Vector();
        return node;
    }

    public class Refresh
    extends Command {
        Node node;

        Refresh(Node node) {
            super(Tree.this.shell, "Refresh", "x16/refresh.png", null);
            this.node = node;
        }

        public void doInvoke() {
            this.node.refresh(Tree.this);
        }
    }

    static class Node
    implements TreeNode {
        Node parent;
        UiSession session;
        Obj obj;
        String name;
        Uri href;
        Vector kids;
        boolean leaf;
        Icon icon;

        Node() {
            this.name = "Sessions";
            this.href = new Uri("spy:sessions");
            this.session = null;
            this.leaf = false;
            this.icon = Utils.icon("x16/cloud.png");
        }

        Node(Node node, UiSession uiSession) {
            this.parent = node;
            this.session = uiSession;
            this.name = uiSession.getLobbyUri().toString();
            this.href = uiSession.getLobbyUri();
            this.leaf = false;
            this.icon = Utils.icon("x16/host.png");
        }

        Node(Node node, Obj obj) {
            this.parent = node;
            this.session = node.session;
            this.obj = obj;
            this.name = obj.toDisplayName();
            if (this.name == null) {
                this.name = obj.getElement();
            }
            this.href = obj.getNormalizedHref();
            this.leaf = obj.size() == 0 && !(obj instanceof Ref) && !(obj instanceof List);
            this.icon = this.session.loadIcon(obj);
        }

        public Enumeration children() {
            return this.kids().elements();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public TreeNode getChildAt(int n) {
            return (TreeNode)this.kids().get(n);
        }

        public int getChildCount() {
            return this.kids().size();
        }

        public int getIndex(TreeNode treeNode) {
            return this.kids().indexOf(treeNode);
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public boolean isLeaf() {
            return this.leaf;
        }

        public String toString() {
            return this.name;
        }

        public TreePath getPath() {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Node node = this;
            while (node != null) {
                arrayList.add(0, node);
                node = node.parent;
            }
            return new TreePath(arrayList.toArray());
        }

        public void refresh(Tree tree) {
            this.kids = null;
            tree.collapsePath(this.getPath());
            tree.model.reload(this);
            tree.expandPath(this.getPath());
        }

        Vector kids() {
            if (this.kids == null) {
                System.out.println("Tree.expand: " + this.name + " [" + this.href + "]");
                this.kids = new Vector();
                try {
                    this.obj = this.session.read(this.href);
                    Obj[] objArray = this.obj.list();
                    for (int i = 0; i < objArray.length; ++i) {
                        Obj obj = objArray[i];
                        if (obj.getHref() == null || !obj.isRef() && !obj.isList()) continue;
                        this.kids.add(new Node(this, obj));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return this.kids;
        }
    }

    class Renderer
    extends DefaultTreeCellRenderer {
        Renderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Icon icon;
            if (object instanceof Node && (icon = ((Node)object).icon) != null) {
                this.setOpenIcon(icon);
                this.setClosedIcon(icon);
                this.setLeafIcon(icon);
            }
            return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
    }
}

