/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import obix.Obj;
import obix.ui.Editor;
import obix.ui.HighlightedImageFactory;
import obix.ui.ObjField;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.Utils;

public class ObjSheet
extends Editor {
    static final int indent = 10;
    static final int lgapf = 20;
    static final int ygap = 4;
    static final ImageIcon defaultIcon = Utils.icon("x16/object.png");
    Node node;
    Shell shell;
    UiSession session;

    public static Obj prompt(Shell shell, String string, UiSession uiSession, Obj obj) throws Exception {
        ObjSheet objSheet = new ObjSheet(shell, uiSession);
        objSheet.load(obj);
        JOptionPane jOptionPane = new JOptionPane(objSheet, -1, 2);
        JDialog jDialog = jOptionPane.createDialog(shell, string);
        jDialog.pack();
        jDialog.setVisible(true);
        if (jOptionPane.getValue() == null || jOptionPane.getValue().equals(new Integer(2))) {
            return null;
        }
        objSheet.save(obj);
        return obj;
    }

    public ObjSheet(Shell shell, UiSession uiSession) {
        this.setLayout(new Layout());
        this.shell = shell;
        this.session = uiSession;
    }

    protected void doSetEditable(boolean bl) {
        this.node.setEditable(bl);
    }

    protected void doLoad(Obj obj) {
        this.removeAll();
        this.node = new Node(obj);
    }

    protected void doSave(Obj obj) throws Exception {
        if (obj != this.node.target) {
            throw new IllegalStateException("Must save back to same instance passed to load()");
        }
        this.node.save(null);
    }

    public void save(SaveVisitor saveVisitor) throws Exception {
        this.node.save(saveVisitor);
    }

    public static interface SaveVisitor {
        public void save(Obj var1) throws Exception;
    }

    class Layout
    implements LayoutManager {
        int lmaxw;
        int fmaxw;
        int prefw;
        int prefh;

        Layout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            this.layoutContainer(container);
            return new Dimension(this.prefw, this.prefh);
        }

        public void layoutContainer(Container container) {
            this.prefh = 0;
            this.prefw = 0;
            if (ObjSheet.this.node == null) {
                return;
            }
            this.findMax(ObjSheet.this.node, 0);
            this.prefw = this.lmaxw + 20 + this.fmaxw;
            this.prefh = this.layout(ObjSheet.this.node, 0, 0, this.lmaxw + 20);
        }

        void findMax(Node node, int n) {
            this.lmaxw = Math.max(n + node.label.getPreferredSize().width, this.lmaxw);
            if (node.field != null) {
                this.fmaxw = Math.max(node.field.getPreferredSize().width, this.fmaxw);
            }
            for (int i = 0; i < node.kids.length; ++i) {
                this.findMax(node.kids[i], n + 10);
            }
        }

        int layout(Node node, int n, int n2, int n3) {
            Dimension dimension = node.label.getPreferredSize();
            int n4 = dimension.height;
            if (node.field != null) {
                Dimension dimension2 = node.field.getPreferredSize();
                node.field.setBounds(n3, n2, dimension2.width, dimension2.height);
                n4 = Math.max(n4, dimension2.height);
            }
            node.label.setBounds(n, n2 + (n4 - dimension.height) / 2, dimension.width, dimension.height);
            n2 += n4;
            for (int i = 0; i < node.kids.length; ++i) {
                n2 = this.layout(node.kids[i], n + 10, n2 + 4, n3);
            }
            return n2;
        }
    }

    class ObjLabel
    extends JLabel {
        Obj target;
        Color fg;
        boolean mouseOver;

        ObjLabel(String string, Icon icon, Obj obj) {
            super(string, icon, 2);
            this.target = obj;
            this.fg = this.getForeground();
            this.enableEvents(16L);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (ObjSheet.this.shell == null || this.target.getHref() == null) {
                return;
            }
            if (mouseEvent.isPopupTrigger()) {
                JPopupMenu jPopupMenu = ObjSheet.this.shell.commands.makePopup(this.target);
                if (jPopupMenu != null) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                return;
            }
            switch (mouseEvent.getID()) {
                case 504: {
                    this.mouseOver = true;
                    ObjSheet.this.shell.status("href=" + this.target.getHref());
                    this.setForeground(Color.blue);
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    break;
                }
                case 505: {
                    this.mouseOver = false;
                    ObjSheet.this.shell.status(null);
                    this.setForeground(this.fg);
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 502: {
                    if (!this.mouseOver || mouseEvent.getButton() != 1) break;
                    ObjSheet.this.shell.hyperlink(this.target.getNormalizedHref());
                }
            }
        }
    }

    class Node
    implements Editor.Listener {
        Obj target;
        String name;
        Icon icon;
        ObjLabel label;
        ObjField field;
        boolean changed;
        Node[] kids;

        Node(Obj obj) {
            this.target = obj;
            this.name = obj.toDisplayName();
            this.icon = ObjSheet.this.session != null ? ObjSheet.this.session.loadIcon(obj) : defaultIcon;
            this.label = new ObjLabel(this.name, this.icon, obj);
            ObjSheet.this.add(this.label);
            this.field = ObjField.make(obj);
            this.field.addListener(this);
            this.field.load(obj);
            if (!obj.isWritable() && ObjSheet.this.shell.commands.useWritable.isSelected()) {
                this.field.setEditable(false);
            }
            ObjSheet.this.add(this.field);
            if (this.isAtomic(obj)) {
                this.kids = new Node[0];
            } else {
                Obj[] objArray = obj.list();
                this.kids = new Node[objArray.length];
                for (int i = 0; i < this.kids.length; ++i) {
                    this.kids[i] = new Node(objArray[i]);
                }
            }
        }

        public boolean isAtomic(Obj obj) {
            return obj.is("obix:Status");
        }

        public void changed(Editor editor) {
            if (this.changed) {
                return;
            }
            this.changed = true;
            this.label.setIcon(HighlightedImageFactory.convert(this.icon));
            this.label.repaint();
            ObjSheet.this.fireChanged();
        }

        void setEditable(boolean bl) {
            if (this.field != null) {
                this.field.setEditable(bl);
            }
            for (int i = 0; i < this.kids.length; ++i) {
                this.kids[i].setEditable(bl);
            }
        }

        void save(SaveVisitor saveVisitor) throws Exception {
            if (this.field != null && this.changed) {
                try {
                    this.field.save(this.target);
                    if (saveVisitor != null) {
                        saveVisitor.save(this.target);
                    }
                    this.label.setIcon(this.icon);
                    this.changed = false;
                }
                catch (Exception exception) {
                    throw new Exception("Cannot save field: " + this.name, exception);
                }
            }
            for (int i = 0; i < this.kids.length; ++i) {
                this.kids[i].save(saveVisitor);
            }
        }
    }
}

