/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import obix.ui.HyperlinkInfo;
import obix.ui.Shell;

public class Locator
extends JComboBox {
    public final Shell shell;
    boolean locked;

    public Locator(Shell shell) {
        this.shell = shell;
        this.setEditable(true);
        this.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                Locator.this.editorKeyPressed(keyEvent);
            }
        });
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Locator.this.itemChanged(itemEvent);
            }
        });
    }

    void update(String string) {
        this.locked = true;
        this.getEditor().setItem(string);
        if (this.getItemCount() > 20) {
            this.removeItemAt(this.getItemCount() - 1);
        }
        this.insertItemAt(string, 0);
        this.setSelectedIndex(0);
        this.locked = false;
    }

    void editorKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.handleEnter();
            keyEvent.consume();
        }
    }

    void handleEnter() {
        String string = "" + this.getEditor().getItem();
        this.shell.hyperlink(new HyperlinkInfo(string));
    }

    void itemChanged(ItemEvent itemEvent) {
        if (this.locked) {
            return;
        }
        String string = "" + this.getSelectedItem();
        if (!string.equals(this.shell.uri())) {
            this.shell.hyperlink(string);
        }
    }
}

