/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import obix.Uri;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.View;
import obix.ui.ViewPane;
import obix.ui.ViewRegistry;
import obix.ui.views.ErrorView;

public class HyperlinkInfo {
    String uriStr;
    boolean addToHistory;
    Shell shell;
    Uri uri;
    UiSession session;
    UiSession.Response resp;
    View[] views;

    public HyperlinkInfo(String string, boolean bl) {
        this.uriStr = string;
        this.addToHistory = bl;
    }

    public HyperlinkInfo(String string) {
        this(string, true);
    }

    public void hyperlink(Shell shell) throws Exception {
        this.shell = shell;
        this.closeCurrentViews();
        try {
            this.views = ViewRegistry.toBuiltin(shell, this.uriStr);
            if (this.views == null) {
                this.toUri();
                this.toSession();
                this.toResponse();
                this.toViews();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.views = new View[]{new ErrorView(shell, throwable)};
        }
        if (this.addToHistory) {
            shell.history.append(this.uriStr);
        }
        this.updateUi();
    }

    void closeCurrentViews() {
        if (this.shell.views == null) {
            return;
        }
        if (this.shell.views.views == null) {
            return;
        }
        View[] viewArray = this.shell.views.views;
        for (int i = 0; i < viewArray.length; ++i) {
            View view = viewArray[i];
            try {
                view.closing();
                continue;
            }
            catch (Exception exception) {
                System.out.println("ERROR: Closing " + view.name);
            }
        }
    }

    void toUri() {
        this.uri = new Uri(this.uriStr);
        this.uri.checkAbsolute();
        this.uriStr = this.uri.toString();
    }

    void toSession() throws Exception {
        this.session = UiSession.make(this.shell, this.uri);
        if (this.session == null) {
            throw new RuntimeException("User canceled open session dialog");
        }
    }

    void toResponse() throws Exception {
        this.resp = this.session.request(this.uri);
    }

    void toViews() throws Exception {
        this.views = ViewRegistry.viewsFor(this.shell, this.resp);
    }

    void updateUi() {
        this.shell.commands.save.setEnabled(false);
        this.shell.commands.update();
        this.shell.locator.update(this.uriStr);
        this.shell.setViewPane(new ViewPane(this.shell, this.uri, this.views));
        this.shell.status(this.uriStr);
    }
}

