/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Field;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import obix.ui.UiSession;
import obix.ui.Utils;

public class Form
extends JPanel {
    Object target;
    Editor[] editors;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$obix$ui$UiSession;

    public static Object prompt(JComponent jComponent, String string, Object object) {
        Form form = new Form(object);
        form.load();
        JOptionPane jOptionPane = new JOptionPane(form, -1, 2);
        JDialog jDialog = jOptionPane.createDialog(jComponent, string);
        jDialog.pack();
        jDialog.setVisible(true);
        if (jOptionPane.getValue() == null || jOptionPane.getValue().equals(new Integer(2))) {
            return null;
        }
        form.save();
        return object;
    }

    public Form(Object object) {
        try {
            this.target = object;
            Field[] fieldArray = object.getClass().getFields();
            this.editors = new Editor[fieldArray.length];
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            for (int i = 0; i < fieldArray.length; ++i) {
                this.editors[i] = Form.makeEditor(fieldArray[i]);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = i;
                gridBagConstraints.insets = new Insets(2, 2, 2, 2);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 0.0;
                gridBagLayout.setConstraints(this.editors[i].label, gridBagConstraints);
                this.add(this.editors[i].label);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = i;
                gridBagConstraints.insets = new Insets(2, 2, 2, 2);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 1.0;
                gridBagLayout.setConstraints(this.editors[i].editor, gridBagConstraints);
                this.add(this.editors[i].editor);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void load() {
        for (int i = 0; i < this.editors.length; ++i) {
            Editor editor = this.editors[i];
            try {
                editor.load(editor.field.get(this.target));
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException("Cannot save form field: " + editor.name, exception);
            }
        }
    }

    public void save() {
        for (int i = 0; i < this.editors.length; ++i) {
            Editor editor = this.editors[i];
            try {
                editor.field.set(this.target, editor.save());
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException("Cannot save form field: " + editor.name, exception);
            }
        }
    }

    static Editor makeEditor(Field field) {
        Class<?> clazz = field.getType();
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = Form.class$("java.lang.String")) : class$java$lang$String)) {
            return new StringEditor(field);
        }
        if (clazz == Integer.TYPE) {
            return new IntEditor(field);
        }
        if (clazz == (class$obix$ui$UiSession == null ? (class$obix$ui$UiSession = Form.class$("obix.ui.UiSession")) : class$obix$ui$UiSession)) {
            return new SessionEditor(field);
        }
        throw new IllegalStateException("Field not unsupported: " + clazz.getName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SessionEditor
    extends Editor {
        JComboBox combo;

        SessionEditor(Field field) {
            super(field);
            this.editor = this.combo = new JComboBox<UiSession>(UiSession.list());
            this.combo.setSelectedIndex(0);
        }

        void load(Object object) {
            if (object != null) {
                this.combo.setSelectedItem(object);
            }
        }

        Object save() {
            return this.combo.getSelectedItem();
        }
    }

    static class IntEditor
    extends Editor {
        JTextField textField = new JTextField("0", 15);

        IntEditor(Field field) {
            super(field);
            this.editor = this.textField;
        }

        void load(Object object) {
            this.textField.setText(object.toString());
        }

        Object save() {
            return new Integer(this.textField.getText());
        }
    }

    static class StringEditor
    extends Editor {
        JTextField textField;

        StringEditor(Field field) {
            super(field);
            if (field.getName().equals("password")) {
                this.textField = new JPasswordField("", 30);
                this.editor = this.textField;
            } else {
                this.textField = new JTextField("", 30);
                this.editor = this.textField;
            }
        }

        void load(Object object) {
            this.textField.setText(object.toString());
        }

        Object save() {
            return this.textField.getText();
        }
    }

    static abstract class Editor {
        Field field;
        String name;
        JLabel label;
        JComponent editor;

        Editor(Field field) {
            this.field = field;
            this.name = Utils.toFriendly(field.getName());
            this.label = new JLabel(this.name, 2);
        }

        abstract void load(Object var1);

        abstract Object save();
    }
}

