/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import obix.Obj;
import obix.Op;
import obix.Uri;
import obix.ui.Command;
import obix.ui.History;
import obix.ui.HyperlinkInfo;
import obix.ui.Shell;
import obix.ui.UiSession;

public class Commands {
    public final Shell shell;
    public final Command back = new Back();
    public final Command forward = new Forward();
    public final Command up = new Up();
    public final Command refresh = new Refresh();
    public final Command save = new Save();
    public final Command exit = new Exit();
    public final Command localHost = new LocalHost();
    public final Command sessions = new Sessions();
    public final ToggleCommand verbose = new Verbose();
    public final ToggleCommand useWritable = new UseWritable();
    public final Command about = new About();
    static /* synthetic */ Class class$obix$Op;

    public Commands(Shell shell) {
        this.shell = shell;
    }

    public JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.makeFileMenu());
        jMenuBar.add(this.makeToolsMenu());
        jMenuBar.add(this.makeHelpMenu());
        return jMenuBar;
    }

    private JMenu makeFileMenu() {
        JMenu jMenu = new JMenu("File");
        jMenu.add(Commands.makeMenuItem(this.back));
        jMenu.add(Commands.makeMenuItem(this.forward));
        jMenu.add(Commands.makeMenuItem(this.up));
        jMenu.add(Commands.makeMenuItem(this.refresh));
        jMenu.add(new JSeparator());
        jMenu.add(Commands.makeMenuItem(this.save));
        jMenu.add(new JSeparator());
        jMenu.add(Commands.makeMenuItem(this.exit));
        return jMenu;
    }

    private JMenu makeToolsMenu() {
        JMenu jMenu = new JMenu("Tools");
        jMenu.add(Commands.makeMenuItem(this.localHost));
        jMenu.add(Commands.makeMenuItem(this.sessions));
        jMenu.add(new JSeparator());
        jMenu.add(Commands.makeMenuItem(this.verbose));
        jMenu.add(Commands.makeMenuItem(this.useWritable));
        return jMenu;
    }

    private JMenu makeHelpMenu() {
        JMenu jMenu = new JMenu("Help");
        jMenu.add(Commands.makeMenuItem(this.about));
        return jMenu;
    }

    public static JMenuItem makeMenuItem(Command command) {
        JMenuItem jMenuItem;
        if (command instanceof ToggleCommand) {
            jMenuItem = new JCheckBoxMenuItem(command);
            jMenuItem.setSelected(((ToggleCommand)command).isSelected());
        } else {
            jMenuItem = new JMenuItem(command);
        }
        command.bind(jMenuItem);
        return jMenuItem;
    }

    public JToolBar makeToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(Commands.makeToolBarButton(this.back));
        jToolBar.add(Commands.makeToolBarButton(this.forward));
        jToolBar.add(Commands.makeToolBarButton(this.up));
        jToolBar.add(Commands.makeToolBarButton(this.refresh));
        jToolBar.add(new JSeparator());
        jToolBar.add(Commands.makeToolBarButton(this.save));
        return jToolBar;
    }

    public static AbstractButton makeToolBarButton(Command command) {
        AbstractButton abstractButton;
        if (command instanceof ToggleCommand) {
            abstractButton = new JToggleButton(command);
            abstractButton.setSelected(((ToggleCommand)command).isSelected());
        } else {
            abstractButton = new JButton(command);
        }
        abstractButton.setFocusable(false);
        abstractButton.setText(null);
        abstractButton.setBorderPainted(false);
        command.bind(abstractButton);
        return abstractButton;
    }

    public JPopupMenu makePopup(Obj obj) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        Op[] opArray = (Op[])obj.list(class$obix$Op == null ? (class$obix$Op = Commands.class$("obix.Op")) : class$obix$Op);
        if (opArray.length > 0) {
            JMenu jMenu = new JMenu("Operations");
            jMenu.setIcon(UiSession.iconOp);
            for (int i = 0; i < opArray.length; ++i) {
                jMenu.add(new Invoke(opArray[i]));
            }
            jPopupMenu.add(jMenu);
        }
        if (obj.getHref() != null) {
            jPopupMenu.add(new Goto(obj.getNormalizedHref()));
        }
        if (obj instanceof Op) {
            jPopupMenu.add(new Invoke((Op)obj));
        }
        return jPopupMenu;
    }

    public void update() {
        History history = this.shell.history;
        this.back.setEnabled(history.isBackEnabled());
        this.forward.setEnabled(history.isForwardEnabled());
        this.up.setEnabled(history.isUpEnabled());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class Invoke
    extends MyCommand {
        Op op;

        Invoke(Op op) {
            super(op.toDisplayName(), "x16/exclaim.png", null);
            this.op = op;
        }

        public void doInvoke() throws Exception {
            UiSession uiSession = UiSession.make(Commands.this.shell, this.op.getNormalizedHref());
            uiSession.invoke(Commands.this.shell, this.op);
        }
    }

    public class Goto
    extends MyCommand {
        Uri uri;

        Goto(Uri uri) {
            super("Goto", "x16/arrowRight.png", null);
            this.uri = uri;
        }

        public void doInvoke() {
            Commands.this.shell.hyperlink(this.uri);
        }
    }

    public class About
    extends MyCommand {
        About() {
            super("About", "x16/questionMark.png", null);
        }

        public void doInvoke() {
            Commands.this.shell.hyperlink("spy:splash");
        }
    }

    public class Sessions
    extends MyCommand {
        Sessions() {
            super("Sessions", null, null);
        }

        public void doInvoke() {
            Commands.this.shell.hyperlink("spy:sessions");
        }
    }

    public class LocalHost
    extends MyCommand {
        LocalHost() {
            super("LocalHost", null, null);
        }

        public void doInvoke() {
            Commands.this.shell.hyperlink("http://localhost/obix");
        }
    }

    public class UseWritable
    extends ToggleCommand {
        UseWritable() {
            super("Use Writable", null, null);
            this.setSelected(true);
        }

        public void doInvoke() {
            Commands.this.refresh.invoke();
        }
    }

    public class Verbose
    extends ToggleCommand {
        Verbose() {
            super("Verbose", "x16/v.png", null);
            this.setSelected(true);
        }

        public void doInvoke() {
            Commands.this.refresh.invoke();
        }
    }

    public class Exit
    extends MyCommand {
        Exit() {
            super("Exit", "x16/close.png", "control X");
        }

        public void doInvoke() {
            Commands.this.shell.savePrefs();
            System.exit(0);
        }
    }

    public class Save
    extends MyCommand {
        Save() {
            super("Save", "x16/save.png", "control S");
        }

        public void doInvoke() throws Exception {
            Commands.this.shell.activeView().save();
            this.setEnabled(false);
        }
    }

    public class Refresh
    extends MyCommand {
        Refresh() {
            super("Refresh", "x16/refresh.png", "control R");
        }

        public void doInvoke() {
            Commands.this.shell.refresh();
        }
    }

    public class Up
    extends MyCommand {
        Up() {
            super("Up", "x16/upLevel.png", "alt UP");
        }

        public void doInvoke() {
            int n;
            String string = Commands.this.shell.uri().toString();
            if (string.startsWith("spy:") && (n = string.lastIndexOf(47)) > 0) {
                Commands.this.shell.hyperlink(string.substring(0, n));
                return;
            }
            Uri uri = new Uri(Commands.this.shell.uri()).parent();
            if (uri != null) {
                Commands.this.shell.hyperlink(uri.toString());
            }
        }
    }

    public class Forward
    extends MyCommand {
        Forward() {
            super("Forward", "x16/arrowRight.png", "alt RIGHT");
        }

        public void doInvoke() {
            String string = Commands.this.shell.history.forward();
            if (string == null) {
                return;
            }
            Commands.this.shell.hyperlink(new HyperlinkInfo(string, false));
        }
    }

    public class Back
    extends MyCommand {
        Back() {
            super("Back", "x16/arrowLeft.png", "alt LEFT");
        }

        public void doInvoke() {
            String string = Commands.this.shell.history.back();
            if (string == null) {
                return;
            }
            Commands.this.shell.hyperlink(new HyperlinkInfo(string, false));
        }
    }

    public abstract class ToggleCommand
    extends MyCommand {
        boolean selected;

        public ToggleCommand(String string, String string2, String string3) {
            super(string, string2, string3);
        }

        public ToggleCommand(String string) {
            super(string);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            if (this.selected == bl) {
                return;
            }
            this.selected = bl;
            JComponent[] jComponentArray = this.bindings();
            for (int i = 0; i < jComponentArray.length; ++i) {
                this.setSelected(jComponentArray[i], bl);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setSelected(this.getSelected(actionEvent.getSource()));
            super.actionPerformed(actionEvent);
        }

        boolean getSelected(Object object) {
            if (object instanceof JToggleButton) {
                return ((JToggleButton)object).isSelected();
            }
            if (object instanceof JCheckBoxMenuItem) {
                return ((JCheckBoxMenuItem)object).getState();
            }
            throw new IllegalStateException(object.getClass().getName());
        }

        void setSelected(Object object, boolean bl) {
            if (object instanceof JToggleButton) {
                ((JToggleButton)object).setSelected(bl);
                return;
            }
            if (object instanceof JCheckBoxMenuItem) {
                ((JCheckBoxMenuItem)object).setState(bl);
                return;
            }
        }
    }

    public abstract class MyCommand
    extends Command {
        public MyCommand(String string, String string2, String string3) {
            super(null, string, string2, string3);
        }

        public MyCommand(String string) {
            this(string, null, null);
        }

        public Shell shell() {
            return Commands.this.shell;
        }
    }
}

