/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import obix.ui.Shell;
import obix.ui.Utils;

public abstract class Command
extends AbstractAction {
    private String name;
    private Shell shell;
    private ArrayList bindings = new ArrayList();

    public Command(Shell shell, String string, String string2, String string3) {
        super(string);
        this.shell = shell;
        this.name = string;
        if (string2 != null) {
            this.putValue("SmallIcon", Utils.icon(string2));
        }
        if (string3 != null) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(string3));
        }
    }

    public Command(Shell shell, String string) {
        this(shell, string, null, null);
    }

    public Shell shell() {
        return this.shell;
    }

    public void invoke() {
        try {
            this.shell().setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.doInvoke();
            }
            finally {
                this.shell().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            String string = "Error invoking \"" + this.name + "\" command (see console for stack trace)\n" + throwable;
            JOptionPane.showMessageDialog(this.shell(), string, "Error", 0);
        }
    }

    public abstract void doInvoke() throws Exception;

    public void actionPerformed(ActionEvent actionEvent) {
        this.invoke();
    }

    public void bind(JComponent jComponent) {
        this.bindings.add(jComponent);
    }

    public void unbind(JComponent jComponent) {
        this.bindings.remove(jComponent);
    }

    public JComponent[] bindings() {
        return this.bindings.toArray(new JComponent[this.bindings.size()]);
    }
}

