/*
 * Decompiled with CFR 0.152.
 */
package obix.test;

import obix.Time;
import obix.test.Test;

public class TimeTest
extends Test {
    public static final long S = 1000L;
    public static final long M = 60000L;
    public static final long H = 3600000L;

    public void run() throws Exception {
        Time time = new Time(1, 2, 3, 4);
        this.verify(time.getHour(), 1L);
        this.verify(time.getMinute(), (long)2);
        this.verify(time.getSecond(), (long)3);
        this.verify(time.getMillisecond(), (long)4);
        this.verify(time.equals(new Time(1, 2, 3, 4)));
        this.verify(time.equals(new Time(1, 2, 3, 0)) ^ true);
        this.verify(time.equals(new Time(1, 2, 0, 4)) ^ true);
        this.verify(time.equals(new Time(1, 0, 3, 4)) ^ true);
        this.verify(time.equals(new Time(0, 2, 3, 4)) ^ true);
        boolean bl = false;
        if (new Time(1, 2, 3, 4).compareTo(new Time(1, 2, 3, 4)) == 0) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (new Time(1, 2, 3, 3).compareTo(new Time(1, 2, 3, 4)) < 0) {
            bl2 = true;
        }
        this.verify(bl2);
        boolean bl3 = false;
        if (new Time(1, 2, 3, 5).compareTo(new Time(1, 2, 3, 4)) > 0) {
            bl3 = true;
        }
        this.verify(bl3);
        boolean bl4 = false;
        if (new Time(1, 2, 10, 4).compareTo(new Time(1, 2, 3, 4)) > 0) {
            bl4 = true;
        }
        this.verify(bl4);
        boolean bl5 = false;
        if (new Time(1, 2, 3, 4).compareTo(new Time(13, 2, 3, 4)) < 0) {
            bl5 = true;
        }
        this.verify(bl5);
        this.verify("12:34", 45240000L);
        this.verify("00:00", 0L);
        this.verify("00:00:00", 0L);
        this.verify("02:00:00", 0x6DDD00L);
        this.verify("02:03:00", 7380000L);
        this.verify("02:03:04", 7384000L);
        this.verify("02:03:04.007", 7384007L);
        this.verify("02:03:04.087", 7384087L);
        this.verify("02:03:04.987", 7384987L);
        this.verify("23:58:36.030", 86316030L);
        this.verify("12:34:56.0123", 45296012L);
        this.verify("12:34:56.01234", 45296012L);
        this.verifyInvalid("2:30");
        this.verifyInvalid("12:4");
        this.verifyInvalid("12.34");
        this.verifyInvalid("12:34.3");
        this.verifyInvalid("12:34:3");
        this.verifyInvalid("12:34:35x");
    }

    public void verify(String string, long l) throws Exception {
        Time time = new Time();
        time.decodeVal(string);
        boolean bl = false;
        if (time.getMillis() == l) {
            bl = true;
        }
        this.verify(bl);
        Time time2 = new Time();
        time2.decodeVal(time.encodeVal());
        this.verify(time2.equals(time));
        boolean bl2 = false;
        if (time2.getMillis() == l) {
            bl2 = true;
        }
        this.verify(bl2);
        this.verify(new Time(l), time);
    }

    public void verifyInvalid(String string) throws Exception {
        Exception exception = null;
        Time time = new Time();
        try {
            time.decodeVal(string);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        boolean bl = false;
        if (exception != null) {
            bl = true;
        }
        this.verify(bl);
    }
}

