/*
 * Decompiled with CFR 0.152.
 */
package obix.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import obix.Abstime;
import obix.Bool;
import obix.Date;
import obix.Enum;
import obix.Feed;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Real;
import obix.Reltime;
import obix.Str;
import obix.Time;
import obix.Val;
import obix.io.BinObixDecoder;
import obix.io.BinObixEncoder;
import obix.io.ObixDecoder;
import obix.io.ObixEncoder;
import obix.test.AbstimeTest;
import obix.test.ContractTest;
import obix.test.DateTest;
import obix.test.FragmentsTest;
import obix.test.IOTest;
import obix.test.ReltimeTest;
import obix.test.TestException;
import obix.test.TimeTest;
import obix.test.TreeTest;
import obix.test.UriTest;

public abstract class Test {
    public static final Test[] tests = new Test[]{new TreeTest(), new IOTest(), new AbstimeTest(), new ReltimeTest(), new TimeTest(), new DateTest(), new UriTest(), new ContractTest(), new FragmentsTest()};
    static boolean verbose;
    int count;
    byte[] binaryRoundtrip;

    public String getName() {
        return this.getClass().getName();
    }

    public abstract void run() throws Exception;

    public void verify(boolean bl) {
        if (!bl) {
            throw new TestException("Failed verify");
        }
        ++this.count;
    }

    public void verify(boolean bl, String string) {
        if (!bl) {
            throw new TestException("Failed verify: " + string);
        }
        ++this.count;
    }

    public void verify(Object object, Object object2) {
        if (object == null) {
            boolean bl = false;
            if (object2 == null) {
                bl = true;
            }
            this.verify(bl);
        } else if (object2 == null) {
            boolean bl = false;
            if (object == null) {
                bl = true;
            }
            this.verify(bl);
        } else {
            this.verify(object.equals(object2));
        }
    }

    public void verify(long l, long l2) {
        boolean bl = false;
        if (l == l2) {
            bl = true;
        }
        this.verify(bl);
    }

    public void verifyEquivalent(Obj obj, Obj obj2) {
        if (verbose) {
            System.out.println("  " + obj + " ?= " + obj2);
        }
        boolean bl = false;
        if (obj.getClass() == obj2.getClass()) {
            bl = true;
        }
        this.verify(bl);
        this.verify(obj.getName(), (Object)obj2.getName());
        this.verify(obj.getHref(), obj2.getHref());
        this.verify(obj.getIs(), obj2.getIs());
        if (obj instanceof Val) {
            this.verify(((Val)obj).encodeVal(), (Object)((Val)obj2).encodeVal());
        }
        if (obj instanceof List) {
            this.verify(((List)obj).getOf(), ((List)obj2).getOf());
        }
        if (obj instanceof Op) {
            this.verify(((Op)obj).getIn(), ((Op)obj2).getIn());
            this.verify(((Op)obj).getOut(), ((Op)obj2).getOut());
        }
        if (obj instanceof Feed) {
            this.verify(((Feed)obj).getIn(), ((Feed)obj2).getIn());
            this.verify(((Feed)obj).getOf(), ((Feed)obj2).getOf());
        }
        this.verify(obj.getDisplay(), (Object)obj2.getDisplay());
        this.verify(obj.getDisplayName(), (Object)obj2.getDisplayName());
        this.verify(obj.getIcon(), obj2.getIcon());
        boolean bl2 = false;
        if (obj.getStatus() == obj2.getStatus()) {
            bl2 = true;
        }
        this.verify(bl2);
        this.verify(obj.isNull() ^ obj2.isNull() ^ true);
        this.verify(obj.isWritable() ^ obj2.isWritable() ^ true);
        if (obj instanceof Bool) {
            this.verify(((Bool)obj).getRange(), ((Bool)obj2).getRange());
        } else if (obj instanceof Enum) {
            this.verify(((Enum)obj).getRange(), ((Enum)obj2).getRange());
        } else if (obj instanceof Int) {
            boolean bl3 = false;
            if (((Int)obj).getMin() == ((Int)obj2).getMin()) {
                bl3 = true;
            }
            this.verify(bl3);
            boolean bl4 = false;
            if (((Int)obj).getMax() == ((Int)obj2).getMax()) {
                bl4 = true;
            }
            this.verify(bl4);
            this.verify(((Int)obj).getUnit(), ((Int)obj2).getUnit());
        } else if (obj instanceof Real) {
            boolean bl5 = false;
            if (((Real)obj).getMin() == ((Real)obj2).getMin()) {
                bl5 = true;
            }
            this.verify(bl5);
            boolean bl6 = false;
            if (((Real)obj).getMax() == ((Real)obj2).getMax()) {
                bl6 = true;
            }
            this.verify(bl6);
            this.verify(((Real)obj).getUnit(), ((Real)obj2).getUnit());
            boolean bl7 = false;
            if (((Real)obj).getPrecision() == ((Real)obj2).getPrecision()) {
                bl7 = true;
            }
            this.verify(bl7);
        } else if (obj instanceof Str) {
            boolean bl8 = false;
            if (((Str)obj).getMin() == ((Str)obj2).getMin()) {
                bl8 = true;
            }
            this.verify(bl8);
            boolean bl9 = false;
            if (((Str)obj).getMax() == ((Str)obj2).getMax()) {
                bl9 = true;
            }
            this.verify(bl9);
        } else if (obj instanceof Reltime) {
            this.verify(((Reltime)obj).getMin(), ((Reltime)obj2).getMin());
            this.verify(((Reltime)obj).getMax(), ((Reltime)obj2).getMax());
        } else if (obj instanceof Abstime) {
            this.verify(((Abstime)obj).getMin(), ((Abstime)obj2).getMin());
            this.verify(((Abstime)obj).getMax(), ((Abstime)obj2).getMax());
            this.verify(((Abstime)obj).getTz(), (Object)((Abstime)obj2).getTz());
        } else if (obj instanceof Time) {
            this.verify(((Time)obj).getMin(), ((Time)obj2).getMin());
            this.verify(((Time)obj).getMax(), ((Time)obj2).getMax());
            this.verify(((Time)obj).getTz(), (Object)((Time)obj2).getTz());
        } else if (obj instanceof Date) {
            this.verify(((Date)obj).getMin(), ((Date)obj2).getMin());
            this.verify(((Date)obj).getMax(), ((Date)obj2).getMax());
            this.verify(((Date)obj).getTz(), (Object)((Date)obj2).getTz());
        } else if (obj instanceof List) {
            boolean bl10 = false;
            if (((List)obj).getMin() == ((List)obj2).getMin()) {
                bl10 = true;
            }
            this.verify(bl10);
            boolean bl11 = false;
            if (((List)obj).getMax() == ((List)obj2).getMax()) {
                bl11 = true;
            }
            this.verify(bl11);
        }
        Obj[] objArray = obj.list();
        Obj[] objArray2 = obj2.list();
        boolean bl12 = false;
        if (objArray.length == objArray2.length) {
            bl12 = true;
        }
        this.verify(bl12);
        int n = 0;
        while (n < objArray.length) {
            this.verifyEquivalent(objArray[n], objArray2[n]);
            ++n;
        }
    }

    public Obj roundtrip(Obj obj) throws Exception {
        return this.roundtrip(obj, true);
    }

    public Obj roundtrip(Obj obj, boolean bl) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObixEncoder obixEncoder = new ObixEncoder(byteArrayOutputStream);
        obixEncoder.encodeDocument(obj);
        obixEncoder.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObixDecoder obixDecoder = new ObixDecoder(byteArrayInputStream);
        Obj obj2 = obixDecoder.decodeDocument();
        if (verbose) {
            System.out.println("");
            System.out.println("============");
            System.out.write(byArray);
            System.out.println("--- xml ---");
            ObixEncoder.dump(obj2);
        }
        this.verifyEquivalent(obj, obj2);
        this.binaryRoundtrip = null;
        if (bl) {
            byte[] byArray2 = BinObixEncoder.toBytes(obj);
            this.binaryRoundtrip = byArray2;
            Obj obj3 = BinObixDecoder.fromBytes(byArray2);
            if (verbose) {
                System.out.print("Bin:");
                int n = 0;
                while (n < byArray2.length) {
                    int n2 = byArray2[n] & 0xFF;
                    System.out.print(" " + (n2 < 10 ? "0" : "") + Integer.toHexString(n2));
                    ++n;
                }
                System.out.println();
                ObixEncoder.dump(obj3);
            }
            this.verifyEquivalent(obj, obj3);
        }
        return obj2;
    }

    public static void main(String[] stringArray) {
        String string = "";
        if (stringArray.length > 0 && !stringArray[0].startsWith("/")) {
            string = "obix.test." + stringArray[0];
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("/v")) {
                verbose = true;
            }
            ++n;
        }
        n = 0;
        while (n < tests.length) {
            Test test = tests[n];
            if (test.getName().startsWith(string)) {
                try {
                    test.run();
                    System.out.println("Success: " + test.getName() + " [" + test.count + ']');
                }
                catch (Throwable throwable) {
                    System.out.println("FAILED:  " + test.getName());
                    throwable.printStackTrace();
                }
            }
            ++n;
        }
    }
}

