/*
 * Decompiled with CFR 0.152.
 */
package obix.test;

import java.io.ByteArrayInputStream;
import java.util.TimeZone;
import obix.Abstime;
import obix.Bool;
import obix.Contract;
import obix.Date;
import obix.Enum;
import obix.Err;
import obix.Feed;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Real;
import obix.Ref;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Time;
import obix.Uri;
import obix.io.ObixDecoder;
import obix.test.Test;

public class IOTest
extends Test {
    public void run() throws Exception {
        this.verify(new Obj());
        this.verify(new Obj("foo"));
        this.verify(new Bool());
        this.verify(new Bool("foo"));
        this.verify(new Bool(true));
        this.verify(new Bool("foo", false));
        this.verify(new Enum());
        this.verify(new Enum("foo", ""));
        this.verify(new Enum("foo", "bar"));
        this.verify(new Int());
        this.verify(new Int("foo"));
        this.verify(new Int(77L));
        this.verify(new Int("foo", 77L));
        this.verify(new Int("foo", 5124095577148911L));
        this.verify(new Real());
        this.verify(new Real("foo"));
        this.verify(new Real(1.7));
        this.verify(new Real("foo", 1.7));
        this.verify(new Str());
        this.verify(new Str("foo", ""));
        this.verify(new Str("foo", "hello world"));
        this.verify(new Abstime());
        this.verify(new Abstime("foo"));
        this.verify(new Abstime("foo", System.currentTimeMillis()));
        this.verify(new Reltime());
        this.verify(new Reltime("foo"));
        this.verify(new Reltime("foo", 60000L));
        this.verify(new Time());
        this.verify(new Time("foo"));
        this.verify(new Time(23, 59, 0));
        this.verify(new Time("foo", 1, 2, 3, 4));
        this.verify(new Date());
        this.verify(new Date("foo"));
        this.verify(new Date(2011, 3, 30));
        this.verify(new Date("foo", 1929, 12, 31));
        this.verify(new Uri());
        this.verify(new Uri("foo", ""));
        this.verify(new Uri("foo", "obix:foo"));
        this.verify(new Op());
        this.verify(new Op("foo"));
        this.verify(new Op("foo", new Contract("obix:Foo"), new Contract("obix:Bar")));
        this.verify(new Op("foo", new Contract("obix:Foo obix:Ray"), new Contract("obix:Bar obix:Boo")));
        this.verify(new Feed());
        this.verify(new Feed("foo"));
        this.verify(new Feed("foo", new Contract("obix:Foo"), null));
        this.verify(new Feed("foo", null, new Contract("obix:Bar")));
        this.verify(new Feed("foo", new Contract("obix:Foo"), new Contract("obix:Bar")));
        this.verify(new Ref());
        this.verify(new Ref("foo"));
        this.verify(new Ref("foo", new Uri("/obix/foo")));
        this.verify(new Err());
        this.verify(new Err("foo"));
        Obj obj = new Obj();
        obj.setHref(new Uri("/obix/boo"));
        this.verify(obj);
        obj = new Obj();
        obj.setIs(new Contract("/obix/boo obix:Hanover"));
        this.verify(obj);
        this.verify(new List());
        this.verify(new List("coolList"));
        this.verify(new List("coolList", new Contract("obix:Uri")));
        obj = new Obj();
        obj.add(new Obj("foo"));
        obj.add(new Int("bar", 1972L));
        obj.add(new Real("moo", 0.5));
        obj.add(new Str("description", "Pretty cool"));
        obj.add(new List("items", new Contract("obix:Str")));
        obj.add(new Op("doIt", new Contract("obix:Str"), new Contract("obix:Int")));
        obj.add(new Feed("yourFired", new Contract("obix:Nil"), new Contract("obix:Int")));
        Obj obj2 = new Obj("nest");
        obj.add(obj2);
        obj2.add(new Int("baz", -33L));
        this.verify(obj);
        obj = new Obj();
        obj.setDisplay("da display");
        this.verify(obj);
        obj = new Obj();
        obj.setDisplayName("da displayName");
        this.verify(obj);
        obj = new Obj();
        obj.setNull(true);
        this.verify(obj);
        obj = new Obj();
        obj.setIcon(new Uri("/icon.png"));
        this.verify(obj);
        obj = new Obj();
        obj.setWritable(true);
        this.verify(obj);
        obj = new Obj();
        int n = 0;
        while (n < Status.list().length) {
            obj.setStatus(Status.list()[n]);
            this.verify(obj);
            ++n;
        }
        Bool bool = new Bool();
        bool.setRange(new Uri("/myrange"));
        this.verify(bool);
        Int intVal = new Int();
        intVal.setMin(0L);
        this.verify(intVal);
        intVal = new Int();
        intVal.setMax(88L);
        this.verify(intVal);
        intVal = new Int();
        intVal.setUnit(new Uri("obix:Celsius"));
        this.verify(intVal);
        Real real = new Real();
        real.setMin(0.0);
        this.verify(real);
        real = new Real();
        real.setMax(88.0);
        this.verify(real);
        real = new Real();
        real.setUnit(new Uri("obix:Celsius"));
        this.verify(real);
        real = new Real();
        real.setPrecision(3);
        this.verify(real);
        Enum enum_ = new Enum();
        enum_.setRange(new Uri("/myrange"));
        this.verify(enum_);
        Str str = new Str();
        str.setMin(1);
        this.verify(str);
        str = new Str();
        str.setMax(20);
        this.verify(str);
        Reltime reltime = new Reltime();
        reltime.setMin(new Reltime(99L));
        this.verify(reltime);
        reltime = new Reltime();
        reltime.setMax(new Reltime(-8L));
        this.verify(reltime);
        Abstime abstime = new Abstime();
        abstime.setMin(new Abstime(System.currentTimeMillis()));
        this.verify(abstime);
        abstime = new Abstime();
        abstime.setMax(new Abstime(System.currentTimeMillis()));
        this.verify(abstime);
        TimeZone timeZone = TimeZone.getTimeZone("Europe/London");
        abstime = new Abstime(System.currentTimeMillis(), timeZone);
        this.verify(abstime);
        Time time = new Time();
        time.setMin(new Time(0, 0, 0));
        this.verify(time);
        time = new Time();
        time.setMax(new Time(23, 59, 59, 999));
        this.verify(time);
        time = new Time(3, 45, 9);
        time.setTz("America/Chicago");
        this.verify(time);
        Date date = new Date();
        date.setMin(new Date(1980, 1, 1));
        this.verify(date);
        date = new Date();
        date.setMax(new Date(2020, 12, 31));
        this.verify(date);
        date = new Date(2003, 6, 3);
        date.setTz("America/Denver");
        this.verify(date);
        List list = new List();
        list.setMin(1);
        this.verify(list);
        list = new List();
        list.setMax(20);
        this.verify(list);
        Obj obj3 = this.make("<obj><what/><int name='i' val='3'/></obj>");
        boolean bl = false;
        if (obj3.size() == 1) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (obj3.get("i").getInt() == (long)3) {
            bl2 = true;
        }
        this.verify(bl2);
        obj = new Obj();
        obj.setIs(new Contract("acme:FooBar"));
        obj.add(new Str("a", "a"));
        obj.add(new Str("b", "beta"));
        obj.add(new Str("c0", "charlie really long string"));
        obj.add(new Str("c1", "charlie really long string"));
        obj.add(new Str("c2", "charlie really long string"));
        obj2 = new Obj("nest");
        obj.add(obj2);
        obj2.setIs(new Contract("acme:FooBar"));
        obj2.add(new Str("a", "a"));
        obj2.add(new Str("b", "beta"));
        obj2.add(new Str("xyz", "xyz"));
        this.verify(obj);
        this.verifySingleStr("acme:FooBar", this.binaryRoundtrip);
        this.verifySingleStr("beta", this.binaryRoundtrip);
        this.verifySingleStr("xyz", this.binaryRoundtrip);
        this.verifySingleStr("charlie really long string", this.binaryRoundtrip);
    }

    public void verify(Obj obj) throws Exception {
        this.roundtrip(obj);
    }

    public Obj make(String string) throws Exception {
        return this.make(string, true);
    }

    public Obj make(String string, boolean bl) throws Exception {
        ObixDecoder obixDecoder = new ObixDecoder(new ByteArrayInputStream(string.getBytes()));
        obixDecoder.setUseContracts(bl);
        return obixDecoder.decodeDocument();
    }

    void verifySingleStr(String string, byte[] byArray) {
        int n = -1;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (IOTest.match(string, byArray, n2)) {
                if (n < 0) {
                    n = n2;
                } else {
                    throw new RuntimeException("Multiple matches for string '" + string + '\'');
                }
            }
            ++n2;
        }
        boolean bl = false;
        if (n >= 0) {
            bl = true;
        }
        this.verify(bl);
    }

    static boolean match(String string, byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < string.length()) {
            if (n2 + n >= byArray.length) {
                return false;
            }
            if (byArray[n + n2] != string.charAt(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

