/*
 * Decompiled with CFR 0.152.
 */
package obix.test;

import java.util.SimpleTimeZone;
import java.util.TimeZone;
import obix.Abstime;
import obix.test.Test;

public class AbstimeTest
extends Test {
    public static TimeZone[] timeZones = new TimeZone[]{TimeZone.getDefault(), TimeZone.getTimeZone("GMT"), TimeZone.getTimeZone("America/New_York"), TimeZone.getTimeZone("America/Phoenix"), TimeZone.getTimeZone("America/Los_Angeles"), TimeZone.getTimeZone("US/Mountain"), TimeZone.getTimeZone("Europe/Brussels"), TimeZone.getTimeZone("Europe/Vienna"), TimeZone.getTimeZone("Asia/Tokyo"), TimeZone.getTimeZone("Asia/Hong_Kong"), new SimpleTimeZone(-14400000, "Offset1"), new SimpleTimeZone(-18000000, "Offset2")};
    public static final int january = 1;
    public static final int february = 2;
    public static final int march = 3;
    public static final int april = 4;
    public static final int may = 5;
    public static final int june = 6;
    public static final int july = 7;
    public static final int august = 8;
    public static final int september = 9;
    public static final int october = 10;
    public static final int november = 11;
    public static final int december = 12;
    public static final int sunday = 0;
    public static final int monday = 1;
    public static final int tuesday = 2;
    public static final int wednesday = 3;
    public static final int thursday = 4;
    public static final int friday = 5;
    public static final int saturday = 6;

    public void run() throws Exception {
        this.verifyBasics();
        this.verifyCodec();
        this.verifyLeapYears();
        this.verifyDaysInMonth();
        this.verifyTimeOfDayMillis();
        this.verifyNextPrevDay();
        this.verifyNextPrevMonth();
        this.verifyNextPrevYear();
        this.verifyNextPrevWeekdays();
    }

    public void verifyBasics() {
        TimeZone timeZone = TimeZone.getTimeZone("America/New_York");
        Abstime abstime = new Abstime(2005, 9, 21, 10, 59, 7, 654, timeZone);
        boolean bl = false;
        if (abstime.getTimeZone() == timeZone) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (abstime.getYear() == 2005) {
            bl2 = true;
        }
        this.verify(bl2);
        boolean bl3 = false;
        if (abstime.getMonth() == 9) {
            bl3 = true;
        }
        this.verify(bl3);
        boolean bl4 = false;
        if (abstime.getDay() == 21) {
            bl4 = true;
        }
        this.verify(bl4);
        boolean bl5 = false;
        if (abstime.getHour() == 10) {
            bl5 = true;
        }
        this.verify(bl5);
        boolean bl6 = false;
        if (abstime.getMinute() == 59) {
            bl6 = true;
        }
        this.verify(bl6);
        boolean bl7 = false;
        if (abstime.getSecond() == 7) {
            bl7 = true;
        }
        this.verify(bl7);
        boolean bl8 = false;
        if (abstime.getMillisecond() == 654) {
            bl8 = true;
        }
        this.verify(bl8);
        this.verify(abstime.inDaylightTime());
        boolean bl9 = false;
        if (abstime.getTimeZoneOffset() == -14400000) {
            bl9 = true;
        }
        this.verify(bl9);
        abstime = new Abstime(2005, 12, 25, 13, 2, 0, 0, timeZone);
        boolean bl10 = false;
        if (abstime.getTimeZone() == timeZone) {
            bl10 = true;
        }
        this.verify(bl10);
        boolean bl11 = false;
        if (abstime.getYear() == 2005) {
            bl11 = true;
        }
        this.verify(bl11);
        boolean bl12 = false;
        if (abstime.getMonth() == 12) {
            bl12 = true;
        }
        this.verify(bl12);
        boolean bl13 = false;
        if (abstime.getDay() == 25) {
            bl13 = true;
        }
        this.verify(bl13);
        boolean bl14 = false;
        if (abstime.getHour() == 13) {
            bl14 = true;
        }
        this.verify(bl14);
        boolean bl15 = false;
        if (abstime.getMinute() == 2) {
            bl15 = true;
        }
        this.verify(bl15);
        boolean bl16 = false;
        if (abstime.getSecond() == 0) {
            bl16 = true;
        }
        this.verify(bl16);
        boolean bl17 = false;
        if (abstime.getMillisecond() == 0) {
            bl17 = true;
        }
        this.verify(bl17);
        this.verify(abstime.inDaylightTime() ^ true);
        boolean bl18 = false;
        if (abstime.getTimeZoneOffset() == -18000000) {
            bl18 = true;
        }
        this.verify(bl18);
        abstime = new Abstime(1127314741310L, timeZone);
        boolean bl19 = false;
        if (abstime.getYear() == 2005) {
            bl19 = true;
        }
        this.verify(bl19);
        boolean bl20 = false;
        if (abstime.getMonth() == 9) {
            bl20 = true;
        }
        this.verify(bl20);
        boolean bl21 = false;
        if (abstime.getDay() == 21) {
            bl21 = true;
        }
        this.verify(bl21);
        boolean bl22 = false;
        if (abstime.getHour() == 10) {
            bl22 = true;
        }
        this.verify(bl22);
        boolean bl23 = false;
        if (abstime.getMinute() == 59) {
            bl23 = true;
        }
        this.verify(bl23);
        boolean bl24 = false;
        if (abstime.getSecond() == 1) {
            bl24 = true;
        }
        this.verify(bl24);
        boolean bl25 = false;
        if (abstime.getMillisecond() == 310) {
            bl25 = true;
        }
        this.verify(bl25);
        this.verify(abstime.inDaylightTime());
        boolean bl26 = false;
        if (abstime.getTimeZoneOffset() == -14400000) {
            bl26 = true;
        }
        this.verify(bl26);
        abstime = abstime.toUtcTime();
        boolean bl27 = false;
        if (abstime.getYear() == 2005) {
            bl27 = true;
        }
        this.verify(bl27);
        boolean bl28 = false;
        if (abstime.getMonth() == 9) {
            bl28 = true;
        }
        this.verify(bl28);
        boolean bl29 = false;
        if (abstime.getDay() == 21) {
            bl29 = true;
        }
        this.verify(bl29);
        boolean bl30 = false;
        if (abstime.getHour() == 14) {
            bl30 = true;
        }
        this.verify(bl30);
        boolean bl31 = false;
        if (abstime.getMinute() == 59) {
            bl31 = true;
        }
        this.verify(bl31);
        boolean bl32 = false;
        if (abstime.getSecond() == 1) {
            bl32 = true;
        }
        this.verify(bl32);
        boolean bl33 = false;
        if (abstime.getMillisecond() == 310) {
            bl33 = true;
        }
        this.verify(bl33);
        this.verify(abstime.inDaylightTime() ^ true);
        boolean bl34 = false;
        if (abstime.getTimeZoneOffset() == 0) {
            bl34 = true;
        }
        this.verify(bl34);
        this.verify(abstime.encodeVal().equals("2005-09-21T14:59:01.310Z"));
        abstime = abstime.toLocalTime();
        boolean bl35 = false;
        if (abstime.getYear() == 2005) {
            bl35 = true;
        }
        this.verify(bl35);
        boolean bl36 = false;
        if (abstime.getMonth() == 9) {
            bl36 = true;
        }
        this.verify(bl36);
        boolean bl37 = false;
        if (abstime.getDay() == 21) {
            bl37 = true;
        }
        this.verify(bl37);
        boolean bl38 = false;
        if (abstime.getHour() == 10) {
            bl38 = true;
        }
        this.verify(bl38);
        boolean bl39 = false;
        if (abstime.getMinute() == 59) {
            bl39 = true;
        }
        this.verify(bl39);
        boolean bl40 = false;
        if (abstime.getSecond() == 1) {
            bl40 = true;
        }
        this.verify(bl40);
        boolean bl41 = false;
        if (abstime.getMillisecond() == 310) {
            bl41 = true;
        }
        this.verify(bl41);
        this.verify(abstime.inDaylightTime());
        boolean bl42 = false;
        if (abstime.getTimeZoneOffset() == -14400000) {
            bl42 = true;
        }
        this.verify(bl42);
        this.verify(abstime.encodeVal().equals("2005-09-21T10:59:01.310-04:00"));
    }

    public void verifyCodec() throws Exception {
        int n = 0;
        while (n < timeZones.length) {
            int n2 = 0;
            while (n2 < timeZones.length) {
                TimeZone timeZone = timeZones[n];
                TimeZone timeZone2 = timeZones[n2];
                Abstime[] abstimeArray = new Abstime[]{new Abstime(System.currentTimeMillis()), new Abstime(System.currentTimeMillis(), timeZone), new Abstime(System.currentTimeMillis(), timeZone2), new Abstime(2001, 6, 7, 0, 0, 0, 0, timeZone), new Abstime(2001, 6, 7, 0, 0, 0, 0, timeZone2), new Abstime(2001, 11, 30, 0, 0, 0, 0, timeZone), new Abstime(2001, 11, 30, 0, 0, 0, 0, timeZone2), new Abstime(1004553579152L, timeZone), new Abstime(1004553579152L, timeZone2)};
                int n3 = 0;
                while (n3 < abstimeArray.length) {
                    int n4 = 0;
                    while (n4 < abstimeArray.length) {
                        Abstime abstime = abstimeArray[n3];
                        Abstime abstime2 = new Abstime();
                        abstime2.decodeVal(abstime.encodeVal());
                        this.verify(abstime.equals(abstime2));
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        Abstime abstime = new Abstime();
        abstime.decodeVal("2005-09-21T13:14:02.1234567Z");
        this.verify(abstime.equals(new Abstime(2005, 9, 21, 13, 14, 2, 123, TimeZone.getTimeZone("UTC"))));
        abstime.decodeVal("2005-09-21T13:14:02.1234567-05:00");
        this.verify(abstime.equals(new Abstime(2005, 9, 21, 13, 14, 2, 123, TimeZone.getTimeZone("EST"))));
        abstime.decodeVal("2005-09-21T13:14:02Z");
        this.verify(abstime.equals(new Abstime(2005, 9, 21, 13, 14, 2, 0, TimeZone.getTimeZone("UTC"))));
        abstime.decodeVal("2005-09-21T13:14:02.7Z");
        this.verify(abstime.equals(new Abstime(2005, 9, 21, 13, 14, 2, 700, TimeZone.getTimeZone("UTC"))));
        abstime.decodeVal("2005-09-21T13:14:02.74Z");
        this.verify(abstime.equals(new Abstime(2005, 9, 21, 13, 14, 2, 740, TimeZone.getTimeZone("UTC"))));
        abstime.decodeVal("2005-09-21T13:14:02.005Z");
        this.verify(abstime.equals(new Abstime(2005, 9, 21, 13, 14, 2, 5, TimeZone.getTimeZone("UTC"))));
    }

    public void verifyNextPrevDay() {
        Abstime abstime = new Abstime(2001, 10, 28, 0, 0, 0, 0);
        Abstime abstime2 = abstime.nextDay();
        this.verify(abstime2.equals(new Abstime(2001, 10, 29, 0, 0, 0, 0)));
        this.verify(abstime2.prevDay().equals(abstime));
        abstime = abstime2;
        abstime2 = abstime.nextDay();
        this.verify(abstime2.equals(new Abstime(2001, 10, 30, 0, 0, 0, 0)));
        this.verify(abstime2.prevDay().equals(abstime));
        abstime = new Abstime(2001, 12, 31, 0, 0, 0, 0);
        abstime2 = abstime.nextDay();
        this.verify(abstime2.equals(new Abstime(2002, 1, 1, 0, 0, 0, 0)));
        this.verify(abstime2.prevDay().equals(abstime));
    }

    public void verifyNextPrevMonth() {
        this.verify(new Abstime(2003, 7, 17).nextMonth().equals(new Abstime(2003, 8, 17)));
        this.verify(new Abstime(2003, 7, 17).prevMonth().equals(new Abstime(2003, 6, 17)));
        this.verify(new Abstime(2003, 12, 17).nextMonth().equals(new Abstime(2004, 1, 17)));
        this.verify(new Abstime(2003, 1, 17).prevMonth().equals(new Abstime(2002, 12, 17)));
        this.verify(new Abstime(2003, 1, 31).nextMonth().equals(new Abstime(2003, 2, 28)));
        this.verify(new Abstime(2003, 1, 30).nextMonth().equals(new Abstime(2003, 2, 28)));
        this.verify(new Abstime(2003, 1, 29).nextMonth().equals(new Abstime(2003, 2, 28)));
        this.verify(new Abstime(2003, 1, 28).nextMonth().equals(new Abstime(2003, 2, 28)));
        this.verify(new Abstime(2003, 1, 27).nextMonth().equals(new Abstime(2003, 2, 27)));
        this.verify(new Abstime(2004, 3, 31).prevMonth().equals(new Abstime(2004, 2, 29)));
        this.verify(new Abstime(2004, 3, 30).prevMonth().equals(new Abstime(2004, 2, 29)));
        this.verify(new Abstime(2004, 3, 29).prevMonth().equals(new Abstime(2004, 2, 29)));
        this.verify(new Abstime(2004, 3, 28).prevMonth().equals(new Abstime(2004, 2, 28)));
        this.verify(new Abstime(2003, 2, 28).nextMonth().equals(new Abstime(2003, 3, 31)));
        this.verify(new Abstime(2004, 2, 29).nextMonth().equals(new Abstime(2004, 3, 31)));
        this.verify(new Abstime(2004, 3, 31).nextMonth().equals(new Abstime(2004, 4, 30)));
        this.verify(new Abstime(2004, 4, 30).prevMonth().equals(new Abstime(2004, 3, 31)));
        this.verify(new Abstime(2004, 3, 31).prevMonth().equals(new Abstime(2004, 2, 29)));
        this.verify(new Abstime(2004, 2, 28).prevMonth().equals(new Abstime(2004, 1, 28)));
        this.verify(new Abstime(2004, 2, 29).prevMonth().equals(new Abstime(2004, 1, 31)));
        this.verify(new Abstime(2003, 3, 31).prevMonth().equals(new Abstime(2003, 2, 28)));
        this.verify(new Abstime(2003, 2, 28).prevMonth().equals(new Abstime(2003, 1, 31)));
    }

    public void verifyNextPrevYear() {
        this.verify(new Abstime(2003, 4, 30).nextYear().equals(new Abstime(2004, 4, 30)));
        this.verify(new Abstime(2003, 2, 28).nextYear().equals(new Abstime(2004, 2, 28)));
        this.verify(new Abstime(2004, 2, 29).nextYear().equals(new Abstime(2005, 2, 28)));
        this.verify(new Abstime(2003, 4, 30).prevYear().equals(new Abstime(2002, 4, 30)));
        this.verify(new Abstime(2003, 2, 28).prevYear().equals(new Abstime(2002, 2, 28)));
        this.verify(new Abstime(2004, 2, 29).prevYear().equals(new Abstime(2003, 2, 28)));
    }

    public void verifyNextPrevWeekdays() {
        this.verify(new Abstime(2003, 7, 17).nextWeekday(4).equals(new Abstime(2003, 7, 24)));
        this.verify(new Abstime(2003, 7, 17).nextWeekday(5).equals(new Abstime(2003, 7, 18)));
        this.verify(new Abstime(2003, 7, 17).nextWeekday(3).equals(new Abstime(2003, 7, 23)));
        this.verify(new Abstime(2003, 12, 30).nextWeekday(5).equals(new Abstime(2004, 1, 2)));
        this.verify(new Abstime(2003, 11, 3).prevWeekday(4).equals(new Abstime(2003, 10, 30)));
        this.verify(new Abstime(2003, 11, 3).prevWeekday(1).equals(new Abstime(2003, 10, 27)));
    }

    public void verifyLeapYears() {
        this.verify(Abstime.isLeapYear(1996));
        this.verify(Abstime.isLeapYear(1997) ^ true);
        this.verify(Abstime.isLeapYear(1998) ^ true);
        this.verify(Abstime.isLeapYear(1999) ^ true);
        this.verify(Abstime.isLeapYear(2000));
        this.verify(Abstime.isLeapYear(2001) ^ true);
        this.verify(Abstime.isLeapYear(2002) ^ true);
        this.verify(Abstime.isLeapYear(2003) ^ true);
        this.verify(Abstime.isLeapYear(2004));
        this.verify(Abstime.isLeapYear(2005) ^ true);
        this.verify(Abstime.isLeapYear(2006) ^ true);
        this.verify(Abstime.isLeapYear(2007) ^ true);
        this.verify(Abstime.isLeapYear(2008));
        boolean bl = false;
        if (Abstime.getDaysInYear(2000) == 366) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (Abstime.getDaysInYear(2001) == 365) {
            bl2 = true;
        }
        this.verify(bl2);
    }

    public void verifyDaysInMonth() {
        boolean bl = false;
        if (Abstime.getDaysInMonth(2000, 1) == 31) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (Abstime.getDaysInMonth(2000, 2) == 29) {
            bl2 = true;
        }
        this.verify(bl2);
        boolean bl3 = false;
        if (Abstime.getDaysInMonth(2001, 2) == 28) {
            bl3 = true;
        }
        this.verify(bl3);
        boolean bl4 = false;
        if (Abstime.getDaysInMonth(2000, 3) == 31) {
            bl4 = true;
        }
        this.verify(bl4);
        boolean bl5 = false;
        if (Abstime.getDaysInMonth(2000, 4) == 30) {
            bl5 = true;
        }
        this.verify(bl5);
        boolean bl6 = false;
        if (Abstime.getDaysInMonth(2000, 5) == 31) {
            bl6 = true;
        }
        this.verify(bl6);
        boolean bl7 = false;
        if (Abstime.getDaysInMonth(2000, 6) == 30) {
            bl7 = true;
        }
        this.verify(bl7);
        boolean bl8 = false;
        if (Abstime.getDaysInMonth(2000, 7) == 31) {
            bl8 = true;
        }
        this.verify(bl8);
        boolean bl9 = false;
        if (Abstime.getDaysInMonth(2000, 8) == 31) {
            bl9 = true;
        }
        this.verify(bl9);
        boolean bl10 = false;
        if (Abstime.getDaysInMonth(2000, 9) == 30) {
            bl10 = true;
        }
        this.verify(bl10);
        boolean bl11 = false;
        if (Abstime.getDaysInMonth(2000, 10) == 31) {
            bl11 = true;
        }
        this.verify(bl11);
        boolean bl12 = false;
        if (Abstime.getDaysInMonth(2000, 11) == 30) {
            bl12 = true;
        }
        this.verify(bl12);
        boolean bl13 = false;
        if (Abstime.getDaysInMonth(2000, 12) == 31) {
            bl13 = true;
        }
        this.verify(bl13);
    }

    public void verifyTimeOfDayMillis() {
        boolean bl = false;
        if (0L == new Abstime(2000, 1, 30, 0, 0, 0, 0).getTimeOfDayMillis()) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (1L == new Abstime(2000, 1, 30, 0, 0, 0, 1).getTimeOfDayMillis()) {
            bl2 = true;
        }
        this.verify(bl2);
        boolean bl3 = false;
        if (1000L == new Abstime(2000, 1, 30, 0, 0, 1, 0).getTimeOfDayMillis()) {
            bl3 = true;
        }
        this.verify(bl3);
        boolean bl4 = false;
        if (7000L == new Abstime(2000, 1, 30, 0, 0, 7, 0).getTimeOfDayMillis()) {
            bl4 = true;
        }
        this.verify(bl4);
        boolean bl5 = false;
        if (60000L == new Abstime(2000, 1, 30, 0, 1, 0, 0).getTimeOfDayMillis()) {
            bl5 = true;
        }
        this.verify(bl5);
        boolean bl6 = false;
        if (120000L == new Abstime(2000, 1, 30, 0, 2, 0, 0).getTimeOfDayMillis()) {
            bl6 = true;
        }
        this.verify(bl6);
        boolean bl7 = false;
        if (3600000L == new Abstime(2000, 1, 30, 1, 0, 0, 0).getTimeOfDayMillis()) {
            bl7 = true;
        }
        this.verify(bl7);
        boolean bl8 = false;
        if (86399999L == new Abstime(2000, 1, 30, 23, 59, 59, 999).getTimeOfDayMillis()) {
            bl8 = true;
        }
        this.verify(bl8);
        boolean bl9 = false;
        if (0L == new Abstime(2000, 1, 30, 24, 0, 0, 0).getTimeOfDayMillis()) {
            bl9 = true;
        }
        this.verify(bl9);
    }

    public static void dump(TimeZone timeZone) {
        System.out.println(timeZone.getID() + " = " + timeZone.getRawOffset() / 3600000);
    }
}

