/*
 * Decompiled with CFR 0.152.
 */
package obix.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import obix.Contract;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Reltime;
import obix.Uri;
import obix.net.ObixSession;
import obix.net.WatchListener;

public class SessionWatch {
    public boolean debug = false;
    ObixSession session;
    String name;
    Obj watchObj;
    long lease;
    Uri leaseHref;
    Uri addHref;
    Uri removeHref;
    Uri pollChangesHref;
    Uri pollRefreshHref;
    Uri deleteHref;
    ArrayList items = new ArrayList();
    HashMap hrefToItem = new HashMap();
    long pollPeriod;
    long lastPollAttempt;
    long lastPollSuccess;
    Thread poller;
    boolean alive;
    ArrayList listeners = new ArrayList();

    static SessionWatch make(ObixSession obixSession, String string, long l) throws Exception {
        if (obixSession.watchService == null) {
            throw new Exception("Lobby missing watchService with valid href");
        }
        Op op = (Op)obixSession.watchService.get("make");
        if (op == null || op.getNormalizedHref() == null) {
            throw new Exception("watchService missing op with valid href");
        }
        Obj obj = obixSession.invoke(op, new Obj());
        SessionWatch sessionWatch = new SessionWatch(obixSession, string, obj, l);
        sessionWatch.start();
        return sessionWatch;
    }

    private SessionWatch(ObixSession obixSession, String string, Obj obj, long l) throws Exception {
        this.session = obixSession;
        this.name = string;
        this.watchObj = obj;
        this.addHref = obj.getChildHref("add");
        this.removeHref = obj.getChildHref("remove");
        this.pollChangesHref = obj.getChildHref("pollChanges");
        this.pollRefreshHref = obj.getChildHref("pollRefresh");
        this.deleteHref = obj.getChildHref("delete");
        Reltime reltime = (Reltime)obj.get("lease");
        if (reltime == null) {
            throw new Exception("Watch missing lease object " + obj);
        }
        this.lease = reltime.get();
        this.leaseHref = reltime.getNormalizedHref();
        this.setPollPeriod(l);
    }

    public ObixSession getSession() {
        return this.session;
    }

    public Obj getWatchObj() {
        return this.watchObj;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Watch:" + this.name + " :: " + (this.watchObj != null ? this.watchObj.getHref() : null);
    }

    public int size() {
        return this.items.size();
    }

    public Obj get(int n) {
        Item item = (Item)this.items.get(n);
        return item != null ? item.obj : null;
    }

    public Obj get(Uri uri) {
        Item item = (Item)this.hrefToItem.get(uri.toString());
        return item != null ? item.obj : null;
    }

    public long getLastUpdate(int n) {
        return ((Item)this.items.get((int)n)).lastUpdate;
    }

    public Obj[] list() {
        Obj[] objArray = new Obj[this.items.size()];
        for (int i = 0; i < objArray.length; ++i) {
            objArray[i] = this.get(i);
        }
        return objArray;
    }

    public Iterator hrefs() {
        return this.hrefToItem.keySet().iterator();
    }

    public Obj add(Uri uri) throws Exception {
        return this.add(new Uri[]{uri})[0];
    }

    public Obj[] add(Uri[] uriArray) throws Exception {
        Obj obj = new Obj();
        obj.setIs(new Contract("obix:WatchIn"));
        obj.add(new List("hrefs", new Contract("obix:Uri")).addAll(uriArray));
        Obj obj2 = this.session.invoke(this.addHref, obj);
        if (this.debug) {
            System.out.println("-- ADD: " + this.name);
            obj2.dump();
        }
        Obj[] objArray = ((List)obj2.get("values")).list();
        long l = System.currentTimeMillis();
        for (int i = 0; i < objArray.length; ++i) {
            Obj obj3 = objArray[i];
            String string = obj3.getHref().toString();
            Item item = (Item)this.hrefToItem.get(string);
            if (item == null) {
                item = new Item();
                this.hrefToItem.put(string, item);
                this.items.add(item);
            }
            item.obj = obj3;
            item.lastUpdate = l;
        }
        return objArray;
    }

    public void remove(Uri[] uriArray) throws Exception {
        Item[] itemArray = new Item[uriArray.length];
        for (int i = 0; i < itemArray.length; ++i) {
            itemArray[i] = (Item)this.hrefToItem.get(uriArray[i].toString());
        }
        this.remove(itemArray, uriArray);
    }

    public void remove(int[] nArray) throws Exception {
        Item[] itemArray = new Item[nArray.length];
        Uri[] uriArray = new Uri[itemArray.length];
        for (int i = 0; i < itemArray.length; ++i) {
            itemArray[i] = (Item)this.items.get(nArray[i]);
            uriArray[i] = itemArray[i].obj.getHref();
        }
        this.remove(itemArray, uriArray);
    }

    private void remove(Item[] itemArray, Uri[] uriArray) throws Exception {
        Obj obj = new Obj();
        obj.setIs(new Contract("obix:WatchIn"));
        obj.add(new List("hrefs", new Contract("obix:Uri")).addAll(uriArray));
        if (this.debug) {
            System.out.println("-- Remove: " + this.name);
            obj.dump();
        }
        this.session.invoke(this.removeHref, obj);
        for (int i = 0; i < itemArray.length; ++i) {
            Item item = itemArray[i];
            this.items.remove(item);
            this.hrefToItem.remove(item.obj.getHref().toString());
        }
    }

    public long getLease() {
        return this.lease;
    }

    public long setLease(long l) throws Exception {
        if (this.leaseHref == null) {
            throw new Exception("Lease time missing href");
        }
        Reltime reltime = new Reltime(l);
        reltime.setHref(this.leaseHref);
        reltime = (Reltime)this.session.write(reltime);
        this.lease = reltime.get();
        return this.lease;
    }

    public long getPollPeriod() {
        return this.pollPeriod;
    }

    public long setPollPeriod(long l) throws Exception {
        long l2 = l + 5000L;
        if (l2 > this.lease) {
            this.setLease(l2);
        }
        if (l2 > this.lease && (l = this.lease - 5000L) < 100L) {
            throw new Exception("Lease time is too short: " + this.lease);
        }
        this.pollPeriod = l;
        return this.pollPeriod;
    }

    public long lastPollAttempt() {
        return this.lastPollAttempt;
    }

    public long lastPollSuccess() {
        return this.lastPollSuccess;
    }

    public void pollChanges() throws Exception {
        this.poll(this.pollChangesHref, false);
    }

    public void pollRefresh() throws Exception {
        this.poll(this.pollRefreshHref, true);
    }

    private void poll(Uri uri, boolean bl) throws Exception {
        this.lastPollAttempt = System.currentTimeMillis();
        Obj obj = this.session.invoke(uri, null);
        long l = System.currentTimeMillis();
        if (this.debug) {
            System.out.println("-- POLL: " + this.name + " [refresh=" + bl + "]");
            obj.dump();
        }
        Obj[] objArray = ((List)obj.get("values")).list();
        for (int i = 0; i < objArray.length; ++i) {
            Obj obj2 = objArray[i];
            String string = obj2.getHref().toString();
            Item item = (Item)this.hrefToItem.get(string);
            if (item == null) {
                System.out.println("WARNING: polled href not in my list: " + string);
                continue;
            }
            item.obj = obj2;
            item.lastUpdate = l;
            this.fireChanged(obj2);
        }
        this.lastPollSuccess = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(WatchListener watchListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(watchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(WatchListener watchListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(watchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WatchListener[] getListeners() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            return this.listeners.toArray(new WatchListener[this.listeners.size()]);
        }
    }

    public void fireChanged(Obj obj) {
        WatchListener[] watchListenerArray = this.getListeners();
        for (int i = 0; i < watchListenerArray.length; ++i) {
            try {
                watchListenerArray[i].changed(obj);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void fireClosed() {
        WatchListener[] watchListenerArray = this.getListeners();
        for (int i = 0; i < watchListenerArray.length; ++i) {
            try {
                watchListenerArray[i].closed(this);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void delete() {
        this.stop();
        try {
            this.session.invoke(this.deleteHref, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.session.watches.remove(this.name);
        this.session = null;
    }

    void start() {
        this.poller = new Thread(this.toString() + "-Poller"){

            public void run() {
                SessionWatch.this.pollLoop();
            }
        };
        this.alive = true;
        this.poller.start();
    }

    void stop() {
        this.alive = false;
        if (this.poller != null) {
            this.poller.interrupt();
        }
        this.poller = null;
    }

    void pollLoop() {
        while (this.alive) {
            long l = this.lastPollAttempt + this.pollPeriod;
            long l2 = System.currentTimeMillis();
            try {
                long l3 = l - l2;
                if (l3 > 0L) {
                    Thread.sleep(l3);
                }
                if (!this.alive) continue;
                this.pollChanges();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (this.alive && this.session != null) {
                    this.session.watches.remove(this.name);
                    this.session = null;
                }
                this.alive = false;
            }
        }
        this.fireClosed();
    }

    static class Item {
        Obj obj;
        long lastUpdate;

        Item() {
        }
    }
}

