/*
 * Decompiled with CFR 0.152.
 */
package obix.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import obix.net.HttpDateFormat;

public class HttpHeader {
    protected HashMap table = new HashMap(17);

    public Enumeration getFieldNames() {
        Vector<String> vector = new Vector<String>(this.table.size() + 3);
        Iterator iterator = this.table.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            vector.add(string);
        }
        this.addFieldNames(vector);
        return vector.elements();
    }

    protected void addFieldNames(Vector vector) {
    }

    public String get(String string) {
        return (String)this.table.get(string.toLowerCase());
    }

    public int getInt(String string, int n) {
        try {
            String string2 = this.get(string);
            if (string2 == null) {
                return n;
            }
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public long getDate(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            return -1L;
        }
        return HttpDateFormat.parse(string2);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.get(string);
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        return bl;
    }

    public boolean contains(String string, String string2) {
        String string3 = this.get(string);
        if (string3 == null) {
            return false;
        }
        return string3.equalsIgnoreCase(string2);
    }

    public void set(String string, String string2) {
        this.table.put(string.toLowerCase(), string2);
    }

    public void setInt(String string, int n) {
        this.set(string, Integer.toString(n));
    }

    public void setDate(String string, long l) {
        this.set(string, HttpDateFormat.format(l));
    }

    public void setBoolean(String string, boolean bl) {
        this.set(string, bl ? "true" : "false");
    }

    public void read(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(64);
        while (true) {
            String string = null;
            String string2 = null;
            int n = inputStream.read();
            if (n == -1 || n == 13) {
                n = inputStream.read();
                return;
            }
            while (n != -1 && n != 58) {
                stringBuffer.append((char)n);
                n = inputStream.read();
            }
            string = stringBuffer.toString();
            stringBuffer.setLength(0);
            n = inputStream.read();
            while (n != -1 && n == 32) {
                n = inputStream.read();
            }
            while (n != -1 && n != 13) {
                stringBuffer.append((char)n);
                n = inputStream.read();
            }
            string2 = stringBuffer.toString();
            stringBuffer.setLength(0);
            n = inputStream.read();
            this.addField(string, string2);
        }
    }

    protected void addField(String string, String string2) {
        this.table.put(string.toLowerCase(), string2);
    }

    public void write(PrintWriter printWriter) throws IOException {
        this.write(printWriter, null);
    }

    public void write(PrintWriter printWriter, StringBuffer stringBuffer) throws IOException {
        Iterator iterator = this.table.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.table.get(string);
            printWriter.print(string);
            printWriter.print(": ");
            printWriter.print(string2);
            printWriter.print("\r\n");
            if (stringBuffer == null) continue;
            stringBuffer.append("  ");
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(string2);
            stringBuffer.append("\r\n");
        }
        this.doWriteFields(printWriter, stringBuffer);
    }

    protected void doWriteFields(PrintWriter printWriter, StringBuffer stringBuffer) throws IOException {
    }

    public static String[] parseValue(String string) {
        int n = string.indexOf(44);
        if (n == -1) {
            return new String[]{string};
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        Vector<String> vector = new Vector<String>(2);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        Iterator iterator = this.table.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("  ").append(string).append(": ");
            stringBuffer.append(this.table.get(string));
            stringBuffer.append('\n');
        }
        try {
            this.doAppendFields(stringBuffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    protected void doAppendFields(StringBuffer stringBuffer) throws IOException {
    }
}

