/*
 * Decompiled with CFR 0.152.
 */
package obix.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import obix.net.ChunkedOutputStream;
import obix.net.HttpDateFormat;
import obix.net.HttpException;
import obix.net.HttpInputStream;

public class HttpConnection {
    public static final String HTTP_VERSION = "HTTP/1.1";
    private String startUri;
    private String requestMethod = "GET";
    private String hostHeader;
    private StatusLine statusLine;
    private boolean allowMultipleRequests = true;
    private boolean requestComplete = true;
    private boolean transferChunked = false;
    private boolean followRedirects = false;
    private boolean redirected = false;
    private String userAgent;
    private static String defUserAgent = "";
    private Socket s;
    private BufferedOutputStream out;
    private PrintWriter pw;
    private InputStream in;
    private int timeout = 0;
    private int port = 80;
    private String hostname;
    private Vector requestHeaderFields;
    private Hashtable responseHeaderFields;

    public HttpConnection(String string, int n, String string2) {
        this(string, n);
        this.startUri = string2;
    }

    public HttpConnection(String string, int n) {
        this.hostname = string;
        this.port = n < 0 ? 80 : n;
        this.requestHeaderFields = new Vector(5);
        this.responseHeaderFields = new Hashtable(5);
        this.timeout = 0;
    }

    public static int post(String string, int n, String string2, String string3, byte[] byArray) throws IOException {
        HttpConnection httpConnection = new HttpConnection(string, n, string2);
        httpConnection.setRequestMethod("POST");
        if (string3 != null) {
            httpConnection.setRequestHeader("content-type", string3);
        }
        httpConnection.setRequestHeader("content-length", byArray.length);
        httpConnection.setRequestHeader("expect", "100-continue");
        int n2 = httpConnection.connect();
        if (n2 != 100) {
            try {
                httpConnection.readContent();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return n2;
        }
        OutputStream outputStream = httpConnection.getOutputStream();
        outputStream.write(byArray);
        outputStream.flush();
        n2 = httpConnection.postComplete();
        httpConnection.close();
        return n2;
    }

    public static void setDefaultUserAgent(String string) {
        defUserAgent = string;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public void setTimeout(int n) throws SocketException {
        this.timeout = n;
        if (this.s != null) {
            this.s.setSoTimeout(n);
        }
    }

    public int getTimeout() {
        try {
            if (this.s != null) {
                return this.s.getSoTimeout();
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in getTimeout:" + exception);
        }
        return this.timeout;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public String getUri() {
        return this.startUri;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String string) {
        this.requestMethod = string;
    }

    public void setRequestHeader(String string, String string2) {
        this.checkHeaderReset();
        this.requestHeaderFields.addElement(new NameValue(string, string2));
    }

    public void setRequestHeader(String string, int n) {
        this.checkHeaderReset();
        this.requestHeaderFields.addElement(new NameValue(string, n));
    }

    public void setRequestHeader(String string, long l) {
        this.checkHeaderReset();
        this.requestHeaderFields.addElement(new NameValue(string, l));
    }

    public void setRequestHeader(String string, boolean bl) {
        this.checkHeaderReset();
        this.requestHeaderFields.addElement(new NameValue(string, bl));
    }

    private void checkHeaderReset() {
        if (this.requestComplete) {
            this.requestHeaderFields.removeAllElements();
            this.requestComplete = false;
        }
    }

    public void removeRequestHeader(String string) {
        for (int i = 0; i < this.requestHeaderFields.size(); ++i) {
            NameValue nameValue = (NameValue)this.requestHeaderFields.elementAt(i);
            if (!nameValue.name.equalsIgnoreCase(string)) continue;
            this.requestHeaderFields.removeElementAt(i);
            return;
        }
    }

    public void setFollowRedirects(boolean bl) {
        this.followRedirects = bl;
    }

    public boolean isRedirected() {
        return this.redirected;
    }

    public synchronized int connect() throws IOException {
        if (this.hostHeader == null) {
            StringBuffer stringBuffer = new StringBuffer(this.hostname.length() + 5);
            stringBuffer.append(this.hostname);
            if (this.port != 80) {
                stringBuffer.append(':').append(this.port);
            }
            this.hostHeader = stringBuffer.toString();
        }
        this.s = new Socket(InetAddress.getByName(this.hostname), this.port);
        this.in = new BufferedInputStream(this.s.getInputStream());
        this.out = new BufferedOutputStream(this.s.getOutputStream());
        this.pw = new PrintWriter(this.out, false);
        if (this.timeout > 0) {
            this.s.setSoTimeout(this.timeout);
        }
        return this.newRequest(this.startUri);
    }

    public synchronized int newRequest(String string) throws IOException {
        if (!this.allowMultipleRequests) {
            throw new IOException("This connection doesn't allow multiple requests.");
        }
        if (!this.isOpen()) {
            this.startUri = string;
            return this.connect();
        }
        this.writeRequest(this.pw, string);
        return this.readResponse(this.in);
    }

    public synchronized int post(String string, String string2, byte[] byArray) throws IOException {
        this.setRequestMethod("POST");
        this.setRequestHeader("content-type", string2);
        this.setRequestHeader("content-length", byArray.length);
        this.setRequestHeader("expect", "100-continue");
        int n = this.newRequest(string);
        System.out.println("RC=" + n);
        if (n != 100) {
            this.readContent();
            return n;
        }
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(byArray);
        return this.postComplete();
    }

    public synchronized int put(String string, String string2, byte[] byArray) throws IOException {
        this.setRequestMethod("PUT");
        this.setRequestHeader("content-type", string2);
        this.setRequestHeader("content-length", byArray.length);
        int n = this.newRequest(string);
        if (n != 100) {
            this.readContent();
            return n;
        }
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(byArray);
        return this.putComplete();
    }

    public static void pipe(InputStream inputStream, long l, OutputStream outputStream) throws IOException {
        int n = 4096;
        byte[] byArray = new byte[n];
        while (l > 0L) {
            int n2 = inputStream.read(byArray, 0, (int)Math.min(l, (long)n));
            if (n2 <= 0) {
                throw new IOException("Unexpected EOF");
            }
            outputStream.write(byArray, 0, n2);
            l -= (long)n2;
        }
    }

    public int postComplete() throws IOException {
        if (!this.requestMethod.equals("POST")) {
            throw new IllegalStateException("Request was not a post.");
        }
        this.out.flush();
        this.responseHeaderFields.clear();
        int n = this.readResponse(this.in);
        return n;
    }

    public int putComplete() throws IOException {
        if (!this.requestMethod.equals("PUT")) {
            throw new IllegalStateException("Request was not a put.");
        }
        this.out.flush();
        this.responseHeaderFields.clear();
        int n = this.readResponse(this.in);
        return n;
    }

    private void writeRequest(PrintWriter printWriter, String string) {
        String string2;
        printWriter.print(this.requestMethod);
        printWriter.print(' ');
        printWriter.print(string);
        printWriter.print(' ');
        printWriter.print(HTTP_VERSION);
        printWriter.print("\r\n");
        String string3 = string2 = this.userAgent != null ? this.userAgent : defUserAgent;
        if (string2 != null) {
            printWriter.print("user-agent: ");
            printWriter.print(string2);
            printWriter.print("\r\n");
        }
        printWriter.print("host: ");
        printWriter.print(this.hostHeader.toString());
        printWriter.print("\r\n");
        for (int i = 0; i < this.requestHeaderFields.size(); ++i) {
            NameValue nameValue = (NameValue)this.requestHeaderFields.elementAt(i);
            printWriter.print(nameValue.name);
            printWriter.print(": ");
            printWriter.print(nameValue.value);
            printWriter.print("\r\n");
        }
        printWriter.print("\r\n");
        printWriter.flush();
        this.requestComplete = true;
        this.responseHeaderFields.clear();
    }

    int readResponse(InputStream inputStream) throws IOException {
        int n;
        String string;
        this.statusLine = new StatusLine(inputStream);
        StringBuffer stringBuffer = new StringBuffer(30);
        while (true) {
            string = null;
            String string2 = null;
            stringBuffer.setLength(0);
            n = inputStream.read();
            if (n == -1 || n == 13) break;
            while (n != -1 && n != 58) {
                stringBuffer.append((char)n);
                n = inputStream.read();
            }
            string = stringBuffer.toString();
            n = inputStream.read();
            while (n != -1 && n == 32) {
                n = inputStream.read();
            }
            stringBuffer.setLength(0);
            while (n != -1 && n != 13) {
                stringBuffer.append((char)n);
                n = inputStream.read();
            }
            n = inputStream.read();
            string2 = stringBuffer.toString();
            if (string == null || string2 == null) continue;
            this.responseHeaderFields.put(string.toLowerCase(), string2);
        }
        n = inputStream.read();
        string = this.getResponseHeader("Connection");
        if (string != null && string.equalsIgnoreCase("close") && this.statusLine.getStatusCode() != 302) {
            this.allowMultipleRequests = false;
        }
        return this.statusLine.getStatusCode();
    }

    public String getResponseVersion() {
        return this.statusLine.getVersion();
    }

    public int getStatusCode() {
        return this.statusLine.getStatusCode();
    }

    public String getStatusMessage() {
        return this.statusLine.getMessage();
    }

    public String getContentType() {
        return this.getResponseHeader("Content-Type");
    }

    public int getContentLength() {
        return this.getResponseHeaderInt("Content-Length");
    }

    public byte[] readContent() throws IOException {
        byte[] byArray = null;
        int n = this.getContentLength();
        if (n != -1) {
            byArray = new byte[n];
            DataInputStream dataInputStream = new DataInputStream(this.in);
            dataInputStream.readFully(byArray);
        } else {
            byte[] byArray2 = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            int n2 = 0;
            while ((n2 = this.in.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    public String getRequestHeader(String string) {
        if (this.requestHeaderFields == null) {
            return null;
        }
        for (int i = 0; i < this.requestHeaderFields.size(); ++i) {
            NameValue nameValue = (NameValue)this.requestHeaderFields.elementAt(i);
            if (!nameValue.name.equalsIgnoreCase(string)) continue;
            return nameValue.value;
        }
        return null;
    }

    public String getResponseHeader(String string) {
        return (String)this.responseHeaderFields.get(string.toLowerCase());
    }

    public Enumeration getResponseHeaderNames() {
        return this.responseHeaderFields.keys();
    }

    public int getResponseHeaderInt(String string) {
        String string2 = (String)this.responseHeaderFields.get(string.toLowerCase());
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return -1;
    }

    public long getResponseHeaderDate(String string) {
        String string2 = (String)this.responseHeaderFields.get(string.toLowerCase());
        if (string2 != null) {
            try {
                return HttpDateFormat.parse(string2);
            }
            catch (Exception exception) {
                return -1L;
            }
        }
        return -1L;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Connection is not open");
        }
        int n = this.getResponseHeaderInt("Content-Length");
        String string = this.getResponseHeader("Transfer-Encoding");
        if (string != null && string.equalsIgnoreCase("chunked")) {
            return new HttpInputStream(this.in, true);
        }
        return new HttpInputStream(this.in, n);
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Connection is not open");
        }
        String string = this.getRequestHeader("Transfer-Encoding");
        if (string != null && string.equalsIgnoreCase("chunked")) {
            this.transferChunked = true;
            return new ChunkedOutputStream(this.out, 2048);
        }
        this.transferChunked = false;
        return this.out;
    }

    public boolean isTransferChunked() {
        return this.transferChunked;
    }

    public boolean isOpen() {
        return this.s != null;
    }

    public boolean shouldClose() {
        return !this.allowMultipleRequests;
    }

    public void close() {
        if (this.s != null) {
            try {
                this.pw.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pw = null;
            this.in = null;
            this.out = null;
            this.s = null;
        }
    }

    public String dumpResponseHeader() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.statusLine).append('\n');
        Enumeration enumeration = this.responseHeaderFields.keys();
        if (!enumeration.hasMoreElements()) {
            return stringBuffer.toString();
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append("   ").append(string).append(": ").append(this.responseHeaderFields.get(string)).append('\n');
        }
        return stringBuffer.toString();
    }

    public void checkOk() throws HttpException {
        this.checkStatus(200);
    }

    public void checkStatus(int n) throws HttpException {
        int n2 = this.getStatusCode();
        if (n2 != n) {
            this.close();
            throw new HttpException(n, n2);
        }
    }

    private class NameValue {
        public String name;
        public String value;

        public NameValue(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public NameValue(String string, int n) {
            this.name = string;
            this.value = Integer.toString(n);
        }

        public NameValue(String string, long l) {
            this.name = string;
            this.value = String.valueOf(l);
        }

        public NameValue(String string, boolean bl) {
            this.name = string;
            this.value = "" + bl;
        }
    }

    private class StatusLine {
        private InputStream in;
        private String version;
        private int statusCode;
        private String message;

        public StatusLine(InputStream inputStream) throws IOException {
            this.in = inputStream;
            this.readVersion();
            this.readStatusCode();
            this.readMessage();
        }

        protected void readVersion() throws IOException {
            StringBuffer stringBuffer = new StringBuffer(8);
            int n = this.in.read();
            while (n != -1 && n != 32) {
                stringBuffer.append((char)n);
                n = this.in.read();
            }
            if (n == -1) {
                HttpConnection.this.close();
                throw new EOFException("End of input while reading version.");
            }
            this.version = stringBuffer.toString();
        }

        public String getVersion() {
            return this.version;
        }

        protected void readStatusCode() throws IOException {
            StringBuffer stringBuffer = new StringBuffer(3);
            int n = this.in.read();
            while (n != -1 && n != 32) {
                stringBuffer.append((char)n);
                n = this.in.read();
            }
            if (n == -1) {
                HttpConnection.this.close();
                throw new EOFException("End of input while reading status code.");
            }
            this.statusCode = Integer.parseInt(stringBuffer.toString());
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        protected void readMessage() throws IOException {
            StringBuffer stringBuffer = new StringBuffer(25);
            int n = this.in.read();
            while (n != -1 && n != 13) {
                stringBuffer.append((char)n);
                n = this.in.read();
            }
            if (n == -1) {
                HttpConnection.this.close();
                throw new EOFException("End of input while reading reason phrase.");
            }
            n = this.in.read();
            this.message = stringBuffer.toString();
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.version + " " + this.statusCode + " " + this.message;
        }
    }
}

