/*
 * Decompiled with CFR 0.152.
 */
package obix.net;

import obix.Contract;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Uri;
import obix.net.ObixSession;

public class BatchIn
extends List {
    public static final Contract uriContract = new Contract("obix:uri");
    public static final Contract batchInContract = new Contract("obix:BatchIn");
    public static final Contract readContract = new Contract("obix:Read");
    public static final Contract writeContract = new Contract("obix:Write");
    public static final Contract invokeContract = new Contract("obix:Invoke");
    ObixSession session;

    BatchIn(ObixSession obixSession) {
        this.setOf(uriContract);
        this.setIs(batchInContract);
        this.session = obixSession;
    }

    public ObixSession getSession() {
        return this.session;
    }

    public void read(Uri uri) throws Exception {
        uri.setIs(readContract);
        this.add(uri);
    }

    public void write(Obj obj) throws Exception {
        Uri uri = obj.getHref();
        uri.setIs(writeContract);
        obj.setName("in");
        uri.add(obj);
        this.add(uri);
    }

    public void invoke(Op op, Obj obj) throws Exception {
        Uri uri = op.getHref();
        if (uri == null) {
            throw new Exception("op.href is null");
        }
        this.invoke(uri, obj);
    }

    public void invoke(Uri uri, Obj obj) throws Exception {
        if (obj == null) {
            obj = new Obj();
            obj.setNull(true);
        }
        uri.setIs(invokeContract);
        obj.setName("in");
        uri.add(obj);
        this.add(uri);
    }

    public List commit() throws Exception {
        return (List)this.session.invoke(this.session.batchUri, (Obj)this);
    }
}

