/*
 * Decompiled with CFR 0.152.
 */
package obix.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import obix.Abstime;
import obix.Bool;
import obix.Contract;
import obix.Date;
import obix.Enum;
import obix.Feed;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Real;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Time;
import obix.Uri;
import obix.Val;
import obix.xml.XWriter;

public class ObixEncoder
extends XWriter {
    private int indent;

    public static void dump(Obj obj) {
        try {
            ObixEncoder obixEncoder = new ObixEncoder(System.out);
            obixEncoder.encodeDocument(obj);
            obixEncoder.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public static String toString(Obj obj) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObixEncoder obixEncoder = new ObixEncoder(byteArrayOutputStream);
            obixEncoder.encode(obj);
            obixEncoder.flush();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public void encodeDocument(Obj obj) throws IOException {
        this.prolog();
        this.encode(obj);
        this.flush();
    }

    public void encode(Obj obj) throws IOException {
        Object object;
        Object object2;
        Uri uri;
        String string = obj.getElement();
        this.indent(this.indent * 2).w('<').w(string);
        String string2 = obj.getName();
        if (string2 != null) {
            this.attr(" name", string2);
        }
        if ((uri = obj.getHref()) != null) {
            this.attr(" href", uri.encodeVal());
        }
        if (obj instanceof Val) {
            object2 = (Val)obj;
            this.attr(" val", ((Val)object2).encodeVal());
        } else if (obj instanceof List) {
            object2 = (List)obj;
            object = ((List)object2).getOf();
            if (!((Contract)object).containsOnlyObj()) {
                this.attr(" of", ((Contract)object).toString());
            }
        } else if (obj instanceof Op) {
            object2 = (Op)obj;
            this.attr(" in", ((Op)object2).getIn().toString());
            this.attr(" out", ((Op)object2).getOut().toString());
        } else if (obj instanceof Feed) {
            object2 = (Feed)obj;
            this.attr(" in", ((Feed)object2).getIn().toString());
            this.attr(" of", ((Feed)object2).getOf().toString());
        }
        object2 = obj.getIs();
        if (object2 != null) {
            this.attr(" is", ((Contract)object2).toString());
        }
        if (obj.getDisplay() != null) {
            this.attr(" display", obj.getDisplay().toString());
        }
        if (obj.getDisplayName() != null) {
            this.attr(" displayName", obj.getDisplayName().toString());
        }
        if (obj.getIcon() != null) {
            this.attr(" icon", obj.getIcon().toString());
        }
        if (obj.getStatus() != Status.ok) {
            this.attr(" status", obj.getStatus().toString());
        }
        if (obj.isNull()) {
            this.attr(" null", "true");
        }
        if (obj.isWritable()) {
            this.attr(" writable", "true");
        }
        if (obj instanceof Bool) {
            object = (Bool)obj;
            if (((Bool)object).getRange() != null) {
                this.attr(" range", ((Bool)object).getRange().toString());
            }
        } else if (obj instanceof Int) {
            object = (Int)obj;
            if (((Int)object).getMin() != Long.MIN_VALUE) {
                this.attr(" min", String.valueOf(((Int)object).getMin()));
            }
            if (((Int)object).getMax() != Long.MAX_VALUE) {
                this.attr(" max", String.valueOf(((Int)object).getMax()));
            }
            if (((Int)object).getUnit() != null) {
                this.attr(" unit", ((Int)object).getUnit().toString());
            }
        } else if (obj instanceof Str) {
            object = (Str)obj;
            if (((Str)object).getMin() != 0) {
                this.attr(" min", String.valueOf(((Str)object).getMin()));
            }
            if (((Str)object).getMax() != Integer.MAX_VALUE) {
                this.attr(" max", String.valueOf(((Str)object).getMax()));
            }
        } else if (obj instanceof Enum) {
            object = (Enum)obj;
            if (((Enum)object).getRange() != null) {
                this.attr(" range", ((Enum)object).getRange().toString());
            }
        } else if (obj instanceof Real) {
            object = (Real)obj;
            if (((Real)object).getMin() != Double.NEGATIVE_INFINITY) {
                this.attr(" min", String.valueOf(((Real)object).getMin()));
            }
            if (((Real)object).getMax() != Double.POSITIVE_INFINITY) {
                this.attr(" max", String.valueOf(((Real)object).getMax()));
            }
            if (((Real)object).getUnit() != null) {
                this.attr(" unit", ((Real)object).getUnit().toString());
            }
            if (((Real)object).getPrecision() != 1) {
                this.attr(" precision", String.valueOf(((Real)object).getPrecision()));
            }
        } else if (obj instanceof Reltime) {
            object = (Reltime)obj;
            if (((Reltime)object).getMin() != null) {
                this.attr(" min", ((Reltime)object).getMin().encodeVal());
            }
            if (((Reltime)object).getMax() != null) {
                this.attr(" max", ((Reltime)object).getMax().encodeVal());
            }
        } else if (obj instanceof Abstime) {
            object = (Abstime)obj;
            if (((Abstime)object).getMin() != null) {
                this.attr(" min", ((Abstime)object).getMin().encodeVal());
            }
            if (((Abstime)object).getMax() != null) {
                this.attr(" max", ((Abstime)object).getMax().encodeVal());
            }
            if (((Abstime)object).getTz() != null) {
                this.attr(" tz", ((Abstime)object).getTz());
            }
        } else if (obj instanceof Time) {
            object = (Time)obj;
            if (((Time)object).getMin() != null) {
                this.attr(" min", ((Time)object).getMin().encodeVal());
            }
            if (((Time)object).getMax() != null) {
                this.attr(" max", ((Time)object).getMax().encodeVal());
            }
            if (((Time)object).getTz() != null) {
                this.attr(" tz", ((Time)object).getTz());
            }
        } else if (obj instanceof Date) {
            object = (Date)obj;
            if (((Date)object).getMin() != null) {
                this.attr(" min", ((Date)object).getMin().encodeVal());
            }
            if (((Date)object).getMax() != null) {
                this.attr(" max", ((Date)object).getMax().encodeVal());
            }
            if (((Date)object).getTz() != null) {
                this.attr(" tz", ((Date)object).getTz());
            }
        } else if (obj instanceof List) {
            object = (List)obj;
            if (((List)object).getMin() != 0) {
                this.attr(" min", String.valueOf(((List)object).getMin()));
            }
            if (((List)object).getMax() != Integer.MAX_VALUE) {
                this.attr(" max", String.valueOf(((List)object).getMax()));
            }
        }
        if (obj.size() == 0) {
            this.w("/>\n");
            return;
        }
        this.w(">\n");
        ++this.indent;
        object = obj.list();
        int n = 0;
        while (n < ((Object)object).length) {
            this.encode((Obj)object[n]);
            ++n;
        }
        --this.indent;
        this.indent(this.indent * 2).w("</").w(string).w(">\n");
    }

    public ObixEncoder(File file) throws IOException {
        super(file);
    }

    public ObixEncoder(OutputStream outputStream) throws IOException {
        super(outputStream);
    }
}

