/*
 * Decompiled with CFR 0.152.
 */
package obix.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import obix.Abstime;
import obix.Bool;
import obix.Contract;
import obix.Date;
import obix.Enum;
import obix.Feed;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Real;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Time;
import obix.Uri;
import obix.io.ObixDecoder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BinObixEncoder
extends DataOutputStream {
    private HashMap strTable;

    public static byte[] toBytes(Obj obj) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BinObixEncoder binObixEncoder = new BinObixEncoder(byteArrayOutputStream);
            binObixEncoder.encode(obj);
            binObixEncoder.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public void encodeDocument(Obj obj) throws IOException {
        this.strTable.clear();
        this.encode(obj);
        this.flush();
    }

    public void encode(Obj obj) throws IOException {
        boolean bl = false;
        if (obj.size() > 0) {
            bl = true;
        }
        boolean bl2 = bl;
        Node node = this.toNode(obj, bl2);
        while (node != null) {
            node.write(this);
            node = node.next;
        }
        if (bl2) {
            this.write(4);
            Obj[] objArray = obj.list();
            int n = 0;
            while (n < objArray.length) {
                this.encode(objArray[n]);
                ++n;
            }
            this.write(68);
        }
    }

    private final Node toNode(Obj obj, boolean bl) {
        Node node = null;
        Node node2 = null;
        int n = obj.getBinCode();
        switch (n) {
            case 4: {
                node = node2 = new Node(null, n);
                break;
            }
            case 8: {
                Bool bool = (Bool)obj;
                node = node2 = new BoolNode(null, n, bool.get());
                if (bool.getRange() == null) break;
                node2 = new StrNode(node2, 68, bool.getRange().toString());
                break;
            }
            case 12: {
                Int intVal = (Int)obj;
                node = node2 = new IntNode(null, n, intVal.get());
                if (intVal.getMin() != Long.MIN_VALUE) {
                    node2 = new IntNode(node2, 52, intVal.getMin());
                }
                if (intVal.getMax() != Long.MAX_VALUE) {
                    node2 = new IntNode(node2, 56, intVal.getMax());
                }
                if (intVal.getUnit() == null) break;
                node2 = new StrNode(node2, 60, intVal.getUnit().toString());
                break;
            }
            case 16: {
                Real real = (Real)obj;
                node = node2 = new RealNode(null, n, real.get());
                if (real.getMin() != Double.NEGATIVE_INFINITY) {
                    node2 = new RealNode(node2, 52, real.getMin());
                }
                if (real.getMax() != Double.POSITIVE_INFINITY) {
                    node2 = new RealNode(node2, 56, real.getMax());
                }
                if (real.getUnit() != null) {
                    node2 = new StrNode(node2, 60, real.getUnit().toString());
                }
                if (real.getPrecision() == 1) break;
                node2 = new IntNode(node2, 64, real.getPrecision());
                break;
            }
            case 20: {
                Str str = (Str)obj;
                node = node2 = new StrNode(null, n, str.get());
                if (str.getMin() != 0) {
                    node2 = new IntNode(node2, 52, str.getMin());
                }
                if (str.getMax() == Integer.MAX_VALUE) break;
                node2 = new IntNode(node2, 56, str.getMax());
                break;
            }
            case 24: {
                Enum enum_ = (Enum)obj;
                node = node2 = new StrNode(null, n, enum_.get());
                if (enum_.getRange() == null) break;
                node2 = new StrNode(node2, 68, enum_.getRange().toString());
                break;
            }
            case 32: {
                Abstime abstime = (Abstime)obj;
                node = node2 = new AbstimeNode(null, n, abstime);
                if (abstime.getMin() != null) {
                    node2 = new AbstimeNode(node2, 52, abstime.getMin());
                }
                if (abstime.getMax() != null) {
                    node2 = new AbstimeNode(node2, 56, abstime.getMax());
                }
                if (abstime.getTz() == null) break;
                node2 = new StrNode(node2, 72, abstime.getTz());
                break;
            }
            case 36: {
                Reltime reltime = (Reltime)obj;
                node = node2 = new ReltimeNode(null, n, reltime);
                if (reltime.getMin() != null) {
                    node2 = new ReltimeNode(node2, 52, reltime.getMin());
                }
                if (reltime.getMax() == null) break;
                node2 = new ReltimeNode(node2, 56, reltime.getMax());
                break;
            }
            case 44: {
                Time time = (Time)obj;
                node = node2 = new TimeNode(null, n, time);
                if (time.getMin() != null) {
                    node2 = new TimeNode(node2, 52, time.getMin());
                }
                if (time.getMax() != null) {
                    node2 = new TimeNode(node2, 56, time.getMax());
                }
                if (time.getTz() == null) break;
                node2 = new StrNode(node2, 72, time.getTz());
                break;
            }
            case 40: {
                Date date = (Date)obj;
                node = node2 = new DateNode(null, n, date);
                if (date.getMin() != null) {
                    node2 = new DateNode(node2, 52, date.getMin());
                }
                if (date.getMax() != null) {
                    node2 = new DateNode(node2, 56, date.getMax());
                }
                if (date.getTz() == null) break;
                node2 = new StrNode(node2, 72, date.getTz());
                break;
            }
            case 28: {
                Uri uri = (Uri)obj;
                node = node2 = new StrNode(null, n, uri.get());
                break;
            }
            case 48: {
                List list = (List)obj;
                node = node2 = new Node(null, n);
                if (!list.getOf().containsOnlyObj()) {
                    node2 = new ContractNode(node2, 20, list.getOf());
                }
                if (list.getMin() != 0) {
                    node2 = new IntNode(node2, 52, list.getMin());
                }
                if (list.getMax() == Integer.MAX_VALUE) break;
                node2 = new IntNode(node2, 56, list.getMax());
                break;
            }
            case 52: {
                Op op = (Op)obj;
                node = node2 = new Node(null, n);
                if (!op.getIn().containsOnlyObj()) {
                    node2 = new ContractNode(node2, 24, op.getIn());
                }
                if (op.getOut().containsOnlyObj()) break;
                node2 = new ContractNode(node2, 28, op.getOut());
                break;
            }
            case 56: {
                Feed feed = (Feed)obj;
                node = node2 = new Node(null, n);
                if (!feed.getIn().containsOnlyObj()) {
                    node2 = new ContractNode(node2, 24, feed.getIn());
                }
                if (feed.getOf().containsOnlyObj()) break;
                node2 = new ContractNode(node2, 20, feed.getOf());
                break;
            }
            case 60: 
            case 64: {
                node = node2 = new Node(null, n);
                break;
            }
            default: {
                throw new IllegalStateException(obj.getElement());
            }
        }
        if (obj.getName() != null) {
            node2 = new StrNode(node2, 8, obj.getName());
        }
        if (obj.getHref() != null) {
            node2 = new StrNode(node2, 12, obj.getHref().encodeVal());
        }
        if (obj.getIs() != null) {
            node2 = new ContractNode(node2, 16, obj.getIs());
        }
        if (obj.getStatus() != Status.ok) {
            node2 = new StatusNode(node2, 76, obj.getStatus());
        }
        if (obj.getDisplay() != null) {
            node2 = new StrNode(node2, 44, obj.getDisplay());
        }
        if (obj.getDisplayName() != null) {
            node2 = new StrNode(node2, 40, obj.getDisplayName());
        }
        if (obj.getIcon() != null) {
            node2 = new StrNode(node2, 36, obj.getIcon().encodeVal());
        }
        if (obj.isNull()) {
            node2 = new BoolNode(node2, 32, true);
        }
        if (obj.isWritable()) {
            node2 = new BoolNode(node2, 48, true);
        }
        if (bl) {
            node2.code |= 0x80;
        }
        return node;
    }

    static void writeStr(DataOutputStream dataOutputStream, String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\u0000' || c > '\u007f') {
                throw new IOException("Invalic ASCII string chars: " + string);
            }
            dataOutputStream.write(c);
            ++n;
        }
        dataOutputStream.write(0);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("usage: BinObixEncoder <xml>");
            return;
        }
        System.out.println("=== XML ===");
        String string = stringArray[0];
        Obj obj = ObixDecoder.fromString(string);
        obj.dump();
        System.out.println();
        System.out.println("=== Binary ===");
        byte[] byArray = BinObixEncoder.toBytes(obj);
        int n = 0;
        while (n < byArray.length) {
            String string2 = Integer.toHexString(byArray[n] & 0xFF);
            if ((string2 = string2.toUpperCase()).length() == 1) {
                string2 = "0" + string2;
            }
            System.out.print("  " + string2);
            ++n;
        }
        System.out.println();
        n = byArray.length * 100 / string.length();
        System.out.println();
        System.out.println("XML:    " + string.length() + " bytes");
        System.out.println("Binary: " + byArray.length + " bytes (" + n + "% of XML)");
    }

    private final /* synthetic */ void this() {
        this.strTable = new HashMap();
    }

    public BinObixEncoder(File file) throws IOException {
        this(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public BinObixEncoder(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.this();
    }

    static class Node {
        int code;
        Node next;

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.write(this.code);
        }

        Node(Node node, int n) {
            if (node != null) {
                node.code |= 0x80;
                node.next = this;
            }
            this.code = n;
        }
    }

    static class BoolNode
    extends Node {
        boolean val;

        void write(DataOutputStream dataOutputStream) throws IOException {
            if (this.val) {
                dataOutputStream.write(this.code | 1);
            } else {
                dataOutputStream.write(this.code);
            }
        }

        BoolNode(Node node, int n, boolean bl) {
            super(node, n);
            this.val = bl;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class StrNode
    extends Node {
        String val;

        void write(DataOutputStream dataOutputStream) throws IOException {
            Integer n = (Integer)BinObixEncoder.this.strTable.get(this.val);
            if (n != null && n < (char)-1) {
                dataOutputStream.write(this.code | 1);
                dataOutputStream.writeShort(n);
            } else {
                BinObixEncoder.this.strTable.put(this.val, new Integer(BinObixEncoder.this.strTable.size()));
                dataOutputStream.write(this.code);
                BinObixEncoder.writeStr(dataOutputStream, this.val);
            }
        }

        StrNode(Node node, int n, String string) {
            super(node, n);
            this.val = string;
        }
    }

    static class IntNode
    extends Node {
        long val;

        void write(DataOutputStream dataOutputStream) throws IOException {
            if (0L <= this.val && this.val <= 255L) {
                dataOutputStream.write(this.code);
                dataOutputStream.write((int)this.val);
            } else if (0L <= this.val && this.val <= 65535L) {
                dataOutputStream.write(this.code | 1);
                dataOutputStream.writeShort((short)this.val);
            } else if (Integer.MIN_VALUE <= this.val && this.val <= Integer.MAX_VALUE) {
                dataOutputStream.write(this.code | 2);
                dataOutputStream.writeInt((int)this.val);
            } else {
                dataOutputStream.write(this.code | 3);
                dataOutputStream.writeLong(this.val);
            }
        }

        IntNode(Node node, int n, long l) {
            super(node, n);
            this.val = l;
        }
    }

    static class RealNode
    extends Node {
        double val;

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.write(this.code | 1);
            dataOutputStream.writeDouble(this.val);
        }

        RealNode(Node node, int n, double d) {
            super(node, n);
            this.val = d;
        }
    }

    static class AbstimeNode
    extends Node {
        Abstime val;

        void write(DataOutputStream dataOutputStream) throws IOException {
            if (this.val.getMillisecond() == 0) {
                dataOutputStream.write(this.code);
                dataOutputStream.writeInt((int)(this.val.getMillis2000() / 1000L));
            } else {
                dataOutputStream.write(this.code | 1);
                dataOutputStream.writeLong(this.val.getMillis2000() * 1000000L);
            }
        }

        AbstimeNode(Node node, int n, Abstime abstime) {
            super(node, n);
            this.val = abstime;
        }
    }

    static class ReltimeNode
    extends Node {
        Reltime val;

        void write(DataOutputStream dataOutputStream) throws IOException {
            long l = this.val.get();
            if (l % 1000L == 0L) {
                dataOutputStream.write(this.code);
                dataOutputStream.writeInt((int)(l / 1000L));
            } else {
                dataOutputStream.write(this.code | 1);
                dataOutputStream.writeLong(l * 1000000L);
            }
        }

        ReltimeNode(Node node, int n, Reltime reltime) {
            super(node, n);
            this.val = reltime;
        }
    }

    static class TimeNode
    extends Node {
        Time val;

        void write(DataOutputStream dataOutputStream) throws IOException {
            long l = this.val.getMillis();
            if (l % 1000L == 0L) {
                dataOutputStream.write(this.code);
                dataOutputStream.writeInt((int)(l / 1000L));
            } else {
                dataOutputStream.write(this.code | 1);
                dataOutputStream.writeLong(l * 1000000L);
            }
        }

        TimeNode(Node node, int n, Time time) {
            super(node, n);
            this.val = time;
        }
    }

    static class DateNode
    extends Node {
        Date val;

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.write(this.code);
            dataOutputStream.writeShort(this.val.getYear());
            dataOutputStream.write(this.val.getMonth());
            dataOutputStream.write(this.val.getDay());
        }

        DateNode(Node node, int n, Date date) {
            super(node, n);
            this.val = date;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ContractNode
    extends StrNode {
        ContractNode(Node node, int n, Contract contract) {
            super(node, n, contract.toString());
        }
    }

    static class StatusNode
    extends Node {
        Status val;

        void write(DataOutputStream dataOutputStream) throws IOException {
            int n;
            if (this.val == Status.disabled) {
                n = 76;
            } else if (this.val == Status.fault) {
                n = 77;
            } else if (this.val == Status.down) {
                n = 78;
            } else if (this.val == Status.unackedAlarm) {
                n = 79;
            } else if (this.val == Status.alarm) {
                n = 80;
            } else if (this.val == Status.unacked) {
                n = 81;
            } else if (this.val == Status.overridden) {
                n = 82;
            } else {
                throw new IllegalStateException(this.val.toString());
            }
            dataOutputStream.write(n);
        }

        StatusNode(Node node, int n, Status status) {
            super(node, n);
            this.val = status;
        }
    }
}

