/*
 * Decompiled with CFR 0.152.
 */
package obix;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import obix.Obj;
import obix.Val;

public class Uri
extends Val {
    private String val;
    private boolean parsed;
    private boolean abs;
    private String auth;
    private String scheme;
    private String addr;
    private String host;
    private int port = -1;
    private String path;
    private Query query;
    private String frag;
    private Obj resolved;

    public Uri(String string, String string2) {
        super(string);
        this.set(string2);
    }

    public Uri(String string) {
        this.set(string);
    }

    public Uri() {
        this.set("");
    }

    public Uri normalize(Uri uri) {
        try {
            if (this.val.startsWith("obix:")) {
                return this;
            }
            uri.checkAbsolute();
            URL uRL = new URL(new URL(uri.val), this.val);
            return new Uri(uRL.toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Cannot normalize " + uri.val + " + " + this.val);
        }
    }

    public boolean isAbsolute() {
        this.parse();
        return this.abs;
    }

    public boolean isRelative() {
        this.parse();
        return !this.abs;
    }

    public void checkAbsolute() {
        this.parse();
        if (!this.abs) {
            throw new IllegalStateException("Uri is not absolute: " + this.val);
        }
    }

    public boolean isFragment() {
        return this.val.startsWith("#");
    }

    public String getAuthority() {
        this.parse();
        return this.auth;
    }

    public Uri getAuthorityUri() {
        this.parse();
        this.checkAbsolute();
        return new Uri(this.auth);
    }

    public String getScheme() {
        this.parse();
        return this.scheme;
    }

    public boolean contains(Uri uri) {
        this.checkAbsolute();
        if (uri.isRelative()) {
            return true;
        }
        return uri.val.toLowerCase().startsWith(this.val.toLowerCase());
    }

    public String getAddress() {
        this.parse();
        return this.addr;
    }

    public String getHost() {
        this.parse();
        return this.host;
    }

    public int getPort() {
        this.parse();
        return this.port;
    }

    public String getPath() {
        this.parse();
        return this.path;
    }

    public Query getQuery() {
        this.parse();
        return this.query;
    }

    public String getFragment() {
        this.parse();
        return this.frag;
    }

    public URL toURL() {
        this.checkAbsolute();
        try {
            return new URL(this.val);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Invalid url: " + this.val);
        }
    }

    public Uri parent() {
        this.parse();
        if (this.path.length() <= 1) {
            return null;
        }
        int n = this.path.lastIndexOf(47, this.path.length() - 2);
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            if (this.auth != null) {
                return new Uri(this.auth);
            }
            return null;
        }
        if (this.auth != null) {
            return new Uri(this.auth + this.path.substring(1, n));
        }
        return new Uri(this.path.substring(0, n));
    }

    public static Query parseQuery(String string) {
        if (string == null) {
            return null;
        }
        Query query = new Query(string);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3;
                String string4 = stringTokenizer.nextToken();
                int n = string4.indexOf(61);
                if (n < 0) {
                    string3 = string4;
                    string2 = "true";
                } else {
                    string3 = string4.substring(0, n);
                    string2 = string4.substring(n + 1);
                }
                query.keys.add(string3);
                query.map.put(string3, string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return query;
    }

    public Uri removeQueryParam(String string) {
        return this.addQueryParam(string, null);
    }

    public Uri addQueryParam(String string, String string2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Query query = this.getQuery();
        if (query != null) {
            object = query.keys();
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (object[i].equals(string)) {
                    if (string2 != null) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append('&');
                        }
                        stringBuffer.append(string).append('=').append(string2);
                    }
                    bl = true;
                    continue;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('&');
                }
                stringBuffer.append(object[i]).append('=').append(query.get(object[i], null));
            }
        }
        if (!bl && string2 != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('&');
            }
            stringBuffer.append(string).append('=').append(string2);
        }
        object = this.auth + this.path.substring(1);
        if (stringBuffer.length() > 0) {
            object = (String)object + "?" + stringBuffer;
        }
        return new Uri((String)object);
    }

    private void parse() {
        try {
            block6: {
                if (this.parsed) {
                    return;
                }
                try {
                    URL uRL = new URL(this.val);
                    this.abs = true;
                    this.scheme = uRL.getProtocol();
                    this.addr = uRL.getAuthority();
                    this.auth = this.scheme + "://" + this.addr + "/";
                    this.host = uRL.getHost();
                    this.port = uRL.getPort();
                    this.path = uRL.getPath();
                    this.query = Uri.parseQuery(uRL.getQuery());
                    this.frag = uRL.getRef();
                }
                catch (MalformedURLException malformedURLException) {
                    int n;
                    this.abs = false;
                    this.path = this.val;
                    int n2 = this.path.indexOf(35);
                    if (n2 >= 0) {
                        this.frag = this.path.substring(n2 + 1);
                        this.path = this.path.substring(0, n2);
                    }
                    if ((n = this.path.indexOf(63)) < 0) break block6;
                    this.query = Uri.parseQuery(this.path.substring(n + 1));
                    this.path = this.path.substring(0, n);
                }
            }
            this.parsed = true;
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid uri: " + this.val);
        }
    }

    public boolean isResolved() {
        return this.resolved != null;
    }

    public Obj getResolved() {
        return this.resolved;
    }

    public void setResolved(Obj obj) {
        this.resolved = obj;
    }

    public String get() {
        return this.val;
    }

    public void set(String string) {
        if (string == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this.parsed = false;
        this.val = string;
    }

    public String getElement() {
        return "uri";
    }

    public int getBinCode() {
        return 28;
    }

    public boolean valEquals(Val val) {
        if (val instanceof Uri) {
            return ((Uri)val).val.equals(this.val);
        }
        return false;
    }

    public int compareTo(Object object) {
        return this.val.compareTo(((Uri)object).val);
    }

    public String encodeVal() {
        return this.val;
    }

    public void decodeVal(String string) throws Exception {
        this.set(string);
    }

    public String encodeJava() {
        return '\"' + this.val + '\"';
    }

    public static class Query {
        ArrayList keys = new ArrayList();
        HashMap map = new HashMap();
        String str;

        Query(String string) {
            this.str = string;
        }

        public String[] keys() {
            return this.keys.toArray(new String[this.keys.size()]);
        }

        public String get(String string, String string2) {
            String string3 = (String)this.map.get(string);
            if (string3 == null) {
                return string2;
            }
            return string3;
        }

        public String toString() {
            return this.str;
        }
    }
}

