/*
 * Decompiled with CFR 0.152.
 */
package obix;

import obix.Val;

public class Reltime
extends Val {
    private long val;
    private Reltime min;
    private Reltime max;

    public Reltime(String string, long l) {
        super(string);
        this.set(l);
    }

    public Reltime(String string) {
        super(string);
        this.set(0L);
    }

    public Reltime(long l) {
        this.set(l);
    }

    public Reltime() {
        this.set(0L);
    }

    public long getMillis() {
        return this.val;
    }

    public long get() {
        return this.val;
    }

    public void set(long l) {
        this.val = l;
    }

    public String getElement() {
        return "reltime";
    }

    public int getBinCode() {
        return 36;
    }

    public boolean valEquals(Val val) {
        if (val instanceof Reltime) {
            return ((Reltime)val).val == this.val;
        }
        return false;
    }

    public int compareTo(Object object) {
        long l = this.val;
        long l2 = ((Reltime)object).val;
        if (l == l2) {
            return 0;
        }
        if (l < l2) {
            return -1;
        }
        return 1;
    }

    public String encodeVal() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.val < 0L) {
            stringBuffer.append('-');
        }
        stringBuffer.append("PT");
        long l = Math.abs(this.val);
        long l2 = l / 1000L;
        long l3 = l % 1000L;
        stringBuffer.append(l2);
        if (l3 != 0L) {
            stringBuffer.append('.');
            if (l3 < 10L) {
                stringBuffer.append("00");
            } else if (l3 < 100L) {
                stringBuffer.append("0");
            }
            stringBuffer.append(l3);
        }
        stringBuffer.append('S');
        return stringBuffer.toString();
    }

    public static Reltime parse(String string) throws Exception {
        Reltime reltime = new Reltime();
        reltime.decodeVal(string);
        return reltime;
    }

    public void decodeVal(String string) throws Exception {
        try {
            long l = 0L;
            boolean bl = false;
            Parser parser = new Parser(string);
            if (parser.cur == 45) {
                bl = true;
                parser.consume();
            } else if (parser.cur == 43) {
                parser.consume();
            }
            parser.consume(80);
            if (parser.cur == -1) {
                throw new Exception();
            }
            int n = parser.num();
            if (parser.cur == 68) {
                parser.consume();
                l += (long)n * 24L * 60L * 60L * 1000L;
                n = parser.num();
            }
            if (n >= 0 && parser.cur == 72) {
                if (!parser.time) {
                    throw new Exception();
                }
                parser.consume();
                l += (long)n * 60L * 60L * 1000L;
                n = parser.num();
            }
            if (n >= 0 && parser.cur == 77) {
                if (!parser.time) {
                    throw new Exception();
                }
                parser.consume();
                l += (long)n * 60L * 1000L;
                n = parser.num();
            }
            if (n >= 0 && parser.cur == 83 || parser.cur == 46) {
                if (!parser.time) {
                    throw new Exception();
                }
                l += (long)n * 1000L;
                if (parser.cur == 46) {
                    parser.consume();
                    l += (long)parser.frac();
                }
                parser.consume(83);
            }
            if (parser.cur != -1) {
                throw new Exception();
            }
            if (bl) {
                l *= -1L;
            }
            this.set(l);
        }
        catch (Exception exception) {
            throw new Exception("Invalid reltime: " + string);
        }
    }

    public String encodeJava() {
        return String.valueOf(this.val) + "L";
    }

    public Reltime getMin() {
        return this.min;
    }

    public void setMin(Reltime reltime) {
        this.min = reltime;
    }

    public Reltime getMax() {
        return this.max;
    }

    public void setMax(Reltime reltime) {
        this.max = reltime;
    }

    static class Parser {
        String s;
        int off;
        int cur;
        boolean curIsDigit;
        boolean time;

        Parser(String string) {
            this.s = string;
            this.cur = string.charAt(0);
        }

        int frac() {
            int n = 0;
            if (this.curIsDigit) {
                n += this.digit() * 100;
                this.consume();
                if (this.curIsDigit) {
                    n += this.digit() * 10;
                    this.consume();
                    if (this.curIsDigit) {
                        n += this.digit();
                        this.consume();
                        while (this.curIsDigit) {
                            this.consume();
                        }
                    }
                }
            }
            return n;
        }

        int num() {
            if (this.cur == 84) {
                this.time = true;
                this.consume();
            }
            int n = 0;
            while (this.curIsDigit) {
                n = n * 10 + this.digit();
                this.consume();
            }
            return n;
        }

        int digit() {
            return this.cur - 48;
        }

        void consume(int n) {
            if (this.cur != n) {
                throw new IllegalStateException();
            }
            this.consume();
        }

        void consume() {
            ++this.off;
            if (this.off < this.s.length()) {
                this.cur = this.s.charAt(this.off);
                this.curIsDigit = 48 <= this.cur && this.cur <= 57;
            } else {
                this.cur = -1;
                this.curIsDigit = false;
            }
        }
    }
}

