/*
 * Decompiled with CFR 0.152.
 */
package obix;

import obix.Val;

public class Date
extends Val {
    private int year = 2000;
    private int mon = 1;
    private int day = 1;
    private Date min;
    private Date max;
    private String tz;

    public Date(String string, int n, int n2, int n3) {
        super(string);
        this.set(n, n2, n3);
    }

    public Date(String string) {
        super(string);
    }

    public Date(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public Date() {
    }

    public final int getYear() {
        return this.year;
    }

    public final int getMonth() {
        return this.mon;
    }

    public final int getDay() {
        return this.day;
    }

    public void set(int n, int n2, int n3) {
        if (n < 1900 || n > 2100) {
            throw new IllegalArgumentException("year not 1900-2100: " + n);
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("mon not 1-12: " + n2);
        }
        if (n3 < 0 || n3 > 31) {
            throw new IllegalArgumentException("day not 1-31: " + n3);
        }
        this.year = n;
        this.mon = n2;
        this.day = n3;
    }

    public String getElement() {
        return "date";
    }

    public int getBinCode() {
        return 40;
    }

    public boolean valEquals(Val val) {
        if (val instanceof Date) {
            Date date = (Date)val;
            return this.year == date.year && this.mon == date.mon && this.day == date.day;
        }
        return false;
    }

    public int compareTo(Object object) {
        Date date = this;
        Date date2 = (Date)object;
        if (date.year < date2.year) {
            return -1;
        }
        if (date.year > date2.year) {
            return 1;
        }
        if (date.mon < date2.mon) {
            return -1;
        }
        if (date.mon > date2.mon) {
            return 1;
        }
        if (date.day < date2.day) {
            return -1;
        }
        if (date.day > date2.day) {
            return 1;
        }
        return 0;
    }

    public String encodeVal() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.year);
        stringBuffer.append('-');
        if (this.mon < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(this.mon);
        stringBuffer.append('-');
        if (this.day < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(this.day);
        return stringBuffer.toString();
    }

    public static Date parse(String string) throws Exception {
        Date date = new Date();
        date.decodeVal(string);
        return date;
    }

    public void decodeVal(String string) throws Exception {
        try {
            if (string.length() != 10 || string.charAt(4) != '-' || string.charAt(7) != '-') {
                throw new Exception();
            }
            int n = Integer.parseInt(string.substring(0, 4));
            int n2 = Integer.parseInt(string.substring(5, 7));
            int n3 = Integer.parseInt(string.substring(8));
            this.set(n, n2, n3);
        }
        catch (Exception exception) {
            throw new Exception("Invalid date: " + string);
        }
    }

    public Date getMin() {
        return this.min;
    }

    public void setMin(Date date) {
        this.min = date;
    }

    public Date getMax() {
        return this.max;
    }

    public void setMax(Date date) {
        this.max = date;
    }

    public String getTz() {
        return this.tz;
    }

    public void setTz(String string) {
        this.tz = string;
    }
}

