/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.BCoordinatedGridPane;
import com.tridium.ui.theme.Theme;
import com.tridium.util.ObjectUtil;
import java.text.DateFormat;
import java.util.Date;
import javax.baja.gx.BFont;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.LexiconText;

public class LabelUtil {
    public static BFont BOLD_TEXT_FONT = Theme.widget().getBoldText();

    public static void addLabelWidgetPair(BGridPane bGridPane, LexiconText lexiconText, BWidget bWidget, boolean bl) {
        LabelUtil.addLabelWidgetPair(bGridPane, lexiconText == null ? "" : lexiconText.getText(null), bWidget, bl);
    }

    public static void addLabelWidgetPair(BGridPane bGridPane, LexiconText lexiconText, BWidget bWidget) {
        LabelUtil.addLabelWidgetPair(bGridPane, lexiconText == null ? "" : lexiconText.getText(null), bWidget, true);
    }

    public static void addLabelWidgetPair(BCoordinatedGridPane bCoordinatedGridPane, LexiconText lexiconText, BWidget bWidget) {
        LabelUtil.addLabelWidgetPair(bCoordinatedGridPane, lexiconText == null ? "" : lexiconText.getText(null), bWidget, true);
    }

    public static void addLabelWidgetPair(BGridPane bGridPane, LexiconText lexiconText, Object[] objectArray, BWidget bWidget, boolean bl) {
        LabelUtil.addLabelWidgetPair(bGridPane, lexiconText == null ? "" : lexiconText.getText(null, objectArray), bWidget, bl);
    }

    public static void addLabelWidgetPair(BGridPane bGridPane, LexiconText lexiconText, Object[] objectArray, BWidget bWidget) {
        LabelUtil.addLabelWidgetPair(bGridPane, lexiconText == null ? "" : lexiconText.getText(null, objectArray), bWidget, true);
    }

    public static void addLabelWidgetPair(BGridPane bGridPane, String string, BWidget bWidget) {
        LabelUtil.addLabelWidgetPair(bGridPane, string, bWidget, true);
    }

    public static void addLabelWidgetPair(BGridPane bGridPane, String string, BWidget bWidget, boolean bl) {
        String string2 = string.trim();
        if (string2.length() > 10) {
            string2 = string2.substring(0, 10);
        }
        string2 = ObjectUtil.generateUniqueSlotName((String)SlotPath.escape((String)string2), (ObjectUtil.NameContainer)new NameContainer((BComplex)bGridPane));
        bGridPane.add(string2, (BValue)LabelUtil.makeLabel(string, bl));
        bGridPane.add(null, (BValue)bWidget);
    }

    public static void addLabelWidgetPair(BCoordinatedGridPane bCoordinatedGridPane, String string, BWidget bWidget, boolean bl) {
        String string2 = string.trim();
        if (string2.length() > 10) {
            string2 = string2.substring(0, 10);
        }
        string2 = ObjectUtil.generateUniqueSlotName((String)SlotPath.escape((String)string2), (ObjectUtil.NameContainer)new NameContainer((BComplex)bCoordinatedGridPane));
        bCoordinatedGridPane.add(string2, (BValue)LabelUtil.makeLabel(string, bl));
        bCoordinatedGridPane.add(null, (BValue)bWidget);
    }

    public static BLabel makeLabel(LexiconText lexiconText) {
        return LabelUtil.makeLabel(lexiconText, false, BHalign.left);
    }

    public static BLabel makeLabel(LexiconText lexiconText, boolean bl) {
        return LabelUtil.makeLabel(lexiconText, bl, BHalign.left);
    }

    public static BLabel makeLabel(LexiconText lexiconText, boolean bl, BHalign bHalign) {
        return LabelUtil.makeLabel(lexiconText == null ? null : lexiconText.getText(null), bl, bHalign);
    }

    public static BLabel makeLabel(LexiconText lexiconText, Object[] objectArray) {
        return LabelUtil.makeLabel(lexiconText, objectArray, false, BHalign.left);
    }

    public static BLabel makeLabel(LexiconText lexiconText, Object[] objectArray, boolean bl) {
        return LabelUtil.makeLabel(lexiconText, objectArray, bl, BHalign.left);
    }

    public static BLabel makeLabel(LexiconText lexiconText, Object[] objectArray, boolean bl, BHalign bHalign) {
        return LabelUtil.makeLabel(lexiconText == null ? null : lexiconText.getText(null, objectArray), bl, bHalign);
    }

    public static BLabel makeLabel(String string, boolean bl) {
        return LabelUtil.makeLabel(string, bl, BHalign.left);
    }

    public static BLabel makeLabel(String string, boolean bl, BHalign bHalign) {
        BLabel bLabel = new BLabel(string == null ? "" : string, bHalign);
        if (bl) {
            bLabel.setFont(BOLD_TEXT_FONT);
        }
        return bLabel;
    }

    public static String formatTime(BAbsTime bAbsTime) {
        if (bAbsTime == null || bAbsTime.isNull()) {
            return String.valueOf(bAbsTime);
        }
        return DateFormat.getInstance().format(new Date(bAbsTime.getMillis()));
    }

    private static class NameContainer
    implements ObjectUtil.NameContainer {
        BComplex complex;

        public NameContainer(BComplex bComplex) {
            this.complex = bComplex;
        }

        public boolean contains(String string) {
            return this.complex.getSlot(string) != null;
        }
    }
}

