/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.BTextOutputPane;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidgetShell;
import javax.baja.util.Lexicon;

public abstract class BInputStreamPane
extends BTextOutputPane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$util$BInputStreamPane == null ? (class$com$tridium$platform$ui$util$BInputStreamPane = BInputStreamPane.class$("com.tridium.platform.ui.util.BInputStreamPane")) : class$com$tridium$platform$ui$util$BInputStreamPane));
    public static final int BUFFER_TIME_MAX = 3000;
    protected int bufferTime = 3000;
    protected OutputWatcher watcher = null;
    private static Lexicon lex = Lexicon.make((String)"platform");
    static /* synthetic */ Class class$com$tridium$platform$ui$util$BInputStreamPane;

    public Type getType() {
        return TYPE;
    }

    public BInputStreamPane() {
        this(20, 80);
    }

    public BInputStreamPane(int n, int n2) {
        super(n, n2);
        this.setUseAutoScroll(true);
    }

    protected abstract InputStream getInputStream();

    public synchronized void load() {
        InputStream inputStream = this.getInputStream();
        if (inputStream != null) {
            this.stopUpdates();
            this.startUpdates(new OutputWatcher(inputStream));
        }
    }

    public void setBufferTime(int n) {
        this.bufferTime = n;
    }

    public int getBufferTime() {
        return this.bufferTime;
    }

    protected synchronized void startUpdates(OutputWatcher outputWatcher) {
        this.watcher = outputWatcher;
        this.watcher.start();
    }

    public synchronized void stopUpdates() {
        if (this.watcher != null) {
            this.watcher.stopWatcher();
            this.watcher = null;
        }
    }

    public void clearValue() {
        this.stopUpdates();
        this.clear();
    }

    public synchronized void clearText() throws Exception {
        if (this.watcher == null) {
            this.clear();
        } else {
            this.watcher.clearOutput();
        }
    }

    public void deactivated() {
        this.stopUpdates();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopUpdates();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class OutputWatcher
    extends Thread {
        private InputStream in;
        private boolean stopped = true;
        private boolean clearBuffer = false;
        private String clearSync = new String("sync");
        private BWidgetShell shell;

        public OutputWatcher(InputStream inputStream) {
            super("InputStreamPane:OutputWatcher");
            this.in = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long l;
            boolean bl = true;
            this.stopped = false;
            byte[] byArray = new byte[1024];
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            long l2 = l = Clock.ticks();
            BInputStreamPane.this.setText("");
            try {
                this.shell = BInputStreamPane.this.getShell();
                if (this.shell != null) {
                    this.shell.enterBusy();
                }
                while (!this.stopped) {
                    String string;
                    block30: {
                        string = this.clearSync;
                        synchronized (string) {
                            this.clearBuffer = false;
                        }
                        try {
                            l2 = Clock.ticks();
                            n = this.in.read(byArray, 0, 1024);
                            if (!bl) break block30;
                            if (this.shell != null) {
                                this.shell.exitBusy();
                            }
                            bl = false;
                        }
                        catch (NullPointerException nullPointerException) {
                            if (bl) {
                                if (this.shell != null) {
                                    this.shell.exitBusy();
                                }
                                bl = false;
                            }
                            throw new IOException();
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            if (stringBuffer.length() > 0) {
                                BInputStreamPane.this.append(stringBuffer.toString());
                                stringBuffer = new StringBuffer();
                            }
                            if (!bl) continue;
                            if (this.shell != null) {
                                this.shell.exitBusy();
                            }
                            bl = false;
                            continue;
                        }
                    }
                    string = this.clearSync;
                    synchronized (string) {
                        if (this.clearBuffer) {
                            n = 0;
                            this.clearBuffer = false;
                        }
                    }
                    if (this.stopped) continue;
                    if (n >= 0) {
                        if (l2 - l > (long)BInputStreamPane.this.bufferTime) {
                            if (stringBuffer.length() > 0) {
                                BInputStreamPane.this.append(stringBuffer.toString());
                                stringBuffer = new StringBuffer();
                            }
                            BInputStreamPane.this.append(new String(byArray, 0, n));
                            continue;
                        }
                        stringBuffer.append(new String(byArray, 0, n));
                        continue;
                    }
                    if (stringBuffer.length() > 0) {
                        BInputStreamPane.this.append(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                    }
                    this.stopWatcher(false);
                }
            }
            catch (EOFException eOFException) {
                String string = "\n" + lex.getText("InputStreamPane.eof");
                BInputStreamPane.this.append(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                BInputStreamPane.this.append(string.getBytes(), 0, string.length());
            }
            catch (IOException iOException) {
                BInputStreamPane.this.append(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                if (!this.stopped) {
                    iOException.printStackTrace(System.out);
                }
            }
            finally {
                if (bl && this.shell != null) {
                    this.shell.exitBusy();
                }
                this.stopWatcher(false);
            }
        }

        public void stopWatcher() {
            this.stopWatcher(true);
        }

        public void stopWatcher(boolean bl) {
            if (this.stopped) {
                return;
            }
            this.clearBuffer = false;
            this.stopped = true;
            try {
                this.in.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bl) {
                try {
                    this.join();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearOutput() {
            String string = this.clearSync;
            synchronized (string) {
                BInputStreamPane.this.clear();
                this.clearBuffer = true;
            }
        }
    }
}

