/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.platform.ui.util.BBox;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.LexiconText;

public class BIndentPane
extends BGridPane {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$util$BIndentPane == null ? (class$com$tridium$platform$ui$util$BIndentPane = BIndentPane.class$("com.tridium.platform.ui.util.BIndentPane")) : class$com$tridium$platform$ui$util$BIndentPane));
    private BIndentPane contentPane;
    private int indentWidth;
    public static int DEFAULT_WIDTH = 6;
    static /* synthetic */ Class class$com$tridium$platform$ui$util$BIndentPane;

    public Type getType() {
        return TYPE;
    }

    public BIndentPane() {
        this(DEFAULT_WIDTH);
    }

    private BIndentPane(int n) {
        super(1);
        this.setValign(BValign.top);
        this.setHalign(BHalign.left);
        this.contentPane = this;
        this.indentWidth = n;
    }

    public void setIndentWidth(int n) {
        this.indentWidth = n;
        if (this.contentPane != this) {
            this.contentPane.setIndentWidth(n);
        }
    }

    public int getIndentWidth() {
        return this.indentWidth;
    }

    public void indent(int n) {
        if (n < 0) {
            this.unindent(-1 * n);
        } else {
            for (int i = 0; i < n; ++i) {
                this.indent();
            }
        }
    }

    public void indent() {
        if (this.contentPane == this) {
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.setValign(BValign.top);
            bGridPane.setHalign(BHalign.left);
            bGridPane.add("box", (BValue)new BBox(this.indentWidth, 0.0));
            this.contentPane = new BIndentPane(this.getIndentWidth());
            bGridPane.add("content", (BValue)this.contentPane);
            super.add(null, (BValue)bGridPane);
        } else {
            this.contentPane.indent();
        }
    }

    public void unindentAll() {
        this.contentPane = this;
    }

    public void unindent(int n) {
        if (n < 0) {
            this.indent(-1 * n);
        } else {
            for (int i = 0; i < n; ++i) {
                this.unindent();
            }
        }
    }

    public boolean unindent() {
        if (this.contentPane == this) {
            return false;
        }
        if (!this.contentPane.unindent()) {
            this.contentPane = this;
        }
        return true;
    }

    public void add(BWidget bWidget) {
        if (this.contentPane == this) {
            super.add((String)null, (BValue)bWidget);
        } else {
            this.contentPane.add(bWidget);
        }
    }

    public void add(String string) {
        this.add((BWidget)new BLabel(string, BHalign.left));
    }

    public void add(LexiconText lexiconText) {
        this.add((BWidget)new BLabel(lexiconText.getText(null), BHalign.left));
    }

    public void add(LexiconText lexiconText, Context context) {
        this.add((BWidget)new BLabel(lexiconText.getText(context), BHalign.left));
    }

    public void add(LexiconText lexiconText, Object[] objectArray) {
        this.add((BWidget)new BLabel(lexiconText.getText(null, objectArray), BHalign.left));
    }

    public void add(LexiconText lexiconText, Object[] objectArray, Context context) {
        this.add((BWidget)new BLabel(lexiconText.getText(context, objectArray), BHalign.left));
    }

    public void clear() {
        this.removeAll();
        this.unindentAll();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

