/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.util;

import com.tridium.sys.module.BModuleNavNode;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.ui.file.FileChooserModel;
import java.util.ArrayList;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;

public class BFileChooserListView
extends BTable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$util$BFileChooserListView == null ? (class$com$tridium$platform$ui$util$BFileChooserListView = BFileChooserListView.class$("com.tridium.platform.ui.util.BFileChooserListView")) : class$com$tridium$platform$ui$util$BFileChooserListView));
    protected FileChooserModel fileModel;
    protected ListModel model;
    protected boolean showDirs;
    protected boolean showFiles;
    static /* synthetic */ Class class$com$tridium$platform$ui$util$BFileChooserListView;

    public Type getType() {
        return TYPE;
    }

    public BFileChooserListView() {
        throw new UnsupportedOperationException();
    }

    public BFileChooserListView(FileChooserModel fileChooserModel) {
        this.model = new ListModel();
        this.fileModel = fileChooserModel;
        this.setShowDirectories(true);
        this.setShowFiles(true);
        this.populateChildren();
        this.setModel(this.model);
        this.setController(new Controller());
        this.setSelection(new Selection());
        this.setHeaderVisible(false);
        this.setHgridVisible(false);
        this.setVgridVisible(false);
    }

    public boolean getShowDirectories() {
        return this.showDirs;
    }

    public void setShowDirectories(boolean bl) {
        this.showDirs = bl;
    }

    public boolean getShowFiles() {
        return this.showFiles;
    }

    public void setShowFiles(boolean bl) {
        this.showFiles = bl;
    }

    public void populateChildren() {
        BINavNode[] bINavNodeArray = this.fileModel.getChildren();
        this.model.kids = this.sort(this.filter(bINavNodeArray));
    }

    private BINavNode[] filter(BINavNode[] bINavNodeArray) {
        if (!(this.fileModel.getSpace() instanceof BFileSpace)) {
            return bINavNodeArray;
        }
        ArrayList<BIFile> arrayList = new ArrayList<BIFile>();
        for (int i = 0; i < bINavNodeArray.length; ++i) {
            BIFile bIFile = (BIFile)bINavNodeArray[i];
            if ((!this.showDirs || !(bIFile instanceof BIDirectory)) && (!this.showFiles || bIFile instanceof BIDirectory)) continue;
            arrayList.add(bIFile);
        }
        BIFile[] bIFileArray = new BIFile[arrayList.size()];
        return (BINavNode[])arrayList.toArray(bIFileArray);
    }

    private BINavNode[] sort(BINavNode[] bINavNodeArray) {
        if (!this.showDirs || !this.showFiles) {
            return bINavNodeArray;
        }
        for (int i = 1; i < bINavNodeArray.length; ++i) {
            if (!(bINavNodeArray[i] instanceof BIDirectory)) continue;
            for (int j = i; j > 0 && !(bINavNodeArray[j - 1] instanceof BIDirectory); --j) {
                BINavNode bINavNode = bINavNodeArray[j - 1];
                bINavNodeArray[j - 1] = bINavNodeArray[j];
                bINavNodeArray[j] = bINavNode;
            }
        }
        return bINavNodeArray;
    }

    public void select(BIFile bIFile) {
        for (int i = 0; i < this.model.kids.length; ++i) {
            if (!bIFile.getNavName().equals(this.model.kids[i].getNavName())) continue;
            if (this.getSelection().isSelected(i)) break;
            this.getSelection().select(i);
            break;
        }
    }

    public void setListView() {
        this.model = new ListModel();
        this.setModel(this.model);
        this.setHeaderVisible(false);
        this.populateChildren();
    }

    public void setDetailsView() {
        this.model = new DetailsModel();
        this.setModel(this.model);
        this.setHeaderVisible(true);
        this.populateChildren();
    }

    public void setView(ListModel listModel, boolean bl) {
        this.model = listModel;
        this.setModel(this.model);
        this.setHeaderVisible(bl);
        this.populateChildren();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DetailsModel
    extends ListModel {
        public int getColumnCount() {
            if (this.kids.length == 0 || this.kids[0] instanceof BIFile) {
                return 3;
            }
            if (this.kids[0] instanceof BModuleNavNode) {
                return 4;
            }
            return 1;
        }

        public String getColumnName(int n) {
            if (this.kids.length == 0 || this.kids[0] instanceof BIFile) {
                switch (n) {
                    case 0: {
                        return UiLexicon.bajaui.getText("fileChooser.name");
                    }
                    case 1: {
                        return UiLexicon.bajaui.getText("fileChooser.size");
                    }
                    case 2: {
                        return UiLexicon.bajaui.getText("fileChooser.lastModified");
                    }
                }
                return "";
            }
            if (this.kids[0] instanceof BModuleNavNode) {
                switch (n) {
                    case 0: {
                        return "Name";
                    }
                    case 1: {
                        return "Vendor";
                    }
                    case 2: {
                        return "Version";
                    }
                    case 3: {
                        return "Description";
                    }
                }
                return "";
            }
            return UiLexicon.bajaui.getText("fileChooser.name");
        }

        public Object getValueAt(int n, int n2) {
            if (this.kids[n] instanceof BIFile) {
                return this.getFileDetail(n, n2);
            }
            if (this.kids[n] instanceof BModuleNavNode) {
                return this.getModuleDetail(n, n2);
            }
            return super.getValueAt(n, n2);
        }

        private Object getFileDetail(int n, int n2) {
            BIFile bIFile = (BIFile)this.kids[n];
            switch (n2) {
                case 0: {
                    return super.getValueAt(n, n2);
                }
                case 1: {
                    if (bIFile instanceof BIDirectory) {
                        return "";
                    }
                    long l = bIFile.getSize();
                    String string = l < 1024L ? "1 KB" : String.valueOf(l / 1024L) + " KB";
                    return string;
                }
                case 2: {
                    if (bIFile instanceof BDirectory || bIFile.getLastModified().getMillis() == 0L) {
                        return "";
                    }
                    return String.valueOf(bIFile.getLastModified());
                }
            }
            return null;
        }

        private Object getModuleDetail(int n, int n2) {
            BModuleNavNode bModuleNavNode = (BModuleNavNode)this.kids[n];
            NModuleInfo nModuleInfo = bModuleNavNode.info;
            switch (n2) {
                case 0: {
                    return super.getValueAt(n, n2);
                }
                case 1: {
                    return nModuleInfo.getVendor();
                }
                case 2: {
                    return nModuleInfo.getVendorVersion();
                }
                case 3: {
                    return nModuleInfo.getDescription();
                }
            }
            return null;
        }
    }

    public static class ListModel
    extends TableModel {
        protected BINavNode[] kids;

        public int getRowCount() {
            return this.kids.length;
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            return "";
        }

        public Object getValueAt(int n, int n2) {
            return this.kids[n].getNavDisplayName(null);
        }

        public BImage getRowIcon(int n) {
            return BImage.make((BIcon)this.kids[n].getNavIcon());
        }

        public BINavNode get(int n) {
            return this.kids[n];
        }
    }

    public class Selection
    extends TableSelection {
        public void select(int n, boolean bl) {
            super.select(n, bl);
            if (bl) {
                BFileChooserListView.this.fileModel.deselectAll();
            }
            if (n < BFileChooserListView.this.model.getRowCount()) {
                this.handleSelect(n);
            }
        }

        public void select(int n, int n2, boolean bl) {
            int n3;
            int n4;
            int n5;
            super.select(n, n2, bl);
            if (bl) {
                BFileChooserListView.this.fileModel.deselectAll();
            }
            if ((n5 = n2) < (n4 = n)) {
                n3 = n4;
                n4 = n5;
                n5 = n3;
            }
            for (n3 = n4; n3 <= n5; ++n3) {
                this.handleSelect(n3);
            }
        }

        public void select(int[] nArray) {
            super.select(nArray);
            for (int i = 0; i < nArray.length; ++i) {
                this.handleSelect(i);
            }
        }

        public void deselect(int n) {
            super.deselect(n);
            BINavNode bINavNode = BFileChooserListView.this.model.get(n);
            if (bINavNode instanceof BIFile) {
                BFileChooserListView.this.fileModel.deselect((BIFile)bINavNode);
            }
        }

        public void deselectAll() {
            super.deselectAll();
            BFileChooserListView.this.fileModel.deselectAll();
        }

        private void handleSelect(int n) {
            BINavNode bINavNode = BFileChooserListView.this.model.get(n);
            if (bINavNode instanceof BIFile) {
                BFileChooserListView.this.fileModel.select((BIFile)bINavNode);
            }
        }
    }

    public class Controller
    extends TableController {
        public void handleEnter(BKeyEvent bKeyEvent) {
            int n = this.getTable().getSelection().getRow();
            if (n >= 0) {
                this.handleSelection(BFileChooserListView.this.model.kids[n]);
            }
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            this.handleSelection(BFileChooserListView.this.model.kids[n]);
        }

        void handleSelection(BINavNode bINavNode) {
            if (bINavNode instanceof BIDirectory || bINavNode instanceof BNavContainer) {
                BFileChooserListView.this.fileModel.setDirectory(bINavNode);
            } else {
                BFileChooserListView.this.fileModel.chooseSelectedFiles();
            }
        }

        public void keyPressed(BKeyEvent bKeyEvent) {
            super.keyPressed(bKeyEvent);
            if (bKeyEvent.getKeyCode() == 38 && bKeyEvent.isAltDown()) {
                BFileChooserListView.this.fileModel.moveUpDirectory();
            }
        }

        public int getTextSearchColumn() {
            return 0;
        }
    }
}

