/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.ui.tcpip;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.ui.tcpip.BIpHostFE;
import com.tridium.platform.ui.tcpip.BIpHostVectorFE;
import com.tridium.platform.ui.tcpip.BTcpIpAdapterEditor;
import com.tridium.platform.ui.util.LabelUtil;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BExpandablePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbComponentView;

public class BTcpIpHostEditor
extends BWbComponentView {
    public static final Action handleHostFileContentChanged = BTcpIpHostEditor.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$ui$tcpip$BTcpIpHostEditor == null ? (class$com$tridium$platform$ui$tcpip$BTcpIpHostEditor = BTcpIpHostEditor.class$("com.tridium.platform.ui.tcpip.BTcpIpHostEditor")) : class$com$tridium$platform$ui$tcpip$BTcpIpHostEditor));
    private BTextEditorPane hostsFilePane = null;
    private Array adapterEditors = null;
    private boolean hostFileDirty = false;
    private BTextField hostNameTextField = null;
    private boolean isIPv6Readonly = true;
    private BCheckBox niagaraUsesIpv6 = null;
    private BTextField domainTextField = null;
    private BIpHostFE gatewayFE = null;
    private BIpHostVectorFE dnsHostEditor = null;
    private BIpHostFE ipv6DefaultGatewayFE = null;
    private BIpHostVectorFE ipv6DnsHostEditor = null;
    static /* synthetic */ Class class$com$tridium$platform$ui$tcpip$BTcpIpHostEditor;

    public void handleHostFileContentChanged() {
        this.invoke(handleHostFileContentChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doHandleHostFileContentChanged() {
        this.hostFileDirty = true;
        this.setModified();
    }

    private BWidget left(BWidget bWidget) {
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setColumnAlign(BHalign.left);
        bGridPane.add(null, (BValue)bWidget);
        return bGridPane;
    }

    protected final void doLoadValue(BObject bObject, Context context) throws Exception {
        BTcpIpHostSettings bTcpIpHostSettings = (BTcpIpHostSettings)bObject;
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setValign(BValign.top);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setStretchColumn(1);
        bGridPane.setColumnGap(10.0);
        bGridPane.setRowGap(6.0);
        bGridPane.setColorRows(true);
        this.hostNameTextField = new BTextField(bTcpIpHostSettings.getHostName(), 32);
        LabelUtil.addLabelWidgetPair(bGridPane, LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.hostName"), this.left((BWidget)this.hostNameTextField));
        this.hostsFilePane = new BTextEditorPane(bTcpIpHostSettings.getHostFileContents(), 20, 80, true);
        LabelUtil.addLabelWidgetPair(bGridPane, LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.hostFile"), (BWidget)new BExpandablePane((BWidget)new BNullWidget(), (BWidget)this.hostsFilePane));
        BTcpIpAdapterSettings bTcpIpAdapterSettings = null;
        boolean bl = false;
        SlotCursor slotCursor = bTcpIpHostSettings.getAdapters().loadSlots().getProperties();
        while (slotCursor.next()) {
            bTcpIpAdapterSettings = (BTcpIpAdapterSettings)slotCursor.get();
            if (!bTcpIpAdapterSettings.getIsIpv6Supported()) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.niagaraUsesIpv6 = new BCheckBox(this.getLexicon().getText("TcpIpHostEditor.niagaraUsesIpv6.value"));
            LabelUtil.addLabelWidgetPair(bGridPane, LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.niagaraUsesIpv6"), this.left((BWidget)this.niagaraUsesIpv6));
            this.niagaraUsesIpv6.setSelected(bTcpIpHostSettings.getNiagaraUsesIpv6());
            this.isIPv6Readonly = bTcpIpHostSettings.getIsIPv6Readonly();
        } else {
            this.niagaraUsesIpv6 = null;
            this.isIPv6Readonly = true;
        }
        if (bTcpIpHostSettings.getUsesAdapterLevelSettings()) {
            this.domainTextField = null;
            this.gatewayFE = null;
            this.dnsHostEditor = null;
            this.ipv6DnsHostEditor = null;
            this.ipv6DefaultGatewayFE = null;
        } else {
            this.domainTextField = new BTextField(bTcpIpHostSettings.getDomain(), 32);
            LabelUtil.addLabelWidgetPair(bGridPane, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.domain"), this.left((BWidget)this.domainTextField));
            this.gatewayFE = new BIpHostFE();
            LabelUtil.addLabelWidgetPair(bGridPane, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.gateway"), this.left((BWidget)this.gatewayFE));
            this.gatewayFE.loadValue((BObject)BString.make((String)bTcpIpHostSettings.getDefaultGateway()), context);
            this.dnsHostEditor = new BIpHostVectorFE();
            LabelUtil.addLabelWidgetPair(bGridPane, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.dnsHost"), (BWidget)this.dnsHostEditor);
            if (bl) {
                this.ipv6DefaultGatewayFE = new BIpHostFE(true);
                LabelUtil.addLabelWidgetPair(bGridPane, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6Gateway"), this.left((BWidget)this.ipv6DefaultGatewayFE));
                this.ipv6DefaultGatewayFE.loadValue((BObject)BString.make((String)bTcpIpHostSettings.getIpv6DefaultGateway()), context);
                this.ipv6DnsHostEditor = new BIpHostVectorFE(true);
                LabelUtil.addLabelWidgetPair(bGridPane, LexiconText.make((Type)TYPE, (String)"TcpIpAdapterEditor.ipv6DnsHost"), (BWidget)this.ipv6DnsHostEditor);
            } else {
                this.ipv6DnsHostEditor = null;
                this.ipv6DefaultGatewayFE = null;
            }
            slotCursor = new BasicContext(context, BFacets.make((String)"maxHosts", (BIDataValue)BInteger.make((int)bTcpIpHostSettings.getMaxDnsHosts())));
            this.dnsHostEditor.loadValue((BObject)bTcpIpHostSettings.getDnsHosts(), (Context)slotCursor);
            if (bl) {
                this.ipv6DnsHostEditor.loadValue((BObject)bTcpIpHostSettings.getIpv6DnsHosts(), (Context)slotCursor);
            }
            this.linkTo(null, (BComponent)this.domainTextField, (Slot)BTextField.textModified, (Slot)setModified);
            this.linkTo(null, (BComponent)this.gatewayFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
            this.linkTo(null, (BComponent)this.dnsHostEditor, (Slot)BIpHostVectorFE.pluginModified, (Slot)setModified);
            if (bl) {
                this.linkTo(null, (BComponent)this.ipv6DnsHostEditor, (Slot)BIpHostVectorFE.pluginModified, (Slot)setModified);
                this.linkTo(null, (BComponent)this.ipv6DefaultGatewayFE, (Slot)BIpHostFE.pluginModified, (Slot)setModified);
            }
        }
        slotCursor = new BGridPane(1);
        slotCursor.setHalign(BHalign.left);
        slotCursor.setColumnAlign(BHalign.fill);
        slotCursor.setStretchColumn(0);
        LabelUtil.addLabelWidgetPair(bGridPane, LexiconText.make((Type)TYPE, (String)"TcpIpHostEditor.interfaceCategory"), (BWidget)slotCursor);
        if (this.getSlot("lk0") != null) {
            this.remove("lk0");
        }
        if (this.getSlot("lk3") != null) {
            this.remove("lk3");
        }
        this.linkTo("lk0", (BComponent)this.hostNameTextField, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.hostsFilePane.getEditor(), (Slot)BTextEditor.textModified, (Slot)handleHostFileContentChanged);
        if (bl) {
            this.linkTo(null, (BComponent)this.niagaraUsesIpv6, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        }
        this.adapterEditors = new Array();
        int n = 0;
        BExpandablePane bExpandablePane = null;
        SlotCursor slotCursor2 = bTcpIpHostSettings.getAdapters().loadSlots().getProperties();
        while (slotCursor2.next()) {
            BTcpIpAdapterSettings bTcpIpAdapterSettings2 = (BTcpIpAdapterSettings)slotCursor2.get();
            ++n;
            BTcpIpAdapterEditor bTcpIpAdapterEditor = new BTcpIpAdapterEditor();
            bTcpIpAdapterEditor.loadValue((BObject)bTcpIpAdapterSettings2);
            this.adapterEditors.add((Object)bTcpIpAdapterEditor);
            bTcpIpAdapterEditor.setReadonly(this.isReadonly());
            this.linkTo(null, (BComponent)bTcpIpAdapterEditor, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
            BExpandablePane bExpandablePane2 = new BExpandablePane((BWidget)new BLabel(this.getLexicon().getText("TcpIpHostEditor.interfacePrefix") + " " + n), (BWidget)new BBorderPane((BWidget)bTcpIpAdapterEditor, BBorder.inset, BInsets.make((double)4.0)));
            if (bExpandablePane == null) {
                bExpandablePane = bExpandablePane2;
            }
            slotCursor.add(null, (BValue)bExpandablePane2, null);
        }
        if (n == 1 && bExpandablePane != null) {
            bExpandablePane.setExpanded(true);
        }
        this.doSetReadonly(this.isReadonly() || bTcpIpHostSettings.getIsReadonly());
        this.setContent((BWidget)bGridPane);
    }

    protected void doSetReadonly(boolean bl) {
        if (this.hostNameTextField != null) {
            this.hostNameTextField.setEditable(!bl);
            this.hostNameTextField.setEnabled(!bl);
        }
        if (this.hostsFilePane != null) {
            this.hostsFilePane.getEditor().setEditable(!bl);
            this.hostsFilePane.getEditor().setEnabled(!bl);
        }
        if (this.domainTextField != null) {
            this.domainTextField.setEditable(!bl);
            this.domainTextField.setEnabled(!bl);
        }
        if (this.gatewayFE != null) {
            this.gatewayFE.setReadonly(bl);
            this.gatewayFE.setEnabled(!bl);
        }
        if (this.dnsHostEditor != null) {
            this.dnsHostEditor.setReadonly(bl);
            this.dnsHostEditor.setEnabled(!bl);
        }
        if (this.niagaraUsesIpv6 != null) {
            this.niagaraUsesIpv6.setEnabled(!bl);
        }
        if (this.ipv6DefaultGatewayFE != null) {
            this.ipv6DefaultGatewayFE.setReadonly(bl || this.isIPv6Readonly);
            this.ipv6DefaultGatewayFE.setEnabled(!bl && !this.isIPv6Readonly);
        }
        if (this.ipv6DnsHostEditor != null) {
            this.ipv6DnsHostEditor.setReadonly(bl || this.isIPv6Readonly);
            this.ipv6DnsHostEditor.setEnabled(!bl && !this.isIPv6Readonly);
        }
        if (this.adapterEditors != null) {
            for (int i = 0; i < this.adapterEditors.size(); ++i) {
                BWbEditor bWbEditor = (BWbEditor)this.adapterEditors.get(i);
                bWbEditor.setReadonly(bl);
                bWbEditor.setEnabled(!bl);
            }
        }
    }

    protected final BObject doSaveValue(BObject bObject, Context context) throws Exception {
        Object object;
        Object object2;
        BTcpIpHostSettings bTcpIpHostSettings = (BTcpIpHostSettings)bObject;
        int n = 0;
        boolean bl = false;
        Object object3 = this.adapterEditors.iterator();
        while (object3.hasNext()) {
            object2 = (BTcpIpAdapterEditor)((Object)object3.next());
            if (!object2.isAdapterEnabledSelected()) continue;
            ++n;
            if (!object2.isIpv6EnabledSelected()) continue;
            bl = true;
        }
        if (n == 0) {
            this.saveError("TcpIpHostEditor.noEnabledAdapters");
        }
        object3 = null;
        object2 = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = null;
        Object object4 = this.adapterEditors.iterator();
        while (object4.hasNext()) {
            object = (BTcpIpAdapterEditor)((Object)object4.next());
            object3 = (BTcpIpAdapterSettings)object.saveValue(context);
            if (!((BTcpIpAdapterSettings)((Object)object3)).getIsAdapterEnabled()) continue;
            try {
                string = IPAddressUtil.getIPv4NetworkPrefix((String)((BTcpIpAdapterSettings)((Object)object3)).getIpAddress(), (String)((BTcpIpAdapterSettings)((Object)object3)).getSubnetMask());
            }
            catch (Exception exception) {
                string = null;
            }
            if (string == null || (object2 = (BTcpIpAdapterSettings)((Object)hashMap.put(string, object3))) == null) continue;
            this.saveError("TcpIpHostEditor.duplicateNetworkPrefixes");
        }
        if (!this.isModified()) {
            return bObject;
        }
        object4 = this.hostNameTextField.getText();
        if (((String)object4).length() != 0 && !IPAddressUtil.isHostname((String)object4)) {
            this.saveError("TcpIpHostEditor.invalidHostNameSyntax");
        }
        bTcpIpHostSettings.setHostName((String)object4);
        bTcpIpHostSettings.setHostFileContents(this.hostsFilePane.getText());
        this.hostFileDirty = false;
        if (this.niagaraUsesIpv6 != null) {
            bTcpIpHostSettings.setNiagaraUsesIpv6(this.niagaraUsesIpv6.getSelected());
        }
        if (this.gatewayFE != null) {
            bTcpIpHostSettings.setDefaultGateway(this.gatewayFE.saveValue(context).toString().trim());
        }
        if (this.domainTextField != null) {
            bTcpIpHostSettings.setDomain(this.domainTextField.getText());
        }
        if (this.dnsHostEditor != null) {
            bTcpIpHostSettings.setDnsHosts((BVector)this.dnsHostEditor.saveValue(context));
        }
        if (this.ipv6DefaultGatewayFE != null) {
            object = this.ipv6DefaultGatewayFE.saveValue(context).toString().trim();
            if (bl) {
                bTcpIpHostSettings.setIpv6DefaultGateway((String)object);
            } else if (((String)object).length() != 0) {
                this.saveError("TcpIpHostEditor.nonEmptyIPv6Gateway");
            }
        }
        if (this.ipv6DnsHostEditor != null) {
            object = (BVector)this.ipv6DnsHostEditor.saveValue(context);
            if (bl) {
                bTcpIpHostSettings.setIpv6DnsHosts((BVector)object);
            } else if (object.getSlotCount() != 0) {
                this.saveError("TcpIpHostEditor.nonEmptyIPv6DNSHosts");
            }
        }
        return bObject;
    }

    public boolean isHostFileDirty() {
        return this.hostFileDirty;
    }

    protected void saveError(String string) throws CannotSaveException {
        BDialog.error((BWidget)this, (String)this.getLexicon().getText("TcpIpHostEditor.invalidDataTitle"), (Object)this.getLexicon().getText(string));
        CannotSaveException cannotSaveException = new CannotSaveException();
        cannotSaveException.setSilent(true);
        throw cannotSaveException;
    }

    public final void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (bComponentEvent.getSourceComponent() instanceof BTcpIpHostSettings) {
            BTcpIpHostSettings bTcpIpHostSettings = (BTcpIpHostSettings)bComponentEvent.getSourceComponent();
            Property property = bComponentEvent.getSlot().asProperty();
            BValue bValue = bTcpIpHostSettings.get(property);
            if (property == BTcpIpHostSettings.niagaraUsesIpv6) {
                if (this.niagaraUsesIpv6 != null) {
                    this.niagaraUsesIpv6.setSelected(((BBoolean)bValue).getBoolean());
                }
            } else if (property == BTcpIpHostSettings.hostName) {
                if (this.hostNameTextField != null) {
                    this.hostNameTextField.setText(bValue.toString().trim());
                }
            } else if (property == BTcpIpHostSettings.hostFileContents) {
                if (this.hostsFilePane != null) {
                    this.hostsFilePane.setText(bValue.toString().trim());
                }
            } else if (!bTcpIpHostSettings.getUsesAdapterLevelSettings()) {
                if (property == BTcpIpHostSettings.defaultGateway) {
                    if (this.gatewayFE != null) {
                        this.gatewayFE.loadValue((BObject)((BString)bValue));
                    }
                } else if (property == BTcpIpHostSettings.domain) {
                    if (this.domainTextField != null) {
                        this.domainTextField.setText(bValue.toString().trim());
                    }
                } else if (property == BTcpIpHostSettings.dnsHosts) {
                    if (this.dnsHostEditor != null) {
                        this.dnsHostEditor.loadValue((BObject)((BVector)bValue));
                    }
                } else {
                    boolean bl = false;
                    BTcpIpAdapterSettings bTcpIpAdapterSettings = null;
                    SlotCursor slotCursor = bTcpIpHostSettings.getAdapters().loadSlots().getProperties();
                    while (slotCursor.next()) {
                        bTcpIpAdapterSettings = (BTcpIpAdapterSettings)slotCursor.get();
                        if (!bTcpIpAdapterSettings.getIsIpv6Supported()) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        if (property == BTcpIpHostSettings.ipv6DefaultGateway) {
                            if (this.ipv6DnsHostEditor != null) {
                                this.ipv6DnsHostEditor.loadValue((BObject)((BVector)bValue));
                            }
                        } else if (property == BTcpIpHostSettings.ipv6DnsHosts && this.ipv6DefaultGatewayFE != null) {
                            this.ipv6DefaultGatewayFE.loadValue((BObject)((BString)bValue));
                        }
                    }
                }
            }
        } else if (bComponentEvent.getSourceComponent() instanceof BTcpIpAdapterSettings) {
            BTcpIpAdapterSettings bTcpIpAdapterSettings = (BTcpIpAdapterSettings)bComponentEvent.getSourceComponent();
            if (this.adapterEditors != null) {
                for (int i = 0; i < this.adapterEditors.size(); ++i) {
                    if (bTcpIpAdapterSettings != ((BTcpIpAdapterEditor)((Object)this.adapterEditors.get(i))).getAdapter()) continue;
                    ((BTcpIpAdapterEditor)((Object)this.adapterEditors.get(i))).processComponentEvent(bComponentEvent);
                }
            }
        } else {
            super.handleComponentEvent(bComponentEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

