/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.timezone.command;

import com.ice.tar.TarInputStream;
import com.tridium.platform.command.BAbstractPlatformCommand;
import com.tridium.timezone.HistoricalDstRule;
import com.tridium.timezone.HistoricalTimeZone;
import com.tridium.timezone.HistoricalTimeZoneDate;
import com.tridium.timezone.HistoricalTimeZoneEra;
import com.tridium.timezone.TimeZoneDatabaseManifest;
import com.tridium.timezone.TzJarUtil;
import com.tridium.util.CommandLineArguments;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.nre.util.Array;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;

public final class BBuildTzDbCommand
extends BAbstractPlatformCommand {
    public static final BBuildTzDbCommand INSTANCE = new BBuildTzDbCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platform$timezone$command$BBuildTzDbCommand == null ? (class$com$tridium$platform$timezone$command$BBuildTzDbCommand = BBuildTzDbCommand.class$("com.tridium.platform.timezone.command.BBuildTzDbCommand")) : class$com$tridium$platform$timezone$command$BBuildTzDbCommand));
    private static final short DNE = 0;
    private static final short UNSUPPORTED = 1;
    private static final short OLSON_TAR_GZ_FILE = 2;
    private static final short REG_FILE = 3;
    private static final short DIRECTORY = 4;
    private static final String EXE = "buildtzdb";
    private static final String FORCE = "f";
    private static final String VERBOSE = "v";
    private static final String DUMP = "d";
    private static final String ID_PREFIX = "# @(#)";
    private static final String PATCH = "p";
    private static final String INPUT = "i";
    private static final String OUTPUT = "o";
    private static final String PROPS = "tzprops";
    private static final String MANIFEST_ENTRY_PATH = "META-INF/tzdb.xml";
    static /* synthetic */ Class class$com$tridium$platform$timezone$command$BBuildTzDbCommand;
    static /* synthetic */ Class class$com$tridium$timezone$HistoricalDstRule;
    static /* synthetic */ Class class$com$tridium$timezone$HistoricalTimeZoneEra;

    public Type getType() {
        return TYPE;
    }

    public final void usage() {
        System.out.println();
        System.out.println("usage:");
        System.out.println("  plat buildtzdb <flags> < tarball | file [file] ... | dir >");
        System.out.println("parameters:");
        System.out.println("  tarball                     valid tar.gz zoneinfo (Olson) archive provided ");
        System.out.println("                                by ftp://elsie.nci.nih.gov/pub/");
        System.out.println("  file                        valid zoneinfo syntax source file");
        System.out.println("  dir                         directory containing at least one zoneinfo");
        System.out.println("                                syntax source file");
        System.out.println("optional flags:");
        System.out.println("  -i:<timeZonesJarPath>       path of existing timezones.jar file");
        System.out.println("                                defaults to ^lib/timezones.jar if omitted");
        System.out.println("  -o:<timeZonesJarPath>       path of timezones.jar file to create");
        System.out.println("                                defaults to ^lib/timezones.jar if omitted");
        System.out.println("  -p:<patchNum>               patch number to append to zoneinfo version number");
        System.out.println("  -tzprops:<propertyOverrides>  XML file with zone db config parameters and");
        System.out.println("                                zone names to import.  If omitted, the ");
        System.out.println("                                META-INF/tzdb.xml entry in the existing");
        System.out.println("                                timezones.jar is used");
        System.out.println("  -v                          provide verbose output");
        System.out.println("  -f                          force a downgrade or reinstall of database w/o prompt");
        System.out.println("  -d TZID                        dump the contents of a particular zone");
        System.out.println();
    }

    public final String getCommandDescription() {
        return "import time zone information from zoneinfo (Olson) compatible source";
    }

    public final String getCommandName() {
        return EXE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final int invoke(CommandLineArguments var1_1) throws Exception {
        if (var1_1.parameters.length + var1_1.options.length + var1_1.optionValues.length == 0) {
            this.usage();
            return 2;
        }
        if (var1_1.hasHelpOption()) {
            this.usage();
            return 4;
        }
        var2_2 = null;
        for (var3_3 = 0; var3_3 < var1_1.options.length; var3_3 = (int)((short)(var3_3 + 1))) {
            var2_2 = var1_1.options[var3_3];
            if (var2_2.equalsIgnoreCase("v") || var2_2.equalsIgnoreCase("i") || var2_2.equalsIgnoreCase("o") || var2_2.equalsIgnoreCase("p") || var2_2.equalsIgnoreCase("tzprops") || var2_2.equalsIgnoreCase("f") || var2_2.equalsIgnoreCase("d")) continue;
            System.out.println("invalid option : " + var1_1.options[var3_3]);
            this.usage();
            return 2;
        }
        if (var1_1.hasOption("d")) {
            if (var1_1.parameters.length == 0) {
                this.usage();
                return 2;
            }
            if (var1_1.options.length > 1) {
                this.usage();
                return 2;
            }
            TzJarUtil.dumpTimeZone((String)var1_1.parameters[0]);
            return 0;
        }
        var3_4 = null;
        if (var1_1.hasOption("tzprops")) {
            var4_5 = BFileSystem.INSTANCE.findFile(new FilePath(var1_1.getOption("tzprops")));
            if (var4_5 == null) {
                System.out.println("File not found: " + var1_1.getOption("tzprops"));
                return 1;
            }
            var3_4 = TimeZoneDatabaseManifest.make((InputStream)var4_5.getInputStream());
        } else {
            if (var1_1.hasOption("i")) {
                var4_5 = (BZipFile)BFileSystem.INSTANCE.findFile(new FilePath(var1_1.getOption("i")));
                if (var4_5 == null) {
                    System.out.println("File not found: " + var1_1.getOption("i"));
                    return 1;
                }
            } else {
                var4_5 = (BZipFile)BFileSystem.INSTANCE.findFile(new FilePath("!lib/timezones.jar"));
            }
            if (var4_5 != null) {
                var5_7 = (BZipSpace)var4_5.open();
                var6_8 = null;
                var7_9 = null;
                try {
                    var6_8 = var5_7.findFile(new FilePath("META-INF/tzdb.xml"));
                    if (var6_8 != null) {
                        var7_9 = var6_8.getInputStream();
                        var3_4 = TimeZoneDatabaseManifest.make((InputStream)var7_9);
                    }
                }
                finally {
                    if (var7_9 != null) {
                        var7_9.close();
                    }
                    var4_5.close();
                }
            }
            if (var3_4 == null) {
                System.out.println("No properties found, please ensure properties exist in !lib/timezones.jar, or in the file provided with the i or tzprops flags");
                return 1;
            }
        }
        var4_6 = var1_1.hasOption("v");
        var5_7 = null;
        var6_8 = null;
        var7_10 = 0;
        var8_12 = 0;
        for (var9_13 = 0; var9_13 < var1_1.parameters.length; var9_13 = (int)((short)(var9_13 + 1))) {
            var7_10 = BBuildTzDbCommand.determineArg(var1_1.parameters[var9_13]);
            if (var7_10 == 0) {
                System.out.println("argument does not exist: " + var1_1.parameters[var9_13]);
                this.usage();
                return 1;
            }
            if (var7_10 == 2) {
                if (var8_12 == 3) {
                    System.out.println("invalid argument combination with: " + var1_1.parameters[var9_13]);
                    this.usage();
                    return 2;
                }
                if (var1_1.parameters.length != 1) {
                    if (var4_6) {
                        System.out.println("ignoring arguments after archive: " + var1_1.parameters[var9_13]);
                    }
                    var1_1.parameters[1] = null;
                }
                var8_12 = 2;
                break;
            }
            if (var7_10 == 4) {
                if (var8_12 == 3) {
                    System.out.println("invalid argument combination with: " + var1_1.parameters[var9_13]);
                    this.usage();
                    return 2;
                }
                if (var1_1.parameters.length != 1) {
                    if (var4_6) {
                        System.out.println("ignoring arguments after directory: " + var1_1.parameters[var9_13]);
                    }
                    var1_1.parameters[1] = null;
                }
                var8_12 = 4;
                break;
            }
            if (var7_10 == 3) {
                var8_12 = 3;
                continue;
            }
            if (var7_10 != 1) continue;
            System.out.println("argument not supported: " + var1_1.parameters[var9_13] + ", it is not a regular or directory");
            this.usage();
            return 2;
        }
        var9_14 = new LinkedList<BIFile>();
        var10_15 = new OlsonDBParser(var3_4.getZoneIds());
        switch (var8_12) {
            case 2: {
                var11_16 = new File(var1_1.parameters[0]);
                var6_8 = var11_16.getName();
                var5_7 = var1_1.hasOption("p") != false ? new Version(var6_8.substring(6, 10) + '.' + (var6_8.charAt(10) - 97 + 1) + '.' + var1_1.getOption("p")) : new Version(var6_8.substring(6, 10) + '.' + (var6_8.charAt(10) - 97 + 1));
                if (var4_6) {
                    System.out.println("creating database...");
                }
                if (var4_6) {
                    System.out.println("checking database version...");
                }
                if ((var12_21 = var5_7.compareTo((Object)var3_4.getVersion())) >= 0) ** GOTO lbl132
                System.out.println();
                System.out.println("WARNING: " + var3_4.getVersion() + " > " + var5_7 + "!!");
                System.out.println("         The installed olson database is more recent than " + var5_7);
                if (var1_1.hasOption("f")) ** GOTO lbl128
                System.out.println();
                while (true) {
                    System.out.print("Would you like to overwrite it anyway? [y/N]: ");
                    var13_25 = new BufferedReader(new InputStreamReader(System.in));
                    var14_26 = var13_25.readLine();
                    if ("".equals(var14_26) || "no".equalsIgnoreCase((String)var14_26) || "n".equalsIgnoreCase((String)var14_26)) {
                        System.out.println();
                        System.out.println("Closing buildtzdb.");
                        return 4;
                    }
                    if (!"yes".equalsIgnoreCase((String)var14_26) && !"y".equalsIgnoreCase((String)var14_26)) ** GOTO lbl126
                    System.out.println();
                    System.out.println("OVERWRITTING DATABASE!");
                    ** GOTO lbl138
lbl126:
                    // 1 sources

                    System.out.println("Invalid input, please try again.");
                }
lbl128:
                // 1 sources

                if (var4_6) {
                    System.out.println();
                    System.out.println("'force' argument detected, overwriting regardless over version");
                }
                ** GOTO lbl138
lbl132:
                // 1 sources

                if (var12_21 > 0) {
                    if (var4_6) {
                        System.out.println("upgrading database: " + var3_4.getVersion() + " -->" + var5_7);
                    }
                } else if (var4_6) {
                    System.out.println("reinstalling database: " + var5_7);
                }
lbl138:
                // 6 sources

                var3_4.setSource((String)var6_8);
                var3_4.setVersion((Version)var5_7);
                if (var4_6) {
                    System.out.println("done!");
                }
                var13_25 = new TarInputStream(new GZIPInputStream(new FileInputStream(var11_16)));
                var14_26 = null;
                var15_27 = var13_25.getNextEntry();
                var16_28 = 0;
                var17_30 /* !! */  = (BIFile)new byte[1024];
                while (var15_27 != null) {
                    if (!BBuildTzDbCommand.isValidFilename(var15_27.getName())) {
                        if (var4_6) {
                            System.out.println("skipping file in archive: " + var15_27.getName() + ", it has an invalid name");
                        }
                    } else {
                        var14_26 = new StringBuffer();
                        while (true) {
                            v0 = (short)var13_25.read((byte[])var17_30 /* !! */ , 0, 1024);
                            var16_28 = v0;
                            if (v0 == -1) break;
                            for (var18_31 = var16_28; var18_31 < 1024; var18_31 = (int)((short)(var18_31 + 1))) {
                                var17_30 /* !! */ [var18_31] = (BIFile)false;
                            }
                            var14_26.append(new String((byte[])var17_30 /* !! */ ));
                        }
                        if (var4_6) {
                            System.out.println("parsing: " + var15_27.getName() + "...");
                        }
                        if (var10_15.parseFileContents(var14_26.toString(), var4_6)) {
                            System.out.println("successfully parsed: " + var15_27.getName());
                        } else {
                            System.out.println("  error parsing: " + var15_27.getName());
                        }
                        var14_26 = null;
                    }
                    var15_27 = var13_25.getNextEntry();
                }
                var13_25.close();
                break;
            }
            case 4: {
                var11_17 = ((BDirectory)BFileSystem.INSTANCE.findFile(new FilePath(var1_1.parameters[0]))).listFiles();
                for (var12_22 = 0; var12_22 < var11_17.length; var12_22 = (int)((short)(var12_22 + 1))) {
                    if (var11_17[var12_22] instanceof BDirectory || !BBuildTzDbCommand.isValidFilename(var11_17[var12_22].getFileName())) {
                        if (!var4_6) continue;
                        System.out.println("skipping file in directory: " + var11_17[var12_22].getFileName() + ", it is hidden or has an invalid name");
                        continue;
                    }
                    var9_14.add(var11_17[var12_22]);
                }
                break;
            }
            case 3: {
                for (var11_18 = 0; var11_18 < var1_1.parameters.length; var11_18 = (int)((short)(var11_18 + 1))) {
                    var12_23 = BFileSystem.INSTANCE.findFile(new FilePath(var1_1.parameters[var11_18]));
                    if (var12_23 instanceof BDirectory || !BBuildTzDbCommand.isValidFilename(var12_23.getFileName())) {
                        if (!var4_6) continue;
                        System.out.println("skipping file in arguments: " + var1_1.parameters[var11_18]);
                        continue;
                    }
                    var9_14.add(var12_23);
                }
                break;
            }
        }
        if (var9_14.size() != 0 || var8_12 == 2) {
            if (var8_12 != 2) {
                var11_19 = null;
                for (var12_21 = 0; var12_21 < var9_14.size(); var12_21 = (int)((short)(var12_21 + 1))) {
                    var11_19 = (BIFile)var9_14.get(var12_21);
                    if (BBuildTzDbCommand.validateContents(var11_19, var4_6)) {
                        if (var4_6) {
                            System.out.println("parsing: " + var11_19.toString() + "...");
                        }
                        if (var10_15.parseFile(var11_19, var4_6)) {
                            if (!var4_6) continue;
                            System.out.println("successfully parsed: " + var11_19.toString());
                            continue;
                        }
                        System.out.println("  error parsing: " + var11_19.toString());
                        continue;
                    }
                    if (!var4_6) continue;
                    System.out.println("skipping file: " + var11_19.toString() + ", it does not appear to be a valid olson source");
                }
            }
            if (var4_6) {
                System.out.println("resolving links...");
            }
            var10_15.buildLinks(var4_6);
            if (var4_6) {
                System.out.println("done");
            }
            var11_20 = null;
            var12_24 = null;
            var13_25 = null;
            var14_26 = null;
            var15_27 = var3_4.getZoneIds();
            for (var16_28 = 0; var16_28 < ((String[])var15_27).length; var16_28 = (int)((short)(var16_28 + 1))) {
                if (!var10_15.isUndefinedZone(var15_27[var16_28])) continue;
                if (var4_6) {
                    System.out.println("  removing zone [" + var15_27[var16_28] + "] from manifest, no Olson data found for it");
                }
                var3_4.removeZoneId(var15_27[var16_28]);
            }
            var16_29 = new FilePath(var1_1.getOption("o", "!lib/timezones.jar"));
            var17_30 /* !! */  = BFileSystem.INSTANCE.findFile(var16_29);
            if (var17_30 /* !! */  != null) {
                var17_30 /* !! */ .delete();
            }
            var17_30 /* !! */  = BFileSystem.INSTANCE.makeFile(var16_29);
            if (var4_6) {
                System.out.println("writing to file: " + var17_30 /* !! */ );
            }
            var11_20 = var17_30 /* !! */ .getOutputStream();
            var12_24 = new JarOutputStream(var11_20);
            var12_24.putNextEntry(new JarEntry("META-INF/tzdb.xml"));
            var3_4.write((OutputStream)var12_24);
            var12_24.closeEntry();
            for (var18_31 = 0; var18_31 < OlsonDBParser.access$000(var10_15).size(); var18_31 = (int)((short)(var18_31 + 1))) {
                var14_26 = (HistoricalTimeZone)OlsonDBParser.access$000(var10_15).get(var18_31);
                if (var14_26.getNumberEras() == 0) {
                    if (!var4_6) continue;
                    System.out.println("  skipping zone [" + (var18_31 + 1) + " of " + OlsonDBParser.access$000(var10_15).size() + "]: " + var14_26.getHistoricalTimeZoneName() + ", it contains no entries");
                    continue;
                }
                if (!var10_15.isValidZone(var14_26.getHistoricalTimeZoneName())) {
                    if (!var4_6) continue;
                    System.out.println("  skipping zone [" + (var18_31 + 1) + " of " + OlsonDBParser.access$000(var10_15).size() + "]: " + var14_26.getHistoricalTimeZoneName() + ", it is invalid");
                    continue;
                }
                try {
                    if (var4_6) {
                        System.out.print("  jarring file [" + (var18_31 + 1) + " of " + OlsonDBParser.access$000(var10_15).size() + "]: " + var14_26.getHistoricalTimeZoneName());
                    }
                    var19_32 = var14_26.getHistoricalTimeZoneName();
                    var19_32 = var19_32.replace('/', '\\');
                    var13_25 = new JarEntry(var19_32);
                    var12_24.putNextEntry((ZipEntry)var13_25);
                    var14_26.write((OutputStream)var12_24);
                    var12_24.closeEntry();
                    if (!var4_6) continue;
                    System.out.println(" done");
                    continue;
                }
                catch (IOException var19_33) {
                    System.out.println(var19_33.getMessage());
                }
            }
        } else {
            System.out.println("no valid files found, closing.");
            return 4;
        }
        var12_24.close();
        var11_20.close();
        System.out.println(" done!");
        return 0;
    }

    private static final short determineArg(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return 0;
        }
        if (file.isDirectory()) {
            return 4;
        }
        return (short)(file.getName().startsWith("tzdata") && file.getName().endsWith(".tar.gz") ? 2 : 3);
    }

    private static final boolean isValidFilename(String string) {
        int n = string.lastIndexOf(47);
        String string2 = string.substring(n + 1, string.length());
        if (string2.indexOf(46) == -1) {
            return true;
        }
        return string2.indexOf(46) == string2.length() - 4 && string2.endsWith(".tab");
    }

    private static final boolean validateContents(BIFile bIFile, boolean bl) {
        if (bl) {
            System.out.println("validating: " + bIFile.getFileName() + "...");
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bIFile.getInputStream()));
            String string = ID_PREFIX;
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                if (bl) {
                    System.out.println("  skipping file: " + bIFile.toString() + ", it appears to be empty.");
                }
            } else {
                string = string.concat(bIFile.getFileName());
                boolean bl2 = false;
                if (!string2.startsWith(string)) {
                    int n = 1;
                    while ((string2 = bufferedReader.readLine()) != null && (n = (int)((short)(n + 1))) < 3) {
                        if (!string2.startsWith(string)) continue;
                        bl2 = true;
                        break;
                    }
                } else {
                    bl2 = true;
                }
                bufferedReader.close();
                if (bl) {
                    if (!bl2) {
                        System.out.println(" did not find expected line \"" + string + "\"");
                    }
                    System.out.println("done");
                }
                return bl2;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("  error while trying to open: " + bIFile.toString());
        }
        if (bl) {
            System.out.println("done");
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class OlsonDBParser {
        private LinkedList historicalTimeZoneDB = new LinkedList();
        private LinkedList historicalLinkDB = new LinkedList();
        private String[] validZones;
        private Set undefinedManifestZones;

        public OlsonDBParser(String[] stringArray) {
            this.validZones = stringArray;
            this.undefinedManifestZones = new HashSet();
            for (int n = 0; n < stringArray.length; n = (int)((short)(n + 1))) {
                this.undefinedManifestZones.add(stringArray[n]);
            }
        }

        public final boolean buildLinks(boolean bl) {
            HistoricalTimeZoneLink historicalTimeZoneLink = null;
            HistoricalTimeZone historicalTimeZone = null;
            HistoricalTimeZone historicalTimeZone2 = null;
            for (int n = 0; n < this.historicalLinkDB.size(); n = (int)((short)(n + 1))) {
                historicalTimeZoneLink = (HistoricalTimeZoneLink)this.historicalLinkDB.get(n);
                boolean bl2 = false;
                for (int i = 0; i < this.historicalTimeZoneDB.size(); ++i) {
                    historicalTimeZone2 = (HistoricalTimeZone)this.historicalTimeZoneDB.get(i);
                    if (!historicalTimeZone2.nameEquals(historicalTimeZoneLink.getLinkSource())) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    if (!bl) continue;
                    System.out.println("  skipping link: " + historicalTimeZoneLink.getLinkTarget() + ", its source, " + historicalTimeZoneLink.getLinkSource() + ", was not in the database.");
                    continue;
                }
                if (bl) {
                    System.out.println("  linking: " + historicalTimeZoneLink.getLinkSource() + " to " + historicalTimeZoneLink.getLinkTarget());
                }
                historicalTimeZone = new HistoricalTimeZone(historicalTimeZone2);
                this.undefinedManifestZones.remove(historicalTimeZoneLink.getLinkTarget());
                historicalTimeZone.setName(historicalTimeZoneLink.getLinkTarget());
                this.historicalTimeZoneDB.add(historicalTimeZone);
            }
            return true;
        }

        public final boolean parseFileContents(String string, boolean bl) {
            HistoricalTimeZoneDate historicalTimeZoneDate;
            LinkedList<HistoricalTimeZoneDate> linkedList = new LinkedList<HistoricalTimeZoneDate>();
            String string2 = null;
            String string3 = "";
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            int n = 0;
            short s = 0;
            short s2 = 0;
            HistoricalTimeZoneDate historicalTimeZoneDate2 = HistoricalTimeZoneDate.makeMinimumDate();
            HistoricalTimeZoneDate historicalTimeZoneDate3 = HistoricalTimeZoneDate.makeMinimumDate();
            HistoricalTimeZoneDate historicalTimeZoneDate4 = HistoricalTimeZoneDate.makeMinimumDate();
            HistoricalTimeZone historicalTimeZone = null;
            HistoricalTimeZoneEra historicalTimeZoneEra = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, "\n\r");
            StringTokenizer stringTokenizer3 = null;
            int n2 = 0;
            int n3 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (!this.isRule(string2 = string2.trim())) continue;
                stringTokenizer3 = new StringTokenizer(string2, " \t\b\n\r");
                stringTokenizer3.nextToken();
                n = 0;
                while (stringTokenizer3.hasMoreTokens() && (n = (int)((short)(n + 1))) < 8 && (n == 5 || !this.isComment(string3 = stringTokenizer3.nextToken()))) {
                    switch (n) {
                        case 1: {
                            string4 = string3;
                            break;
                        }
                        case 2: {
                            if (string3.equalsIgnoreCase("min") || string3.equalsIgnoreCase("minimum")) {
                                s = (short)HistoricalTimeZone.MIN_YEAR;
                                break;
                            }
                            s = (short)Integer.parseInt(string3);
                            break;
                        }
                        case 3: {
                            if (string3.equalsIgnoreCase("only")) {
                                s2 = s;
                                break;
                            }
                            if (string3.equalsIgnoreCase("max") || string3.equalsIgnoreCase("maximum")) {
                                s2 = (short)HistoricalTimeZone.MAX_YEAR;
                                break;
                            }
                            s2 = (short)Integer.parseInt(string3);
                            break;
                        }
                        case 4: {
                            string5 = string3;
                            if (!string5.equalsIgnoreCase("-")) break;
                            historicalTimeZoneDate3 = HistoricalTimeZoneDate.makeYearStart((short)s);
                            historicalTimeZoneDate4 = HistoricalTimeZoneDate.makeYearEnd((short)s2);
                            break;
                        }
                        case 5: {
                            historicalTimeZoneDate2 = HistoricalTimeZoneDate.makeAnnualDate();
                            stringTokenizer3 = historicalTimeZoneDate2.makeHistoricalTimeZoneDateFromString(stringTokenizer3);
                            break;
                        }
                        case 6: {
                            n3 = (int)HistoricalTimeZoneDate.parseTime((String)string3);
                            break;
                        }
                        case 7: {
                            string6 = string3;
                        }
                    }
                }
                historicalTimeZoneDate = HistoricalDstRule.make(string4, string6, string5, (HistoricalTimeZoneDate)historicalTimeZoneDate3, (HistoricalTimeZoneDate)historicalTimeZoneDate4, (HistoricalTimeZoneDate)historicalTimeZoneDate2, (int)n3);
                if (!historicalTimeZoneDate.getEndDate().occursAfterOrOnAbsolute(HistoricalTimeZoneDate.makeMinimumDate()) || linkedList.add(historicalTimeZoneDate)) continue;
                System.out.println("error adding the rule: " + historicalTimeZoneDate.toVerboseString() + " to rule db.");
            }
            historicalTimeZoneDate = HistoricalTimeZoneDate.makeMinimumDate();
            while (stringTokenizer2.hasMoreTokens()) {
                int n4;
                GregorianCalendar gregorianCalendar;
                GregorianCalendar gregorianCalendar2;
                HistoricalTimeZoneDate historicalTimeZoneDate5;
                HistoricalTimeZoneDate historicalTimeZoneDate6;
                HistoricalTimeZoneEra historicalTimeZoneEra2;
                HistoricalTimeZoneLink historicalTimeZoneLink;
                string2 = stringTokenizer2.nextToken();
                if (this.isEmpty(string2 = string2.trim()) || this.isComment(string2)) continue;
                if (this.isLink(string2)) {
                    stringTokenizer3 = new StringTokenizer(string2, " \t\b\n\r");
                    stringTokenizer3.nextToken();
                    historicalTimeZoneLink = new HistoricalTimeZoneLink(stringTokenizer3.nextToken(), stringTokenizer3.nextToken());
                    if (bl) {
                        System.out.println("  adding link: " + historicalTimeZoneLink.toString());
                    }
                    this.historicalLinkDB.add(historicalTimeZoneLink);
                    continue;
                }
                if (this.isRule(string2) || !this.isZone(string2) && !bl2) continue;
                stringTokenizer3 = new StringTokenizer(string2, " \t\b\n\r");
                if (this.isZone(string2)) {
                    stringTokenizer3.nextToken();
                    string7 = stringTokenizer3.nextToken();
                    string7 = string7.replace('\\', '/');
                    historicalTimeZone = HistoricalTimeZone.make((String)string7);
                }
                n = 0;
                block17: while (stringTokenizer3.hasMoreTokens() && (n = (int)((short)(n + 1))) < 4 && !this.isComment(string3 = stringTokenizer3.nextToken())) {
                    switch (n) {
                        case 1: {
                            string3 = string3.startsWith("GMT") ? string3.substring(3, string3.length()) : string3;
                            string3 = string3.startsWith("+") ? string3.substring(1, string3.length()) : string3;
                            bl3 = string3.startsWith("-");
                            string3 = bl3 ? string3.substring(1, string3.length()) : string3;
                            n2 = (int)HistoricalTimeZoneDate.parseTime((String)string3);
                            if (!bl3) continue block17;
                            n2 = -n2;
                            continue block17;
                        }
                        case 2: {
                            if (string3.indexOf(58) != -1) {
                                n2 = (int)((long)n2 + HistoricalTimeZoneDate.parseTime((String)string3));
                                string8 = "-";
                                continue block17;
                            }
                            string8 = string3;
                            continue block17;
                        }
                        case 3: {
                            string9 = string3;
                            if (!string9.startsWith("\"")) continue block17;
                            string9 = string9 + stringTokenizer3.nextToken("\"");
                            string9 = string9 + "\"";
                            continue block17;
                        }
                    }
                }
                if (historicalTimeZone != null && (!stringTokenizer3.hasMoreTokens() || this.isComment(string3 = stringTokenizer3.nextToken()))) {
                    bl2 = false;
                    historicalTimeZoneDate2 = HistoricalTimeZoneDate.makeMaximumDate();
                    historicalTimeZoneEra = HistoricalTimeZoneEra.make((int)n2, string8, string9, (HistoricalTimeZoneDate)historicalTimeZoneDate2);
                    if (historicalTimeZoneDate2.occursAfterOrOnAbsolute(HistoricalTimeZoneDate.makeMinimumDate())) {
                        Object object = historicalTimeZoneLink = historicalTimeZone.getNumberEras() == 0 ? HistoricalTimeZoneDate.makeMinimumDate() : historicalTimeZone.getLastEra().getValidUntilDate();
                        if (!historicalTimeZoneEra.determineRules((HistoricalTimeZoneDate)historicalTimeZoneLink, linkedList) && bl) {
                            System.out.println("  WARNING! Current era for zone \"" + string7 + "\" references a rule: " + historicalTimeZoneEra.getActiveRuleName() + " that has yet to be defined");
                        }
                        historicalTimeZoneEra2 = null;
                        historicalTimeZoneDate6 = null;
                        if (historicalTimeZoneEra.getNumberEndRules() + historicalTimeZoneEra.getNumberStartRules() > 0) {
                            HistoricalTimeZoneDate historicalTimeZoneDate7;
                            historicalTimeZoneDate5 = this.getEarliestValidFromDate(historicalTimeZoneEra.getStartRuleAtIndex((short)0), historicalTimeZoneEra.getEndRuleAtIndex((short)0));
                            if (historicalTimeZoneDate5.occursAfterAbsolute(historicalTimeZoneDate)) {
                                if (bl) {
                                    System.out.println("  WARNING: discontinuity of rule set at start of era ( " + historicalTimeZoneEra + ":" + historicalTimeZoneEra.getActiveRuleName() + ":" + historicalTimeZoneEra.getValidUntilDate().getTheYear() + " ) for zone: " + historicalTimeZone.getHistoricalTimeZoneName() + " -> [" + historicalTimeZoneDate5 + " > " + historicalTimeZoneDate + "]");
                                }
                                historicalTimeZone.addEra(HistoricalTimeZoneEra.make((int)n2, (String)"-", (String)string9, (HistoricalTimeZoneDate)historicalTimeZoneDate5));
                                historicalTimeZoneDate = historicalTimeZoneDate5;
                            }
                            if ((historicalTimeZoneDate7 = this.getLatestValidUntilDate(historicalTimeZoneEra.getStartRuleAtIndex((short)(historicalTimeZoneEra.getNumberStartRules() - 1)), historicalTimeZoneEra.getEndRuleAtIndex((short)(historicalTimeZoneEra.getNumberEndRules() - 1)))).occursBeforeAbsolute(historicalTimeZoneEra.getValidUntilDate())) {
                                gregorianCalendar2 = (GregorianCalendar)historicalTimeZoneDate7.toGregorianCalendar(historicalTimeZoneDate7.getTheYear());
                                gregorianCalendar = (GregorianCalendar)historicalTimeZoneEra.getValidUntilDate().toGregorianCalendar(historicalTimeZoneEra.getValidUntilDate().getTheYear());
                                ((Calendar)gregorianCalendar2).add(14, 1);
                                if (gregorianCalendar2.before(gregorianCalendar)) {
                                    if (bl) {
                                        System.out.println("  WARNING: discontinuity of rule set at   end of era ( " + historicalTimeZoneEra + ":" + historicalTimeZoneEra.getActiveRuleName() + ":" + historicalTimeZoneEra.getValidUntilDate().getTheYear() + " ) for zone: " + historicalTimeZone.getHistoricalTimeZoneName() + " -> [" + historicalTimeZoneDate7 + " < " + historicalTimeZoneEra.getValidUntilDate() + "]");
                                    }
                                    historicalTimeZoneEra2 = HistoricalTimeZoneEra.make((int)n2, (String)"-", (String)string9, (HistoricalTimeZoneDate)historicalTimeZoneEra.getValidUntilDate());
                                    historicalTimeZoneDate6 = historicalTimeZoneDate7;
                                }
                            }
                        }
                        if (historicalTimeZoneEra2 == null) {
                            historicalTimeZoneDate5 = this.detectSplitMergeInternalDiscontinuities(historicalTimeZoneDate, historicalTimeZoneEra, string7, bl);
                            for (n4 = 0; n4 < ((HistoricalTimeZoneEra[])historicalTimeZoneDate5).length; ++n4) {
                                historicalTimeZone.addEra(historicalTimeZoneDate5[n4]);
                                historicalTimeZoneDate = historicalTimeZoneDate5[n4].getValidUntilDate();
                            }
                            historicalTimeZoneDate = historicalTimeZoneEra.getValidUntilDate();
                        } else {
                            historicalTimeZoneEra.setValidUntilDate(historicalTimeZoneDate6);
                            historicalTimeZoneDate5 = this.detectSplitMergeInternalDiscontinuities(historicalTimeZoneDate, historicalTimeZoneEra, string7, bl);
                            for (n4 = 0; n4 < ((HistoricalTimeZoneEra[])historicalTimeZoneDate5).length; ++n4) {
                                historicalTimeZone.addEra(historicalTimeZoneDate5[n4]);
                            }
                            historicalTimeZone.addEra(historicalTimeZoneEra2);
                            historicalTimeZoneDate = historicalTimeZoneEra2.getValidUntilDate();
                        }
                    }
                    if (historicalTimeZone.getNumberEras() != 0) {
                        if (bl) {
                            System.out.println("  adding zone: " + string7);
                        }
                        this.undefinedManifestZones.remove(historicalTimeZone.getHistoricalTimeZoneName());
                        this.historicalTimeZoneDB.add(historicalTimeZone);
                    } else if (bl) {
                        System.out.println("  ignoring zone: " + historicalTimeZone + ", it \"expires\" before our minimum date");
                    }
                    historicalTimeZoneDate = HistoricalTimeZoneDate.makeMinimumDate();
                    historicalTimeZone = null;
                    historicalTimeZoneEra = null;
                    historicalTimeZoneDate2 = null;
                    continue;
                }
                if (historicalTimeZone != null) {
                    bl2 = true;
                    historicalTimeZoneDate2 = HistoricalTimeZoneDate.makeYearStart((short)((short)Integer.parseInt(string3)));
                    stringTokenizer3 = historicalTimeZoneDate2.makeHistoricalTimeZoneDateFromString(stringTokenizer3);
                    historicalTimeZoneEra = HistoricalTimeZoneEra.make((int)n2, string8, (String)string9, (HistoricalTimeZoneDate)historicalTimeZoneDate2);
                    if (historicalTimeZoneDate2.occursAfterOrOnAbsolute(HistoricalTimeZoneDate.makeMinimumDate())) {
                        Object object = historicalTimeZoneLink = historicalTimeZone.getNumberEras() == 0 ? HistoricalTimeZoneDate.makeMinimumDate() : historicalTimeZone.getLastEra().getValidUntilDate();
                        if (!historicalTimeZoneEra.determineRules((HistoricalTimeZoneDate)historicalTimeZoneLink, linkedList) && bl) {
                            System.out.println("  WARNING! Current era for zone \"" + string7 + "\" references a rule: " + historicalTimeZoneEra.getActiveRuleName() + " that has yet to be defined");
                        }
                        historicalTimeZoneEra2 = null;
                        historicalTimeZoneDate6 = null;
                        if (historicalTimeZoneEra.getNumberEndRules() + historicalTimeZoneEra.getNumberStartRules() > 0) {
                            HistoricalTimeZoneDate historicalTimeZoneDate8;
                            historicalTimeZoneDate5 = this.getEarliestValidFromDate(historicalTimeZoneEra.getStartRuleAtIndex((short)0), historicalTimeZoneEra.getEndRuleAtIndex((short)0));
                            if (historicalTimeZoneDate5.occursAfterAbsolute(historicalTimeZoneDate)) {
                                if (bl) {
                                    System.out.println("  WARNING: discontinuity of rule set at start of era ( " + historicalTimeZoneEra + ":" + historicalTimeZoneEra.getActiveRuleName() + ":" + historicalTimeZoneEra.getValidUntilDate().getTheYear() + " ) for zone: " + historicalTimeZone.getHistoricalTimeZoneName() + " -> [" + historicalTimeZoneDate5 + " > " + historicalTimeZoneDate + "]");
                                }
                                historicalTimeZone.addEra(HistoricalTimeZoneEra.make((int)n2, (String)"-", (String)string9, (HistoricalTimeZoneDate)historicalTimeZoneDate5));
                                historicalTimeZoneDate = historicalTimeZoneDate5;
                            }
                            if ((historicalTimeZoneDate8 = this.getLatestValidUntilDate(historicalTimeZoneEra.getStartRuleAtIndex((short)(historicalTimeZoneEra.getNumberStartRules() - 1)), historicalTimeZoneEra.getEndRuleAtIndex((short)(historicalTimeZoneEra.getNumberEndRules() - 1)))).occursBeforeAbsolute(historicalTimeZoneEra.getValidUntilDate())) {
                                gregorianCalendar2 = (GregorianCalendar)historicalTimeZoneDate8.toGregorianCalendar(historicalTimeZoneDate8.getTheYear());
                                gregorianCalendar = (GregorianCalendar)historicalTimeZoneEra.getValidUntilDate().toGregorianCalendar(historicalTimeZoneEra.getValidUntilDate().getTheYear());
                                ((Calendar)gregorianCalendar2).add(14, 1);
                                if (gregorianCalendar2.before(gregorianCalendar)) {
                                    if (bl) {
                                        System.out.println("  WARNING: discontinuity of rule set at   end of era ( " + historicalTimeZoneEra + ":" + historicalTimeZoneEra.getActiveRuleName() + ":" + historicalTimeZoneEra.getValidUntilDate().getTheYear() + " ) for zone: " + historicalTimeZone.getHistoricalTimeZoneName() + " -> [" + historicalTimeZoneDate8 + " < " + historicalTimeZoneEra.getValidUntilDate() + "]");
                                    }
                                    historicalTimeZoneEra2 = HistoricalTimeZoneEra.make((int)n2, (String)"-", (String)string9, (HistoricalTimeZoneDate)historicalTimeZoneEra.getValidUntilDate());
                                    historicalTimeZoneDate6 = historicalTimeZoneDate8;
                                }
                            }
                        }
                        if (historicalTimeZoneEra2 == null) {
                            historicalTimeZoneDate5 = this.detectSplitMergeInternalDiscontinuities(historicalTimeZoneDate, historicalTimeZoneEra, string7, bl);
                            for (n4 = 0; n4 < ((HistoricalTimeZoneEra[])historicalTimeZoneDate5).length; ++n4) {
                                historicalTimeZone.addEra((HistoricalTimeZoneEra)historicalTimeZoneDate5[n4]);
                                historicalTimeZoneDate = historicalTimeZoneDate5[n4].getValidUntilDate();
                            }
                            historicalTimeZoneDate = historicalTimeZoneEra.getValidUntilDate();
                        } else {
                            historicalTimeZoneEra.setValidUntilDate(historicalTimeZoneDate6);
                            historicalTimeZoneDate5 = this.detectSplitMergeInternalDiscontinuities(historicalTimeZoneDate, historicalTimeZoneEra, string7, bl);
                            for (n4 = 0; n4 < ((HistoricalTimeZoneEra[])historicalTimeZoneDate5).length; ++n4) {
                                historicalTimeZone.addEra((HistoricalTimeZoneEra)historicalTimeZoneDate5[n4]);
                            }
                            historicalTimeZone.addEra(historicalTimeZoneEra2);
                            historicalTimeZoneDate = historicalTimeZoneEra2.getValidUntilDate();
                        }
                    }
                    historicalTimeZoneEra = null;
                    historicalTimeZoneDate2 = null;
                    continue;
                }
                System.out.println("PARSE ERROR: Somehow you had a null HistoricalTimeZone when adding eras.");
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private final HistoricalTimeZoneEra[] detectSplitMergeInternalDiscontinuities(HistoricalTimeZoneDate historicalTimeZoneDate, HistoricalTimeZoneEra historicalTimeZoneEra, String string, boolean bl) {
            HistoricalTimeZoneEra historicalTimeZoneEra2;
            HistoricalTimeZoneEra historicalTimeZoneEra3;
            Array array;
            int n;
            Array array2 = new Array(class$com$tridium$timezone$HistoricalDstRule == null ? (class$com$tridium$timezone$HistoricalDstRule = BBuildTzDbCommand.class$("com.tridium.timezone.HistoricalDstRule")) : class$com$tridium$timezone$HistoricalDstRule);
            Array array3 = new Array(class$com$tridium$timezone$HistoricalDstRule == null ? (class$com$tridium$timezone$HistoricalDstRule = BBuildTzDbCommand.class$("com.tridium.timezone.HistoricalDstRule")) : class$com$tridium$timezone$HistoricalDstRule);
            boolean bl2 = false;
            boolean bl3 = false;
            for (n = 0; n < historicalTimeZoneEra.getNumberStartRules(); n = (short)(n + 1)) {
                array2.add((Object)historicalTimeZoneEra.getStartRuleAtIndex((short)n));
                bl2 = true;
            }
            for (n = 0; n < historicalTimeZoneEra.getNumberEndRules(); n = (short)(n + 1)) {
                array3.add((Object)historicalTimeZoneEra.getEndRuleAtIndex((short)n));
                bl3 = true;
            }
            n = historicalTimeZoneDate.getTheYear();
            short s = historicalTimeZoneEra.getValidUntilDate().getTheYear();
            if (historicalTimeZoneEra.getValidUntilDate().occursOnAbsolute(HistoricalTimeZoneDate.makeYearStart((short)s))) {
                s = (short)(s - 1);
            }
            HistoricalTimeZoneEra historicalTimeZoneEra4 = null;
            Array array4 = new Array(class$com$tridium$timezone$HistoricalTimeZoneEra == null ? (class$com$tridium$timezone$HistoricalTimeZoneEra = BBuildTzDbCommand.class$("com.tridium.timezone.HistoricalTimeZoneEra")) : class$com$tridium$timezone$HistoricalTimeZoneEra);
            HistoricalDstRule historicalDstRule = null;
            HistoricalDstRule historicalDstRule2 = null;
            boolean bl4 = false;
            int n2 = n;
            while (true) {
                block34: {
                    block39: {
                        block37: {
                            block38: {
                                block36: {
                                    int n3;
                                    if (n2 <= s) {
                                    } else {
                                        array = new Array(class$com$tridium$timezone$HistoricalTimeZoneEra == null ? (class$com$tridium$timezone$HistoricalTimeZoneEra = BBuildTzDbCommand.class$("com.tridium.timezone.HistoricalTimeZoneEra")) : class$com$tridium$timezone$HistoricalTimeZoneEra);
                                        if (!bl4) {
                                            array.add((Object)historicalTimeZoneEra);
                                            return (HistoricalTimeZoneEra[])array.trim();
                                        }
                                        if (bl) {
                                            System.out.println("  WARNING: discontinuity exists in rules for zone: " + string);
                                        }
                                        historicalTimeZoneEra3 = null;
                                        historicalTimeZoneEra2 = array4.size() > 0 ? (HistoricalTimeZoneEra)array4.remove(0) : null;
                                        break;
                                    }
                                    for (n3 = 0; n3 < array2.size(); ++n3) {
                                        if (!((HistoricalDstRule)array2.get(n3)).ruleAppliesForYear(n2)) continue;
                                        historicalDstRule = (HistoricalDstRule)array2.get(n3);
                                        break;
                                    }
                                    for (n3 = 0; n3 < array3.size(); ++n3) {
                                        if (!((HistoricalDstRule)array3.get(n3)).ruleAppliesForYear(n2)) continue;
                                        historicalDstRule2 = (HistoricalDstRule)array3.get(n3);
                                        break;
                                    }
                                    if (historicalDstRule == null && bl2) {
                                        if (bl) {
                                            System.out.println("  WARNING: discontinuity of rule set at   middle of era ( " + historicalTimeZoneEra + ":" + historicalTimeZoneEra.getActiveRuleName() + ":" + historicalTimeZoneEra.getValidUntilDate().getTheYear() + " ), for zone: \"" + string + "\" -> no start rule for year: " + n2 + "!");
                                        }
                                        bl4 = true;
                                    }
                                    if (historicalDstRule2 == null && bl3) {
                                        if (bl) {
                                            System.out.println("  WARNING: discontinuity of rule set at   middle of era ( " + historicalTimeZoneEra + ":" + historicalTimeZoneEra.getActiveRuleName() + ":" + historicalTimeZoneEra.getValidUntilDate().getTheYear() + " ), for zone: \"" + string + "\" -> no end rule for year: " + n2 + "!");
                                        }
                                        bl4 = true;
                                    }
                                    historicalTimeZoneEra3 = null;
                                    historicalTimeZoneEra3 = historicalTimeZoneEra.getValidUntilDate().occursAfterAbsolute(HistoricalTimeZoneDate.makeYearStart((short)((short)(n2 + 1)))) ? HistoricalTimeZoneDate.makeYearStart((short)((short)(n2 + 1))) : historicalTimeZoneEra.getValidUntilDate();
                                    historicalTimeZoneEra4 = historicalDstRule == null && historicalDstRule2 == null ? HistoricalTimeZoneEra.make((int)historicalTimeZoneEra.getActiveUtcOffsetMillis(), (String)"-", (String)historicalTimeZoneEra.getActiveZoneFormat(), (HistoricalTimeZoneDate)historicalTimeZoneEra3) : HistoricalTimeZoneEra.make((int)historicalTimeZoneEra.getActiveUtcOffsetMillis(), (String)historicalTimeZoneEra.getActiveRuleName(), (String)historicalTimeZoneEra.getActiveZoneFormat(), (HistoricalTimeZoneDate)historicalTimeZoneEra3);
                                    if (historicalDstRule != null || historicalDstRule2 == null) break block36;
                                    break block37;
                                }
                                if (historicalDstRule2 != null || historicalDstRule == null) break block38;
                                break block39;
                            }
                            if (historicalDstRule2 != null && historicalDstRule != null) {
                                historicalTimeZoneEra4.addRule(historicalDstRule);
                                historicalTimeZoneEra4.addRule(historicalDstRule2);
                            }
                            break block34;
                        }
                        for (int i = 0; i < array2.size(); ++i) {
                            if (!((HistoricalDstRule)array2.get(i)).ruleAppliesForYear(n2 - 1)) continue;
                            historicalDstRule = (HistoricalDstRule)array2.get(i);
                            break;
                        }
                        if (historicalDstRule == null) {
                            if (bl) {
                                System.out.println("  ERROR: could not retrieve start rule for previous year when creating dummy start rule for zone: " + string + " for year: " + n2);
                            }
                            historicalTimeZoneEra4 = HistoricalTimeZoneEra.make((int)historicalTimeZoneEra.getActiveUtcOffsetMillis(), (String)"-", (String)historicalTimeZoneEra.getActiveZoneFormat(), (HistoricalTimeZoneDate)historicalTimeZoneEra3);
                            historicalDstRule = null;
                            historicalDstRule2 = null;
                            break block34;
                        } else {
                            historicalTimeZoneEra4.addRule(historicalDstRule2);
                            historicalTimeZoneEra4.addRule(historicalDstRule);
                            HistoricalTimeZoneDate historicalTimeZoneDate2 = new HistoricalTimeZoneDate(historicalDstRule2.getOccursOnAnnualDate());
                            historicalTimeZoneDate2.update(historicalTimeZoneDate2.getTheYear(), historicalTimeZoneDate2.getTheMonth().next().next(), historicalTimeZoneDate2.getTheDay(), historicalTimeZoneDate2.getTheTimeOfDay(), historicalTimeZoneDate2.getTheTimeOfDayIsExpressedAs());
                            historicalTimeZoneEra4.setValidUntilDate(historicalTimeZoneDate2.convertAnnualDateForYear((short)n2));
                        }
                        break block34;
                    }
                    for (int i = 0; i < array3.size(); ++i) {
                        if (!((HistoricalDstRule)array3.get(i)).ruleAppliesForYear(n2 + 1)) continue;
                        historicalDstRule2 = (HistoricalDstRule)array3.get(i);
                        break;
                    }
                    if (historicalDstRule2 == null) {
                        if (bl) {
                            System.out.println("  ERROR: could not retrieve end rule for next year when creating dummy end rule for zone: " + string + " for year: " + n2);
                        }
                        historicalTimeZoneEra4 = HistoricalTimeZoneEra.make((int)historicalTimeZoneEra.getActiveUtcOffsetMillis(), (String)"-", (String)historicalTimeZoneEra.getActiveZoneFormat(), (HistoricalTimeZoneDate)historicalTimeZoneEra3);
                        historicalDstRule = null;
                        historicalDstRule2 = null;
                    } else {
                        historicalTimeZoneEra4.addRule(historicalDstRule2);
                        historicalTimeZoneEra4.addRule(historicalDstRule);
                        HistoricalTimeZoneDate historicalTimeZoneDate3 = new HistoricalTimeZoneDate(historicalDstRule.getOccursOnAnnualDate());
                        historicalTimeZoneDate3.update(historicalTimeZoneDate3.getTheYear(), historicalTimeZoneDate3.getTheMonth().previous().previous(), historicalTimeZoneDate3.getTheDay(), historicalTimeZoneDate3.getTheTimeOfDay(), historicalTimeZoneDate3.getTheTimeOfDayIsExpressedAs());
                        array4.add((Object)HistoricalTimeZoneEra.make((int)historicalTimeZoneEra4.getActiveUtcOffsetMillis(), (String)"-", (String)historicalTimeZoneEra4.getShortName(false), (HistoricalTimeZoneDate)historicalTimeZoneDate3.convertAnnualDateForYear((short)n2)));
                    }
                }
                array4.add((Object)historicalTimeZoneEra4);
                historicalDstRule = null;
                historicalDstRule2 = null;
                ++n2;
            }
            while (historicalTimeZoneEra2 != null) {
                block35: {
                    if (historicalTimeZoneEra3 == null) {
                        historicalTimeZoneEra3 = historicalTimeZoneEra2;
                    } else {
                        if (historicalTimeZoneEra3.getNumberStartRules() + historicalTimeZoneEra3.getNumberEndRules() == 0) {
                            if (historicalTimeZoneEra2.getNumberStartRules() + historicalTimeZoneEra2.getNumberEndRules() == 0) {
                                historicalTimeZoneEra3.setValidUntilDate(historicalTimeZoneEra2.getValidUntilDate());
                                break block35;
                            } else {
                                array.add((Object)historicalTimeZoneEra3);
                                historicalTimeZoneEra3 = null;
                                continue;
                            }
                        }
                        if (historicalTimeZoneEra3.getNumberStartRules() == 1 && historicalTimeZoneEra3.getNumberEndRules() == 1) {
                            if (historicalTimeZoneEra3.getNumberStartRules() != 1 || historicalTimeZoneEra3.getNumberEndRules() != 1) {
                                array.add((Object)historicalTimeZoneEra3);
                                historicalTimeZoneEra3 = null;
                                continue;
                            }
                            if (historicalTimeZoneEra3.getStartRule().equals((Object)historicalTimeZoneEra2.getStartRule()) && historicalTimeZoneEra3.getEndRule().equals((Object)historicalTimeZoneEra2.getEndRule())) {
                                historicalTimeZoneEra3.setValidUntilDate(historicalTimeZoneEra2.getValidUntilDate());
                                break block35;
                            } else {
                                array.add((Object)historicalTimeZoneEra3);
                                historicalTimeZoneEra3 = null;
                                continue;
                            }
                        }
                        array.add((Object)historicalTimeZoneEra3);
                        historicalTimeZoneEra3 = null;
                        continue;
                    }
                }
                historicalTimeZoneEra2 = array4.size() > 0 ? (HistoricalTimeZoneEra)array4.remove(0) : null;
            }
            if (historicalTimeZoneEra3 != null) {
                array.add((Object)historicalTimeZoneEra3);
            }
            return (HistoricalTimeZoneEra[])array.trim();
        }

        private final HistoricalTimeZoneDate getEarliestValidFromDate(HistoricalDstRule historicalDstRule, HistoricalDstRule historicalDstRule2) {
            HistoricalTimeZoneDate historicalTimeZoneDate;
            if (historicalDstRule == null && historicalDstRule2 == null) {
                return null;
            }
            HistoricalTimeZoneDate historicalTimeZoneDate2 = historicalDstRule != null ? historicalDstRule.getStartDate() : HistoricalTimeZoneDate.makeMaximumDate();
            HistoricalTimeZoneDate historicalTimeZoneDate3 = historicalTimeZoneDate = historicalDstRule2 != null ? historicalDstRule2.getStartDate() : HistoricalTimeZoneDate.makeMaximumDate();
            if (historicalTimeZoneDate2.occursBeforeAbsolute(historicalTimeZoneDate)) {
                return historicalTimeZoneDate2;
            }
            return historicalTimeZoneDate;
        }

        private final HistoricalTimeZoneDate getLatestValidUntilDate(HistoricalDstRule historicalDstRule, HistoricalDstRule historicalDstRule2) {
            HistoricalTimeZoneDate historicalTimeZoneDate;
            if (historicalDstRule == null && historicalDstRule2 == null) {
                System.out.println("Both rules are null");
                return null;
            }
            HistoricalTimeZoneDate historicalTimeZoneDate2 = historicalDstRule != null ? historicalDstRule.getEndDate() : HistoricalTimeZoneDate.makeMinimumDate();
            HistoricalTimeZoneDate historicalTimeZoneDate3 = historicalTimeZoneDate = historicalDstRule2 != null ? historicalDstRule2.getEndDate() : HistoricalTimeZoneDate.makeMinimumDate();
            if (historicalTimeZoneDate2.occursAfterAbsolute(historicalTimeZoneDate)) {
                return historicalTimeZoneDate2;
            }
            return historicalTimeZoneDate;
        }

        public final boolean parseFile(BIFile bIFile, boolean bl) {
            String string = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bIFile.getInputStream()));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string).append('\n');
                }
                this.parseFileContents(stringBuffer.toString(), bl);
                bufferedReader.close();
            }
            catch (IOException iOException) {
                System.out.println("error opening " + bIFile.toString());
                return false;
            }
            return true;
        }

        public final boolean isValidZone(String string) {
            for (int n = 0; n < this.validZones.length; n = (int)((short)(n + 1))) {
                if (!this.validZones[n].equals(string)) continue;
                return true;
            }
            return false;
        }

        public final boolean isUndefinedZone(String string) {
            return this.undefinedManifestZones.contains(string);
        }

        private final boolean isComment(String string) {
            return string.startsWith("#");
        }

        private final boolean isEmpty(String string) {
            return string.length() == 0;
        }

        private final boolean isZone(String string) {
            return string.startsWith("Zone");
        }

        private final boolean isLink(String string) {
            return string.startsWith("Link");
        }

        private final boolean isRule(String string) {
            return string.startsWith("Rule");
        }

        static /* synthetic */ LinkedList access$000(OlsonDBParser olsonDBParser) {
            return olsonDBParser.historicalTimeZoneDB;
        }

        private final class HistoricalTimeZoneLink {
            private final String linkTarget;
            private final String linkSource;

            public HistoricalTimeZoneLink(String string, String string2) {
                this.linkTarget = string2.replace('\\', '/');
                this.linkSource = string.replace('\\', '/');
            }

            public final boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (!(object instanceof HistoricalTimeZoneLink)) {
                    return false;
                }
                HistoricalTimeZoneLink historicalTimeZoneLink = (HistoricalTimeZoneLink)object;
                return this.linkTarget.equals(historicalTimeZoneLink.linkTarget) && this.linkSource.equals(historicalTimeZoneLink.linkSource);
            }

            public final String toString() {
                return new String(this.linkSource + " -> " + this.linkTarget);
            }

            public final String getLinkSource() {
                return this.linkSource;
            }

            public final String getLinkTarget() {
                return this.linkTarget;
            }
        }
    }
}

