/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.time;

import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.timezone.TimeZoneUtil;
import javax.baja.platform.time.TimeManager;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BStation;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.TimeZoneDatabase;

public class PlatformTimeManager
implements TimeManager {
    public static PlatformTimeManager make() {
        return new PlatformTimeManager();
    }

    public boolean isTimeZoneSupported(String string) {
        try {
            return TimeZoneUtil.isSupported(TimeZoneDatabase.getTimeZone((String)string), this.getSystemPlatformService().getTimezoneDayModeSupport());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean setTimeZone(String string) {
        return this.setTimeZone(string, false);
    }

    public boolean setTimeZone(String string, boolean bl) {
        BStation bStation;
        if ((bl || this.isTimeZoneSupported(string)) && (bStation = Sys.getStation()) != null) {
            try {
                this.getSystemPlatformService().setTimeZone(TimeZoneDatabase.getTimeZone((String)string));
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public String getLocale() {
        return this.getSystemPlatformService().getLocale();
    }

    public boolean setLocale(String string) {
        BSystemPlatformService bSystemPlatformService = this.getSystemPlatformService();
        BFacets bFacets = bSystemPlatformService.getProperty("locale").getFacets();
        int n = ((BInteger)bFacets.get("min")).getInt();
        int n2 = ((BInteger)bFacets.get("fieldWidth")).getInt();
        int n3 = string.length();
        if (n3 < n || n3 > n2) {
            return false;
        }
        bSystemPlatformService.setLocale(string);
        return true;
    }

    public void saveProperties() {
        this.getSystemPlatformService().savePlatformServiceProperties();
    }

    private final BSystemPlatformService getSystemPlatformService() {
        return (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
    }

    private final void loadProperties() {
        this.getSystemPlatformService().poll();
    }

    private PlatformTimeManager() {
        this.loadProperties();
    }
}

