/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.tcpip;

import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import javax.baja.naming.SlotPath;
import javax.baja.platform.tcpip.TcpIpManager;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PlatformTcpIpManager
implements TcpIpManager {
    private static final String dhcpEnabledMsg = "Can not set value because DHCP is enabled";
    private static final String serverArrayTooLargeMsg = "Server array exceeds maximum size";
    static /* synthetic */ Class class$javax$baja$sys$BString;
    static /* synthetic */ Class class$com$tridium$platform$tcpip$BTcpIpAdapterSettings;

    public static PlatformTcpIpManager make() {
        return new PlatformTcpIpManager();
    }

    public String[] getAdapterIds() {
        BTcpIpAdapterSettings[] bTcpIpAdapterSettingsArray = this.getAllTcpIpAdapterSettings();
        int n = bTcpIpAdapterSettingsArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = bTcpIpAdapterSettingsArray[n2].getAdapterId();
            ++n2;
        }
        return stringArray;
    }

    public String getDefaultGateway(String string) {
        BTcpIpHostSettings bTcpIpHostSettings = this.getTcpIpHostSettings();
        if (bTcpIpHostSettings.getUsesAdapterLevelSettings()) {
            return this.getTcpIpAdapterSettings(bTcpIpHostSettings, string).getDefaultGateway();
        }
        return bTcpIpHostSettings.getDefaultGateway();
    }

    public void setDefaultGateway(String string, String string2) {
        BTcpIpHostSettings bTcpIpHostSettings = this.getTcpIpHostSettings();
        if (bTcpIpHostSettings.getUsesAdapterLevelSettings()) {
            BTcpIpAdapterSettings bTcpIpAdapterSettings = this.getTcpIpAdapterSettings(bTcpIpHostSettings, string);
            if (this.usingDhcp(bTcpIpAdapterSettings)) {
                throw new IllegalStateException(dhcpEnabledMsg);
            }
            bTcpIpAdapterSettings.setDefaultGateway(string2);
        } else {
            if (this.usingDhcp()) {
                throw new IllegalStateException(dhcpEnabledMsg);
            }
            bTcpIpHostSettings.setDefaultGateway(string2);
        }
    }

    public boolean isDhcpEnabled(String string) {
        return this.getTcpIpAdapterSettings(string).getIsDhcpEnabled();
    }

    public void enableDhcp(String string, boolean bl) {
        this.getTcpIpAdapterSettings(string).setIsDhcpEnabled(bl);
    }

    public int getDnsServerLimit(String string) {
        BTcpIpHostSettings bTcpIpHostSettings = this.getTcpIpHostSettings();
        if (bTcpIpHostSettings.getUsesAdapterLevelSettings()) {
            return this.getTcpIpAdapterSettings(bTcpIpHostSettings, string).getMaxDnsHosts();
        }
        return bTcpIpHostSettings.getMaxDnsHosts();
    }

    public String[] getDnsServers(String string) {
        BVector bVector = null;
        BTcpIpHostSettings bTcpIpHostSettings = this.getTcpIpHostSettings();
        bVector = bTcpIpHostSettings.getUsesAdapterLevelSettings() ? this.getTcpIpAdapterSettings(bTcpIpHostSettings, string).getDnsHosts() : bTcpIpHostSettings.getDnsHosts();
        Class clazz = class$javax$baja$sys$BString;
        if (clazz == null) {
            clazz = class$javax$baja$sys$BString = PlatformTcpIpManager.class("[Ljavax.baja.sys.BString;", false);
        }
        BString[] bStringArray = (BString[])bVector.getChildren(clazz);
        int n = bStringArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = bStringArray[n2].toString();
            ++n2;
        }
        return stringArray;
    }

    public void setDnsServers(String string, String[] stringArray) {
        BVector bVector = this.buildHostsVector(stringArray);
        if (bVector.getSlotCount() > this.getDnsServerLimit(string)) {
            throw new IllegalArgumentException(serverArrayTooLargeMsg);
        }
        BTcpIpHostSettings bTcpIpHostSettings = this.getTcpIpHostSettings();
        if (bTcpIpHostSettings.getUsesAdapterLevelSettings()) {
            BTcpIpAdapterSettings bTcpIpAdapterSettings = this.getTcpIpAdapterSettings(bTcpIpHostSettings, string);
            if (this.usingDhcp(bTcpIpAdapterSettings)) {
                throw new IllegalStateException(dhcpEnabledMsg);
            }
            bTcpIpAdapterSettings.setDnsHosts(bVector);
        } else {
            if (this.usingDhcp()) {
                throw new IllegalStateException(dhcpEnabledMsg);
            }
            bTcpIpHostSettings.setDnsHosts(bVector);
        }
    }

    public String getDomain(String string) {
        BTcpIpHostSettings bTcpIpHostSettings = this.getTcpIpHostSettings();
        if (bTcpIpHostSettings.getUsesAdapterLevelSettings()) {
            return this.getTcpIpAdapterSettings(bTcpIpHostSettings, string).getDomain();
        }
        return bTcpIpHostSettings.getDomain();
    }

    public void setDomain(String string, String string2) {
        BTcpIpHostSettings bTcpIpHostSettings = this.getTcpIpHostSettings();
        if (bTcpIpHostSettings.getUsesAdapterLevelSettings()) {
            BTcpIpAdapterSettings bTcpIpAdapterSettings = this.getTcpIpAdapterSettings(bTcpIpHostSettings, string);
            if (this.usingDhcp(bTcpIpAdapterSettings)) {
                throw new IllegalStateException(dhcpEnabledMsg);
            }
            bTcpIpAdapterSettings.setDomain(string2);
        } else {
            if (this.usingDhcp()) {
                throw new IllegalStateException(dhcpEnabledMsg);
            }
            bTcpIpHostSettings.setDomain(string2);
        }
    }

    public String getHostName() {
        return this.getTcpIpHostSettings().getHostName();
    }

    public void setHostName(String string) {
        this.getTcpIpHostSettings().setHostName(string);
    }

    public String getIpAddress(String string) {
        return this.getTcpIpAdapterSettings(string).getIpAddress();
    }

    public void setIpAddress(String string, String string2) {
        BTcpIpAdapterSettings bTcpIpAdapterSettings = this.getTcpIpAdapterSettings(string);
        if (this.usingDhcp(bTcpIpAdapterSettings)) {
            throw new IllegalStateException(dhcpEnabledMsg);
        }
        bTcpIpAdapterSettings.setIpAddress(string2);
    }

    public String getSubnetMask(String string) {
        return this.getTcpIpAdapterSettings(string).getSubnetMask();
    }

    public void setSubnetMask(String string, String string2) {
        BTcpIpAdapterSettings bTcpIpAdapterSettings = this.getTcpIpAdapterSettings(string);
        if (this.usingDhcp(bTcpIpAdapterSettings)) {
            throw new IllegalStateException(dhcpEnabledMsg);
        }
        bTcpIpAdapterSettings.setSubnetMask(string2);
    }

    public String getMediaAccessControlAddress(String string) {
        return this.getTcpIpAdapterSettings(string).getMediaAccessControlAddress();
    }

    public void saveProperties() {
        this.getTcpIpService().savePlatformServiceProperties();
    }

    private final BVector buildHostsVector(String[] stringArray) {
        BVector bVector = new BVector();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            bVector.add(SlotPath.escape((String)string), (BValue)BString.make((String)string));
            ++n;
        }
        return bVector;
    }

    private final BTcpIpHostSettings getTcpIpHostSettings() {
        return this.getTcpIpService().getSettings();
    }

    private final BTcpIpAdapterSettings getTcpIpAdapterSettings(BTcpIpHostSettings bTcpIpHostSettings, String string) {
        BVector bVector = bTcpIpHostSettings.getAdapters();
        Class clazz = class$com$tridium$platform$tcpip$BTcpIpAdapterSettings;
        if (clazz == null) {
            clazz = class$com$tridium$platform$tcpip$BTcpIpAdapterSettings = PlatformTcpIpManager.class("[Lcom.tridium.platform.tcpip.BTcpIpAdapterSettings;", false);
        }
        BTcpIpAdapterSettings[] bTcpIpAdapterSettingsArray = (BTcpIpAdapterSettings[])bVector.getChildren(clazz);
        return this.resolveAdapter(bTcpIpAdapterSettingsArray, string);
    }

    private final BTcpIpAdapterSettings getTcpIpAdapterSettings(String string) {
        BTcpIpAdapterSettings[] bTcpIpAdapterSettingsArray = this.getAllTcpIpAdapterSettings();
        return this.resolveAdapter(bTcpIpAdapterSettingsArray, string);
    }

    private final BTcpIpAdapterSettings resolveAdapter(BTcpIpAdapterSettings[] bTcpIpAdapterSettingsArray, String string) {
        int n = 0;
        while (n < bTcpIpAdapterSettingsArray.length) {
            if (bTcpIpAdapterSettingsArray[n].getAdapterId().equals(string)) {
                return bTcpIpAdapterSettingsArray[n];
            }
            ++n;
        }
        return bTcpIpAdapterSettingsArray[0];
    }

    private final BTcpIpAdapterSettings[] getAllTcpIpAdapterSettings() {
        BVector bVector = this.getTcpIpHostSettings().getAdapters();
        Class clazz = class$com$tridium$platform$tcpip$BTcpIpAdapterSettings;
        if (clazz == null) {
            clazz = class$com$tridium$platform$tcpip$BTcpIpAdapterSettings = PlatformTcpIpManager.class("[Lcom.tridium.platform.tcpip.BTcpIpAdapterSettings;", false);
        }
        return (BTcpIpAdapterSettings[])bVector.getChildren(clazz);
    }

    private final BTcpIpPlatformService getTcpIpService() {
        return (BTcpIpPlatformService)Sys.getService((Type)BTcpIpPlatformService.TYPE);
    }

    private final void loadPlatformProperties() {
        this.getTcpIpService().poll();
    }

    private final boolean usingDhcp() {
        return this.usingDhcp(this.getTcpIpAdapterSettings(null));
    }

    private final boolean usingDhcp(BTcpIpAdapterSettings bTcpIpAdapterSettings) {
        boolean bl = false;
        if (bTcpIpAdapterSettings.getCanUseDhcp() && bTcpIpAdapterSettings.getIsDhcpEnabled()) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private PlatformTcpIpManager() {
        this.loadPlatformProperties();
    }
}

