/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.posix;

import com.tridium.platform.BOperatingSystemEnum;
import com.tridium.sys.Nre;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NtpConfUtil {
    private static BBoolean EnabledStatusToWrite = null;
    private static BBoolean UseLocalBackup = null;
    private static BBoolean SyncAtBoot = null;
    private static String[] ServerStringsToWrite = null;
    private static String EnabledStringToWrite = null;
    private static String DisabledStringToWrite = null;
    private static int RevokeIntervalToWrite = -1;
    private static int RegenIntervalToWrite = -1;
    private static int PanicValueToWrite = -1;
    private static String[] raw_ntpd_conf_fileContents = null;
    private static boolean needToWriteLocalToPlat = false;
    private static boolean needToReadLocalFromPlat = true;
    private static String ntpConfPath = BOperatingSystemEnum.isOS(BOperatingSystemEnum.qnx) ? Nre.bootEnv.getBajaHome().toString() + File.separator + "lib" + File.separator + "ntp.conf" : "/etc/ntp.conf";
    static /* synthetic */ Class class$java$lang$String;

    private static final synchronized void load() {
        if (needToReadLocalFromPlat) {
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = NtpConfUtil.class("[Ljava.lang.String;", false);
            }
            Array array = new Array(clazz);
            BufferedReader bufferedReader = null;
            String string = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(ntpConfPath));
                while ((string = bufferedReader.readLine()) != null) {
                    array.add((Object)string.trim());
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            raw_ntpd_conf_fileContents = (String[])array.trim();
            needToReadLocalFromPlat = false;
        }
    }

    public static String[] getNtpServers() {
        NtpConfUtil.load();
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = NtpConfUtil.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < raw_ntpd_conf_fileContents.length) {
            if (!raw_ntpd_conf_fileContents[n].startsWith("server 127.127.1.0") && !raw_ntpd_conf_fileContents[n].startsWith("server 127.127.1.1") && (raw_ntpd_conf_fileContents[n].startsWith("server") || raw_ntpd_conf_fileContents[n].startsWith("peer") || raw_ntpd_conf_fileContents[n].startsWith("broadcast") || raw_ntpd_conf_fileContents[n].startsWith("manycastclient"))) {
                array.add((Object)raw_ntpd_conf_fileContents[n]);
            }
            ++n;
        }
        return (String[])array.trim();
    }

    public static int getPanic() {
        NtpConfUtil.load();
        int n = BOperatingSystemEnum.isOS(BOperatingSystemEnum.qnx) ? 0 : 1000;
        int n2 = 0;
        block0: while (n2 < raw_ntpd_conf_fileContents.length) {
            if (raw_ntpd_conf_fileContents[n2].startsWith("tinker")) {
                StringTokenizer stringTokenizer = new StringTokenizer(raw_ntpd_conf_fileContents[n2]);
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    if (!string.equals("panic")) continue;
                    n = Integer.valueOf(stringTokenizer.nextToken());
                    break block0;
                }
                break;
            }
            ++n2;
        }
        return n;
    }

    public static String getEnabledString() {
        NtpConfUtil.load();
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = NtpConfUtil.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < raw_ntpd_conf_fileContents.length) {
            if (raw_ntpd_conf_fileContents[n].startsWith("enable")) {
                array.add((Object)raw_ntpd_conf_fileContents[n]);
            }
            ++n;
        }
        String string = "enable ";
        if (array.size() > 1) {
            string = (String)array.get(0);
            int n2 = 1;
            while (n2 < array.size()) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)array.get(n2));
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string.indexOf(string2) != -1) continue;
                    string = string.concat(" " + string2);
                }
                ++n2;
            }
        } else if (array.size() != 0) {
            string = (String)array.get(0);
        }
        return string;
    }

    public static String getDisabledString() {
        NtpConfUtil.load();
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = NtpConfUtil.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < raw_ntpd_conf_fileContents.length) {
            if (raw_ntpd_conf_fileContents[n].startsWith("disable")) {
                array.add((Object)raw_ntpd_conf_fileContents[n]);
            }
            ++n;
        }
        String string = "disable ";
        if (array.size() > 1) {
            string = (String)array.get(0);
            int n2 = 1;
            while (n2 < array.size()) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)array.get(n2));
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string.indexOf(string2) != -1) continue;
                    string = string.concat(" " + string2);
                }
                ++n2;
            }
        } else if (array.size() != 0) {
            string = (String)array.get(0);
        }
        return string;
    }

    public static int getRevokeInterval() {
        NtpConfUtil.load();
        int n = 16;
        int n2 = 0;
        while (n2 < raw_ntpd_conf_fileContents.length) {
            if (raw_ntpd_conf_fileContents[n2].startsWith("revoke")) {
                int n3 = raw_ntpd_conf_fileContents[n2].indexOf(" ");
                String string = raw_ntpd_conf_fileContents[n2].substring(n3).trim();
                n = Integer.valueOf(string);
                break;
            }
            ++n2;
        }
        return n;
    }

    public static int getAutokeyInterval() {
        NtpConfUtil.load();
        int n = 12;
        int n2 = 0;
        while (n2 < raw_ntpd_conf_fileContents.length) {
            if (raw_ntpd_conf_fileContents[n2].startsWith("autokey")) {
                int n3 = raw_ntpd_conf_fileContents[n2].indexOf(" ");
                String string = raw_ntpd_conf_fileContents[n2].substring(n3).trim();
                n = Integer.valueOf(string);
                break;
            }
            ++n2;
        }
        return n;
    }

    public static boolean isEnabled() {
        NtpConfUtil.load();
        boolean bl = false;
        boolean bl2 = false;
        if (BOperatingSystemEnum.isOS(BOperatingSystemEnum.qnx)) {
            bl2 = true;
        } else if (BOperatingSystemEnum.isOS(BOperatingSystemEnum.linux)) {
            if (!ntpConfPath.equalsIgnoreCase("/etc/ntp.conf")) {
                bl2 = true;
            }
        } else {
            return false;
        }
        if (bl2) {
            int n = 0;
            while (n < raw_ntpd_conf_fileContents.length) {
                if (raw_ntpd_conf_fileContents[n].startsWith("#ntpEnabled")) {
                    int n2 = raw_ntpd_conf_fileContents[n].indexOf(" ");
                    bl = Boolean.valueOf(raw_ntpd_conf_fileContents[n].substring(n2).trim());
                    break;
                }
                ++n;
            }
        } else {
            bl = new File("/var/run/ntpd.pid").exists();
        }
        return bl;
    }

    public static boolean getUseLocalBackup() {
        NtpConfUtil.load();
        boolean bl = false;
        int n = 0;
        while (n < raw_ntpd_conf_fileContents.length) {
            if (raw_ntpd_conf_fileContents[n].startsWith("server 127.127.1")) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public static boolean getSyncAtBoot() {
        NtpConfUtil.load();
        boolean bl = false;
        if (BOperatingSystemEnum.isOS(BOperatingSystemEnum.qnx)) {
            int n = 0;
            while (n < raw_ntpd_conf_fileContents.length) {
                if (raw_ntpd_conf_fileContents[n].startsWith("#syncAtBoot")) {
                    int n2 = raw_ntpd_conf_fileContents[n].indexOf(" ");
                    bl = Boolean.valueOf(raw_ntpd_conf_fileContents[n].substring(n2).trim());
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public static synchronized void write() throws Exception {
        if (needToWriteLocalToPlat) {
            if (EnabledStatusToWrite == null) {
                EnabledStatusToWrite = BBoolean.make((boolean)NtpConfUtil.isEnabled());
            }
            if (ServerStringsToWrite == null) {
                ServerStringsToWrite = NtpConfUtil.getNtpServers();
            }
            if (EnabledStringToWrite == null) {
                EnabledStringToWrite = NtpConfUtil.getEnabledString();
            }
            if (DisabledStringToWrite == null) {
                DisabledStringToWrite = NtpConfUtil.getDisabledString();
            }
            if (RevokeIntervalToWrite == -1) {
                RevokeIntervalToWrite = NtpConfUtil.getRevokeInterval();
            }
            if (RegenIntervalToWrite == -1) {
                RegenIntervalToWrite = NtpConfUtil.getAutokeyInterval();
            }
            if (PanicValueToWrite == -1) {
                PanicValueToWrite = NtpConfUtil.getPanic();
            }
            if (UseLocalBackup == null) {
                UseLocalBackup = BBoolean.make((boolean)NtpConfUtil.getUseLocalBackup());
            }
            if (SyncAtBoot == null) {
                SyncAtBoot = BBoolean.make((boolean)NtpConfUtil.getSyncAtBoot());
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(ntpConfPath));
            bufferedWriter.write("#" + ntpConfPath + ": Niagara Network Time Protocol Configuration File\n");
            bufferedWriter.write("#Use the NtpPlatformService UI to modify this file.\n");
            bufferedWriter.write("#Created: " + BAbsTime.now() + '\n');
            bufferedWriter.write("#\n");
            bufferedWriter.write("#Niagara NtpPlatformService variable, do not modify\n");
            bufferedWriter.write("#ntpEnabled " + String.valueOf(EnabledStatusToWrite.getBoolean()) + '\n');
            EnabledStatusToWrite = null;
            bufferedWriter.write("#syncAtBoot " + String.valueOf(SyncAtBoot.getBoolean()) + '\n');
            SyncAtBoot = null;
            bufferedWriter.write("\n");
            if (ServerStringsToWrite.length != 0) {
                bufferedWriter.write("#server list\n");
            }
            int n = 0;
            while (n < ServerStringsToWrite.length) {
                bufferedWriter.write(ServerStringsToWrite[n] + '\n');
                ++n;
            }
            bufferedWriter.write("\n");
            ServerStringsToWrite = null;
            if (UseLocalBackup.getBoolean()) {
                bufferedWriter.write("#local backup clock\n");
                bufferedWriter.write("server 127.127.1.0\n");
                bufferedWriter.write("fudge 127.127.1.0 stratum 10\n\n");
            }
            UseLocalBackup = null;
            if (!EnabledStringToWrite.trim().equals("enable")) {
                bufferedWriter.write("#ntp features enabled\n");
                bufferedWriter.write(EnabledStringToWrite + "\n\n");
            }
            EnabledStringToWrite = null;
            if (!DisabledStringToWrite.trim().equals("disable")) {
                bufferedWriter.write("#ntp features disabled\n");
                bufferedWriter.write(DisabledStringToWrite + "\n\n");
            }
            DisabledStringToWrite = null;
            if (PanicValueToWrite != 1000) {
                bufferedWriter.write("#ntp panic value, if offset exceeds this, ntpd should exit (disabled if 0)\n");
                bufferedWriter.write("tinker panic " + PanicValueToWrite + "\n\n");
            }
            PanicValueToWrite = -1;
            if (RegenIntervalToWrite != 12) {
                bufferedWriter.write("#interval in log base 2 seconds to regenerate autokey\n");
                bufferedWriter.write("autokey " + RegenIntervalToWrite + "\n\n");
            }
            RegenIntervalToWrite = -1;
            if (RevokeIntervalToWrite != 16) {
                bufferedWriter.write("#interval in log base 2 seconds to revoke key generated\n");
                bufferedWriter.write("revoke " + RevokeIntervalToWrite + "\n\n");
            }
            RevokeIntervalToWrite = -1;
            bufferedWriter.write("#gather information about statistics\n");
            bufferedWriter.write("statistics clockstats loopstats\n");
            bufferedWriter.write("filegen clockstats file clockstats type none nolink enable\n");
            bufferedWriter.write("filegen loopstats file loopstats type none nolink enable\n");
            bufferedWriter.close();
            needToWriteLocalToPlat = false;
            needToReadLocalFromPlat = true;
        }
    }

    public static void setNtpServers(String[] stringArray) {
        ServerStringsToWrite = stringArray;
        needToWriteLocalToPlat = true;
    }

    public static void setEnabledString(String string) {
        EnabledStringToWrite = string;
        needToWriteLocalToPlat = true;
    }

    public static void setDisabledString(String string) {
        DisabledStringToWrite = string;
        needToWriteLocalToPlat = true;
    }

    public static void setRevokeInterval(int n) {
        RevokeIntervalToWrite = n;
        needToWriteLocalToPlat = true;
    }

    public static void setAutokeyInterval(int n) {
        RegenIntervalToWrite = n;
        needToWriteLocalToPlat = true;
    }

    public static void setEnabled(boolean bl) {
        EnabledStatusToWrite = BBoolean.make((boolean)bl);
        needToWriteLocalToPlat = true;
    }

    public static void setPanic(int n) {
        PanicValueToWrite = n;
        needToWriteLocalToPlat = true;
    }

    public static void setLocalBackup(boolean bl) {
        UseLocalBackup = BBoolean.make((boolean)bl);
        needToWriteLocalToPlat = true;
    }

    public static void setSyncAtBoot(boolean bl) {
        SyncAtBoot = BBoolean.make((boolean)bl);
        needToWriteLocalToPlat = true;
    }

    public static void setNtpPath(String string) {
        ntpConfPath = string;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

