/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.pki;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PemInputStream
extends PushbackInputStream {
    public static final String HEADER_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String FOOTER_CERT = "-----END CERTIFICATE-----\n";
    public static final String HEADER_KEY = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String FOOTER_KEY = "-----END RSA PRIVATE KEY-----\n";
    public static final int ENTRY_CERT = 1;
    public static final int ENTRY_KEY = 2;
    public static final int ENTRY_UNSUPPORTED = 128;
    public static final int ENTRY_ANY = 255;
    public static final int ENTRY_NONE = -1;
    public static int POSITION_BEFORE_HEADER = 1;
    public static int POSITION_AFTER_HEADER = 2;
    public static int POSITION_UNKNOWN = 0;
    public static int POSITION_EOF = -1;
    protected int entryPosition;
    protected int entryType;
    protected int markedEntryPosition;
    protected int markedEntryType;
    protected CircularByteBuffer recentlyRead;
    protected boolean bypassSpecialReadProcessing;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void determineEntryType() throws IOException {
        boolean bl;
        block12: {
            if (this.entryPosition != POSITION_BEFORE_HEADER) {
                throw new IllegalStateException("determineEntryType() can only be called at entry start");
            }
            bl = this.bypassSpecialReadProcessing;
            this.bypassSpecialReadProcessing = true;
            try {
                int n;
                byte[] byArray = new byte[40];
                if (n < 0) {
                    this.entryPosition = POSITION_EOF;
                    this.entryType = -1;
                    Object var3_4 = null;
                    this.bypassSpecialReadProcessing = bl;
                    return;
                }
                for (n = super.read(byArray, 0, 40); n < 40; n += super.read(byArray, n, 40 - n)) {
                    try {
                        continue;
                    }
                    catch (EOFException eOFException) {
                        if (n > 0) {
                            this.unread(byArray, 0, n);
                        }
                        Object var3_5 = null;
                        this.bypassSpecialReadProcessing = bl;
                        return;
                    }
                }
                this.unread(byArray, 0, byArray.length);
                String string = new String(byArray);
                if (string.startsWith(HEADER_CERT)) {
                    this.entryType = 1;
                    break block12;
                }
                if (string.startsWith(HEADER_KEY)) {
                    this.entryType = 2;
                    break block12;
                }
                this.entryType = 128;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this.bypassSpecialReadProcessing = bl;
                throw throwable;
            }
        }
        Object var3_7 = null;
        this.bypassSpecialReadProcessing = bl;
    }

    public void unread(byte[] byArray) throws IOException {
        if (!this.bypassSpecialReadProcessing) {
            throw new UnsupportedOperationException();
        }
        super.unread(byArray);
    }

    public void unread(byte[] byArray, int n, int n2) throws IOException {
        if (!this.bypassSpecialReadProcessing) {
            throw new UnsupportedOperationException();
        }
        super.unread(byArray, n, n2);
    }

    public void unread(int n) throws IOException {
        if (!this.bypassSpecialReadProcessing) {
            throw new UnsupportedOperationException();
        }
        super.unread(n);
    }

    public synchronized int readToEntry(int n) throws IOException {
        while (this.entryPosition == POSITION_UNKNOWN || (this.entryType & n) == 0) {
            int n2 = this.read();
            if (n2 < 0) break;
        }
        if (this.entryPosition == POSITION_AFTER_HEADER) {
            this.bypassSpecialReadProcessing = true;
            if (this.entryType == 1) {
                this.unread(HEADER_CERT.getBytes());
            } else if (this.entryType == 2) {
                this.unread(HEADER_KEY.getBytes());
            }
            this.bypassSpecialReadProcessing = false;
            this.entryPosition = POSITION_BEFORE_HEADER;
        }
        return this.entryType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read() throws IOException {
        if (this.bypassSpecialReadProcessing) {
            return super.read();
        }
        boolean bl = this.bypassSpecialReadProcessing;
        this.bypassSpecialReadProcessing = true;
        try {
            int n = super.read();
            if (n < 0) {
                this.entryPosition = POSITION_EOF;
                this.entryType = -1;
            } else {
                this.recentlyRead.append((byte)n);
                if (this.entryPosition == POSITION_BEFORE_HEADER) {
                    this.entryPosition = POSITION_UNKNOWN;
                } else if (this.entryType == 1 && this.recentlyRead.endsWith(FOOTER_CERT)) {
                    this.entryPosition = POSITION_BEFORE_HEADER;
                    this.determineEntryType();
                } else if (this.entryType == 2 && this.recentlyRead.endsWith(FOOTER_KEY)) {
                    this.entryPosition = POSITION_BEFORE_HEADER;
                    this.determineEntryType();
                } else if (this.entryType == 128) {
                    if (this.recentlyRead.endsWith(HEADER_CERT)) {
                        this.entryPosition = POSITION_AFTER_HEADER;
                        this.entryType = 1;
                    } else if (this.recentlyRead.endsWith(HEADER_KEY)) {
                        this.entryPosition = POSITION_AFTER_HEADER;
                        this.entryType = 2;
                    }
                }
            }
            int n2 = n;
            Object var3_4 = null;
            this.bypassSpecialReadProcessing = bl;
            return n2;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.bypassSpecialReadProcessing = bl;
            throw throwable;
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 < 0) {
                return n3 == n ? -1 : n3 - n;
            }
            byArray[n + n3] = (byte)n4;
            ++n3;
        }
        return n2;
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l2 < l) {
            int n = this.read();
            if (n < 0) {
                return l2;
            }
            ++l2;
        }
        return l;
    }

    public synchronized void mark(int n) {
        this.markedEntryPosition = this.entryPosition;
        this.markedEntryType = this.entryType;
        super.mark(n);
    }

    public synchronized void reset() throws IOException {
        super.reset();
        this.entryType = this.markedEntryType;
        this.entryPosition = this.markedEntryPosition;
    }

    private final /* synthetic */ void this() {
        this.entryPosition = POSITION_BEFORE_HEADER;
        this.bypassSpecialReadProcessing = false;
    }

    public PemInputStream(InputStream inputStream) throws IOException {
        super(inputStream, 40);
        this.this();
        this.entryPosition = POSITION_BEFORE_HEADER;
        this.recentlyRead = new CircularByteBuffer(40);
        this.determineEntryType();
    }

    protected static class CircularByteBuffer {
        private byte[] buf;
        int len;
        int nextWrite;

        public void clear() {
            this.len = 0;
            this.nextWrite = 0;
        }

        public void append(byte by) {
            if (this.nextWrite >= this.buf.length) {
                this.buf[0] = by;
                this.nextWrite = 1;
            } else {
                this.buf[this.nextWrite] = by;
                ++this.nextWrite;
                if (this.len < this.buf.length) {
                    ++this.len;
                }
            }
        }

        public boolean endsWith(String string) {
            if (string.length() > this.len) {
                return false;
            }
            byte[] byArray = string.getBytes();
            int n = 1;
            while (n <= byArray.length) {
                if (byArray[byArray.length - n] != this.get(-n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public byte get(int n) {
            int n2;
            if (n < 0) {
                if (n < -1 * this.len) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                n2 = this.nextWrite + n;
                if (n2 < 0) {
                    n2 += this.buf.length;
                }
            } else {
                if (n > this.len - 1) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                n2 = this.nextWrite + n;
                if (n2 >= this.buf.length) {
                    n2 -= this.buf.length;
                }
            }
            return this.buf[n2];
        }

        public int len() {
            return this.len;
        }

        public String toString() {
            byte[] byArray = new byte[this.len];
            int n = 0;
            while (n < this.len) {
                byArray[n] = this.get(n);
                ++n;
            }
            return new String(byArray);
        }

        public CircularByteBuffer(int n) {
            this.buf = new byte[n];
            this.clear();
        }
    }
}

