/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.license;

import com.tridium.file.types.text.BCertificateFile;
import com.tridium.file.types.text.BLicenseFile;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.platform.daemon.message.ByteArrayFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.fox.BLicenseChannel;
import com.tridium.platform.license.BCertificateSummary;
import com.tridium.platform.license.BEnvLicenseSummary;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.BrandProps;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.IFileInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.sys.license.dom.CertificateDatabase;
import com.tridium.sys.license.dom.Feature;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorCertificate;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.baja.file.BIFile;
import javax.baja.nre.util.Array;
import javax.baja.sys.BModule;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PortalLicenseUtil {
    private static boolean initialized = false;
    private static Class portalApiClass = null;
    static /* synthetic */ Class class$com$tridium$sys$license$dom$VendorLicense;
    static /* synthetic */ Class class$com$tridium$sys$license$dom$VendorCertificate;
    static /* synthetic */ Class array$Ljavax$baja$xml$XElem;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$platform$license$LicenseInfo;
    static /* synthetic */ Class class$com$tridium$platform$license$CertificateInfo;

    public static IFileInfo makeFileInfo(BIFile bIFile) throws Exception {
        Object object;
        BLicenseChannel bLicenseChannel = null;
        if (bIFile.getSession() instanceof BFoxSession) {
            object = (BFoxSession)bIFile.getSession();
            try {
                Version version = (Version)object.fw(404, (Object)"platform", null, null, null);
                if (version != null && version.compareTo((Object)new Version("3.7.201")) != -1) {
                    bLicenseChannel = (BLicenseChannel)object.getConnection().getChannels().get("license", BLicenseChannel.TYPE);
                }
            }
            catch (Exception exception) {}
        }
        if (bIFile instanceof BLicenseFile) {
            if (bLicenseChannel != null) {
                try {
                    object = bLicenseChannel.read((BFoxFileStore)bIFile.getStore());
                    return new LicenseInfo(XParser.make((InputStream)object).parse(true), bIFile);
                }
                catch (Exception exception) {}
            }
            return new LicenseInfo(bIFile);
        }
        if (bIFile instanceof BCertificateFile) {
            if (bLicenseChannel != null) {
                try {
                    object = bLicenseChannel.read((BFoxFileStore)bIFile.getStore());
                    return new CertificateInfo(XParser.make((InputStream)object).parse(true), bIFile);
                }
                catch (Exception exception) {}
            }
            return new CertificateInfo(bIFile);
        }
        return null;
    }

    public static synchronized boolean isApiAvailable() {
        if (!initialized) {
            try {
                BModule bModule = Sys.loadModule((String)"portalApi");
                portalApiClass = bModule.loadClass("com.tridium.portal.api.PortalApi");
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (ModuleNotFoundException moduleNotFoundException) {}
            initialized = true;
        }
        boolean bl = false;
        if (portalApiClass != null) {
            bl = true;
        }
        return bl;
    }

    public static boolean autoFetchLicenses() {
        return BrandProps.getLocalInstance().get("license.autoFetch", true);
    }

    public static boolean requestLicensesOnline() {
        return BrandProps.getLocalInstance().get("license.onlineRequest", true);
    }

    public static VendorLicense[] getUpdatedLicenses(BEnvLicenseSummary[] bEnvLicenseSummaryArray, LicenseDatabase licenseDatabase) throws Exception {
        Class clazz = class$com$tridium$sys$license$dom$VendorLicense;
        if (clazz == null) {
            clazz = class$com$tridium$sys$license$dom$VendorLicense = PortalLicenseUtil.class("[Lcom.tridium.sys.license.dom.VendorLicense;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bEnvLicenseSummaryArray.length) {
            HashSet<String> hashSet = new HashSet<String>();
            VendorLicense[] vendorLicenseArray = licenseDatabase.getLicenses(bEnvLicenseSummaryArray[n].getHostId(), bEnvLicenseSummaryArray[n].getBrandId());
            int n2 = 0;
            while (n2 < vendorLicenseArray.length) {
                String string = vendorLicenseArray[n2].getVendor();
                if (string.equalsIgnoreCase("tridium") || !hashSet.contains(string)) {
                    long l = bEnvLicenseSummaryArray[n].getLicenseGenerated(string);
                    long l2 = vendorLicenseArray[n2].getGenerated();
                    if (bEnvLicenseSummaryArray[n].getLicenseSignature(string) == null || l < l2 || l == l2 && !vendorLicenseArray[n2].getSignature().equals(bEnvLicenseSummaryArray[n].getLicenseSignature(string))) {
                        array.add((Object)vendorLicenseArray[n2]);
                        if (!string.equalsIgnoreCase("tridium")) {
                            hashSet.add(string);
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
        return (VendorLicense[])array.trim();
    }

    public static VendorCertificate[] getUpdatedCertificates(BCertificateSummary[] bCertificateSummaryArray, CertificateDatabase certificateDatabase) throws Exception {
        Class clazz = class$com$tridium$sys$license$dom$VendorCertificate;
        if (clazz == null) {
            clazz = class$com$tridium$sys$license$dom$VendorCertificate = PortalLicenseUtil.class("[Lcom.tridium.sys.license.dom.VendorCertificate;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bCertificateSummaryArray.length) {
            VendorCertificate vendorCertificate = certificateDatabase.getCertificate(bCertificateSummaryArray[n].getVendor());
            if (vendorCertificate != null) {
                long l = bCertificateSummaryArray[n].getCertificateGenerated();
                long l2 = vendorCertificate.getGenerated();
                if (bCertificateSummaryArray[n].getCertificateSignature() == null || l < l2 || l == l2 && !vendorCertificate.getSignature().equals(bCertificateSummaryArray[n].getCertificateSignature())) {
                    array.add((Object)vendorCertificate);
                }
            }
            ++n;
        }
        return (VendorCertificate[])array.trim();
    }

    public static VendorLicense[] getPortalUpdates(VendorLicense[] vendorLicenseArray) throws Exception {
        return PortalLicenseUtil.getPortalUpdates(BEnvLicenseSummary.make(vendorLicenseArray));
    }

    public static VendorLicense[] getPortalUpdates(BEnvLicenseSummary[] bEnvLicenseSummaryArray) throws Exception {
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        try {
            Class[] classArray = new Class[1];
            Class clazz = array$Ljavax$baja$xml$XElem;
            if (clazz == null) {
                clazz = array$Ljavax$baja$xml$XElem = PortalLicenseUtil.class("[Ljavax.baja.xml.XElem;", true);
            }
            classArray[0] = clazz;
            Method method = portalApiClass.getMethod("getLicenseUpdates", classArray);
            XElem[] xElemArray = new XElem[bEnvLicenseSummaryArray.length];
            int n = 0;
            while (n < bEnvLicenseSummaryArray.length) {
                xElemArray[n] = bEnvLicenseSummaryArray[n].asXml();
                ++n;
            }
            XElem[] xElemArray2 = (XElem[])method.invoke(null, new Object[]{xElemArray});
            VendorLicense[] vendorLicenseArray = new VendorLicense[xElemArray2.length];
            int n2 = 0;
            while (n2 < xElemArray2.length) {
                vendorLicenseArray[n2] = VendorLicense.make((String)"portal", (XElem)xElemArray2[n2]);
                ++n2;
            }
            return vendorLicenseArray;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new UnsupportedOperationException();
        }
    }

    public static VendorCertificate[] getPortalUpdates(VendorCertificate[] vendorCertificateArray) throws Exception {
        return PortalLicenseUtil.getPortalUpdates(BCertificateSummary.make(vendorCertificateArray));
    }

    public static VendorCertificate[] getPortalUpdates(BCertificateSummary[] bCertificateSummaryArray) throws Exception {
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        try {
            Class[] classArray = new Class[1];
            Class clazz = array$Ljavax$baja$xml$XElem;
            if (clazz == null) {
                clazz = array$Ljavax$baja$xml$XElem = PortalLicenseUtil.class("[Ljavax.baja.xml.XElem;", true);
            }
            classArray[0] = clazz;
            Method method = portalApiClass.getMethod("getCertificateUpdates", classArray);
            XElem[] xElemArray = new XElem[bCertificateSummaryArray.length];
            int n = 0;
            while (n < bCertificateSummaryArray.length) {
                xElemArray[n] = bCertificateSummaryArray[n].asXml();
                ++n;
            }
            XElem[] xElemArray2 = (XElem[])method.invoke(null, new Object[]{xElemArray});
            VendorCertificate[] vendorCertificateArray = new VendorCertificate[xElemArray2.length];
            int n2 = 0;
            while (n2 < xElemArray2.length) {
                vendorCertificateArray[n2] = VendorCertificate.make((String)"portal", (XElem)xElemArray2[n2]);
                ++n2;
            }
            return vendorCertificateArray;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new UnsupportedOperationException();
        }
    }

    public static LicenseInfo[] getLicenseInfo(BIFile bIFile, String string, String string2) throws Exception {
        return PortalLicenseUtil.getLicenseInfo(new BIFile[]{bIFile}, string, string2);
    }

    public static LicenseInfo[] getLicenseInfo(BIFile[] bIFileArray, String string, String string2) throws Exception {
        HashMap hashMap = new HashMap();
        VendorLicense[] vendorLicenseArray = PortalLicenseUtil.getLicenses(bIFileArray, string, string2, hashMap);
        LicenseInfo[] licenseInfoArray = new LicenseInfo[vendorLicenseArray.length];
        int n = 0;
        while (n < vendorLicenseArray.length) {
            licenseInfoArray[n] = new LicenseInfo(vendorLicenseArray[n], (BIFile)hashMap.get(vendorLicenseArray[n]));
            ++n;
        }
        return licenseInfoArray;
    }

    public static VendorLicense[] getLicenses(BIFile bIFile, String string, String string2) throws Exception {
        return PortalLicenseUtil.getLicenses(new BIFile[]{bIFile}, string, string2, null);
    }

    public static VendorLicense[] getLicenses(BIFile[] bIFileArray, String string, String string2) throws Exception {
        return PortalLicenseUtil.getLicenses(bIFileArray, string, string2, null);
    }

    protected static VendorLicense[] getLicenses(BIFile[] bIFileArray, String string, String string2, Map map) throws Exception {
        HashMap hashMap = new HashMap();
        String string3 = string2;
        int n = 0;
        while (n < bIFileArray.length) {
            VendorLicense[] vendorLicenseArray;
            if (bIFileArray[n] instanceof BLicenseFile) {
                vendorLicenseArray = VendorLicense.make((BIFile)bIFileArray[n]);
                if (vendorLicenseArray.getBrandId() == null || string2 == null || string2.equals(vendorLicenseArray.getBrandId())) {
                    string3 = PortalLicenseUtil.accumLicenses(string3, hashMap, map, (VendorLicense)vendorLicenseArray, bIFileArray[n]);
                }
            } else if (bIFileArray[n] instanceof BLicenseArchiveFile) {
                vendorLicenseArray = ((BLicenseArchiveFile)bIFileArray[n]).getLicenses(string);
                int n2 = 0;
                while (n2 < vendorLicenseArray.length) {
                    string3 = PortalLicenseUtil.accumLicenses(string3, hashMap, map, vendorLicenseArray[n2], bIFileArray[n]);
                    ++n2;
                }
            }
            ++n;
        }
        VendorLicense[] vendorLicenseArray = new VendorLicense[hashMap.size()];
        hashMap.values().toArray(vendorLicenseArray);
        return vendorLicenseArray;
    }

    protected static String accumLicenses(String string, Map map, Map map2, VendorLicense vendorLicense, BIFile bIFile) throws Exception {
        VendorLicense vendorLicense2;
        if (!(vendorLicense.getBrandId() != null && string != null && !string.equals(vendorLicense.getBrandId()) || (vendorLicense2 = (VendorLicense)map.get(vendorLicense.getLicenseName())) != null && vendorLicense2.getGenerated() >= vendorLicense.getGenerated())) {
            map.put(vendorLicense.getLicenseName(), vendorLicense);
            if (map2 != null) {
                map2.put(vendorLicense, bIFile);
            }
        }
        return string == null ? vendorLicense.getBrandId() : string;
    }

    public static synchronized boolean checkConnectivity() {
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        try {
            Method method = portalApiClass.getMethod("checkConnectivity", new Class[0]);
            Boolean bl = (Boolean)method.invoke(null, null);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static XElem[] getExistingLicenses(String string, String string2) throws Exception {
        Method method;
        Class clazz;
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        XElem[] xElemArray = null;
        Class[] classArray = new Class[2];
        Class clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = classArray[0] = (class$java$lang$String = PortalLicenseUtil.class("[Ljava.lang.String;", false));
        }
        if ((clazz = class$java$lang$String) == null) {
            clazz = classArray[1] = (class$java$lang$String = PortalLicenseUtil.class("[Ljava.lang.String;", false));
        }
        if ((xElemArray = (XElem[])(method = portalApiClass.getMethod("getLicenses", classArray)).invoke(null, string, string2)) == null || xElemArray.length == 0) {
            return null;
        }
        return xElemArray;
    }

    public static XElem[] getCertificates(String string) throws Exception {
        Method method;
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        XElem[] xElemArray = null;
        Class[] classArray = new Class[1];
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = classArray[0] = (class$java$lang$String = PortalLicenseUtil.class("[Ljava.lang.String;", false));
        }
        if ((xElemArray = (XElem[])(method = portalApiClass.getMethod("getCertificates", classArray)).invoke(null, string)) == null || xElemArray.length == 0) {
            return null;
        }
        return xElemArray;
    }

    public static XElem getCertificate(String string) throws Exception {
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        Class[] classArray = new Class[1];
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = PortalLicenseUtil.class("[Ljava.lang.String;", false);
        }
        classArray[0] = clazz;
        Method method = portalApiClass.getMethod("getCertificate", classArray);
        return (XElem)method.invoke(null, string);
    }

    public static XElem[] getCertificates(String[] stringArray) throws Exception {
        if (!PortalLicenseUtil.isApiAvailable()) {
            throw new UnsupportedOperationException();
        }
        Method method = portalApiClass.getMethod("getCertificates", stringArray.getClass());
        return (XElem[])method.invoke(null, new Object[]{stringArray});
    }

    public static LicenseSync syncLicenses(String string, LicenseInfo[] licenseInfoArray, LicenseInfo[] licenseInfoArray2) {
        return PortalLicenseUtil.syncLicenses(string, LicenseInfo.getLocalBrandFeature(), licenseInfoArray, licenseInfoArray2);
    }

    public static LicenseSync syncLicenses(String string, Feature.Brand brand, LicenseInfo[] licenseInfoArray, LicenseInfo[] licenseInfoArray2) {
        Object object;
        Object object2;
        LicenseInfo licenseInfo;
        Class clazz = class$com$tridium$platform$license$LicenseInfo;
        if (clazz == null) {
            clazz = class$com$tridium$platform$license$LicenseInfo = PortalLicenseUtil.class("[Lcom.tridium.platform.license.LicenseInfo;", false);
        }
        Array array = new Array(clazz);
        Class clazz2 = class$com$tridium$platform$license$LicenseInfo;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$platform$license$LicenseInfo = PortalLicenseUtil.class("[Lcom.tridium.platform.license.LicenseInfo;", false);
        }
        Array array2 = new Array(clazz2);
        Class clazz3 = class$com$tridium$platform$license$LicenseInfo;
        if (clazz3 == null) {
            clazz3 = class$com$tridium$platform$license$LicenseInfo = PortalLicenseUtil.class("[Lcom.tridium.platform.license.LicenseInfo;", false);
        }
        Array array3 = new Array(clazz3);
        HashMap<String, LicenseInfo> hashMap = new HashMap<String, LicenseInfo>();
        int n = 0;
        while (n < licenseInfoArray.length) {
            licenseInfo = licenseInfoArray[n];
            object2 = licenseInfo.vendorLicense;
            if (object2.getHostId().equals(string)) {
                LicenseInfo licenseInfo2 = (LicenseInfo)hashMap.get(object2.getVendor());
                if (licenseInfo2 != null) {
                    object = licenseInfo2.vendorLicense;
                    if (object2.getGenerated() > object.getGenerated()) {
                        array3.add((Object)licenseInfo2);
                        hashMap.put(object2.getVendor(), licenseInfo);
                    } else if (object.getGenerated() > object2.getGenerated()) {
                        array3.add((Object)licenseInfo);
                    } else if (licenseInfo.file.getFileName().equals(licenseInfo.getInstalledFileName())) {
                        array3.add((Object)licenseInfo2);
                        hashMap.put(object2.getVendor(), licenseInfo);
                    } else {
                        array3.add((Object)licenseInfo);
                    }
                } else {
                    hashMap.put(object2.getVendor(), licenseInfo);
                }
            }
            ++n;
        }
        n = 0;
        while (n < licenseInfoArray2.length) {
            licenseInfo = licenseInfoArray2[n];
            object2 = (LicenseInfo)hashMap.get(licenseInfo.vendorLicense.getVendor());
            if (PortalLicenseUtil.shouldInstall(licenseInfo, (LicenseInfo)object2, brand)) {
                boolean bl;
                boolean bl2 = false;
                if (object2 != null) {
                    bl2 = true;
                }
                if (bl = bl2) {
                    object = licenseInfo.getInstalledFileName();
                    if (((String)object).equals(object2.file.getFileName())) {
                        array2.add((Object)licenseInfo);
                    } else {
                        array3.add(object2);
                        array.add((Object)licenseInfo);
                    }
                } else {
                    array.add((Object)licenseInfo);
                }
            }
            ++n;
        }
        return new LicenseSync(array, array2, array3);
    }

    public static void sync(FileTransferMessage fileTransferMessage, LicenseSync licenseSync) {
        if (licenseSync == null || fileTransferMessage == null) {
            return;
        }
        int n = 0;
        while (n < licenseSync.toAdd.size()) {
            PortalLicenseUtil.addFile(fileTransferMessage, (IFileInfo)licenseSync.toAdd.get(n));
            ++n;
        }
        n = 0;
        while (n < licenseSync.toUpdate.size()) {
            PortalLicenseUtil.addFile(fileTransferMessage, (IFileInfo)licenseSync.toUpdate.get(n));
            ++n;
        }
        n = 0;
        while (n < licenseSync.toRemove.size()) {
            fileTransferMessage.addDelete(((IFileInfo)licenseSync.toRemove.get(n)).getInstalledFilePath());
            ++n;
        }
    }

    public static void addLicense(FileTransferMessage fileTransferMessage, LicenseInfo licenseInfo) {
        PortalLicenseUtil.addFile(fileTransferMessage, licenseInfo);
    }

    public static void addCertificate(FileTransferMessage fileTransferMessage, CertificateInfo certificateInfo) {
        PortalLicenseUtil.addFile(fileTransferMessage, certificateInfo);
    }

    public static void addFile(FileTransferMessage fileTransferMessage, IFileInfo iFileInfo) {
        ByteArrayFileTransferElement byteArrayFileTransferElement = new ByteArrayFileTransferElement(iFileInfo.getInstalledFilePath(), iFileInfo.getXmlContent().getBytes(), fileTransferMessage.getTargetFileSpace());
        fileTransferMessage.addElement(byteArrayFileTransferElement);
    }

    public static LicenseSync syncCertificates(CertificateInfo[] certificateInfoArray, CertificateInfo[] certificateInfoArray2) {
        CertificateInfo certificateInfo;
        CertificateInfo certificateInfo2;
        Class clazz = class$com$tridium$platform$license$CertificateInfo;
        if (clazz == null) {
            clazz = class$com$tridium$platform$license$CertificateInfo = PortalLicenseUtil.class("[Lcom.tridium.platform.license.CertificateInfo;", false);
        }
        Array array = new Array(clazz);
        Class clazz2 = class$com$tridium$platform$license$CertificateInfo;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$platform$license$CertificateInfo = PortalLicenseUtil.class("[Lcom.tridium.platform.license.CertificateInfo;", false);
        }
        Array array2 = new Array(clazz2);
        Class clazz3 = class$com$tridium$platform$license$CertificateInfo;
        if (clazz3 == null) {
            clazz3 = class$com$tridium$platform$license$CertificateInfo = PortalLicenseUtil.class("[Lcom.tridium.platform.license.CertificateInfo;", false);
        }
        Array array3 = new Array(clazz3);
        HashMap<String, CertificateInfo> hashMap = new HashMap<String, CertificateInfo>();
        int n = 0;
        while (n < certificateInfoArray.length) {
            certificateInfo2 = certificateInfoArray[n];
            certificateInfo = (CertificateInfo)hashMap.get(certificateInfo2.vendorCertificate.getVendor());
            if (certificateInfo != null) {
                if (certificateInfo2.vendorCertificate.getExpiration() > certificateInfo.vendorCertificate.getExpiration()) {
                    array3.add((Object)certificateInfo);
                    hashMap.put(certificateInfo2.vendorCertificate.getVendor(), certificateInfo2);
                } else if (certificateInfo.vendorCertificate.getExpiration() > certificateInfo2.vendorCertificate.getExpiration()) {
                    array3.add((Object)certificateInfo2);
                } else if (certificateInfo2.file.getFileName().equals(certificateInfo2.getInstalledFileName())) {
                    array3.add((Object)certificateInfo);
                    hashMap.put(certificateInfo2.vendorCertificate.getVendor(), certificateInfo2);
                } else {
                    array3.add((Object)certificateInfo2);
                }
            } else {
                hashMap.put(certificateInfo2.vendorCertificate.getVendor(), certificateInfo2);
            }
            ++n;
        }
        n = 0;
        while (n < certificateInfoArray2.length) {
            certificateInfo2 = certificateInfoArray2[n];
            certificateInfo = (CertificateInfo)hashMap.get(certificateInfo2.vendorCertificate.getVendor());
            if (PortalLicenseUtil.shouldInstall(certificateInfo2, certificateInfo)) {
                boolean bl;
                boolean bl2 = false;
                if (certificateInfo != null) {
                    bl2 = true;
                }
                if (bl = bl2) {
                    String string = certificateInfo2.getInstalledFileName();
                    if (string.equals(certificateInfo.file.getFileName())) {
                        array2.add((Object)certificateInfo2);
                    } else {
                        array3.add((Object)certificateInfo);
                        array.add((Object)certificateInfo2);
                    }
                } else {
                    array.add((Object)certificateInfo2);
                }
            }
            ++n;
        }
        return new LicenseSync(array, array2, array3);
    }

    public static boolean shouldInstall(LicenseInfo licenseInfo, LicenseInfo licenseInfo2) {
        return PortalLicenseUtil.shouldInstall(licenseInfo, licenseInfo2, LicenseInfo.getLocalBrandFeature());
    }

    public static boolean shouldInstall(LicenseInfo licenseInfo, LicenseInfo licenseInfo2, Feature.Brand brand) {
        if (licenseInfo2 == null) {
            return true;
        }
        if (!licenseInfo.allowsWbAccess(brand)) {
            return false;
        }
        String string = licenseInfo.vendorLicense.getSignature();
        String string2 = licenseInfo2.vendorLicense.getSignature();
        return string.equals(string2) ^ true;
    }

    public static boolean shouldInstall(CertificateInfo certificateInfo, CertificateInfo certificateInfo2) {
        if (certificateInfo2 == null) {
            return true;
        }
        String string = certificateInfo.vendorCertificate.getSignature();
        String string2 = certificateInfo2.vendorCertificate.getSignature();
        return string.equals(string2) ^ true;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("connectivity: " + PortalLicenseUtil.checkConnectivity());
        XElem[] xElemArray = PortalLicenseUtil.getCertificates(stringArray);
        int n = 0;
        while (n < xElemArray.length) {
            System.out.println("----- " + n + " -----");
            xElemArray[n].dump();
            ++n;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

