/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.license;

import com.tridium.file.types.text.BLicenseFile;
import com.tridium.platform.license.IFileInfo;
import com.tridium.sys.Nre;
import com.tridium.sys.license.Brand;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.dom.Feature;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.util.LexiconText;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LicenseInfo
implements IFileInfo {
    private static LexiconText neverExpiresFmt = LexiconText.make((String)"platform", (String)"LicenseInfo.neverExpiresFormat");
    private static LexiconText defaultFmt = LexiconText.make((String)"platform", (String)"LicenseInfo.format");
    public static final FilePath LICENSES_PATH = new FilePath("!licenses");
    public VendorLicense vendorLicense;
    public BIFile file;
    static /* synthetic */ Class class$com$tridium$platform$license$LicenseInfo;

    public static LicenseInfo[] make(BIFile[] bIFileArray) throws Exception {
        if (bIFileArray == null) {
            return new LicenseInfo[0];
        }
        LicenseInfo[] licenseInfoArray = new LicenseInfo[bIFileArray.length];
        int n = 0;
        while (n < bIFileArray.length) {
            licenseInfoArray[n] = new LicenseInfo(bIFileArray[n]);
            ++n;
        }
        return licenseInfoArray;
    }

    public static LicenseInfo[] make(XElem[] xElemArray) throws Exception {
        if (xElemArray == null) {
            return new LicenseInfo[0];
        }
        LicenseInfo[] licenseInfoArray = new LicenseInfo[xElemArray.length];
        int n = 0;
        while (n < xElemArray.length) {
            licenseInfoArray[n] = new LicenseInfo(xElemArray[n]);
            ++n;
        }
        return licenseInfoArray;
    }

    public static LicenseInfo[] make(VendorLicense[] vendorLicenseArray) throws Exception {
        LicenseInfo[] licenseInfoArray = new LicenseInfo[vendorLicenseArray.length];
        int n = 0;
        while (n < vendorLicenseArray.length) {
            licenseInfoArray[n] = new LicenseInfo(vendorLicenseArray[n], null);
            ++n;
        }
        return licenseInfoArray;
    }

    public static LicenseInfo[] listLocal() {
        Class clazz = class$com$tridium$platform$license$LicenseInfo;
        if (clazz == null) {
            clazz = class$com$tridium$platform$license$LicenseInfo = LicenseInfo.class("[Lcom.tridium.platform.license.LicenseInfo;", false);
        }
        Array array = new Array(clazz);
        BDirectory bDirectory = (BDirectory)BFileSystem.INSTANCE.findFile(LICENSES_PATH);
        BIFile[] bIFileArray = bDirectory.listFiles();
        int n = 0;
        while (n < bIFileArray.length) {
            if (bIFileArray[n] instanceof BLicenseFile) {
                try {
                    array.add((Object)new LicenseInfo(bIFileArray[n]));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++n;
        }
        return (LicenseInfo[])array.trim();
    }

    public static Feature.Brand getLocalBrandFeature() {
        if (Nre.bootEnv.isRemote()) {
            return null;
        }
        String string = Brand.getBrandId();
        if (string == null) {
            return null;
        }
        LicenseInfo[] licenseInfoArray = LicenseInfo.listLocal();
        int n = 0;
        while (n < licenseInfoArray.length) {
            if (licenseInfoArray[n].vendorLicense.getHostId().equals(Sys.getHostId()) && string.equals(licenseInfoArray[n].getBrand())) {
                return licenseInfoArray[n].vendorLicense.getBrandFeature();
            }
            ++n;
        }
        return null;
    }

    public static int countActiveLicenses(LicenseInfo[] licenseInfoArray, BAbsTime bAbsTime) {
        if (licenseInfoArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < licenseInfoArray.length) {
            if (!licenseInfoArray[n2].isExpired(bAbsTime)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public boolean isExpired() {
        return this.isExpired(BAbsTime.now());
    }

    public boolean isExpired(BAbsTime bAbsTime) {
        if (this.vendorLicense.getExpiration() == 0L) {
            return false;
        }
        boolean bl = false;
        if (this.vendorLicense.getExpiration() < bAbsTime.getMillis()) {
            bl = true;
        }
        return bl;
    }

    public String getBrand() {
        return this.vendorLicense.getBrandId();
    }

    public boolean allowsLocalWbAccess() {
        return this.allowsWbAccess(LicenseInfo.getLocalBrandFeature());
    }

    public boolean allowsLocalStationAccess() {
        return this.allowsStationAccess(LicenseInfo.getLocalBrandFeature());
    }

    public boolean allowsWbAccess(Feature.Brand brand) {
        Feature.Brand brand2 = this.vendorLicense.getBrandFeature();
        if (brand == null || brand2 == null) {
            return true;
        }
        boolean bl = true;
        Brand.AcceptList acceptList = new Brand.AcceptList("accept.wb.in", brand2.getWbIn());
        boolean bl2 = false;
        if (bl && acceptList.accept(brand.getBrandId())) {
            bl2 = true;
        }
        bl = bl2;
        Brand.AcceptList acceptList2 = new Brand.AcceptList("accept.wb.out", brand.getWbOut());
        boolean bl3 = false;
        if (bl && acceptList2.accept(brand2.getBrandId())) {
            bl3 = true;
        }
        bl = bl3;
        return bl;
    }

    public boolean allowsStationAccess(Feature.Brand brand) {
        Feature.Brand brand2 = this.vendorLicense.getBrandFeature();
        if (brand == null || brand2 == null) {
            return true;
        }
        boolean bl = true;
        Brand.AcceptList acceptList = new Brand.AcceptList("accept.station.in", brand2.getStationIn());
        boolean bl2 = false;
        if (bl && acceptList.accept(brand.getBrandId())) {
            bl2 = true;
        }
        bl = bl2;
        Brand.AcceptList acceptList2 = new Brand.AcceptList("accept.station.out", brand.getStationOut());
        boolean bl3 = false;
        if (bl && acceptList2.accept(brand2.getBrandId())) {
            bl3 = true;
        }
        bl = bl3;
        return bl;
    }

    public String getInstalledFileName() {
        return this.getBaseName() + ".license";
    }

    public String getBaseName() {
        String string = this.vendorLicense.getBrandId();
        if (string != null) {
            return TextUtil.capitalize((String)string);
        }
        return TextUtil.capitalize((String)this.vendorLicense.getVendor());
    }

    public String getXmlContent() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.vendorLicense.save((OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toString();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public String getXmlSummary() {
        return LicenseInfo.getXmlSummary(this.vendorLicense);
    }

    public static String getXmlSummary(VendorLicense vendorLicense) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<licenseSummary ");
        stringBuffer.append("hostid=\"" + vendorLicense.getHostId() + "\" ");
        stringBuffer.append("vendor=\"" + vendorLicense.getVendor() + "\" ");
        String string = vendorLicense.getBrandId();
        if (string != null) {
            stringBuffer.append("brand=\"" + string + "\" ");
        }
        stringBuffer.append("expiration=\"" + vendorLicense.getExpiration() + "\" ");
        stringBuffer.append("signature=\"" + vendorLicense.getSignature() + "\"/>");
        return stringBuffer.toString();
    }

    public FilePath getInstalledFilePath() {
        return LICENSES_PATH.merge(this.getInstalledFileName());
    }

    public void write(OutputStream outputStream) throws Exception {
        this.write(outputStream, true);
    }

    public void write(OutputStream outputStream, boolean bl) throws Exception {
        this.vendorLicense.save(outputStream, bl);
    }

    public String toString() {
        return this.toString(null);
    }

    public static String getSummaryText(VendorLicense vendorLicense, Context context) {
        return LicenseInfo.getSummaryText(vendorLicense.getLicenseName() + ".license", vendorLicense, context);
    }

    public String toString(Context context) {
        String string = this.file != null && this.file instanceof BLicenseFile ? this.file.getFileName() : this.getInstalledFileName();
        return LicenseInfo.getSummaryText(string, this.vendorLicense, context);
    }

    public static String getSummaryText(String string, VendorLicense vendorLicense, Context context) {
        if (vendorLicense.getExpiration() == Long.MAX_VALUE) {
            return neverExpiresFmt.getText(context, new Object[]{string, vendorLicense.getVendor(), vendorLicense.getVersion()});
        }
        return defaultFmt.getText(context, new Object[]{string, vendorLicense.getVendor(), vendorLicense.getVersion(), LicenseUtil.formatDate((long)vendorLicense.getExpiration())});
    }

    public BIFile getFile() {
        return this.file;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public LicenseInfo(XElem xElem) throws Exception {
        this(xElem, null);
    }

    public LicenseInfo(BIFile bIFile) throws Exception {
        this(VendorLicense.make((BIFile)bIFile), bIFile);
    }

    public LicenseInfo(XElem xElem, BIFile bIFile) throws Exception {
        this(VendorLicense.make((String)(bIFile == null ? "LicenseInfo" : bIFile.getFileName()), (XElem)xElem), bIFile);
    }

    public LicenseInfo(VendorLicense vendorLicense, BIFile bIFile) {
        this.vendorLicense = vendorLicense;
        this.file = bIFile;
    }

    public LicenseInfo(InputStream inputStream) throws Exception {
        this(inputStream, true);
    }

    public LicenseInfo(InputStream inputStream, boolean bl) throws Exception {
        this(XParser.make((InputStream)inputStream).parse(bl), null);
    }
}

