/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.hx.util;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.hx.util.NotNullStringValidator;
import com.tridium.platform.hx.util.SimpleValidator;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TcpIpAddressValidator
implements SimpleValidator {
    public static TcpIpAddressValidator INSTANCE = new TcpIpAddressValidator(false, false);
    public static TcpIpAddressValidator INSTANCE_SUBNET = new TcpIpAddressValidator(false, false, true);
    public static TcpIpAddressValidator INSTANCEv6 = new TcpIpAddressValidator(true, false);
    public static TcpIpAddressValidator INSTANCE_PERMIT_NULL = new TcpIpAddressValidator(false, true);
    public static TcpIpAddressValidator INSTANCEv6_PERMIT_NULL = new TcpIpAddressValidator(true, true);
    private boolean isIpv6;
    private boolean allowNull;
    private boolean isSubnet;

    public void checkValid(String string, BSimple bSimple, Context context) throws Exception {
        if (!this.allowNull) {
            NotNullStringValidator.INSTANCE.checkValid(string, bSimple, context);
        }
        String string2 = bSimple.toString();
        if (this.allowNull && string2.length() == 0) {
            return;
        }
        if (!this.isIpv6) {
            if (!this.isSubnet) {
                if (!IPAddressUtil.isIpv4Address((String)string2)) {
                    throw new LocalizableRuntimeException("platform", "validator.error.badIpAddress", (Object[])new String[]{string});
                }
            } else if (!IPAddressUtil.isIpv4SubnetMask((String)string2)) {
                throw new LocalizableRuntimeException("platform", "validator.error.badSubnetMask", (Object[])new String[]{string});
            }
        } else if (!IPAddressUtil.isIpv6Address((String)string2)) {
            throw new LocalizableRuntimeException("platform", "validator.error.badIpv6Address", (Object[])new String[]{string});
        }
    }

    private final /* synthetic */ void this() {
        this.isIpv6 = false;
        this.allowNull = false;
        this.isSubnet = false;
    }

    private TcpIpAddressValidator() {
        this(false, false);
    }

    private TcpIpAddressValidator(boolean bl, boolean bl2) {
        this(bl, bl2, false);
    }

    private TcpIpAddressValidator(boolean bl, boolean bl2, boolean bl3) {
        this.this();
        this.isIpv6 = bl;
        this.allowNull = bl2;
        this.isSubnet = bl3;
    }
}

