/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import javax.baja.sys.BAbsTime;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;

public class UpdateTimeMessage
extends XmlResponseMessage {
    private StringBuffer message;

    public String getMessageString() {
        return this.message.toString();
    }

    public UpdateTimeMessage(BAbsTime bAbsTime, String string) {
        this(bAbsTime, string, null);
    }

    public UpdateTimeMessage(BAbsTime bAbsTime, String string, BTimeZone bTimeZone) {
        long l = System.currentTimeMillis();
        this.message = new StringBuffer("time?update=true");
        if (bAbsTime != null) {
            this.message.append("&time=" + bAbsTime.getMillis());
        }
        if (string != null) {
            this.message.append("&bajaTzId=");
            this.message.append(HttpUtil.encodeUrl((String)string));
        }
        if (bTimeZone != null) {
            this.message.append("&tzId=");
            this.message.append(HttpUtil.encodeUrl((String)bTimeZone.getId()));
            this.message.append("&tzUtcOffset=");
            if (bAbsTime != null) {
                this.message.append(String.valueOf(bTimeZone.getUtcOffset(bAbsTime.getMillis()) / 60000));
            } else {
                this.message.append(String.valueOf(bTimeZone.getUtcOffset(l) / 60000));
            }
            this.message.append("&dstOffset=");
            if (bAbsTime != null) {
                this.message.append(String.valueOf(bTimeZone.getDaylightAdjustment(bAbsTime.getMillis()) / 60000));
            } else {
                this.message.append(String.valueOf(bTimeZone.getDaylightAdjustment(l) / 60000));
            }
            DstRule dstRule = null;
            dstRule = bAbsTime != null ? DstRule.getWallTimeRule((DstRule)bTimeZone.getDaylightStartRule(bAbsTime.getMillis()), (int)0, (BTimeZone)bTimeZone) : DstRule.getWallTimeRule((DstRule)bTimeZone.getDaylightStartRule(l), (int)0, (BTimeZone)bTimeZone);
            if (dstRule != null) {
                this.message.append("&dstStartHour=");
                this.message.append(String.valueOf(dstRule.getTime().getHour()));
                this.message.append("&dstStartMinute=");
                this.message.append(String.valueOf(dstRule.getTime().getMinute()));
                this.message.append("&dstStartMonth=");
                this.message.append(String.valueOf(dstRule.getMonth().getOrdinal()));
                this.message.append("&dstStartDay=");
                this.message.append(String.valueOf(dstRule.getDay()));
                this.message.append("&dstStartDayMode=");
                this.message.append(String.valueOf(dstRule.getDayMode()));
                this.message.append("&dstStartWeek=");
                this.message.append(String.valueOf(dstRule.getWeek()));
                if (dstRule.getWeekday() != null) {
                    this.message.append("&dstStartWeekDay=");
                    this.message.append(String.valueOf(dstRule.getWeekday().getOrdinal()));
                }
            }
            DstRule dstRule2 = null;
            dstRule2 = bAbsTime != null ? DstRule.getWallTimeRule((DstRule)bTimeZone.getDaylightEndRule(bAbsTime.getMillis()), (int)1, (BTimeZone)bTimeZone) : DstRule.getWallTimeRule((DstRule)bTimeZone.getDaylightEndRule(l), (int)1, (BTimeZone)bTimeZone);
            if (dstRule2 != null) {
                this.message.append("&dstEndHour=");
                this.message.append(String.valueOf(dstRule2.getTime().getHour()));
                this.message.append("&dstEndMinute=");
                this.message.append(String.valueOf(dstRule2.getTime().getMinute()));
                this.message.append("&dstEndMonth=");
                this.message.append(String.valueOf(dstRule2.getMonth().getOrdinal()));
                this.message.append("&dstEndDay=");
                this.message.append(String.valueOf(dstRule2.getDay()));
                this.message.append("&dstEndDayMode=");
                this.message.append(String.valueOf(dstRule2.getDayMode()));
                this.message.append("&dstEndWeek=");
                this.message.append(String.valueOf(dstRule2.getWeek()));
                if (dstRule2.getWeekday() != null) {
                    this.message.append("&dstEndWeekDay=");
                    this.message.append(String.valueOf(dstRule2.getWeekday().getOrdinal()));
                }
            }
        }
    }
}

