/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.FileTransferMessage;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.Set;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileTransferMessageElement {
    private static final BIcon icon = BIcon.std((String)"file.png");
    private static final Lexicon lex = Sys.loadModule((String)"platform").getLexicon();
    private InputStream stream;
    private long size;
    private long existingSize;
    private String shortUri;
    private long transferTotal;
    private long transferComplete;
    private FilePath path;
    private BDaemonFileSpace space;

    public String getRequestMethod() {
        return "POST";
    }

    public String getFullUri(FileTransferMessage fileTransferMessage, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(this.getUri());
        if (fileTransferMessage.isAutoCommit()) {
            stringBuffer.append("?transaction=standalone");
        } else if (bl) {
            stringBuffer.append("?transaction=new");
        } else {
            if (fileTransferMessage.getTransactionId() == null) {
                throw new IllegalStateException("program error: missing transaction id");
            }
            stringBuffer.append("?transaction=current&transactionId=");
            stringBuffer.append(fileTransferMessage.getTransactionId());
        }
        return stringBuffer.toString();
    }

    public String getUri() {
        return this.shortUri;
    }

    public FilePath getFilePath() {
        return this.path;
    }

    public InputStream getStream() throws IOException {
        return this.stream;
    }

    protected BDaemonFileSpace getDaemonFileSpace() {
        return this.space;
    }

    public long getSize() {
        return this.size;
    }

    public void initProgress() {
        this.transferComplete = 0L;
        this.transferTotal = this.getSize();
    }

    public void updateProgress(int n) {
        this.transferComplete += (long)n;
    }

    public int getProgress() {
        return this.transferTotal == 0L ? 100 : (int)(100.0 * (double)this.transferComplete / (double)this.transferTotal);
    }

    public void updateTransferInfo(Set set, Set set2) {
        set.remove(this.getFilePath());
        set2.add(this.getFilePath());
    }

    public BIcon getIcon() {
        return icon;
    }

    public String toString() {
        return this.getRequestMethod() + ' ' + this.getUri();
    }

    protected String getProgressLexiconKey() {
        return "FileTransferMessageElement.progress";
    }

    public String getProgressText() {
        return lex.getText(this.getProgressLexiconKey(), new Object[]{HttpUtil.decodeUrl((String)this.getUri())});
    }

    public long getSizeDelta(BDaemonSession bDaemonSession, FileTransferMessage fileTransferMessage) throws AuthenticationException, ConnectException {
        return this.getSize() - this.getExistingSize(bDaemonSession, fileTransferMessage);
    }

    public long getExistingSize(BDaemonSession bDaemonSession, FileTransferMessage fileTransferMessage) throws AuthenticationException, ConnectException {
        if (this.existingSize == (long)-1) {
            Object object;
            int n = fileTransferMessage.getCache().getCacheStatus(this.getFilePath());
            if (n == 0) {
                object = fileTransferMessage.getCache().getStore(this.getFilePath());
                this.existingSize = object.isDirectory() ? 0L : object.getSize();
            } else if (n == 1) {
                this.existingSize = 0L;
            }
            if (this.existingSize < 0L) {
                object = BDaemonDirectoryStore.make(bDaemonSession.getFileSpace(), this.getFilePath().getParent(), fileTransferMessage.getCache());
                if (object == null) {
                    fileTransferMessage.getCache().cacheNotFound(this.getFilePath());
                    this.existingSize = 0L;
                } else {
                    BIFileStore bIFileStore = object.getChild(this.getFilePath().getName());
                    this.existingSize = bIFileStore == null ? 0L : bIFileStore.getSize();
                }
            }
        }
        return this.existingSize;
    }

    private final /* synthetic */ void this() {
        this.existingSize = -1;
    }

    protected FileTransferMessageElement(FilePath filePath, BDaemonFileSpace bDaemonFileSpace) {
        this.this();
        this.shortUri = bDaemonFileSpace.filePathToUri(filePath);
        this.path = filePath;
        this.space = bDaemonFileSpace;
    }

    public FileTransferMessageElement(FilePath filePath, InputStream inputStream, long l, BDaemonFileSpace bDaemonFileSpace) {
        this(filePath, bDaemonFileSpace);
        this.stream = inputStream;
        this.size = l;
    }
}

