/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.FilePathComparator;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.FileFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.MkDirFileTransferMessageElement;
import com.tridium.platform.daemon.message.RenameFileTransferMessageElement;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BajaRuntimeException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileTransferMessage {
    private Map deletesByFilePath;
    private Array posts;
    private boolean autoCommit;
    private String transactionId;
    private long transferTotal;
    private long transferComplete;
    private StoreCache cache;
    private BDaemonFileSpace fileSpace;
    static /* synthetic */ Class class$com$tridium$platform$daemon$message$FileTransferMessageElement;
    static /* synthetic */ Class class$javax$baja$file$FilePath;

    public static FileTransferMessage make(BIFile bIFile, BDaemonFileSpace bDaemonFileSpace) throws IOException {
        FileTransferMessage fileTransferMessage = new FileTransferMessage(bDaemonFileSpace);
        fileTransferMessage.addFile(bIFile);
        return fileTransferMessage;
    }

    public static FileTransferMessage make(BIFile bIFile, FilePath filePath, BDaemonFileSpace bDaemonFileSpace) throws IOException {
        FileTransferMessage fileTransferMessage = new FileTransferMessage(bDaemonFileSpace);
        fileTransferMessage.addFile(bIFile, filePath);
        return fileTransferMessage;
    }

    public static FileTransferMessage makeDelete(FilePath filePath, BDaemonFileSpace bDaemonFileSpace) {
        FileTransferMessage fileTransferMessage = new FileTransferMessage(bDaemonFileSpace);
        fileTransferMessage.addElement(new DeleteFileTransferMessageElement(filePath, bDaemonFileSpace));
        return fileTransferMessage;
    }

    public static FileTransferMessage makeMkDir(FilePath filePath, BDaemonFileSpace bDaemonFileSpace) {
        FileTransferMessage fileTransferMessage = new FileTransferMessage(bDaemonFileSpace);
        fileTransferMessage.addElement(new MkDirFileTransferMessageElement(filePath, bDaemonFileSpace));
        return fileTransferMessage;
    }

    public static FileTransferMessage makeRename(FilePath filePath, String string, BDaemonFileSpace bDaemonFileSpace) {
        FileTransferMessage fileTransferMessage = new FileTransferMessage(bDaemonFileSpace);
        fileTransferMessage.addElement(new RenameFileTransferMessageElement(filePath, string, bDaemonFileSpace));
        return fileTransferMessage;
    }

    public StoreCache getCache() {
        return this.cache;
    }

    public void addElement(InputStream inputStream, FilePath filePath, long l) {
        this.addElement(new FileTransferMessageElement(filePath, inputStream, l, this.fileSpace));
    }

    public void addFile(BIFile bIFile, FilePath filePath) throws IOException {
        this.addElement(new FileFileTransferElement(filePath, bIFile, this.fileSpace));
    }

    public void addElement(FileTransferMessageElement fileTransferMessageElement) {
        if (fileTransferMessageElement.getRequestMethod().equals("DELETE")) {
            FilePath filePath = fileTransferMessageElement.getFilePath();
            while (filePath != null) {
                if (this.deletesByFilePath.containsKey(filePath)) {
                    return;
                }
                filePath = filePath.getParent();
            }
            Class clazz = class$javax$baja$file$FilePath;
            if (clazz == null) {
                clazz = class$javax$baja$file$FilePath = FileTransferMessage.class("[Ljavax.baja.file.FilePath;", false);
            }
            Array array = new Array(clazz);
            String string = fileTransferMessageElement.getFilePath().getBody() + '/';
            Iterator iterator = this.deletesByFilePath.keySet().iterator();
            while (iterator.hasNext()) {
                FilePath filePath2 = (FilePath)iterator.next();
                if (!filePath2.getBody().startsWith(string)) continue;
                array.add((Object)filePath2);
            }
            int n = 0;
            while (n < array.size()) {
                this.deletesByFilePath.remove(array.get(n));
                ++n;
            }
            this.deletesByFilePath.put(fileTransferMessageElement.getFilePath(), fileTransferMessageElement);
        } else {
            this.posts.add((Object)fileTransferMessageElement);
        }
    }

    public void addDelete(FilePath filePath) {
        this.addElement(new DeleteFileTransferMessageElement(filePath, this.fileSpace));
    }

    public void addFile(BIFile bIFile) throws IOException {
        this.addFile(bIFile, bIFile.getFilePath());
    }

    public String getCommitUri() {
        if (this.autoCommit || this.transactionId == null) {
            return null;
        }
        return "/niagara/?transaction=commit&transactionId=" + this.transactionId;
    }

    public String getAbortUri() {
        if (this.autoCommit || this.transactionId == null) {
            return null;
        }
        return "/niagara/?transaction=abort&transactionId=" + this.transactionId;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public BDaemonFileSpace getTargetFileSpace() {
        return this.fileSpace;
    }

    public Array getElements(BDaemonSession bDaemonSession) throws ConnectException, AuthenticationException {
        try {
            Class clazz = class$com$tridium$platform$daemon$message$FileTransferMessageElement;
            if (clazz == null) {
                clazz = class$com$tridium$platform$daemon$message$FileTransferMessageElement = FileTransferMessage.class("[Lcom.tridium.platform.daemon.message.FileTransferMessageElement;", false);
            }
            Array array = new Array(clazz);
            array.addAll(this.deletesByFilePath.values());
            array.addAll(this.posts);
            return array.sort((Comparator)new ElementComparator(bDaemonSession));
        }
        catch (BajaRuntimeException bajaRuntimeException) {
            Throwable throwable = bajaRuntimeException.getCause();
            if (throwable instanceof ConnectException) {
                throw (ConnectException)throwable;
            }
            if (throwable instanceof AuthenticationException) {
                throw (AuthenticationException)throwable;
            }
            throw bajaRuntimeException;
        }
    }

    public void setTransactionId(String string) {
        this.transactionId = string;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void initProgress() {
        this.transferTotal = 0L;
        this.transferComplete = 0L;
        int n = 0;
        while (n < this.posts.size()) {
            FileTransferMessageElement fileTransferMessageElement = (FileTransferMessageElement)this.posts.get(n);
            this.transferTotal += fileTransferMessageElement.getSize();
            fileTransferMessageElement.initProgress();
            ++n;
        }
    }

    public void updateProgress(FileTransferMessageElement fileTransferMessageElement, int n) {
        fileTransferMessageElement.updateProgress(n);
        this.transferComplete += (long)n;
    }

    public int getProgress() {
        return this.transferTotal == 0L ? 100 : (int)(100.0 * (double)this.transferComplete / (double)this.transferTotal);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.transactionId = null;
        this.transferTotal = 0L;
        this.transferComplete = 0L;
    }

    public FileTransferMessage(StoreCache storeCache, BDaemonFileSpace bDaemonFileSpace) {
        this(false, storeCache, bDaemonFileSpace);
    }

    public FileTransferMessage(BDaemonFileSpace bDaemonFileSpace) {
        this(false, bDaemonFileSpace);
    }

    public FileTransferMessage(boolean bl, BDaemonFileSpace bDaemonFileSpace) {
        this(bl, new StoreCache(), bDaemonFileSpace);
    }

    public FileTransferMessage(boolean bl, StoreCache storeCache, BDaemonFileSpace bDaemonFileSpace) {
        this.this();
        this.autoCommit = bl;
        this.deletesByFilePath = new TreeMap(FilePathComparator.INSTANCE);
        Class clazz = class$com$tridium$platform$daemon$message$FileTransferMessageElement;
        if (clazz == null) {
            clazz = class$com$tridium$platform$daemon$message$FileTransferMessageElement = FileTransferMessage.class("[Lcom.tridium.platform.daemon.message.FileTransferMessageElement;", false);
        }
        this.posts = new Array(clazz);
        this.cache = storeCache;
        this.fileSpace = bDaemonFileSpace;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ElementComparator
    implements Comparator {
        private BDaemonSession session;

        public int compare(Object object, Object object2) {
            try {
                FileTransferMessageElement fileTransferMessageElement = (FileTransferMessageElement)object;
                FileTransferMessageElement fileTransferMessageElement2 = (FileTransferMessageElement)object2;
                if (fileTransferMessageElement.getRequestMethod().equals(fileTransferMessageElement2.getRequestMethod())) {
                    long l;
                    long l2 = fileTransferMessageElement.getSizeDelta(this.session, FileTransferMessage.this);
                    if (l2 == (l = fileTransferMessageElement.getSizeDelta(this.session, FileTransferMessage.this))) {
                        return fileTransferMessageElement.getUri().compareTo(fileTransferMessageElement2.getUri());
                    }
                    if (l2 < l) {
                        return -1;
                    }
                    return 1;
                }
                if (fileTransferMessageElement.getRequestMethod().equals("DELETE")) {
                    return -1;
                }
                return 1;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object == this) {
                bl = true;
            }
            return bl;
        }

        public ElementComparator(BDaemonSession bDaemonSession) {
            this.session = bDaemonSession;
        }
    }
}

