/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.FilePathComparator;
import com.tridium.platform.daemon.file.StoreCache;
import java.util.Collection;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;

public class FileCache
extends StoreCache {
    public static final int FOUND = 0;
    public static final int NOT_FOUND = 1;
    public static final int UNKNOWN = 2;
    private TreeSet pathsNotFound = new TreeSet(FilePathComparator.INSTANCE);
    private TreeMap fileByPath = new TreeMap(FilePathComparator.INSTANCE);
    private TreeSet completedPaths = new TreeSet(FilePathComparator.INSTANCE);
    private BFileSpace space;

    public int getCacheStatus(FilePath filePath) {
        if (this.pathsNotFound.contains(filePath)) {
            return 1;
        }
        if (this.fileByPath.containsKey(filePath)) {
            return 0;
        }
        if (this.completedPaths.contains(filePath.getParent())) {
            return 1;
        }
        return 2;
    }

    public BIFile getFile(FilePath filePath) {
        return (BIFile)this.fileByPath.get(filePath);
    }

    public BIFileStore getStore(FilePath filePath) {
        BIFile bIFile = this.getFile(filePath);
        return bIFile == null ? null : bIFile.getStore();
    }

    public Collection getCachedFiles() {
        return this.fileByPath.values();
    }

    public Set getCachedFilePaths() {
        return this.fileByPath.keySet();
    }

    public void cacheResult(BIFileStore bIFileStore) {
        this.cacheResult(this.space.makeFile(bIFileStore));
    }

    public void cacheResult(BIFile bIFile) {
        this.fileByPath.put(bIFile.getFilePath(), bIFile);
    }

    public void cacheNotFound(FilePath filePath) {
        this.pathsNotFound.add(filePath);
    }

    public void cacheCompleted(FilePath filePath) {
        this.completedPaths.add(filePath);
    }

    public void clear() {
        this.pathsNotFound.clear();
        this.fileByPath.clear();
        this.completedPaths.clear();
    }

    public void clear(FilePath filePath) {
        Object object;
        Object object2;
        TreeSet<Object> treeSet = new TreeSet<Object>(FilePathComparator.INSTANCE);
        Object object3 = this.pathsNotFound.iterator();
        while (object3.hasNext()) {
            object2 = new FilePath((String)object3.next());
            if (DaemonFileUtil.isSubPath((FilePath)object2, filePath)) continue;
            treeSet.add(object2);
        }
        object3 = new TreeMap(FilePathComparator.INSTANCE);
        object2 = this.fileByPath.keySet().iterator();
        while (object2.hasNext()) {
            object = (FilePath)object2.next();
            if (DaemonFileUtil.isSubPath((FilePath)object, filePath)) continue;
            ((TreeMap)object3).put(object, this.fileByPath.get(object));
        }
        object2 = new TreeSet(FilePathComparator.INSTANCE);
        object = this.completedPaths.iterator();
        while (object.hasNext()) {
            FilePath filePath2 = (FilePath)object.next();
            if (DaemonFileUtil.isSubPath(filePath2, filePath)) continue;
            ((TreeSet)object2).add(filePath2);
        }
        this.pathsNotFound = treeSet;
        this.fileByPath = object3;
        this.completedPaths = object2;
    }

    public FileCache(BFileSpace bFileSpace) {
        this.space = bFileSpace;
    }
}

