/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.net.HttpUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.FileCache;
import com.tridium.platform.daemon.file.FilePathComparator;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BIcon;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BDaemonFileSpace
extends BFileSpace {
    public static final Type TYPE;
    protected FilePath sysHomePathFromRoot;
    protected BDirectory[] roots;
    protected boolean initializing;
    static /* synthetic */ Class class$com$tridium$platform$daemon$file$BDaemonFileSpace;

    public Type getType() {
        return TYPE;
    }

    public abstract BDaemonSession getDaemonSession();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void init() throws ConnectException, AuthenticationException {
        if (this.initializing) return;
        if (this.roots != null) {
            return;
        }
        this.initializing = true;
        try {
            ArrayList<BDirectory> arrayList;
            block8: {
                Object object;
                arrayList = new ArrayList<BDirectory>();
                String string = null;
                BDaemonDirectoryStore bDaemonDirectoryStore = BDaemonDirectoryStore.make(this, new FilePath("!"));
                if (bDaemonDirectoryStore != null) {
                    object = new BDirectory((BIFileStore)bDaemonDirectoryStore, LexiconText.make((String)"platform", (String)"nav.sysHomeReadOnly"));
                    string = bDaemonDirectoryStore.getLocalPath();
                    object.setIcon(BIcon.std((String)"home.png"));
                    arrayList.add((BDirectory)object);
                }
                try {
                    bDaemonDirectoryStore = BDaemonDirectoryStore.make(this, new FilePath("/"));
                    if (bDaemonDirectoryStore == null) break block8;
                    arrayList.add(new BDirectory((BIFileStore)bDaemonDirectoryStore, LexiconText.make((String)"platform", (String)"nav.rootReadOnly")));
                    if (string != null && string.startsWith((String)(object = bDaemonDirectoryStore.getLocalPath()))) {
                        this.sysHomePathFromRoot = new FilePath(string.substring(((String)object).length()));
                    }
                }
                catch (Exception exception) {}
            }
            this.roots = arrayList.toArray(new BDirectory[arrayList.size()]);
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.initializing = false;
            throw throwable;
        }
        {
            Object var2_7 = null;
            this.initializing = false;
            return;
        }
    }

    public String filePathToUri(FilePath filePath) {
        StringBuffer stringBuffer;
        String[] stringArray = filePath.getNames();
        int n = 0;
        if (filePath.isLocalAbsolute()) {
            if (stringArray.length > 0 && stringArray[0].equals("niagara")) {
                stringBuffer = new StringBuffer("/niagara");
                n = 1;
            } else {
                stringBuffer = new StringBuffer("/files");
            }
        } else if (filePath.isSysHomeAbsolute()) {
            stringBuffer = new StringBuffer("/niagara");
        } else {
            throw new BajaRuntimeException("file path must be local or sys home absolute " + filePath.getBody());
        }
        int n2 = n;
        while (n2 < stringArray.length) {
            stringBuffer.append('/');
            stringBuffer.append(HttpUtil.encodeUrl((String)stringArray[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean hasNavChildren() {
        return true;
    }

    public String getNavDescription(Context context) {
        return this.getLexicon().getText("DaemonFileSpace.navDesc");
    }

    public FilePath getAltPath(FilePath filePath) {
        if (this.initializing) {
            return null;
        }
        try {
            this.init();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        if (this.sysHomePathFromRoot == null) {
            return null;
        }
        if (filePath.isLocalAbsolute()) {
            if (filePath.depth() < this.sysHomePathFromRoot.depth()) {
                return null;
            }
            int n = 0;
            while (n < this.sysHomePathFromRoot.depth()) {
                if (!filePath.nameAt(n).equals(this.sysHomePathFromRoot.nameAt(n))) {
                    return null;
                }
                ++n;
            }
            FilePath filePath2 = new FilePath("!");
            int n2 = this.sysHomePathFromRoot.depth();
            while (n2 < filePath.depth()) {
                filePath2 = filePath2.merge(filePath.nameAt(n2));
                ++n2;
            }
            return filePath2;
        }
        if (filePath.isSysHomeAbsolute()) {
            FilePath filePath3 = new FilePath("/");
            filePath3 = filePath3.merge(this.sysHomePathFromRoot);
            int n = 0;
            while (n < filePath.depth()) {
                filePath3 = filePath3.merge(filePath.nameAt(n));
                ++n;
            }
            return filePath3;
        }
        return null;
    }

    public BIFile[] listFiles() {
        try {
            this.init();
            return (BIFile[])this.roots.clone();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BIFile getChild(BIFile bIFile, String string) {
        return this.getChild(bIFile, string, BCacheAccessPolicy.forceFetch);
    }

    public BIFile[] getChildren(BIFile bIFile) {
        return this.getChildren(bIFile, BCacheAccessPolicy.forceFetch);
    }

    public BIFile findFile(FilePath filePath) {
        return this.findFile(filePath, BCacheAccessPolicy.forceFetch);
    }

    public BIFileStore findStore(FilePath filePath) {
        return this.findStore(filePath, BCacheAccessPolicy.forceFetch);
    }

    public abstract BIFile getChild(BIFile var1, String var2, BCacheAccessPolicy var3);

    public abstract BIFile[] getChildren(BIFile var1, BCacheAccessPolicy var2);

    public abstract BIFile findFile(FilePath var1, BCacheAccessPolicy var2);

    public abstract BIFileStore findStore(FilePath var1, BCacheAccessPolicy var2);

    public void notify(Set set, Set set2) {
        BIFile bIFile;
        BDirectory bDirectory;
        Object object;
        FileCache fileCache = new FileCache(this);
        TreeSet<NavEvent> treeSet = new TreeSet<NavEvent>(new Comparator(){

            public final int compare(Object object, Object object2) {
                NavEvent navEvent = (NavEvent)object;
                NavEvent navEvent2 = (NavEvent)object2;
                if (navEvent.getId() != navEvent2.getId()) {
                    return navEvent.getId() < navEvent2.getId() ? 1 : -1;
                }
                int n = navEvent.getParentOrd().toString().compareTo(navEvent2.getParentOrd().toString());
                if (n != 0) {
                    return n;
                }
                if (navEvent.getId() == 1) {
                    return navEvent.getNewChildName().compareTo(navEvent2.getNewChildName());
                }
                return navEvent.getOldChildName().compareTo(navEvent2.getOldChildName());
            }
        });
        TreeSet<FilePath> treeSet2 = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
        treeSet2.addAll(set);
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            object = this.getAltPath((FilePath)object2.next());
            if (object == null) continue;
            treeSet2.add((FilePath)object);
        }
        object2 = treeSet2.iterator();
        while (object2.hasNext()) {
            object = (FilePath)object2.next();
            bDirectory = this.findDirectoryForNotify(object.getParent(), fileCache);
            if (bDirectory == null || (bIFile = this.getChild((BIFile)bDirectory, object.getName(), BCacheAccessPolicy.cacheOnly)) == null) continue;
            treeSet.add(NavEvent.makeRemoved((BOrd)bDirectory.getNavOrd(), (String)object.getName(), null));
        }
        object2 = new TreeSet(FilePathComparator.INSTANCE);
        object2.addAll(set2);
        object = set2.iterator();
        while (object.hasNext()) {
            bIFile = this.getAltPath((FilePath)object.next());
            if (bIFile == null) continue;
            object2.add(bIFile);
        }
        object = object2.iterator();
        block3: while (object.hasNext()) {
            BIFile bIFile2;
            bIFile = (FilePath)object.next();
            bDirectory = this.findDirectoryForNotify(bIFile.getParent(), fileCache);
            if (bDirectory == null) {
                bIFile2 = (BIFile)this.getNavChild(bIFile.getAbsoluteBase());
                if (bIFile2 == null) continue;
                int n = 0;
                while (n < bIFile.depth() - 1) {
                    BIFile bIFile3 = this.getChild(bIFile2, bIFile.nameAt(n), BCacheAccessPolicy.cacheOnly);
                    if (bIFile3 == null) {
                        treeSet.add(NavEvent.makeAdded((BOrd)bIFile2.getNavOrd(), (String)bIFile.nameAt(n), null));
                        continue block3;
                    }
                    bIFile2 = bIFile3;
                    ++n;
                }
                continue;
            }
            bIFile2 = this.getChild((BIFile)bDirectory, bIFile.getName(), BCacheAccessPolicy.cacheOnly);
            if (bIFile2 == null) continue;
            treeSet.add(NavEvent.makeAdded((BOrd)bDirectory.getNavOrd(), (String)bIFile.getName(), null));
        }
        object = fileCache.getCachedFiles().iterator();
        while (object.hasNext()) {
            bDirectory = (BDirectory)object.next();
            ((BDaemonDirectoryStore)bDirectory.getStore()).reset();
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            bIFile = (NavEvent)object.next();
            BNavRoot.INSTANCE.fireNavEvent((NavEvent)bIFile);
        }
    }

    private final BDirectory findDirectoryForNotify(FilePath filePath, FileCache fileCache) {
        if (filePath == null) {
            return null;
        }
        switch (fileCache.getCacheStatus(filePath)) {
            case 2: {
                BDirectory bDirectory = (BDirectory)this.findFile(filePath, BCacheAccessPolicy.cacheOnly);
                if (bDirectory == null) {
                    fileCache.cacheNotFound(filePath);
                } else {
                    fileCache.cacheResult((BIFile)bDirectory);
                }
                return bDirectory;
            }
            case 0: {
                return (BDirectory)fileCache.getFile(filePath);
            }
        }
        return null;
    }

    public void notifyTransferred(FilePath filePath) {
        TreeSet<FilePath> treeSet = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
        treeSet.add(filePath);
        this.notify(new TreeSet(FilePathComparator.INSTANCE), treeSet);
    }

    public void notifyRemoved(FilePath filePath) {
        TreeSet<FilePath> treeSet = new TreeSet<FilePath>(FilePathComparator.INSTANCE);
        treeSet.add(filePath);
        this.notify(treeSet, new TreeSet(FilePathComparator.INSTANCE));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sysHomePathFromRoot = null;
        this.roots = null;
        this.initializing = false;
    }

    public BDaemonFileSpace() {
        super("file", LexiconText.make((String)"platform", (String)"nav.daemonFileSpace"));
        this.this();
    }

    static {
        Class clazz = class$com$tridium$platform$daemon$file$BDaemonFileSpace;
        if (clazz == null) {
            clazz = class$com$tridium$platform$daemon$file$BDaemonFileSpace = BDaemonFileSpace.class("[Lcom.tridium.platform.daemon.file.BDaemonFileSpace;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

