/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.GetDirectoryMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.InputStream;
import java.net.ConnectException;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Clock;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDaemonDirectoryStore
extends BAbstractFileStore {
    public static final Type TYPE;
    private String fileUri;
    private XElem element;
    private boolean recurseDir;
    private boolean sendCrc;
    private boolean sendLocalPath;
    private StoreCache cache;
    private FilePath altPath;
    private Array children;
    static /* synthetic */ Class class$com$tridium$platform$daemon$file$BDaemonDirectoryStore;

    public Type getType() {
        return TYPE;
    }

    public static BDaemonDirectoryStore make(BDaemonFileSpace bDaemonFileSpace, FilePath filePath) throws ConnectException, SecurityException {
        return BDaemonDirectoryStore.make(bDaemonFileSpace, filePath, false, false, true, null);
    }

    public static BDaemonDirectoryStore make(BDaemonFileSpace bDaemonFileSpace, FilePath filePath, StoreCache storeCache) throws ConnectException, SecurityException {
        return BDaemonDirectoryStore.make(bDaemonFileSpace, filePath, false, false, true, storeCache);
    }

    public static BDaemonDirectoryStore make(BDaemonFileSpace bDaemonFileSpace, FilePath filePath, boolean bl, boolean bl2, boolean bl3, StoreCache storeCache) throws ConnectException, SecurityException {
        return BDaemonDirectoryStore.make(bDaemonFileSpace, filePath, bl, bl2, bl3, storeCache, BDaemonSession.DEFAULT_TIMEOUT);
    }

    public static BDaemonDirectoryStore make(BDaemonFileSpace bDaemonFileSpace, FilePath filePath, boolean bl, boolean bl2, boolean bl3, StoreCache storeCache, int n) throws ConnectException, SecurityException {
        XElem xElem;
        FilePath filePath2 = bDaemonFileSpace.getAltPath(filePath);
        if (storeCache != null) {
            int n2 = storeCache.getCacheStatus(filePath);
            if (n2 == 1) {
                return null;
            }
            if (n2 == 0) {
                return (BDaemonDirectoryStore)storeCache.getStore(filePath);
            }
        }
        long l = Clock.ticks();
        InputStream inputStream = bDaemonFileSpace.getDaemonSession().getInputStream((DaemonMessage)new GetDirectoryMessage(filePath, bl, bl2, bl3, bDaemonFileSpace), n);
        if (inputStream == null) {
            if (storeCache != null) {
                storeCache.cacheNotFound(filePath);
                if (filePath2 != null) {
                    storeCache.cacheNotFound(filePath2);
                }
            }
            Log.getLog((String)"platform.daemonTuning").trace("parsed " + filePath.getBody() + ' ' + (Clock.ticks() - l) + "ms");
            return null;
        }
        try {
            xElem = XParser.make((InputStream)inputStream).parse();
        }
        catch (Exception exception) {
            Log.getLog((String)"platform.daemonTuning").trace("parse failed " + filePath.getBody() + ' ' + (Clock.ticks() - l) + "ms");
            throw new LocalizableRuntimeException("platform", "RemoteDirectory.exception.contentParse", new Object[]{filePath.getBody()}, (Throwable)exception);
        }
        BDaemonDirectoryStore bDaemonDirectoryStore = new BDaemonDirectoryStore(bDaemonFileSpace, filePath, (XElem)(bl ? xElem : null), bl, bl2, bl3, storeCache);
        if (storeCache != null) {
            storeCache.cacheResult((BIFileStore)bDaemonDirectoryStore);
            if (filePath2 != null) {
                storeCache.cacheResult((BIFileStore)new BDaemonDirectoryStore(bDaemonFileSpace, filePath2, (XElem)(bl ? xElem : null), bl, bl2, bl3, storeCache));
            }
            if (bl) {
                storeCache.cacheCompleted(filePath);
                if (filePath2 != null) {
                    storeCache.cacheCompleted(filePath2);
                }
            }
        }
        Log.getLog((String)"platform.daemonTuning").trace("parsed " + filePath.getBody() + ' ' + (Clock.ticks() - l) + "ms");
        return bDaemonDirectoryStore;
    }

    public BDaemonFileSpace getDaemonFileSpace() {
        return (BDaemonFileSpace)this.getFileSpace();
    }

    public void reset() {
        this.children = null;
        this.element = null;
        if (this.cache != null) {
            this.cache.clear(this.getFilePath());
            if (this.getAltPath() != null) {
                this.cache.clear(this.getAltPath());
            }
        }
    }

    public boolean isReadonly() {
        return true;
    }

    public boolean isDirectory() {
        return true;
    }

    public String getFileUri() {
        return this.fileUri;
    }

    public String getLocalPath() {
        if (this.element == null) {
            this.getChildren(BCacheAccessPolicy.lazyFetch);
        }
        return this.element.get("path", null);
    }

    public boolean copyToLocalHost() throws ConnectException, AuthenticationException {
        return this.copyToLocalHost(this.getFilePath(), null);
    }

    public boolean copyToLocalHost(FilePath filePath) throws ConnectException, AuthenticationException {
        return this.copyToLocalHost(filePath, null);
    }

    public boolean copyToLocalHost(FilePath filePath, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        if (!this.getFilePath().isSysHomeAbsolute()) {
            throw new IllegalStateException("Only system absolute files can be copied to local host");
        }
        Array array = this.getChildren();
        int n = 0;
        while (n < array.size()) {
            BAbstractFileStore bAbstractFileStore;
            if (array.get(n) instanceof BDaemonDirectoryStore ? !(bAbstractFileStore = (BDaemonDirectoryStore)((Object)array.get(n))).copyToLocalHost(filePath.merge(bAbstractFileStore.getFileName()), daemonSessionTaskListener) : !(bAbstractFileStore = (BDaemonFileStore)((Object)array.get(n))).copyToLocalHost(filePath.merge(bAbstractFileStore.getFileName()), daemonSessionTaskListener)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public FilePath getAltPath() {
        return this.altPath;
    }

    public BDaemonSession getDaemonSession() {
        return ((BDaemonFileSpace)this.getFileSpace()).getDaemonSession();
    }

    public BIFileStore getChild(String string) {
        return this.getChild(string, BCacheAccessPolicy.lazyFetch);
    }

    public BIFileStore getChild(String string, BCacheAccessPolicy bCacheAccessPolicy) {
        if (this.getChildren(bCacheAccessPolicy) == null) {
            return null;
        }
        int n = 0;
        while (n < this.children.size()) {
            if (((BIFileStore)this.children.get(n)).getFileName().equals(string)) {
                return (BIFileStore)this.children.get(n);
            }
            ++n;
        }
        if (this.cache != null) {
            this.cache.cacheNotFound(this.getFilePath().merge(string));
            if (this.getAltPath() != null) {
                this.cache.cacheNotFound(this.getAltPath().merge(string));
            }
        }
        return null;
    }

    public Array getChildren() {
        return this.getChildren(BCacheAccessPolicy.lazyFetch, this.recurseDir, this.sendCrc, this.sendLocalPath);
    }

    public Array getChildren(BCacheAccessPolicy bCacheAccessPolicy) {
        return this.getChildren(bCacheAccessPolicy, this.recurseDir, this.sendCrc, this.sendLocalPath);
    }

    public Array getChildren(BCacheAccessPolicy bCacheAccessPolicy, boolean bl, boolean bl2, boolean bl3) {
        long l = Clock.ticks();
        if (bCacheAccessPolicy == BCacheAccessPolicy.forceFetch || bCacheAccessPolicy == BCacheAccessPolicy.lazyFetch && this.element == null) {
            try {
                this.element = XParser.make((InputStream)this.getDaemonSession().getInputStream(new GetDirectoryMessage(this.getFilePath(), bl, bl2, bl3, this.getDaemonFileSpace()))).parse();
                Log.getLog((String)"platform.daemonTuning").trace("parsed " + this.getFilePath().getBody() + ' ' + (Clock.ticks() - l) + "ms");
            }
            catch (Exception exception) {
                Log.getLog((String)"platform.daemonTuning").trace("parse failed " + this.getFilePath().getBody() + ' ' + (Clock.ticks() - l) + "ms");
                throw new LocalizableRuntimeException("platform", "RemoteDirectory.exception.contentParse", new Object[]{this.getFileUri()}, (Throwable)exception);
            }
            this.children = null;
        }
        if (this.children == null && bCacheAccessPolicy != BCacheAccessPolicy.cacheOnly) {
            XElem[] xElemArray = this.element.elems();
            this.children = new Array();
            int n = 0;
            while (n < xElemArray.length) {
                BAbstractFileStore bAbstractFileStore;
                if (xElemArray[n].name().equals("file")) {
                    try {
                        bAbstractFileStore = new BDaemonFileStore(this.getDaemonFileSpace(), this.getFilePath().merge(xElemArray[n].get("name")), xElemArray[n]);
                        if (this.cache != null) {
                            this.cache.cacheResult((BIFileStore)bAbstractFileStore);
                            if (this.getAltPath() != null) {
                                this.cache.cacheResult((BIFileStore)new BDaemonFileStore(this.getDaemonFileSpace(), this.getAltPath().merge(xElemArray[n].get("name")), xElemArray[n]));
                            }
                        }
                        this.children.add((Object)bAbstractFileStore);
                    }
                    catch (SyntaxException syntaxException) {
                        Log.getLog((String)"platform.daemonTuning").trace("ignoring illegal child " + xElemArray[n].get("name") + " of " + this.getFilePath());
                    }
                } else if (xElemArray[n].name().equals("directory")) {
                    try {
                        bAbstractFileStore = new BDaemonDirectoryStore(this.getDaemonFileSpace(), this.getFilePath().merge(xElemArray[n].get("name")), bl ? xElemArray[n] : null, bl, bl2, bl3, this.cache);
                        if (this.cache != null) {
                            this.cache.cacheResult((BIFileStore)bAbstractFileStore);
                            if (this.getAltPath() != null) {
                                this.cache.cacheResult((BIFileStore)new BDaemonDirectoryStore(this.getDaemonFileSpace(), this.getAltPath().merge(xElemArray[n].get("name")), bl ? xElemArray[n] : null, bl, bl2, bl3, this.cache));
                            }
                        }
                        this.children.add((Object)bAbstractFileStore);
                    }
                    catch (SyntaxException syntaxException) {
                        Log.getLog((String)"platform.daemonTuning").trace("ignoring illegal child " + xElemArray[n].get("name") + " of " + this.getFilePath());
                    }
                }
                ++n;
            }
            if (this.cache != null) {
                this.cache.cacheCompleted(this.getFilePath());
                if (this.getAltPath() != null) {
                    this.cache.cacheCompleted(this.getAltPath());
                }
            }
        }
        return this.children;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.children = null;
    }

    private BDaemonDirectoryStore(BDaemonFileSpace bDaemonFileSpace, FilePath filePath, XElem xElem, boolean bl, boolean bl2, boolean bl3, StoreCache storeCache) {
        super((BFileSpace)bDaemonFileSpace, filePath);
        this.this();
        this.fileUri = bDaemonFileSpace.filePathToUri(filePath);
        this.element = xElem;
        this.recurseDir = bl;
        this.sendCrc = bl2;
        this.sendLocalPath = bl3;
        this.cache = storeCache;
        this.altPath = bDaemonFileSpace.getAltPath(filePath);
        if (bl) {
            this.getChildren(BCacheAccessPolicy.lazyFetch, true, bl2, bl3);
        }
    }

    static {
        Class clazz = class$com$tridium$platform$daemon$file$BDaemonDirectoryStore;
        if (clazz == null) {
            clazz = class$com$tridium$platform$daemon$file$BDaemonDirectoryStore = BDaemonDirectoryStore.class("[Lcom.tridium.platform.daemon.file.BDaemonDirectoryStore;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

