/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.PlatformOperationListener;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.FileHeaderInfo;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.FileHeaderMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.IOException;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.platform.IPlatformOperationListener;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCachedDaemonFileSpace
extends BDaemonFileSpace {
    public static final Type TYPE;
    private BDaemonSession session;
    private boolean recurseDirs;
    private boolean getCrcs;
    private boolean getLocalPaths;
    private StoreCache cache;
    private ICancelHint cancelHint;
    private DaemonSessionTaskListener taskListener;
    static /* synthetic */ Class class$com$tridium$platform$daemon$file$BCachedDaemonFileSpace;

    public Type getType() {
        return TYPE;
    }

    public BDaemonSession getDaemonSession() {
        return this.session;
    }

    public BDirectory makeDir(FilePath filePath, Context context) throws IOException {
        int n = this.cache.getCacheStatus(filePath);
        if (n == 1) {
            return this.createDir(filePath, context);
        }
        if (n == 0) {
            return new BDirectory(this.cache.getStore(filePath));
        }
        BDaemonDirectoryStore bDaemonDirectoryStore = BDaemonDirectoryStore.make(this, filePath, this.recurseDirs, this.getCrcs, this.getLocalPaths, this.cache);
        if (bDaemonDirectoryStore == null) {
            return this.createDir(filePath, context);
        }
        return new BDirectory((BIFileStore)bDaemonDirectoryStore);
    }

    private final BDirectory createDir(FilePath filePath, Context context) throws IOException {
        this.cache.clear(filePath);
        try {
            DaemonFileUtil.transfer(this.getDaemonSession(), FileTransferMessage.makeMkDir(filePath, this), this.cancelHint, this.taskListener);
            BDaemonDirectoryStore bDaemonDirectoryStore = BDaemonDirectoryStore.make(this, filePath, this.recurseDirs, this.getCrcs, this.getLocalPaths, this.cache);
            return bDaemonDirectoryStore == null ? null : new BDirectory((BIFileStore)bDaemonDirectoryStore);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BIFile makeFile(FilePath filePath, Context context) throws IOException {
        throw new LocalizableRuntimeException("platform", "DaemonFileSpace.readonly");
    }

    public void move(FilePath filePath, FilePath filePath2, Context context) throws IOException {
        throw new LocalizableRuntimeException("platform", "DaemonFileSpace.readonly");
    }

    public void delete(FilePath filePath, Context context) throws IOException {
        this.cache.clear(filePath);
        try {
            DaemonFileUtil.transfer(this.getDaemonSession(), FileTransferMessage.makeDelete(filePath, this), this.cancelHint, this.taskListener);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BIFile getChild(BIFile bIFile, String string) {
        return this.getChild(bIFile, string, BCacheAccessPolicy.lazyFetch);
    }

    public BIFile[] getChildren(BIFile bIFile) {
        return this.getChildren(bIFile, BCacheAccessPolicy.lazyFetch);
    }

    public BIFile findFile(FilePath filePath) {
        return this.findFile(filePath, BCacheAccessPolicy.lazyFetch);
    }

    public BIFileStore findStore(FilePath filePath) {
        return this.findStore(filePath, BCacheAccessPolicy.lazyFetch);
    }

    public BIFileStore findStore(FilePath filePath, BCacheAccessPolicy bCacheAccessPolicy) {
        try {
            BAbstractFileStore bAbstractFileStore;
            int n = bCacheAccessPolicy == BCacheAccessPolicy.forceFetch ? 2 : this.cache.getCacheStatus(filePath);
            if (n == 1) {
                return null;
            }
            if (n == 0) {
                return this.cache.getStore(filePath);
            }
            if (bCacheAccessPolicy == BCacheAccessPolicy.cacheOnly) {
                return null;
            }
            FileHeaderInfo fileHeaderInfo = DaemonFileUtil.getFileHeaderInfo(this.getDaemonSession(), new FileHeaderMessage(filePath, this));
            if (fileHeaderInfo == null) {
                if (this.cache != null) {
                    this.cache.cacheNotFound(filePath);
                }
                return null;
            }
            if (fileHeaderInfo.isDirectory()) {
                bAbstractFileStore = BDaemonDirectoryStore.make(this, filePath, this.recurseDirs, this.getCrcs, this.getLocalPaths, this.cache);
            } else if (filePath.depth() == 1 || !this.getCrcs) {
                bAbstractFileStore = new BDaemonFileStore(this, filePath, fileHeaderInfo.getContentLength(), -1);
                if (this.cache != null) {
                    this.cache.cacheResult((BIFileStore)bAbstractFileStore);
                }
            } else {
                BDaemonDirectoryStore bDaemonDirectoryStore = BDaemonDirectoryStore.make(this, filePath.getParent(), this.recurseDirs, true, this.getLocalPaths, this.cache);
                if (bDaemonDirectoryStore == null) {
                    bAbstractFileStore = new BDaemonFileStore(this, filePath, fileHeaderInfo.getContentLength(), -1);
                    if (this.cache != null) {
                        this.cache.cacheResult((BIFileStore)bAbstractFileStore);
                    }
                } else {
                    bAbstractFileStore = bDaemonDirectoryStore.getChild(filePath.getName());
                }
            }
            return bAbstractFileStore;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BIFile getChild(BIFile bIFile, String string, BCacheAccessPolicy bCacheAccessPolicy) {
        if (bIFile.isDirectory()) {
            BIFileStore bIFileStore = null;
            BDaemonDirectoryStore bDaemonDirectoryStore = (BDaemonDirectoryStore)bIFile.getStore();
            bIFileStore = bDaemonDirectoryStore.getChild(string, bCacheAccessPolicy);
            return bIFileStore == null ? null : this.makeFile(bIFileStore);
        }
        return null;
    }

    public BIFile[] getChildren(BIFile bIFile, BCacheAccessPolicy bCacheAccessPolicy) {
        if (bIFile.isDirectory()) {
            BDaemonDirectoryStore bDaemonDirectoryStore = (BDaemonDirectoryStore)bIFile.getStore();
            Array array = bDaemonDirectoryStore.getChildren(bCacheAccessPolicy);
            BIFile[] bIFileArray = new BIFile[array.size()];
            int n = 0;
            while (n < bIFileArray.length) {
                bIFileArray[n] = this.makeFile((BIFileStore)array.get(n));
                ++n;
            }
            return bIFileArray;
        }
        return null;
    }

    public BIFile findFile(FilePath filePath, BCacheAccessPolicy bCacheAccessPolicy) {
        try {
            BIFileStore bIFileStore = this.findStore(filePath, bCacheAccessPolicy);
            if (bIFileStore == null) {
                return null;
            }
            if (bIFileStore instanceof BDaemonDirectoryStore) {
                return new BDirectory(bIFileStore);
            }
            return this.makeFile(bIFileStore);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public StoreCache getCache() {
        return this.cache;
    }

    public BOrd getOrdInSession() {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BCachedDaemonFileSpace(BDaemonSession bDaemonSession, boolean bl, boolean bl2, boolean bl3, IPlatformOperationListener iPlatformOperationListener) {
        this.session = bDaemonSession;
        this.recurseDirs = bl;
        this.getCrcs = bl2;
        this.getLocalPaths = bl3;
        this.cache = new StoreCache();
        this.cancelHint = new PlatformOperationListener(iPlatformOperationListener);
        this.taskListener = (DaemonSessionTaskListener)((Object)this.cancelHint);
    }

    public BCachedDaemonFileSpace(BDaemonSession bDaemonSession, boolean bl, boolean bl2, boolean bl3) {
        this(bDaemonSession, bl, bl2, bl3, null, null);
    }

    public BCachedDaemonFileSpace(BDaemonSession bDaemonSession, boolean bl, boolean bl2, boolean bl3, ICancelHint iCancelHint, DaemonSessionTaskListener daemonSessionTaskListener) {
        this.session = bDaemonSession;
        this.recurseDirs = bl;
        this.getCrcs = bl2;
        this.getLocalPaths = bl3;
        this.cache = new StoreCache();
        this.cancelHint = iCancelHint;
        this.taskListener = daemonSessionTaskListener;
    }

    static {
        Class clazz = class$com$tridium$platform$daemon$file$BCachedDaemonFileSpace;
        if (clazz == null) {
            clazz = class$com$tridium$platform$daemon$file$BCachedDaemonFileSpace = BCachedDaemonFileSpace.class("[Lcom.tridium.platform.daemon.file.BCachedDaemonFileSpace;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

