/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.PlatformOperationListener;
import com.tridium.platform.daemon.RemotePlatformStation;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import java.net.ConnectException;
import java.net.SocketException;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.IPlatformOperationListener;
import javax.baja.platform.RemoteStation;
import javax.baja.platform.StationManager;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.util.Lexicon;

public class PlatformStationManager
implements StationManager {
    private static final Lexicon lex = Lexicon.make((String)"platform");
    private BDaemonSession daemonSession;

    public static PlatformStationManager make(BDaemonSession bDaemonSession) {
        return new PlatformStationManager(bDaemonSession);
    }

    public RemoteStation createStation(BDirectory bDirectory, String string, IPlatformOperationListener iPlatformOperationListener) throws Exception {
        PlatformOperationListener platformOperationListener = new PlatformOperationListener(iPlatformOperationListener);
        RemoteStation[] remoteStationArray = this.getAllStations();
        int n = remoteStationArray.length + 1;
        RemoteStation remoteStation = null;
        int n2 = 0;
        while (n2 < remoteStationArray.length) {
            if (TextUtil.toLowerCase((String)remoteStationArray[n2].getName()).equals(TextUtil.toLowerCase((String)string))) {
                remoteStation = remoteStationArray[n2];
                --n;
                break;
            }
            ++n2;
        }
        if (n > this.daemonSession.getHostProperties().getMaxStations()) {
            throw new BajaRuntimeException("Maximum number of stations exceeded");
        }
        if (remoteStation != null) {
            remoteStation.stop(iPlatformOperationListener);
        }
        FileTransferMessage fileTransferMessage = new FileTransferMessage(this.daemonSession.getFileSpace());
        this.addDir(fileTransferMessage, bDirectory, new FilePath("!stations/" + string));
        DaemonFileUtil.transfer(this.daemonSession, fileTransferMessage, platformOperationListener, platformOperationListener);
        if (remoteStation == null) {
            this.daemonSession.sendMessage(new UpdateStationMessage());
            this.daemonSession.sendMessage(new UpdateStationMessage(string, false, true, true, true));
            remoteStation = this.getStation(string);
        } else {
            remoteStation.poll();
        }
        return remoteStation;
    }

    public RemoteStation[] getAllStations() throws Exception {
        return RemotePlatformStation.getAllStations(this.daemonSession);
    }

    public RemoteStation getStation(String string) throws Exception {
        return RemotePlatformStation.getStation(this.daemonSession, string);
    }

    public RemoteStation[] stopAllStations(IPlatformOperationListener iPlatformOperationListener) throws Exception {
        return RemotePlatformStation.stopAllStations(this.daemonSession, iPlatformOperationListener);
    }

    public void rebootAsync() throws ConnectException, AuthenticationException {
        this.daemonSession.sendRebootRequest(false);
    }

    public void rebootSync(IPlatformOperationListener iPlatformOperationListener) throws Exception {
        String string = this.daemonSession.getHostProperties().getSessionTimestamp();
        String string2 = this.daemonSession.getHost().getNavDisplayName(null);
        iPlatformOperationListener.notifyStatus(lex.getText("RemotePlatformStation.reboot", new Object[]{string2}));
        this.daemonSession.sendRebootRequest(false);
        iPlatformOperationListener.notifyStatus(lex.getText("RemotePlatformStation.reconnecting", new Object[]{string2}));
        while (!iPlatformOperationListener.isCanceled()) {
            try {
                this.daemonSession.reloadHostProperties(15000);
                if (this.daemonSession.getHostProperties().getSessionTimestamp().equals(string)) continue;
                iPlatformOperationListener.notifyStatus(lex.getText("RemotePlatformStation.reconnected", new Object[]{string2}));
                break;
            }
            catch (SocketException socketException) {}
        }
    }

    private final void addDir(FileTransferMessage fileTransferMessage, BDirectory bDirectory, FilePath filePath) throws Exception {
        BIFile[] bIFileArray = bDirectory.listFiles();
        int n = 0;
        while (n < bIFileArray.length) {
            if (bIFileArray[n] instanceof BDirectory) {
                this.addDir(fileTransferMessage, (BDirectory)bIFileArray[n], filePath.merge(bIFileArray[n].getFileName()));
            } else if (!this.ignoreStationFile(bIFileArray[n])) {
                fileTransferMessage.addFile(bIFileArray[n], filePath.merge(bIFileArray[n].getFileName()));
            }
            ++n;
        }
    }

    private final boolean ignoreStationFile(BIFile bIFile) {
        return this.ignoreStationFile(bIFile.getFileName());
    }

    private final boolean ignoreStationFile(String string) {
        if (string.endsWith(".lock")) {
            return true;
        }
        if (string.startsWith("console.")) {
            return true;
        }
        if (string.startsWith("config.bog.b")) {
            return true;
        }
        return string.startsWith("config_backup");
    }

    private PlatformStationManager(BDaemonSession bDaemonSession) {
        this.daemonSession = bDaemonSession;
    }
}

