/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.PlatformOperationListener;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.BDefaultDaemonFileSpace;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.platform.BOverwritePolicy;
import javax.baja.platform.FileManager;
import javax.baja.platform.FileTransferOperation;
import javax.baja.platform.ICancelHint;
import javax.baja.platform.IPlatformOperationListener;
import javax.baja.security.AuthenticationException;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PlatformFileManager
implements FileManager {
    private static Lexicon lex = Lexicon.make((String)"platform");
    private BDaemonSession daemonSession;
    static /* synthetic */ Class class$javax$baja$file$BIFileStore;
    static /* synthetic */ Class class$javax$baja$file$BIFile;

    public static PlatformFileManager make(BDaemonSession bDaemonSession) {
        return new PlatformFileManager(bDaemonSession);
    }

    public BFileSpace getFileSpace() throws ConnectException, AuthenticationException {
        return this.daemonSession.getFileSpace();
    }

    public void transfer(FileTransferOperation fileTransferOperation, IPlatformOperationListener iPlatformOperationListener) throws ConnectException, AuthenticationException, IOException {
        StoreCache storeCache = new StoreCache();
        switch (fileTransferOperation.operation) {
            case 0: {
                this.get(fileTransferOperation.source, fileTransferOperation.destinationDir, fileTransferOperation.recurseDirs, fileTransferOperation.overwritePolicy, new PlatformOperationListener(iPlatformOperationListener), storeCache);
                break;
            }
            case 1: {
                this.put(fileTransferOperation.source, fileTransferOperation.destinationDir, fileTransferOperation.recurseDirs, fileTransferOperation.overwritePolicy, new PlatformOperationListener(iPlatformOperationListener), storeCache);
                break;
            }
            case 2: {
                this.delete(fileTransferOperation.source, new PlatformOperationListener(iPlatformOperationListener));
                break;
            }
            case 3: {
                this.rename(fileTransferOperation.source[0], fileTransferOperation.destinationDir.getName(), new PlatformOperationListener(iPlatformOperationListener));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid transfer operation");
            }
        }
    }

    private final void checkCanceled(ICancelHint iCancelHint) {
        if (iCancelHint != null && iCancelHint.isCanceled()) {
            throw new ICancelHint.CanceledException();
        }
    }

    private final void rename(FilePath filePath, String string, PlatformOperationListener platformOperationListener) throws ConnectException, AuthenticationException {
        DaemonFileUtil.transfer(this.daemonSession, FileTransferMessage.makeRename(filePath, string, this.daemonSession.getFileSpace()), null, platformOperationListener);
    }

    private final void get(FilePath[] filePathArray, FilePath filePath, boolean bl, BOverwritePolicy bOverwritePolicy, PlatformOperationListener platformOperationListener, StoreCache storeCache) throws ConnectException, AuthenticationException, IOException {
        BIFileStore bIFileStore;
        Class clazz = class$javax$baja$file$BIFileStore;
        if (clazz == null) {
            clazz = class$javax$baja$file$BIFileStore = PlatformFileManager.class("[Ljavax.baja.file.BIFileStore;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < filePathArray.length) {
            BDefaultDaemonFileSpace bDefaultDaemonFileSpace = this.daemonSession.getFileSpace();
            FilePath filePath2 = filePathArray[n];
            boolean bl2 = false;
            if (bOverwritePolicy == BOverwritePolicy.different) {
                bl2 = true;
            }
            if ((bIFileStore = bDefaultDaemonFileSpace.findStore(storeCache, filePath2, bl, bl2, BCacheAccessPolicy.lazyFetch)) == null) {
                throw new FileNotFoundException(filePathArray[n].getBody() + " not found");
            }
            array.add((Object)bIFileStore);
            ++n;
        }
        n = 0;
        while (n < array.size()) {
            bIFileStore = (BIFileStore)array.get(n);
            if (bIFileStore instanceof BDaemonDirectoryStore) {
                this.getDir((BDaemonDirectoryStore)bIFileStore, filePath.merge(bIFileStore.getFileName()), bl, bOverwritePolicy, platformOperationListener);
            } else if (bIFileStore instanceof BDaemonFileStore) {
                this.getFile((BDaemonFileStore)bIFileStore, filePath.merge(bIFileStore.getFileName()), bOverwritePolicy, platformOperationListener);
            }
            ++n;
        }
    }

    private final void getDir(BDaemonDirectoryStore bDaemonDirectoryStore, FilePath filePath, boolean bl, BOverwritePolicy bOverwritePolicy, PlatformOperationListener platformOperationListener) throws ConnectException, AuthenticationException, IOException {
        Array array = bDaemonDirectoryStore.getChildren();
        int n = 0;
        while (n < array.size()) {
            BIFileStore bIFileStore = (BIFileStore)array.get(n);
            if (array.get(n) instanceof BDaemonFileStore) {
                this.getFile((BDaemonFileStore)bIFileStore, filePath.merge(bIFileStore.getFileName()), bOverwritePolicy, platformOperationListener);
            } else if (array.get(n) instanceof BDaemonDirectoryStore && bl) {
                this.getDir((BDaemonDirectoryStore)bIFileStore, filePath.merge(bIFileStore.getFileName()), true, bOverwritePolicy, platformOperationListener);
            }
            ++n;
        }
    }

    private final void getFile(BDaemonFileStore bDaemonFileStore, FilePath filePath, BOverwritePolicy bOverwritePolicy, PlatformOperationListener platformOperationListener) throws ConnectException, AuthenticationException, IOException {
        BIFile bIFile = BFileSystem.INSTANCE.findFile(filePath);
        if (bIFile != null && (bOverwritePolicy == BOverwritePolicy.none || bOverwritePolicy == BOverwritePolicy.different && bDaemonFileStore.getCrc() == DaemonFileUtil.getCrc(bIFile))) {
            if (platformOperationListener != null) {
                DaemonSessionTask daemonSessionTask = new DaemonSessionTask(lex, "DaemonFileStore.copyToLocalHost.title", "DaemonFileStore.copyToLocalHost.notOverwritten", new Object[]{filePath.getBody()});
                platformOperationListener.taskStarted(daemonSessionTask);
                platformOperationListener.taskFinished(daemonSessionTask);
            }
            return;
        }
        bDaemonFileStore.copyToLocalHost(filePath, platformOperationListener);
    }

    private final void put(FilePath[] filePathArray, FilePath filePath, boolean bl, BOverwritePolicy bOverwritePolicy, PlatformOperationListener platformOperationListener, StoreCache storeCache) throws ConnectException, AuthenticationException, IOException {
        this.checkCanceled(platformOperationListener);
        Class clazz = class$javax$baja$file$BIFile;
        if (clazz == null) {
            clazz = class$javax$baja$file$BIFile = PlatformFileManager.class("[Ljavax.baja.file.BIFile;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < filePathArray.length) {
            this.checkCanceled(platformOperationListener);
            BIFile bIFile = BFileSystem.INSTANCE.findFile(filePathArray[n]);
            if (bIFile == null) {
                throw new FileNotFoundException(filePathArray[n].getBody() + " not found");
            }
            array.add((Object)bIFile);
            ++n;
        }
        FileTransferMessage fileTransferMessage = new FileTransferMessage(this.daemonSession.getFileSpace());
        int n2 = 0;
        while (n2 < array.size()) {
            this.checkCanceled(platformOperationListener);
            BIFile bIFile = (BIFile)array.get(n2);
            if (bIFile instanceof BDirectory) {
                this.putDir((BDirectory)bIFile, filePath.merge(bIFile.getFileName()), bl, bOverwritePolicy, storeCache, fileTransferMessage, platformOperationListener);
            } else {
                this.putFile(bIFile, filePath.merge(bIFile.getFileName()), bl, bOverwritePolicy, storeCache, fileTransferMessage, platformOperationListener);
            }
            ++n2;
        }
        DaemonFileUtil.transfer(this.daemonSession, fileTransferMessage, platformOperationListener, platformOperationListener);
    }

    private final void putDir(BDirectory bDirectory, FilePath filePath, boolean bl, BOverwritePolicy bOverwritePolicy, StoreCache storeCache, FileTransferMessage fileTransferMessage, PlatformOperationListener platformOperationListener) throws ConnectException, AuthenticationException, IOException {
        this.checkCanceled(platformOperationListener);
        BIFile[] bIFileArray = bDirectory.listFiles();
        int n = 0;
        while (n < bIFileArray.length) {
            this.checkCanceled(platformOperationListener);
            if (bIFileArray[n] instanceof BDirectory) {
                if (bl) {
                    this.putDir((BDirectory)bIFileArray[n], filePath.merge(bIFileArray[n].getFileName()), true, bOverwritePolicy, storeCache, fileTransferMessage, platformOperationListener);
                }
            } else {
                this.putFile(bIFileArray[n], filePath.merge(bIFileArray[n].getFileName()), bl, bOverwritePolicy, storeCache, fileTransferMessage, platformOperationListener);
            }
            ++n;
        }
    }

    private final void putFile(BIFile bIFile, FilePath filePath, boolean bl, BOverwritePolicy bOverwritePolicy, StoreCache storeCache, FileTransferMessage fileTransferMessage, PlatformOperationListener platformOperationListener) throws ConnectException, AuthenticationException, IOException {
        BDaemonFileStore bDaemonFileStore;
        this.checkCanceled(platformOperationListener);
        BDefaultDaemonFileSpace bDefaultDaemonFileSpace = this.daemonSession.getFileSpace();
        boolean bl2 = false;
        if (bOverwritePolicy == BOverwritePolicy.different) {
            bl2 = true;
        }
        if ((bDaemonFileStore = (BDaemonFileStore)bDefaultDaemonFileSpace.findStore(storeCache, filePath, bl, bl2, BCacheAccessPolicy.lazyFetch)) == null || bOverwritePolicy == BOverwritePolicy.different && bDaemonFileStore.getCrc() != DaemonFileUtil.getCrc(bIFile) || bOverwritePolicy == BOverwritePolicy.all) {
            fileTransferMessage.addFile(bIFile, filePath);
        }
    }

    private final void delete(FilePath[] filePathArray, PlatformOperationListener platformOperationListener) throws ConnectException, AuthenticationException, IOException {
        FileTransferMessage fileTransferMessage = new FileTransferMessage(this.daemonSession.getFileSpace());
        int n = 0;
        while (n < filePathArray.length) {
            fileTransferMessage.addElement(new DeleteFileTransferMessageElement(filePathArray[n], this.daemonSession.getFileSpace()));
            ++n;
        }
        DaemonFileUtil.transfer(this.daemonSession, fileTransferMessage, platformOperationListener, platformOperationListener);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private PlatformFileManager(BDaemonSession bDaemonSession) {
        this.daemonSession = bDaemonSession;
    }
}

