/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.daemon.Authenticator;
import com.tridium.platform.daemon.BDaemonSession;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.Random;
import javax.baja.naming.BHost;
import javax.baja.net.HttpConnection;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;

public class DigestAuthenticator
extends Authenticator {
    private static Random clientRandom;
    private BHost host;
    private int port;
    private int nc;
    private String realm;

    public BHost getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getAuthenticationScheme() {
        return "HTTP-Digest";
    }

    public boolean setAuthorization(HttpConnection httpConnection, String string) throws IOException {
        Properties properties = DigestAuthenticator.parseHeader(httpConnection, "WWW-Authenticate");
        return this.setAuthorization(httpConnection, string, properties);
    }

    public boolean setAuthorization(HttpConnection httpConnection, String string, Properties properties) throws IOException {
        if (properties == null) {
            return false;
        }
        String string2 = properties.getProperty("realm");
        String string3 = properties.getProperty("nonce");
        String string4 = properties.getProperty("qop");
        if (string3 == null || this.getUserAndPwd() == null) {
            return false;
        }
        ++this.nc;
        String string5 = this.getCnonce();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Digest username=").append(DigestAuthenticator.quote(this.getUserAndPwd().getUsername())).append(", ");
        stringBuffer.append("realm=").append(DigestAuthenticator.quote(string2)).append(", ");
        stringBuffer.append("nonce=").append(DigestAuthenticator.quote(string3)).append(", ");
        stringBuffer.append("uri=").append(DigestAuthenticator.quote(string)).append(", ");
        stringBuffer.append("nc=").append(this.nc).append(", ");
        stringBuffer.append("qop=").append(DigestAuthenticator.unquote(string4)).append(", ");
        stringBuffer.append("cnonce=\"").append(string5).append("\", ");
        stringBuffer.append("response=\"");
        stringBuffer.append(this.hexMD5(this.hexMD5(DigestAuthenticator.unquote(this.getUserAndPwd().getUsername()) + ':' + DigestAuthenticator.unquote(string2) + ':' + this.getUserAndPwd().getPassword().getValue()) + ':' + DigestAuthenticator.unquote(string3) + ':' + this.nc + ':' + string5 + ':' + DigestAuthenticator.unquote(string4) + ':' + this.hexMD5(httpConnection.getRequestMethod() + ':' + string)));
        stringBuffer.append("\"");
        httpConnection.setRequestHeader("Authorization", stringBuffer.toString());
        return true;
    }

    private final String getCnonce() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF("cnonce");
            dataOutputStream.writeInt(this.nc);
            dataOutputStream.writeUTF(this.host.getHostname());
            dataOutputStream.writeInt(this.port);
            dataOutputStream.writeLong(System.currentTimeMillis());
            dataOutputStream.writeInt(clientRandom.nextInt());
            return this.hexMD5(new String(byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {
            BDaemonSession.log.error("error creating cnonce", (Throwable)exception);
            return "xyzzy";
        }
    }

    public String getAuthenticationRealmName() {
        return this.realm;
    }

    DigestAuthenticator(BHost bHost, int n, BUsernameAndPassword bUsernameAndPassword, String string) {
        this(bHost, n, string);
        this.setCredentials((BICredentials)bUsernameAndPassword);
    }

    DigestAuthenticator(BHost bHost, int n, String string) {
        this.host = bHost;
        this.port = n;
        this.realm = string;
    }

    static {
        try {
            clientRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {
            clientRandom = new SecureRandom();
        }
        long l = System.currentTimeMillis();
        BDaemonSession.log.trace("digest authenticator starting RNG seed...");
        clientRandom.nextInt();
        BDaemonSession.log.trace("digest authenticator completed RNG seed [" + (System.currentTimeMillis() - l) + " ms]");
    }
}

