/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.FileHeaderInfo;
import com.tridium.platform.daemon.message.FileHeaderMessage;
import com.tridium.platform.daemon.message.GetTimeMessage;
import com.tridium.platform.daemon.message.UpdateTimeMessage;
import com.tridium.platform.timezone.TimeZoneUtil;
import com.tridium.timezone.HistoricalTimeZone;
import com.tridium.timezone.TzJarUtil;
import com.tridium.timezone.TzXmlDecoder;
import java.io.InputStream;
import java.net.ConnectException;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.timezone.BTimeZone;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DaemonTimeUtil {
    static /* synthetic */ Class class$javax$baja$timezone$BTimeZone;

    public static BAbsTime getLocalTime(BDaemonSession bDaemonSession) throws ConnectException, AuthenticationException {
        return DaemonTimeUtil.getLocalTime(bDaemonSession, null, null);
    }

    public static BAbsTime getLocalTime(BDaemonSession bDaemonSession, BTimeZone bTimeZone, BTimeZone[] bTimeZoneArray) throws ConnectException, AuthenticationException {
        XElem xElem = DaemonTimeUtil.getCurrentTimeElem(bDaemonSession);
        return DaemonTimeUtil.getLocalTime(bDaemonSession, xElem, bTimeZone, bTimeZoneArray);
    }

    public static BAbsTime getLocalTime(BDaemonSession bDaemonSession, XElem xElem, BTimeZone bTimeZone, BTimeZone[] bTimeZoneArray) throws ConnectException, AuthenticationException {
        if (bTimeZone == null) {
            if (bTimeZoneArray == null) {
                bTimeZoneArray = DaemonTimeUtil.getLocalTimeZones(bDaemonSession);
            }
            bTimeZone = DaemonTimeUtil.getLocalTimeZone(xElem, bTimeZoneArray);
        }
        return DaemonTimeUtil.getLocalTime(bDaemonSession, xElem, bTimeZone);
    }

    private static final BAbsTime getLocalTime(BDaemonSession bDaemonSession, XElem xElem, BTimeZone bTimeZone) throws ConnectException, AuthenticationException {
        if (xElem == null) {
            return null;
        }
        if (xElem.get("millis", null) == null) {
            return BAbsTime.make((int)xElem.geti("year"), (BMonth)BMonth.make((int)xElem.geti("month")), (int)xElem.geti("day"), (int)xElem.geti("hour"), (int)xElem.geti("minute"), (int)xElem.geti("second"), (int)0, (BTimeZone)bTimeZone);
        }
        return BAbsTime.make((long)xElem.getl("millis"), (BTimeZone)bTimeZone);
    }

    public static BTimeZone getEquivalentTimeZone(BTimeZone bTimeZone, BDaemonSession bDaemonSession) throws ConnectException, AuthenticationException {
        return DaemonTimeUtil.getEquivalentTimeZone(bTimeZone, DaemonTimeUtil.getLocalTimeZones(bDaemonSession));
    }

    public static BTimeZone getEquivalentTimeZone(BTimeZone bTimeZone, BTimeZone[] bTimeZoneArray) {
        if (bTimeZoneArray == null) {
            return null;
        }
        try {
            BTimeZone bTimeZone2 = null;
            if (bTimeZone.getId().equals("STD")) {
                bTimeZone = BTimeZone.UTC;
            }
            int n = 0;
            while (n < bTimeZoneArray.length) {
                if (TimeZoneUtil.isEquivalent(bTimeZone, bTimeZoneArray[n])) {
                    if (bTimeZone.getId().equals(bTimeZoneArray[n].getId())) {
                        return bTimeZoneArray[n];
                    }
                    if (bTimeZone2 == null) {
                        bTimeZone2 = bTimeZoneArray[n];
                    }
                }
                ++n;
            }
            return bTimeZone2;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public static BTimeZone getLocalTimeZone(BDaemonSession bDaemonSession) throws ConnectException, AuthenticationException {
        return DaemonTimeUtil.getLocalTimeZone(bDaemonSession, DaemonTimeUtil.getLocalTimeZones(bDaemonSession));
    }

    public static XElem getCurrentTimeElem(BDaemonSession bDaemonSession) throws ConnectException, AuthenticationException {
        try {
            InputStream inputStream = bDaemonSession.getInputStream(GetTimeMessage.getInstance());
            if (inputStream == null) {
                return null;
            }
            return XParser.make((InputStream)inputStream).parse();
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public static BTimeZone getLocalTimeZone(BDaemonSession bDaemonSession, BTimeZone[] bTimeZoneArray) throws ConnectException, AuthenticationException {
        return DaemonTimeUtil.getLocalTimeZone(DaemonTimeUtil.getCurrentTimeElem(bDaemonSession), bTimeZoneArray);
    }

    public static BTimeZone getOsTimeZone(BDaemonSession bDaemonSession) throws Exception {
        XElem xElem = DaemonTimeUtil.getCurrentTimeElem(bDaemonSession);
        if (xElem == null) {
            return null;
        }
        XElem xElem2 = xElem.elem("zone");
        if (xElem2 == null) {
            return null;
        }
        try {
            return TzXmlDecoder.getTimeZone((XElem)xElem2, (boolean)false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return BTimeZone.UTC;
        }
    }

    public static BTimeZone getLocalTimeZone(XElem xElem, BTimeZone[] bTimeZoneArray) throws ConnectException, AuthenticationException {
        BTimeZone bTimeZone;
        XElem xElem2;
        if (xElem == null) {
            return null;
        }
        String string = xElem.get("timeZone", "UTC");
        if (string.trim().length() > 0 && bTimeZoneArray != null) {
            int n = 0;
            while (n < bTimeZoneArray.length) {
                if (bTimeZoneArray[n].getId().equals(string)) {
                    return bTimeZoneArray[n];
                }
                ++n;
            }
        }
        if ((xElem2 = xElem.elem("zone")) == null) {
            return BTimeZone.UTC;
        }
        try {
            bTimeZone = TzXmlDecoder.getTimeZone((XElem)xElem2, (boolean)false);
            if (bTimeZone.getId().equals("STD") || bTimeZone.getId().equals("DST")) {
                if (TimeZoneUtil.isEquivalent(bTimeZone, BTimeZone.UTC)) {
                    bTimeZone = BTimeZone.UTC;
                } else if (TimeZoneUtil.isEquivalent(bTimeZone, BTimeZone.getLocal())) {
                    bTimeZone = BTimeZone.getLocal();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        if (bTimeZoneArray != null) {
            BTimeZone bTimeZone2 = null;
            int n = 0;
            while (n < bTimeZoneArray.length) {
                if (TimeZoneUtil.isEquivalent(bTimeZoneArray[n], bTimeZone)) {
                    if (bTimeZoneArray[n].getId().equals(bTimeZone.getId())) {
                        return bTimeZoneArray[n];
                    }
                    bTimeZone2 = bTimeZoneArray[n];
                }
                ++n;
            }
            if (bTimeZone2 != null) {
                return bTimeZone2;
            }
        }
        return BTimeZone.UTC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static BTimeZone[] getLocalTimeZones(BDaemonSession bDaemonSession) throws ConnectException, AuthenticationException {
        try {
            BTimeZone[] bTimeZoneArray;
            BTimeZone[] bTimeZoneArray2;
            Class clazz = class$javax$baja$timezone$BTimeZone;
            if (clazz == null) {
                clazz = class$javax$baja$timezone$BTimeZone = DaemonTimeUtil.class("[Ljavax.baja.timezone.BTimeZone;", false);
            }
            Array array = new Array(clazz);
            BDaemonFileStore bDaemonFileStore = new BDaemonFileStore(bDaemonSession.getFileSpace(), new FilePath("!lib/timezones.jar"));
            InputStream inputStream = null;
            inputStream = bDaemonFileStore.getInputStream();
            if (inputStream != null) break block25;
            BDaemonFileStore bDaemonFileStore2 = new BDaemonFileStore(bDaemonSession.getFileSpace(), new FilePath("!lib/timezones.xml"));
            InputStream inputStream2 = null;
            inputStream2 = bDaemonFileStore2.getInputStream();
            if (inputStream2 != null) break block21;
            BTimeZone[] bTimeZoneArray3 = new BTimeZone[]{DaemonTimeUtil.getOsTimeZone(bDaemonSession)};
            Object var11_13 = null;
            try {
                inputStream2.close();
            }
            catch (Exception exception) {
            }
            Object var5_16 = null;
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            {
                block21: {
                    return bTimeZoneArray3;
                }
                XElem xElem = XParser.make((InputStream)inputStream2).parse();
                XElem[] xElemArray = xElem.elems("zone");
                int n = 0;
                while (n < xElemArray.length) {
                    array.add((Object)TzXmlDecoder.getTimeZone((XElem)xElemArray[n], (boolean)false));
                    ++n;
                }
                array = array.sort(TimeZoneUtil.TZ_COMPARATOR);
                bTimeZoneArray2 = (BTimeZone[])array.trim();
                Object var11_14 = null;
                try {
                    inputStream2.close();
                }
                catch (Exception exception) {
                }
            }
            Object var5_17 = null;
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            {
                block25: {
                    return bTimeZoneArray2;
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        try {
                            inputStream2.close();
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                }
                array.addAll(TzJarUtil.getTimeZones((InputStream)inputStream));
                array = array.sort(TimeZoneUtil.TZ_COMPARATOR);
                bTimeZoneArray = (BTimeZone[])array.trim();
            }
            Object var5_18 = null;
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            return bTimeZoneArray;
            catch (Throwable throwable) {
                Object var5_19 = null;
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BTimeZone getCompleteTimeZone(BDaemonSession bDaemonSession, BTimeZone bTimeZone) throws ConnectException, AuthenticationException {
        try {
            BDaemonFileStore bDaemonFileStore = new BDaemonFileStore(bDaemonSession.getFileSpace(), new FilePath("!lib/timezones.jar"));
            FileHeaderInfo fileHeaderInfo = DaemonFileUtil.getFileHeaderInfo(bDaemonSession, new FileHeaderMessage(bDaemonFileStore.getFilePath(), bDaemonFileStore.getDaemonFileSpace()));
            if (fileHeaderInfo == null) {
                BTimeZone bTimeZone2;
                InputStream inputStream;
                block16: {
                    BTimeZone bTimeZone3;
                    block15: {
                        BDaemonFileStore bDaemonFileStore2 = new BDaemonFileStore(bDaemonSession.getFileSpace(), new FilePath("!lib/timezones.xml"));
                        inputStream = null;
                        try {
                            inputStream = bDaemonFileStore2.getInputStream();
                            if (inputStream == null) {
                                bTimeZone3 = bTimeZone;
                                Object var7_14 = null;
                                break block15;
                            }
                            XElem xElem = XParser.make((InputStream)inputStream).parse();
                            XElem[] xElemArray = xElem.elems("zone");
                            BTimeZone bTimeZone4 = null;
                            int n = 0;
                            while (n < xElemArray.length && !(bTimeZone4 = TzXmlDecoder.getTimeZone((XElem)xElemArray[n])).getId().equalsIgnoreCase(bTimeZone.getId())) {
                                ++n;
                            }
                            bTimeZone2 = bTimeZone4;
                            break block16;
                        }
                        catch (Throwable throwable) {
                            Object var7_16 = null;
                            try {
                                inputStream.close();
                                throw throwable;
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                    }
                    try {}
                    catch (Exception exception) {}
                    inputStream.close();
                    return bTimeZone3;
                }
                Object var7_15 = null;
                try {}
                catch (Exception exception) {}
                inputStream.close();
                return bTimeZone2;
            }
            HistoricalTimeZone historicalTimeZone = TzJarUtil.getCompleteTimeZone((String)bTimeZone.getId());
            if (historicalTimeZone == null) {
                return bTimeZone;
            }
            BTimeZone bTimeZone5 = (BTimeZone)BTimeZone.DEFAULT.fw(1102, (Object)historicalTimeZone, null, null, null);
            if (bTimeZone5 != null) return bTimeZone5;
            return bTimeZone;
        }
        catch (ConnectException connectException) {
            throw connectException;
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public static void updateLocalTime(BDaemonSession bDaemonSession, BAbsTime bAbsTime, String string, BTimeZone bTimeZone) throws ConnectException, AuthenticationException {
        bDaemonSession.sendMessage(new UpdateTimeMessage(bAbsTime, string, TimeZoneUtil.makeCompatible(bAbsTime.getMillis(), bTimeZone, bDaemonSession.getHostProperties().getTimezoneDayModeSupport())));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

