/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.nre.util.BogTranscoderInputStream;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonText;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.FileCache;
import com.tridium.platform.daemon.file.FileHeaderInfo;
import com.tridium.platform.daemon.file.FilePathComparator;
import com.tridium.platform.daemon.message.FileHeaderMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.GetJarContentMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.sys.Nre;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.text.DecimalFormat;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.file.zip.BZipFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.log.Log;
import javax.baja.net.HttpConnection;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class DaemonFileUtil {
    public static Lexicon lex = Lexicon.make((String)"platform");
    public static DecimalFormat kbFormat = new DecimalFormat(lex.getText("Formats.kb"));
    public static DecimalFormat byteFormat = new DecimalFormat(lex.getText("Formats.bytes"));
    public static Log log = Log.getLog((String)"platform.daemonSession");

    public static void deleteFile(BIFile bIFile) throws Exception {
        BFileSpace bFileSpace = (BFileSpace)bIFile.getSpace();
        if (bFileSpace instanceof BDaemonFileSpace) {
            BDaemonFileSpace bDaemonFileSpace = (BDaemonFileSpace)bFileSpace;
            DaemonFileUtil.transfer(bDaemonFileSpace.getDaemonSession(), FileTransferMessage.makeDelete(bIFile.getFilePath(), bDaemonFileSpace), null);
        } else {
            bIFile.delete();
        }
    }

    public static String fileSize(long l) {
        if (l < 0L) {
            return "";
        }
        if (l < 1024L) {
            return byteFormat.format(l);
        }
        return kbFormat.format((double)l / 1024.0);
    }

    public static void pipe(InputStream inputStream, OutputStream outputStream, TransferStatus transferStatus) throws IOException {
        int n = 4096;
        byte[] byArray = new byte[n];
        long l = 0L;
        while (true) {
            if (transferStatus.isCanceled()) {
                throw new ICancelHint.CanceledException();
            }
            int n2 = inputStream.read(byArray, 0, n);
            if (n2 < 0) break;
            outputStream.write(byArray, 0, n2);
            transferStatus.updateBytesWritten(l += (long)n2);
        }
    }

    public static BIFile findFile(BFileSpace bFileSpace, FilePath filePath, FileCache fileCache) {
        if (fileCache == null) {
            return bFileSpace.findFile(filePath);
        }
        switch (fileCache.getCacheStatus(filePath)) {
            case 0: {
                return fileCache.getFile(filePath);
            }
            case 1: {
                return null;
            }
        }
        BIFile bIFile = bFileSpace.findFile(filePath);
        if (bIFile == null) {
            fileCache.cacheNotFound(filePath);
        } else {
            fileCache.cacheResult(bIFile);
        }
        return bIFile;
    }

    public static long getCrc(BIFile bIFile) {
        try {
            if (bIFile instanceof BAbstractFile) {
                return ((BAbstractFile)bIFile).getCrc();
            }
            return -1;
        }
        catch (IOException iOException) {
            throw new LocalizableRuntimeException("platform", "FileUtilities.exception.readCrc", (Throwable)iOException);
        }
    }

    public static FileHeaderInfo getFileHeaderInfo(BDaemonSession bDaemonSession, FileHeaderMessage fileHeaderMessage) throws ConnectException, AuthenticationException {
        String string;
        long l;
        String string2;
        HttpConnection httpConnection = bDaemonSession.getConnection(fileHeaderMessage.getMessageString(), "HEAD", BDaemonSession.DEFAULT_TIMEOUT);
        if (httpConnection == null) {
            return null;
        }
        FileHeaderInfo fileHeaderInfo = new FileHeaderInfo();
        String string3 = httpConnection.getResponseHeader("Content-Type");
        if (string3 != null) {
            fileHeaderInfo.setContentType(string3);
        }
        if ((string2 = httpConnection.getResponseHeader("Content-Length")) != null) {
            fileHeaderInfo.setContentLength(Long.parseLong(string2));
        }
        if ((l = httpConnection.getResponseHeaderDate("Last-Modified")) > 0L) {
            fileHeaderInfo.setLastModified(BAbsTime.make((long)l));
        }
        if ((string = httpConnection.getResponseHeader("File-CRC")) != null) {
            fileHeaderInfo.setCrc(Long.parseLong(string));
        }
        httpConnection.close();
        return fileHeaderInfo;
    }

    public static BFilesystemAttributes getFilesystemAttributes(BDaemonSession bDaemonSession, FilePath filePath) throws Exception {
        InputStream inputStream = bDaemonSession.getInputStream(new FilesystemAttributesMessage(bDaemonSession.getFileSpace(), filePath));
        XElem xElem = XParser.make((InputStream)inputStream).parse();
        return new BFilesystemAttributes(xElem.getl("totalKb", (long)-1), xElem.getl("freeKb", (long)-1), xElem.geti("blockSize", -1), xElem.getl("maxFileCount", (long)-1), xElem.getl("currentFileCount", (long)-1), xElem.getb("isFlash", false));
    }

    public static FilePath getNormalizedFilePath(BIFileStore bIFileStore) {
        if (bIFileStore.getFilePath().isLocalAbsolute()) {
            return bIFileStore.getFilePath();
        }
        if (bIFileStore.getFileSpace() instanceof BDaemonFileSpace) {
            FilePath filePath = ((BDaemonFileSpace)bIFileStore.getFileSpace()).getAltPath(bIFileStore.getFilePath());
            if (filePath != null) {
                return filePath;
            }
        } else if (bIFileStore instanceof BLocalFileStore) {
            return BFileSystem.INSTANCE.localFileToPath(((BLocalFileStore)bIFileStore).getLocalFile());
        }
        return bIFileStore.getFilePath();
    }

    public static InputStream getZipStream(BIFile bIFile, FilePath filePath) throws IOException {
        ZipEntry zipEntry;
        if (bIFile.getStore() instanceof BLocalFileStore) {
            BZipFile bZipFile = bIFile instanceof BZipFile ? (BZipFile)bIFile : new BZipFile(bIFile.getStore());
            BZipSpace bZipSpace = (BZipSpace)bZipFile.open();
            BIFile bIFile2 = bZipSpace.findFile(filePath);
            if (bIFile2 == null) {
                try {
                    bZipFile.close();
                }
                catch (Exception exception) {}
                return null;
            }
            return new ZipEntryInputStream(bZipFile, bIFile2);
        }
        if (bIFile.getStore() instanceof BDaemonFileStore) {
            BDaemonFileStore bDaemonFileStore = (BDaemonFileStore)bIFile.getStore();
            return bDaemonFileStore.getDaemonSession().getInputStream(new GetJarContentMessage(bIFile.getFilePath(), filePath));
        }
        ZipInputStream zipInputStream = new ZipInputStream(bIFile.getInputStream());
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!zipEntry.getName().equalsIgnoreCase(filePath.getBody())) continue;
            return zipInputStream;
        }
        zipInputStream.close();
        return null;
    }

    public static boolean isSubPath(FilePath filePath, FilePath filePath2) {
        return DaemonFileUtil.pathsMatch(filePath, filePath2, filePath2.depth());
    }

    public static BIFile[] listFiles(BDirectory bDirectory, FileCache fileCache) {
        BIFile[] bIFileArray = bDirectory.listFiles();
        if (fileCache != null) {
            int n = 0;
            while (n < bIFileArray.length) {
                fileCache.cacheResult(bIFileArray[n]);
                ++n;
            }
        }
        return bIFileArray;
    }

    public static boolean pathsMatch(FilePath filePath, FilePath filePath2, int n) {
        if (filePath.getAbsoluteMode() != filePath2.getAbsoluteMode()) {
            return false;
        }
        if (filePath.depth() < n) {
            return false;
        }
        if (filePath2.depth() < n) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!filePath.nameAt(n2).equals(filePath2.nameAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean transfer(BDaemonSession bDaemonSession, FileTransferMessage fileTransferMessage, ICancelHint iCancelHint) throws ConnectException, AuthenticationException {
        return DaemonFileUtil.transfer(bDaemonSession, fileTransferMessage, iCancelHint, DaemonSessionTaskListener.NULL_TASK_LISTENER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean transfer(BDaemonSession var0, FileTransferMessage var1_1, ICancelHint var2_2, DaemonSessionTaskListener var3_3) throws ConnectException, AuthenticationException {
        block47: {
            block46: {
                block44: {
                    if (DaemonFileUtil.canceled(var2_2)) {
                        throw new ICancelHint.CanceledException();
                    }
                    var4_4 = new CancelableDaemonSessionTask(DaemonFileUtil.lex, "DaemonSession.transferFiles.taskTitle", "DaemonSession.transferFiles.taskMessage", 100, var2_2);
                    if (var3_3 == null) {
                        var3_3 = DaemonSessionTaskListener.NULL_TASK_LISTENER;
                    }
                    var5_5 = null;
                    var6_6 = false;
                    var7_7 = true;
                    var1_1.initProgress();
                    var4_4.setProgress(var1_1.getProgress());
                    var3_3.taskStarted(var4_4);
                    try {
                        var11_8 = null;
                        var12_9 = "";
                        var13_10 = var1_1.getElements(var0);
                        var14_11 = var13_10.iterator();
                        block20: while (true) {
                            block45: {
                                block48: {
                                    if (var14_11.hasNext()) break block48;
                                    var1_1.getCache().clear();
                                    try {
                                        if (!var6_6) ** GOTO lbl-1000
                                        var4_4.setIsCancelEnabled(false);
                                        var3_3.taskUpdated(var4_4);
                                        if (DaemonFileUtil.sendCommit(var0, var1_1, var11_8, var4_4, var3_3)) {
                                            var17_16 = new TreeSet<E>(FilePathComparator.INSTANCE);
                                            var18_40 = new TreeSet<E>(FilePathComparator.INSTANCE);
                                            var19_19 = 0;
                                            while (true) {
                                                if (var19_19 >= var13_10.size()) {
                                                    var0.getFileSpace().notify(var17_16, var18_40);
                                                    var10_26 = true;
                                                    var15_13 = null;
                                                    if (var11_8 != null) {
                                                        break block20;
                                                    }
                                                    break block44;
                                                }
                                                ((FileTransferMessageElement)var13_10.get(var19_19)).updateTransferInfo(var17_16, var18_40);
                                                ++var19_19;
                                            }
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (Throwable var14_12) {
                                        var15_13 = null;
                                        if (var11_8 == null) throw var14_12;
                                        var11_8.close();
                                        throw var14_12;
                                    }
                                }
                                if (DaemonFileUtil.canceled(var4_4)) {
                                    DaemonFileUtil.sendAbort(var0, var1_1, var11_8, var4_4, var3_3);
                                    var1_1.getCache().clear();
                                    throw new ICancelHint.CanceledException();
                                }
                                var15_13 = (FileTransferMessageElement)var14_11.next();
                                var12_9 = var15_13.getFullUri(var1_1, var7_7);
                                var7_7 = false;
                                if (var15_13.getRequestMethod().equals("POST")) {
                                    var4_4.setMessage(DaemonFileUtil.lex.getText("FileTransferMessageElement.progress", new Object[]{var15_13.getFilePath().getBody()}));
                                } else if (var15_13.getRequestMethod().equals("DELETE")) {
                                    var4_4.setMessage(DaemonFileUtil.lex.getText("DeleteFileTransferMessageElement.progress", new Object[]{var15_13.getFilePath().getBody()}));
                                }
                                var3_3.taskUpdated(var4_4);
                                var16_14 = var15_13.getRequestMethod().equals("POST") != false ? 32 : 0;
                                var17_15 = var15_13.getSize();
                                if (var15_13.getFilePath().getName().endsWith(".bog")) {
                                    try {
                                        var19_17 = var15_13.getStream();
                                        if (var19_17 != null) {
                                            var20_20 = new BogTranscoderInputStream(Nre.getSecurityInfoProvider().getKeyRing(), (InputStream)var19_17, true);
                                            var21_23 = FileUtil.getFileInfo((InputStream)var20_20);
                                            var20_20.close();
                                            var17_15 = var21_23.size;
                                        }
                                    }
                                    catch (IOException var19_18) {
                                        var19_18.printStackTrace();
                                    }
                                }
                                if ((var11_8 = var0.getConnection(var12_9, var15_13.getRequestMethod(), var17_15, BDaemonSession.DEFAULT_TIMEOUT, var11_8, var16_14)) == null) {
                                    DaemonFileUtil.sendAbort(var0, var1_1, var11_8, var4_4, var3_3);
                                    var1_1.getCache().clear();
                                    var10_25 = false;
                                    var9_29 = null;
                                    var3_3.taskFinished(var4_4);
                                    return var10_25;
                                }
                                if (var5_5 == null && (var5_5 = var11_8.getResponseHeader("transactionId")) != null) {
                                    var1_1.setTransactionId(var5_5);
                                    var6_6 = true;
                                }
                                if (var15_13.getRequestMethod().equals("POST")) {
                                    var19_17 = (TreeSet<E>)new byte[4096];
                                    try {
                                        var21_23 = var15_13.getFilePath().getName().endsWith(".bog") != false ? new BogTranscoderInputStream(Nre.getSecurityInfoProvider().getKeyRing(), var15_13.getStream()) : var15_13.getStream();
                                        var1_1.updateProgress(var15_13, 0);
                                        var4_4.setProgress(var1_1.getProgress());
                                        var3_3.taskUpdated(var4_4);
                                        if (DaemonFileUtil.canceled(var4_4)) {
                                            try {
                                                try {
                                                    var11_8.close();
                                                }
                                                catch (Exception v0) {}
                                            }
                                            catch (Throwable var22_34) {
                                                var23_36 = null;
                                                var11_8 = null;
                                                throw var22_34;
                                            }
                                            {
                                                var23_37 = null;
                                                var11_8 = null;
                                            }
                                            DaemonFileUtil.sendAbort(var0, var1_1, var11_8, var4_4, var3_3);
                                            var1_1.getCache().clear();
                                            var21_23.close();
                                            throw new ICancelHint.CanceledException();
                                        }
                                        while (true) {
                                            if ((var20_21 = var21_23.read((byte[])var19_17, 0, ((TreeSet<E>)var19_17).length)) <= 0) {
                                                var21_23.close();
                                                var11_8.postComplete();
                                                var0.readFully(var11_8);
                                                break block45;
                                            }
                                            if (DaemonFileUtil.canceled(var4_4)) {
                                                try {
                                                    try {
                                                        var11_8.close();
                                                    }
                                                    catch (Exception v1) {}
                                                }
                                                catch (Throwable var22_35) {
                                                    var23_38 = null;
                                                    var11_8 = null;
                                                    throw var22_35;
                                                }
                                                {
                                                    var23_39 = null;
                                                    var11_8 = null;
                                                }
                                                DaemonFileUtil.sendAbort(var0, var1_1, var11_8, var4_4, var3_3);
                                                var1_1.getCache().clear();
                                                throw new ICancelHint.CanceledException();
                                            }
                                            var11_8.getOutputStream().write((byte[])var19_17, 0, var20_21);
                                            var1_1.updateProgress(var15_13, var20_21);
                                            var4_4.setProgress(var1_1.getProgress());
                                            var3_3.taskUpdated(var4_4);
                                        }
                                    }
                                    catch (IOException var21_24) {
                                        DaemonFileUtil.log.trace("transfer(FileTransferMessage) closes connection a");
                                        if (var11_8 == null) throw new LocalizableRuntimeException("platform", "DaemonSession.exception.write", new Object[]{var0.getAddressString(), var15_13.getRequestMethod(), var12_9}, (Throwable)var21_24);
                                        var11_8.close();
                                        throw new LocalizableRuntimeException("platform", "DaemonSession.exception.write", new Object[]{var0.getAddressString(), var15_13.getRequestMethod(), var12_9}, (Throwable)var21_24);
                                    }
                                }
                                var1_1.updateProgress(var15_13, 0);
                                var4_4.setProgress(var1_1.getProgress());
                                var3_3.taskUpdated(var4_4);
                                var0.readFully(var11_8);
                            }
                            if (var6_6) continue;
                            var19_17 = new TreeSet<E>(FilePathComparator.INSTANCE);
                            var20_22 = new TreeSet<E>(FilePathComparator.INSTANCE);
                            var15_13.updateTransferInfo(var19_17, var20_22);
                            var0.getFileSpace().notify(var19_17, var20_22);
                        }
                        var11_8.close();
                        break block44;
lbl-1000:
                        // 1 sources

                        {
                            var10_27 = false;
                            var15_13 = null;
                            if (var11_8 == null) break block46;
                        }
                        var11_8.close();
                        break block46;
lbl-1000:
                        // 1 sources

                        {
                            var10_28 = true;
                            var15_13 = null;
                            if (var11_8 == null) break block47;
                        }
                        var11_8.close();
                        break block47;
                    }
                    catch (Throwable var8_41) {
                        var9_33 = null;
                        var3_3.taskFinished(var4_4);
                        throw var8_41;
                    }
                }
                var9_30 = null;
                var3_3.taskFinished(var4_4);
                return var10_26;
            }
            var9_31 = null;
            var3_3.taskFinished(var4_4);
            return var10_27;
        }
        var9_32 = null;
        var3_3.taskFinished(var4_4);
        return var10_28;
    }

    private static final boolean canceled(ICancelHint iCancelHint) {
        boolean bl = false;
        if (iCancelHint != null && iCancelHint.isCanceled()) {
            bl = true;
        }
        return bl;
    }

    private static final boolean sendAbort(BDaemonSession bDaemonSession, FileTransferMessage fileTransferMessage, HttpConnection httpConnection, CancelableDaemonSessionTask cancelableDaemonSessionTask, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        String string = fileTransferMessage.getAbortUri();
        if (string == null) {
            return true;
        }
        try {
            httpConnection = bDaemonSession.getConnection(string, "GET", -1, BDaemonSession.DEFAULT_TIMEOUT, httpConnection);
        }
        catch (IOException iOException) {
            log.trace("sendAbort closes connection");
            if (httpConnection != null) {
                httpConnection.close();
            }
            throw new LocalizableRuntimeException("platform", "DaemonSession.exception.write", new Object[]{bDaemonSession.getAddressString(), "GET", string}, (Throwable)iOException);
        }
        return true;
    }

    private static final boolean sendCommit(BDaemonSession bDaemonSession, FileTransferMessage fileTransferMessage, HttpConnection httpConnection, CancelableDaemonSessionTask cancelableDaemonSessionTask, DaemonSessionTaskListener daemonSessionTaskListener) throws ConnectException, AuthenticationException {
        String string = fileTransferMessage.getCommitUri();
        InputStream inputStream = null;
        if (string == null) {
            if (fileTransferMessage.getTransactionId() == null) {
                log.warning("attempt to commit file transfer that is not transacted");
            } else {
                log.warning("attempt to commit file transfer that is autocommit");
            }
            return false;
        }
        try {
            inputStream = bDaemonSession.getInputStream(string, 0, "text/xml", httpConnection);
            if (inputStream == null) {
                return true;
            }
            XParser xParser = XParser.make((InputStream)inputStream);
            while (xParser.next() != -1) {
                if (xParser.type() == 1) {
                    XElem xElem = null;
                    if (xParser.elem().name().equals("message")) {
                        xElem = xParser.parseCurrent(false);
                    } else if (xParser.elem().name().equals("warning")) {
                        xElem = xParser.parseCurrent(false);
                    } else if (xParser.elem().name().equals("trace")) {
                        xElem = xParser.parseCurrent(false);
                    } else if (xParser.elem().name().equals("error")) {
                        xElem = xParser.parseCurrent(false);
                        int n = xElem.geti("code", 500);
                        DaemonText daemonText = new DaemonText(xElem);
                        if (daemonText.lexModule == null) {
                            String string2 = daemonText.message;
                            if (string2 == null) {
                                string2 = bDaemonSession.getAddressString() + " GET " + string;
                            }
                            if (n >= 400) {
                                throw new LocalizableRuntimeException("platform", "DaemonSession.exception.commit", new Object[]{string2});
                            }
                        } else if (n >= 300) {
                            throw new LocalizableRuntimeException(daemonText.lexModule, daemonText.lexKey, daemonText.lexArgs);
                        }
                    }
                    if (xElem == null) continue;
                    DaemonText daemonText = new DaemonText(xElem);
                    cancelableDaemonSessionTask.setMessage(daemonText.message);
                    daemonSessionTaskListener.taskUpdated(cancelableDaemonSessionTask);
                    continue;
                }
                if (xParser.type() != 2 || xParser.depth() > 1) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            log.trace("sendCommit closes connection");
            try {
                if (inputStream != null) {
                    inputStream.close();
                } else if (httpConnection != null) {
                    httpConnection.close();
                }
            }
            catch (Exception exception) {}
            throw new LocalizableRuntimeException("platform", "DaemonSession.exception.commit", new Object[]{bDaemonSession.getAddressString(), "GET", string}, (Throwable)iOException);
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        return true;
    }

    public static interface TransferStatus
    extends ICancelHint {
        public void updateBytesWritten(long var1);
    }

    private static class FilesystemAttributesMessage
    extends XmlResponseMessage {
        StringBuffer path = new StringBuffer();

        public String getMessageString() {
            return this.path.toString();
        }

        public FilesystemAttributesMessage(BDaemonFileSpace bDaemonFileSpace, FilePath filePath) {
            this.path.append(bDaemonFileSpace.filePathToUri(filePath));
            this.path.append("?fsinfo=true");
        }
    }

    public static class ZipEntryInputStream
    extends InputStream {
        private InputStream stream;
        private BZipFile zipFile;

        public int read() throws IOException {
            return this.stream.read();
        }

        public int read(byte[] byArray) throws IOException {
            return this.stream.read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.stream.read(byArray, n, n2);
        }

        public void close() throws IOException {
            this.stream.close();
            this.zipFile.close();
        }

        public ZipEntryInputStream(BZipFile bZipFile, BIFile bIFile) throws IOException {
            this.zipFile = bZipFile;
            this.stream = bIFile.getInputStream();
        }
    }
}

